/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.scales;

import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.rave.core.internal.nativeImpl.Lang;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scales.AbstractScale;
import java.util.ArrayList;
import java.util.List;

public final class QuantizeScale
extends AbstractScale<Object, Object> {
    private double kx;
    private double i;
    private double x0;
    private double x1;
    private List<Object> _range;

    @Override
    @SwiftMethodOverload(skipParameters={1}, skipOverloads={"Bool"})
    public Object getValue(Object context, Object data, int index, int groupIndex) {
        if (Lang.isEqual(data, Lang.undefined()) || ObjectConverter.isNaN(data)) {
            return Lang.undefined();
        }
        double x = ObjectConverter.toDouble(data);
        return this._range.get((int)Math.max(0.0, Math.min(this.i, Math.floor(this.kx * (x - this.x0)))));
    }

    private QuantizeScale rescale() {
        this.kx = (double)this._range.size() / (this.x1 - this.x0);
        this.i = this._range.size() - 1;
        return this;
    }

    @Override
    public AbstractScale<Object, Object> domain(List<Object> values) {
        this.x0 = ObjectConverter.toDouble(values.get(0));
        this.x1 = ObjectConverter.toDouble(values.get(values.size() - 1));
        return this.rescale();
    }

    @Override
    public List<Object> domain() {
        ArrayList<Object> temp = new ArrayList<Object>();
        temp.add(this.x0);
        temp.add(this.x1);
        return temp;
    }

    @Override
    public List<Object> range() {
        return this._range;
    }

    @Override
    public AbstractScale<Object, Object> range(List<Object> values) {
        this._range = values;
        return this.rescale();
    }

    @Override
    public AbstractScale copy() {
        QuantizeScale scale = new QuantizeScale();
        scale.range(this._range);
        ArrayList<Object> tempList = new ArrayList<Object>();
        tempList.add(this.x0);
        tempList.add(this.x1);
        scale.domain((List<Object>)tempList);
        return scale;
    }

    public List<Object> invertExtent(Object givenRange) {
        Integer _givenRange = this._range.indexOf(givenRange);
        double idx = ObjectConverter.toDouble(_givenRange);
        idx = idx < 0.0 ? Double.NaN : idx / this.kx + this.x0;
        ArrayList<Object> tempList = new ArrayList<Object>();
        tempList.add(idx);
        tempList.add(idx + 1.0 / this.kx);
        return tempList;
    }
}

