/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.svg;

import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.internal.geom.PolygonUtil;
import com.ibm.rave.core.internal.math.Trigonometry;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.core.svg.ArcData;

public class Arc
implements ValueFunction<Object, String> {
    private static ValueFunction<Object, ? extends Number> INNER_RADIUS = new ValueFunction<Object, Number>(){

        @Override
        public Number getValue(Object context, Object data, int index, int groupIndex) {
            return ((ArcData)data).innerRadius;
        }
    };
    private static ValueFunction<Object, ? extends Number> OUTER_RADIUS = new ValueFunction<Object, Number>(){

        @Override
        public Number getValue(Object context, Object data, int index, int groupIndex) {
            return ((ArcData)data).outerRadius;
        }
    };
    static ValueFunction<Object, ? extends Number> START_ANGLE = new ValueFunction<Object, Double>(){

        @Override
        public Double getValue(Object context, Object data, int index, int groupIndex) {
            return ((ArcData)data).startAngle;
        }
    };
    static ValueFunction<Object, ? extends Number> END_ANGLE = new ValueFunction<Object, Double>(){

        @Override
        public Double getValue(Object context, Object data, int index, int groupIndex) {
            return ((ArcData)data).endAngle;
        }
    };
    static ValueFunction<Object, ? extends Number> CORNER_RADIUS = new ValueFunction<Object, Double>(){

        @Override
        public Double getValue(Object context, Object data, int index, int groupIndex) {
            return 0.0;
        }
    };
    static ValueFunction<Object, ? extends Number> PAD_ANGLE = new ValueFunction<Object, Double>(){

        @Override
        public Double getValue(Object context, Object data, int index, int groupIndex) {
            if (data == null) {
                return null;
            }
            return ((ArcData)data).padAngle;
        }
    };
    static ValueFunction<Object, Object> PAD_RADIUS = new ValueFunction<Object, Object>(){

        @Override
        public Object getValue(Object context, Object data, int index, int groupIndex) {
            return "auto";
        }
    };
    private ValueFunction<Object, ? extends Number> _innerRadius = INNER_RADIUS;
    private ValueFunction<Object, ? extends Number> _cornerRadius = CORNER_RADIUS;
    private ValueFunction<Object, ? extends Number> _outerRadius = OUTER_RADIUS;
    private ValueFunction<Object, ? extends Number> _startAngle = START_ANGLE;
    private ValueFunction<Object, ? extends Number> _endAngle = END_ANGLE;
    private ValueFunction<Object, ? extends Number> _arcPadAngle = PAD_ANGLE;
    private ValueFunction<Object, Object> _padRadius = PAD_RADIUS;
    static final double svg_arcMax = 6.283184307179586;

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public String getValue(Object context, Object data, int index, int groupIndex) {
        double y2;
        double x2;
        double y0;
        double x0;
        double rc;
        int cw;
        int l0 = 0;
        int l1 = 0;
        double r0 = Math.max(0.0, ObjectConverter.toDouble(this._innerRadius.getValue(context, data, index, groupIndex)));
        double r1 = Math.max(0.0, ObjectConverter.toDouble(this._outerRadius.getValue(context, data, index, groupIndex)));
        double a0 = ObjectConverter.asDouble(this._startAngle.getValue(context, data, index, groupIndex)) - 1.5707963267948966;
        double a1 = ObjectConverter.asDouble(this._endAngle.getValue(context, data, index, groupIndex)) - 1.5707963267948966;
        double da = Math.abs(a1 - a0);
        int n = cw = a0 > a1 ? 0 : 1;
        if (r1 < r0) {
            rc = r1;
            r1 = r0;
            r0 = rc;
        }
        if (da >= 6.283184307179586) {
            String string;
            StringBuilder stringBuilder = new StringBuilder().append(Arc.circleSegment(r1, cw));
            if (r0 != 0.0 && r0 != 0.0) {
                string = Arc.circleSegment(r0, 1 - cw);
                return stringBuilder.append(string).append("Z").toString();
            }
            string = "";
            return stringBuilder.append(string).append("Z").toString();
        }
        double p0 = 0.0;
        double p1 = 0.0;
        double x1 = Double.NaN;
        double y1 = Double.NaN;
        double x3 = Double.NaN;
        double y3 = Double.NaN;
        String path = "";
        double ap = ObjectConverter.toDouble(this._arcPadAngle.getValue(context, data, index, groupIndex));
        if (ObjectConverter.toBoolean(ap)) {
            ap /= 2.0;
            double rp = ObjectConverter.toDouble(this._padRadius == PAD_RADIUS ? Math.sqrt(r0 * r0 + r1 * r1) : ObjectConverter.toDouble(this._padRadius.getValue(context, data, index, groupIndex)));
            if (cw == 0) {
                p1 *= -1.0;
            }
            if (r1 != 0.0) {
                p1 = Trigonometry.asin(rp / r1 * Math.sin(ap));
            }
            if (r0 != 0.0) {
                p0 = Trigonometry.asin(rp / r0 * Math.sin(ap));
            }
        } else {
            ap = 0.0;
        }
        if (ObjectConverter.toBoolean(r1)) {
            x0 = r1 * Math.cos(a0 + p1);
            y0 = r1 * Math.sin(a0 + p1);
            x1 = r1 * Math.cos(a1 - p1);
            y1 = r1 * Math.sin(a1 - p1);
            int n2 = l1 = Math.abs(a1 - a0 - 2.0 * p1) <= Math.PI ? 0 : 1;
            if (p1 != 0.0 && Arc.arcSweep(x0, y0, x1, y1) == (cw ^ l1)) {
                double h1 = (a0 + a1) / 2.0;
                x0 = r1 * Math.cos(h1);
                y0 = r1 * Math.sin(h1);
                y1 = Double.NaN;
                x1 = Double.NaN;
            }
        } else {
            y0 = 0.0;
            x0 = 0.0;
        }
        if (ObjectConverter.toBoolean(r0)) {
            x2 = r0 * Math.cos(a1 - p0);
            y2 = r0 * Math.sin(a1 - p0);
            x3 = r0 * Math.cos(a0 + p0);
            y3 = r0 * Math.sin(a0 + p0);
            int n3 = l0 = Math.abs(a0 - a1 + 2.0 * p0) <= Math.PI ? 0 : 1;
            if (ObjectConverter.toBoolean(p0) && Arc.arcSweep(x2, y2, x3, y3) == (1 - cw ^ l0)) {
                double h0 = (a0 + a1) / 2.0;
                x2 = r0 * Math.cos(h0);
                y2 = r0 * Math.sin(h0);
                y3 = Double.NaN;
                x3 = Double.NaN;
            }
        } else {
            y2 = 0.0;
            x2 = 0.0;
        }
        if (da > 1.0E-6) {
            double d;
            rc = Math.min(Math.abs(r1 - r0) / 2.0, ObjectConverter.toDouble(this._cornerRadius.getValue(context, data, index, groupIndex)));
            if (d > 0.001) {
                int cr = r0 < r1 ^ ObjectConverter.toBoolean(cw) ? 0 : 1;
                double rc1 = rc;
                double rc0 = rc;
                if (da + 1.0E-6 < Math.PI) {
                    ArrayEx<Double> oc = Double.isNaN(x3) ? new ArrayEx<Double>(x2, y2) : (Double.isNaN(x1) ? new ArrayEx<Double>(x0, y0) : PolygonUtil.polygonIntersect(new ArrayEx<Double>(x0, y0), new ArrayEx<Double>(x3, y3), new ArrayEx<Double>(x1, y1), new ArrayEx<Double>(x2, y2)));
                    double ax = x0 - ((Number)oc.get(0)).doubleValue();
                    double ay = y0 - ((Number)oc.get(1)).doubleValue();
                    if (Math.abs(ax) < 1.0E-6 && Math.abs(ay) < 1.0E-6) {
                        ax = x0 * 0.5;
                        ay = y0 * 0.5;
                    }
                    double bx = x1 - ((Number)oc.get(0)).doubleValue();
                    double by = y1 - ((Number)oc.get(1)).doubleValue();
                    double cosVal = (ax * bx + ay * by) / (Math.sqrt(ax * ax + ay * ay) * Math.sqrt(bx * bx + by * by));
                    cosVal = Math.min(1.0, Math.max(-1.0, cosVal));
                    double kc = 1.0 / Math.sin(Math.acos(cosVal) / 2.0);
                    double lc = Math.sqrt(((Number)oc.get(0)).doubleValue() * ((Number)oc.get(0)).doubleValue() + ((Number)oc.get(1)).doubleValue() * ((Number)oc.get(1)).doubleValue());
                    rc0 = Math.min(rc, (r0 - lc) / (kc - 1.0));
                    rc1 = Math.min(rc, (r1 - lc) / (kc + 1.0));
                }
                if (!Double.isNaN(x1)) {
                    double[] dArray;
                    double[][] t12 = Arc.svg_arcCornerTangents(new double[]{x1, y1}, new double[]{x2, y2}, r1, rc1, cw);
                    if (Double.isNaN(x3)) {
                        double[] dArray2 = new double[2];
                        dArray2[0] = x2;
                        dArray = dArray2;
                        dArray2[1] = y2;
                    } else {
                        double[] dArray3 = new double[2];
                        dArray3[0] = x3;
                        dArray = dArray3;
                        dArray3[1] = y3;
                    }
                    double[][] t30 = Arc.svg_arcCornerTangents(dArray, new double[]{x0, y0}, r1, rc1, cw);
                    if (rc == rc1) {
                        path = path + "M" + t30[0][0] + "," + t30[0][1] + "A" + rc1 + "," + rc1 + " 0 0," + cr + " ";
                        path = path + t30[1][0] + "," + t30[1][1] + "A" + r1 + "," + r1 + " 0 " + (1 - cw ^ Arc.arcSweep(t30[1][0], t30[1][1], t12[1][0], t12[1][1])) + "," + cw + " " + t12[1][0] + "," + t12[1][1] + "A" + rc1 + "," + rc1 + " 0 0," + cr + " " + t12[0][0] + "," + t12[0][1];
                    } else {
                        path = path + "M" + t30[0][0] + "," + t30[0][1] + "A" + rc1 + "," + rc1 + " 0 1," + cr + " " + t12[0][0] + "," + t12[0][1];
                    }
                } else {
                    path = path + "M" + x0 + "," + y0;
                }
                if (!Double.isNaN(x3)) {
                    double[] dArray;
                    double[] dArray4 = new double[]{x2, y2};
                    if (Double.isNaN(x1)) {
                        double[] dArray5 = new double[2];
                        dArray5[0] = x0;
                        dArray = dArray5;
                        dArray5[1] = y0;
                    } else {
                        double[] dArray6 = new double[2];
                        dArray6[0] = x1;
                        dArray = dArray6;
                        dArray6[1] = y1;
                    }
                    double[][] t21 = Arc.svg_arcCornerTangents(dArray4, dArray, r0, -rc0, cw);
                    double[][] t03 = Arc.svg_arcCornerTangents(new double[]{x0, y0}, new double[]{x3, y3}, r0, -rc0, cw);
                    if (Double.isNaN(t21[0][0]) || Double.isNaN(t21[0][1])) {
                        a1 = 0.0;
                    }
                    if (rc == rc0) {
                        path = path + "L" + t21[0][0] + "," + t21[0][1] + "A" + rc0 + "," + rc0 + " 0 0," + cr + " ";
                        path = path + t21[1][0] + "," + t21[1][1] + "A" + r0 + "," + r0 + " 0 " + (cw ^ Arc.arcSweep(t21[1][0], t21[1][1], t03[1][0], t03[1][1])) + "," + (1 - cw) + " " + t03[1][0] + "," + t03[1][1] + "A" + rc0 + "," + rc0 + " 0 0," + cr + " " + t03[0][0] + "," + t03[0][1];
                        return path + "Z";
                    } else {
                        path = path + "L" + t21[0][0] + "," + t21[0][1] + "A" + rc0 + "," + rc0 + " 0 0," + cr + " " + t03[0][0] + "," + t03[0][1];
                    }
                    return path + "Z";
                }
                path = path + "L" + x2 + "," + y2;
                return path + "Z";
            }
        }
        path = path + "M" + x0 + "," + y0;
        if (!Double.isNaN(x1)) {
            path = path + "A" + r1 + "," + r1 + " 0 " + l1 + "," + cw + " " + x1 + "," + y1;
        }
        path = path + "L" + x2 + "," + y2;
        if (Double.isNaN(x3)) return path + "Z";
        path = path + "A" + r0 + "," + r0 + " 0 " + l0 + "," + (1 - cw) + " " + x3 + "," + y3;
        return path + "Z";
    }

    private static String circleSegment(double r1, int cw) {
        return "M0," + r1 + "A" + r1 + "," + r1 + " 0 1," + cw + " 0," + -r1 + "A" + r1 + "," + r1 + " 0 1," + cw + " 0," + r1;
    }

    public Arc innerRadius(ValueFunction<Object, ? extends Number> innerRadiusFn) {
        this._innerRadius = innerRadiusFn;
        return this;
    }

    public Arc innerRadius(final double value) {
        this._innerRadius = new ValueFunction<Object, Double>(){

            @Override
            public Double getValue(Object context, Object data, int index, int groupIndex) {
                return value;
            }
        };
        return this;
    }

    public ValueFunction<Object, ? extends Number> innerRadius() {
        return this._innerRadius;
    }

    public Arc outerRadius(ValueFunction<Object, ? extends Number> outerRadiusFn) {
        this._outerRadius = outerRadiusFn;
        return this;
    }

    public Arc outerRadius(final double value) {
        this._outerRadius = new ValueFunction<Object, Double>(){

            @Override
            public Double getValue(Object context, Object data, int index, int groupIndex) {
                return value;
            }
        };
        return this;
    }

    public ValueFunction<Object, ? extends Number> outerRadius() {
        return this._outerRadius;
    }

    public Arc startAngle(ValueFunction<Object, ? extends Number> startAngleFn) {
        this._startAngle = startAngleFn;
        return this;
    }

    public Arc startAngle(final double value) {
        this._startAngle = new ValueFunction<Object, Double>(){

            @Override
            public Double getValue(Object context, Object data, int index, int groupIndex) {
                return value;
            }
        };
        return this;
    }

    public ValueFunction<Object, ? extends Number> startAngle() {
        return this._startAngle;
    }

    public Arc endAngle(ValueFunction<Object, ? extends Number> endAngleFn) {
        this._endAngle = endAngleFn;
        return this;
    }

    public Arc endAngle(final double value) {
        this._endAngle = new ValueFunction<Object, Double>(){

            @Override
            public Double getValue(Object context, Object data, int index, int groupIndex) {
                return value;
            }
        };
        return this;
    }

    public ValueFunction<Object, ? extends Number> endAngle() {
        return this._endAngle;
    }

    public Arc padAngle(ValueFunction<Object, ? extends Number> padAngleFn) {
        this._arcPadAngle = padAngleFn;
        return this;
    }

    public Arc padAngle(final double value) {
        this._arcPadAngle = new ValueFunction<Object, Double>(){

            @Override
            public Double getValue(Object context, Object data, int index, int groupIndex) {
                return value;
            }
        };
        return this;
    }

    public ValueFunction<Object, ? extends Number> padAngle() {
        return this._arcPadAngle;
    }

    public Arc cornerRadius(ValueFunction<Object, ? extends Number> cornerRadiusFn) {
        this._cornerRadius = cornerRadiusFn;
        return this;
    }

    public Arc cornerRadius(final double value) {
        this._cornerRadius = new ValueFunction<Object, Double>(){

            @Override
            public Double getValue(Object context, Object data, int index, int groupIndex) {
                return value;
            }
        };
        return this;
    }

    public ValueFunction<Object, ? extends Number> cornerRadius() {
        return this._cornerRadius;
    }

    public Arc padRadius(ValueFunction<Object, Object> padRadiusFn) {
        this._padRadius = padRadiusFn;
        return this;
    }

    public Arc padRadius(final double value) {
        this._padRadius = new ValueFunction<Object, Object>(){

            @Override
            public Object getValue(Object context, Object data, int index, int groupIndex) {
                return value;
            }
        };
        return this;
    }

    public ValueFunction<Object, Object> padRadius() {
        return this._padRadius;
    }

    private static int arcSweep(double x0, double y0, double x1, double y1) {
        return (x0 - x1) * y0 - (y0 - y1) * x0 > 0.0 ? 0 : 1;
    }

    private static double[][] svg_arcCornerTangents(double[] p0, double[] p1, double r1, double rc, Number cw) {
        double x01 = p0[0] - p1[0];
        double y01 = p0[1] - p1[1];
        double lo = (cw != null ? rc : -rc) / Math.sqrt(x01 * x01 + y01 * y01);
        double ox = lo * y01;
        double oy = -lo * x01;
        double x1 = p0[0] + ox;
        double y1 = p0[1] + oy;
        double x2 = p1[0] + ox;
        double y2 = p1[1] + oy;
        double x3 = (x1 + x2) / 2.0;
        double y3 = (y1 + y2) / 2.0;
        double dx = x2 - x1;
        double dy = y2 - y1;
        double d2 = dx * dx + dy * dy;
        double r = r1 - rc;
        double D = x1 * y2 - x2 * y1;
        double d = (double)(dy < 0.0 ? -1 : 1) * Math.sqrt(Math.max(0.0, r * r * d2 - D * D));
        double cx0 = (D * dy - dx * d) / d2;
        double cy0 = (-D * dx - dy * d) / d2;
        double cx1 = (D * dy + dx * d) / d2;
        double cy1 = (-D * dx + dy * d) / d2;
        double dx0 = cx0 - x3;
        double dy0 = cy0 - y3;
        double dx1 = cx1 - x3;
        double dy1 = cy1 - y3;
        if (Double.isNaN(d) || d2 < 1.0E-6) {
            d2 = 1.0;
        }
        if (dx0 * dx0 + dy0 * dy0 > dx1 * dx1 + dy1 * dy1) {
            cx0 = cx1;
            cy0 = cy1;
        }
        return new double[][]{{cx0 - ox, cy0 - oy}, {cx0 * r1 / r, cy0 * r1 / r}};
    }

    public double[] centroid(Object data, int index, int groupIndex) {
        double r = (ObjectConverter.asDouble(this._innerRadius.getValue(this, data, index, groupIndex)) + ObjectConverter.asDouble(this._outerRadius.getValue(this, data, index, groupIndex))) / 2.0;
        double a = (ObjectConverter.asDouble(this._startAngle.getValue(this, data, index, groupIndex)) + this._endAngle.getValue(this, data, index, groupIndex).doubleValue()) / 2.0 - 1.5707963267948966;
        return new double[]{Math.cos(a) * r, Math.sin(a) * r};
    }
}

