/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.svg;

import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.geom.Point;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.core.svg.AbstractLineInterpolator;
import com.ibm.rave.core.svg.SVGLine;

@FunctionClass(value="create", contextInvocation=true)
public class AreaPathGenerator {
    private ValueFunction<Object, Object> fx0 = SVGLine.DEFAULT_X_FN;
    private ValueFunction<Object, Object> fx1 = SVGLine.DEFAULT_X_FN;
    private ValueFunction<Object, Object> fy0 = null;
    private ValueFunction<Object, Object> fy1 = SVGLine.DEFAULT_Y_FN;
    private double x0Val = 0.0;
    private double y0Val = 0.0;
    private double x1Val = 0.0;
    private double y1Val = 0.0;
    private ValueFunction<Object, Boolean> definedFn = SVGLine.DEFAULT_DEFINED_FN;
    private AbstractLineInterpolator interpolateFn = SVGLine.r2_svg_lineLinear;
    private Object interpolateKey = this.interpolateFn.getKey();
    private AbstractLineInterpolator interpolateReverseFn = this.interpolateFn;
    private double tensionVal = 0.7;
    private String L = "L";
    private final ValueFunction<Object, ArrayEx<?>> projectionFn;

    public AreaPathGenerator(ValueFunction<Object, ArrayEx<?>> projection) {
        this.projectionFn = projection;
    }

    @SwiftMethodOverload(skip=true)
    public String create(Object context, ArrayEx<?> data) {
        ArrayEx<Object> segments = new ArrayEx<Object>();
        ArrayEx<Point> points0 = new ArrayEx<Point>();
        ArrayEx<Point> points1 = new ArrayEx<Point>();
        int i = -1;
        int n = data.size();
        Object d = null;
        n = data.size();
        final Double[] xa = new Double[1];
        final Double[] ya = new Double[1];
        ValueFunction<Object, Object> localFx1 = this.fx0 != null && this.fx0 == this.fx1 ? new ValueFunction<Object, Object>(){

            @Override
            public Object getValue(Object context, Object data, int index, int groupIndex) {
                return xa[0];
            }
        } : this.fx1;
        ValueFunction<Object, Object> localFy1 = this.fy0 != null && this.fy0 == this.fy1 ? new ValueFunction<Object, Object>(){

            @Override
            public Object getValue(Object context, Object data, int index, int groupIndex) {
                return ya[0];
            }
        } : this.fy1;
        while (++i < n) {
            d = data.get(i);
            if (this.definedFn.getValue(context, d, i, -1).booleanValue()) {
                xa[0] = ObjectConverter.toDouble(this.fx0 == null ? Double.valueOf(this.x0Val) : this.fx0.getValue(context, d, i, -1));
                ya[0] = ObjectConverter.toDouble(this.fy0 == null ? Double.valueOf(this.y0Val) : this.fy0.getValue(context, d, i, -1));
                points0.push(new Point(xa[0], ya[0]));
                points1.push(new Point(ObjectConverter.toDouble(localFx1 == null ? Double.valueOf(this.x1Val) : localFx1.getValue(context, d, i, -1)), ObjectConverter.toDouble(localFy1 == null ? Double.valueOf(this.y1Val) : localFy1.getValue(context, d, i, -1))));
                continue;
            }
            if (points0.size() <= 0) continue;
            segments.push("M", this.interpolateFn.getValue(this.projectionFn.getValue(context, points1, -1, -1), this.tensionVal), this.L, this.interpolateReverseFn.getValue(this.projectionFn.getValue(context, points0.reverse(), -1, -1), this.tensionVal), "Z");
            points0 = new ArrayEx();
            points1 = new ArrayEx();
        }
        if (points0.size() > 0) {
            segments.push("M", this.interpolateFn.getValue(this.projectionFn.getValue(context, points1, -1, -1), this.tensionVal), this.L, this.interpolateReverseFn.getValue(this.projectionFn.getValue(context, points0.reverse(), -1, -1), this.tensionVal), "Z");
        }
        return segments.size() > 0 ? segments.join("") : null;
    }

    public Object x() {
        if (this.fx1 != null) {
            return this.fx1;
        }
        return this.x1Val;
    }

    public AreaPathGenerator x(double xVal) {
        this.fx1 = null;
        this.fx0 = null;
        this.x0Val = this.x1Val = xVal;
        return this;
    }

    public AreaPathGenerator x(ValueFunction<Object, Object> valFn) {
        this.fx1 = valFn;
        this.fx0 = this.fx1;
        return this;
    }

    public Object x0() {
        if (this.fx0 != null) {
            return this.fx0;
        }
        return this.x0Val;
    }

    public AreaPathGenerator x0(double xVal) {
        this.fx0 = null;
        this.x0Val = xVal;
        return this;
    }

    public AreaPathGenerator x0(ValueFunction<Object, Object> valFn) {
        this.fx0 = valFn;
        return this;
    }

    public Object x1() {
        if (this.fx1 != null) {
            return this.fx1;
        }
        return this.x1Val;
    }

    public AreaPathGenerator x1(double xVal) {
        this.fx1 = null;
        this.x1Val = xVal;
        return this;
    }

    public AreaPathGenerator x1(ValueFunction<Object, Object> valFn) {
        this.fx1 = valFn;
        return this;
    }

    public Object y() {
        if (this.fy1 != null) {
            return this.fy1;
        }
        return this.y1Val;
    }

    public AreaPathGenerator y(double yVal) {
        this.fy1 = null;
        this.fy0 = null;
        this.y0Val = this.y1Val = yVal;
        return this;
    }

    public AreaPathGenerator y(ValueFunction<Object, Object> valFn) {
        this.fy1 = valFn;
        this.fy0 = this.fy1;
        return this;
    }

    public Object y0() {
        if (this.fy0 != null) {
            return this.fy0;
        }
        return this.y0Val;
    }

    public AreaPathGenerator y0(double yVal) {
        this.fy0 = null;
        this.y0Val = yVal;
        return this;
    }

    public AreaPathGenerator y0(ValueFunction<Object, Object> valFn) {
        this.fy0 = valFn;
        return this;
    }

    public Object y1() {
        if (this.fy1 != null) {
            return this.fy1;
        }
        return this.y1Val;
    }

    public AreaPathGenerator y1(double yVal) {
        this.fy1 = null;
        this.y1Val = yVal;
        return this;
    }

    public AreaPathGenerator y1(ValueFunction<Object, Object> valFn) {
        this.fy1 = valFn;
        return this;
    }

    public ValueFunction<Object, Boolean> defined() {
        return this.definedFn;
    }

    public AreaPathGenerator defined(ValueFunction<Object, Boolean> valFn) {
        this.definedFn = valFn;
        return this;
    }

    public double tension() {
        return this.tensionVal;
    }

    public AreaPathGenerator tension(double tensionNewVal) {
        this.tensionVal = tensionNewVal;
        return this;
    }

    public Object interpolate() {
        return this.interpolateKey;
    }

    public AreaPathGenerator interpolate(String key) {
        this.interpolateKey = key;
        this.interpolateFn = SVGLine.r2_svg_lineInterpolators.get(key);
        if (this.interpolateFn == null) {
            this.interpolateFn = SVGLine.r2_svg_lineLinear;
            this.interpolateKey = this.interpolateFn.getKey();
        }
        this.interpolateReverseFn = this.interpolateFn.getReverse() != null ? this.interpolateFn.getReverse() : this.interpolateFn;
        this.L = this.interpolateFn.isClosed() ? "M" : "L";
        return this;
    }

    public AreaPathGenerator interpolate(AbstractLineInterpolator valFn) {
        this.interpolateFn = valFn;
        this.interpolateKey = this.interpolateFn;
        this.interpolateReverseFn = this.interpolateFn.getReverse() != null ? this.interpolateFn.getReverse() : this.interpolateFn;
        this.L = this.interpolateFn.isClosed() ? "M" : "L";
        return this;
    }
}

