/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.svg;

import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.rave.codegenerator.annotations.SwiftWeak;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.event.BaseEvent;
import com.ibm.rave.core.event.Event;
import com.ibm.rave.core.event.KeyboardEvent;
import com.ibm.rave.core.event.TouchEvent;
import com.ibm.rave.core.event.UIEvent;
import com.ibm.rave.core.geom.Point;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.internal.event.CustomDispatcher;
import com.ibm.rave.core.internal.nativeImpl.PlatformInitialization;
import com.ibm.rave.core.internal.nativeImpl.RegExp;
import com.ibm.rave.core.internal.nativeImpl.event.DragSuppress;
import com.ibm.rave.core.internal.nativeImpl.transitions.InheritedTransition;
import com.ibm.rave.core.interpolate.ArrayInterpolation;
import com.ibm.rave.core.interpolate.Interpolator;
import com.ibm.rave.core.nativeImpl.event.EventTracker;
import com.ibm.rave.core.nativeImpl.event.Mouse;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scales.AbstractScale;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.CallbackFunction;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selection;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.core.selector.SelectorEventListener;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.core.transition.Transition;
import com.ibm.rave.core.transition.Tween;
import java.util.List;

public final class Brush
implements RunFunction<Object> {
    @InlineStringConstant
    private static final String CHART_PROP = "__chart__";
    private final String[][] brushResizes;
    private final OMap<String, String> brushCursor;
    @SwiftWeak(value=false)
    private final CustomDispatcher<EventObject, Brush, SceneNode> eventDispatcher = CustomDispatcher.create(this, "brushstart", "brush", "brushend");
    private int dragging;
    private final double[] origin;
    private double[] center;
    private double[] offset;
    private Double[] xExtent;
    private Double[] yExtent;
    private Double[] xExtentDomain;
    private Double[] yExtentDomain;
    private boolean xClamp;
    private boolean yClamp;
    private String[] resizes;
    private AbstractScale xScale;
    private AbstractScale yScale;
    private final SelectorEventListener<Event> brushstartMouseDown;
    private final SelectorEventListener<Event> brushstartTouchStart;

    private Brush() {
        this.brushResizes = new String[][]{{"n", "e", "s", "w", "nw", "ne", "se", "sw"}, {"e", "w"}, {"n", "s"}, new String[0]};
        this.brushCursor = new OMap();
        this.brushCursor.put("n", "ns-resize");
        this.brushCursor.put("e", "ew-resize");
        this.brushCursor.put("s", "ns-resize");
        this.brushCursor.put("w", "ew-resize");
        this.brushCursor.put("nw", "nwse-resize");
        this.brushCursor.put("ne", "nesw-resize");
        this.brushCursor.put("se", "nwse-resize");
        this.brushCursor.put("sw", "nesw-resize");
        this.xScale = null;
        this.yScale = null;
        this.xExtent = new Double[]{0.0, 0.0};
        this.yExtent = new Double[]{0.0, 0.0};
        this.xClamp = true;
        this.yClamp = true;
        this.resizes = this.brushResizes[0];
        this.origin = new double[2];
        final Brush self = this;
        this.brushstartMouseDown = new SelectorEventListener<Event>(){

            @Override
            public void onEvent(SceneNode context, Object data, int index, int groupIndex, Event event) {
                self.handleBrushStartEvent(context, data, index, groupIndex, event, false);
            }
        };
        this.brushstartTouchStart = new SelectorEventListener<Event>(){

            @Override
            public void onEvent(SceneNode context, Object data, int index, int groupIndex, Event event) {
                self.handleBrushStartEvent(context, data, index, groupIndex, event, true);
            }
        };
    }

    private void handleBrushStartEvent(SceneNode context, Object data, int index, int groupIndex, Event event, boolean touchEvent) {
        final Brush self = this;
        final SceneNode target = context;
        Selector eventTarget = new Selector().init((SceneNode)EventTracker.INSTANCE.get().target);
        final CustomDispatcher.DispatchContext<EventObject, Brush> event_ = this.eventDispatcher.of(target, data, index, groupIndex);
        final Selector g = new Selector().init(target);
        String resizing = "";
        Object eventTargetDatum = eventTarget.datum();
        if (ObjectConverter.toBoolean(eventTargetDatum)) {
            resizing = eventTargetDatum.toString();
        }
        final boolean resizingX = !new RegExp("^(n|s)$", "g").test(resizing) && this.xScale != null;
        final boolean resizingY = !new RegExp("^(e|w)$", "g").test(resizing) && this.yScale != null;
        this.dragging = ObjectConverter.toNumber(eventTarget.classed("extent"));
        final DragSuppress.Suppress dragRestore = DragSuppress.dragSuppress(target);
        Point originPoint = Mouse.mousePoint(target);
        this.origin[0] = originPoint.getX();
        this.origin[1] = originPoint.getY();
        this.offset = null;
        this.center = null;
        SelectorEventListener<Event> keydown = new SelectorEventListener<Event>(){

            @Override
            public void onEvent(SceneNode context, Object data, int index, int groupIndex, Event event) {
                if (((KeyboardEvent)EventTracker.INSTANCE.get()).keyCode == 32) {
                    if (!ObjectConverter.toBoolean(self.dragging)) {
                        Brush.access$202(self, null);
                        double[] dArray = self.origin;
                        dArray[0] = dArray[0] - self.xExtent[1];
                        double[] dArray2 = self.origin;
                        dArray2[1] = dArray2[1] - self.yExtent[1];
                        self.dragging = 2;
                    }
                    EventTracker.INSTANCE.preventDefault();
                }
            }
        };
        SelectorEventListener<Event> keyup = new SelectorEventListener<Event>(){

            @Override
            public void onEvent(SceneNode context, Object data, int index, int groupIndex, Event event) {
                if (((KeyboardEvent)EventTracker.INSTANCE.get()).keyCode == 32 && self.dragging == 2) {
                    double[] dArray = self.origin;
                    dArray[0] = dArray[0] + self.xExtent[1];
                    double[] dArray2 = self.origin;
                    dArray2[1] = dArray2[1] + self.yExtent[1];
                    self.dragging = 0;
                    EventTracker.INSTANCE.preventDefault();
                }
            }
        };
        final Selector w = new Selector().init(PlatformInitialization.getWindow(target)).on("keydown.brush", (SelectorEventListener<? extends Event>)keydown).on("keyup.brush", (SelectorEventListener<? extends Event>)keyup);
        final SelectorEventListener<Event> brushmove = new SelectorEventListener<Event>(){

            @Override
            public void onEvent(SceneNode context, Object data, int index, int groupIndex, Event event) {
                Point p = Mouse.mousePoint(target);
                double[] point = new double[]{p.getX(), p.getY()};
                boolean moved = false;
                if (self.offset != null) {
                    point[0] = point[0] + self.offset[0];
                    point[1] = point[1] + self.offset[1];
                }
                if (!ObjectConverter.toBoolean(self.dragging)) {
                    if (((UIEvent)EventTracker.INSTANCE.get()).altKey) {
                        if (self.center == null) {
                            Brush.access$202(self, new double[]{(self.xExtent[0] + self.xExtent[1]) / 2.0, (self.yExtent[0] + self.yExtent[1]) / 2.0});
                        }
                        ((Brush)self).origin[0] = self.xExtent[ObjectConverter.toNumber(point[0] < self.center[0])];
                        ((Brush)self).origin[1] = self.yExtent[ObjectConverter.toNumber(point[1] < self.center[1])];
                    } else {
                        Brush.access$202(self, null);
                    }
                }
                if (resizingX && self.move1(point, self.xScale, 0)) {
                    self.redrawX(g);
                    moved = true;
                }
                if (resizingY && self.move1(point, self.yScale, 1)) {
                    self.redrawY(g);
                    moved = true;
                }
                if (moved) {
                    self.redraw(g);
                    event_.dispatch(new EventObject("brush", !ObjectConverter.toBoolean(self.dragging) ? "move" : "resize"));
                }
            }
        };
        SelectorEventListener<Event> brushend = new SelectorEventListener<Event>(){

            @Override
            public void onEvent(SceneNode context, Object data, int index, int groupIndex, Event event) {
                brushmove.onEvent(context, data, index, groupIndex, event);
                g.style("pointer-events", (Object)"all").selectAll(".resize").style("display", (Object)(self.empty() ? "none" : null));
                new Selector().init(PlatformInitialization.getDocumentBodyElement()).style("cursor", (ValueFunction)null);
                w.on("mousemove.brush", null).on("mouseup.brush", null).on("touchmove.brush", null).on("touchend.brush", null).on("keydown.brush", null).on("keyup.brush", null);
                dragRestore.suppress(false);
                event_.dispatch(new EventObject("brushend", null));
            }
        };
        if (touchEvent && ((TouchEvent)EventTracker.INSTANCE.get()).changedTouches != null) {
            w.on("touchmove.brush", (SelectorEventListener<? extends Event>)brushmove).on("touchend.brush", (SelectorEventListener<? extends Event>)brushend);
        } else {
            w.on("mousemove.brush", (SelectorEventListener<? extends Event>)brushmove).on("mouseup.brush", (SelectorEventListener<? extends Event>)brushend);
        }
        g.interrupt().selectAll("*").interrupt();
        if (ObjectConverter.toBoolean(this.dragging)) {
            this.origin[0] = this.xExtent[0] - this.origin[0];
            this.origin[1] = this.yExtent[0] - this.origin[1];
        } else if (ObjectConverter.toBoolean(resizing)) {
            int ex = ObjectConverter.toNumber(new RegExp("w$", "g").test(resizing));
            int ey = ObjectConverter.toNumber(new RegExp("^n", "g").test(resizing));
            this.offset = new double[]{this.xExtent[1 - ex] - this.origin[0], this.yExtent[1 - ey] - this.origin[1]};
            this.origin[0] = this.xExtent[ex];
            this.origin[1] = this.yExtent[ey];
        }
        if (((UIEvent)EventTracker.INSTANCE.get()).altKey) {
            this.center = new double[]{this.origin[0], this.origin[1]};
        }
        g.style("pointer-events", (Object)"none").selectAll(".resize").style("display", (ValueFunction)null);
        new Selector().init(PlatformInitialization.getDocumentBodyElement()).style("cursor", eventTarget.style("cursor"));
        event_.dispatch(new EventObject("brushstart", null));
        brushmove.onEvent(context, data, index, groupIndex, event);
    }

    private boolean move1(double[] point, AbstractScale scale, int i) {
        double max;
        double min;
        List<Object> range = AbstractScale.scaleRange(scale);
        double r0 = ObjectConverter.asDouble(range.get(0));
        double r1 = ObjectConverter.asDouble(range.get(1));
        double position = this.origin[i];
        Double[] extent = ObjectConverter.toBoolean(i) ? this.yExtent : this.xExtent;
        double size = extent[1] - extent[0];
        if (ObjectConverter.toBoolean(this.dragging)) {
            r0 -= position;
            r1 -= size + position;
        }
        double d = (ObjectConverter.toBoolean(i) ? this.yClamp : this.xClamp) ? Math.max(r0, Math.min(r1, point[i])) : (min = point[i]);
        if (ObjectConverter.toBoolean(this.dragging)) {
            max = (min += position) + size;
        } else {
            if (this.center != null) {
                position = Math.max(r0, Math.min(r1, 2.0 * this.center[i] - min));
            }
            if (position < min) {
                max = min;
                min = position;
            } else {
                max = position;
            }
        }
        if (extent[0] != min || extent[1] != max) {
            if (ObjectConverter.toBoolean(i)) {
                this.yExtentDomain = null;
            } else {
                this.xExtentDomain = null;
            }
            extent[0] = min;
            extent[1] = max;
            return true;
        }
        return false;
    }

    public static Brush newBrush() {
        return new Brush();
    }

    @Override
    public Object run(Object context, Object ... args) {
        this.brush((Selector)args[0]);
        return null;
    }

    public void brush(Selection context) {
        final Brush self = this;
        context.each((CallbackFunction<SceneNode>)new CallbackFunction<SceneNode>(){

            @Override
            public void run(SceneNode context, Object data, int index, int groupIndex) {
                List<Object> range;
                Selector g = new Selector().init(context).style("pointer-events", (Object)"all").style("-webkit-tap-highlight-color", (Object)"rgba(0,0,0,0)").on("mousedown.brush", self.brushstartMouseDown).on("touchstart.brush", self.brushstartTouchStart);
                Selector background = g.selectAll(".background").data(new Double[]{0.0});
                background.enter().append("rect").attr("class", "background").style("visibility", (Object)"hidden").style("cursor", (Object)"crosshair");
                g.selectAll(".extent").data(new Double[]{0.0}).enter().append("rect").attr("class", "extent").style("cursor", (Object)"move");
                Selector resize = g.selectAll(".resize").data(self.resizes, new ValueFunction<Object, Object>(){

                    @Override
                    public Object getValue(Object context, Object data, int index, int groupIndex) {
                        return data;
                    }
                });
                resize.exit().remove();
                ((Selector)((Selector)((Selector)((Selector)resize.enter().append("g").attr("class", new ValueFunction<SceneNode, Object>(){

                    @Override
                    public Object getValue(SceneNode context, Object data, int index, int groupIndex) {
                        return "resize " + data;
                    }
                })).style("cursor", new ValueFunction<SceneNode, Object>(){

                    @Override
                    public Object getValue(SceneNode context, Object data, int index, int groupIndex) {
                        return self.brushCursor.get((String)data);
                    }
                })).append("rect").attr("x", new ValueFunction<SceneNode, Object>(){

                    @Override
                    public Object getValue(SceneNode context, Object data, int index, int groupIndex) {
                        return new RegExp("[ew]$", "g").test(data.toString()) ? Integer.valueOf(-3) : null;
                    }
                })).attr("y", new ValueFunction<SceneNode, Object>(){

                    @Override
                    public Object getValue(SceneNode context, Object data, int index, int groupIndex) {
                        return new RegExp("^[ns]", "g").test(data.toString()) ? Integer.valueOf(-3) : null;
                    }
                })).attr("width", 6).attr("height", 6).style("visibility", (Object)"hidden");
                resize.style("display", (Object)(self.empty() ? "none" : null));
                Selection<?> gUpdate = Transition.newTransition(g);
                Selection<?> backgroundUpdate = Transition.newTransition(background);
                if (self.xScale != null) {
                    range = AbstractScale.scaleRange(self.xScale);
                    ((Selection)backgroundUpdate.attr("x", range.get(0))).attr("width", ObjectConverter.asDouble(range.get(1)) - ObjectConverter.asDouble(range.get(0)));
                    self.redrawX(gUpdate);
                }
                if (self.yScale != null) {
                    range = AbstractScale.scaleRange(self.yScale);
                    ((Selection)backgroundUpdate.attr("y", range.get(0))).attr("height", ObjectConverter.asDouble(range.get(1)) - ObjectConverter.asDouble(range.get(0)));
                    self.redrawY(gUpdate);
                }
                self.redraw(gUpdate);
            }
        });
    }

    public boolean empty() {
        boolean xDim = false;
        boolean yDim = false;
        if (this.xScale != null) {
            boolean bl = xDim = this.xExtent[0].doubleValue() == this.xExtent[1].doubleValue();
        }
        if (this.yScale != null) {
            yDim = this.yExtent[0].doubleValue() == this.yExtent[1].doubleValue();
        }
        return xDim || yDim;
    }

    public Brush clear() {
        if (!this.empty()) {
            this.xExtent = new Double[]{0.0, 0.0};
            this.yExtent = new Double[]{0.0, 0.0};
            this.yExtentDomain = null;
            this.xExtentDomain = null;
        }
        return this;
    }

    public RunFunction<? super SceneNode> on(String type) {
        return this.eventDispatcher.on(type);
    }

    public Brush on(String type, RunFunction<? super SceneNode> listener) {
        this.eventDispatcher.on(type, listener);
        return this;
    }

    public void event(Selection g) {
        final Brush self = this;
        g.each((CallbackFunction<SceneNode>)new CallbackFunction<SceneNode>(){

            @Override
            public void run(SceneNode context, Object data, int index, int groupIndex) {
                final CustomDispatcher.DispatchContext event_ = self.eventDispatcher.of(context, data, index, groupIndex);
                BrushExtent brushExtent = (BrushExtent)context.getProperty(Brush.CHART_PROP);
                final BrushExtent extent1 = new BrushExtent(self.xExtent, self.yExtent, self.xExtentDomain, self.yExtentDomain);
                final BrushExtent extent0 = brushExtent == null ? extent1 : brushExtent;
                context.setProperty(Brush.CHART_PROP, extent1);
                if (InheritedTransition.get() != null) {
                    ((Transition)new Selector().init(context).transition().each("start.brush", new RunFunction<SceneNode>(){

                        @Override
                        public Object run(SceneNode context, Object ... args) {
                            Brush.access$1902(self, extent0.i);
                            Brush.access$2002(self, extent0.j);
                            Brush.access$402(self, extent0.x);
                            Brush.access$502(self, extent0.y);
                            event_.dispatch(new EventObject("brushstart", null));
                            return null;
                        }
                    })).tween("brush:brush", new ValueFunction<SceneNode, Tween<SceneNode>>(){

                        @Override
                        public Tween<SceneNode> getValue(SceneNode context, Object data, int index, int groupIndex) {
                            final Interpolator<Object[]> xi = ArrayInterpolation.INSTANCE.create(self.xExtent, extent1.x);
                            final Interpolator<Object[]> yi = ArrayInterpolation.INSTANCE.create(self.yExtent, extent1.y);
                            Brush.access$1902(self, Brush.access$2002(self, null));
                            return new Tween<SceneNode>(){

                                @Override
                                public void tween(SceneNode context, double t) {
                                    extent1.x = ObjectConverter.toDouble((Object[])xi.interpolate(t));
                                    Brush.access$402(self, extent1.x);
                                    extent1.y = ObjectConverter.toDouble((Object[])yi.interpolate(t));
                                    Brush.access$502(self, extent1.y);
                                    event_.dispatch(new EventObject("brush", "resize"));
                                }
                            };
                        }
                    }).each("end.brush", new RunFunction<SceneNode>(){

                        @Override
                        public Object run(SceneNode context, Object ... args) {
                            Brush.access$1902(self, extent1.i);
                            Brush.access$2002(self, extent1.j);
                            event_.dispatch(new EventObject("brush", "resize"));
                            event_.dispatch(new EventObject("brushend", null));
                            return null;
                        }
                    });
                } else {
                    event_.dispatch(new EventObject("brushstart", null));
                    event_.dispatch(new EventObject("brush", "resize"));
                    event_.dispatch(new EventObject("brushend", null));
                }
            }
        });
    }

    private void redraw(Selection g) {
        final Brush self = this;
        ((Selection)g.selectAll(".resize")).attr("transform", (ValueFunction<SceneNode, String>)new ValueFunction<SceneNode, String>(){

            @Override
            public String getValue(SceneNode context, Object data, int index, int groupIndex) {
                return "translate(" + self.xExtent[ObjectConverter.toNumber(new RegExp("e$", "g").test(data.toString()))] + "," + self.yExtent[ObjectConverter.toNumber(new RegExp("^s", "g").test(data.toString()))] + ")";
            }
        });
    }

    private void redrawX(Selection g) {
        ((Selection)g.select(".extent")).attr("x", this.xExtent[0]);
        ((Selection)g.selectAll(".extent,.n>rect,.s>rect")).attr("width", this.xExtent[1] - this.xExtent[0]);
    }

    private void redrawY(Selection g) {
        ((Selection)g.select(".extent")).attr("y", this.yExtent[0]);
        ((Selection)g.selectAll(".extent,.e>rect,.w>rect")).attr("height", this.yExtent[1] - this.yExtent[0]);
    }

    public AbstractScale x() {
        return this.xScale;
    }

    public Brush x(AbstractScale z) {
        this.xScale = z;
        this.resizes = this.brushResizes[ObjectConverter.toNumber(!ObjectConverter.toBoolean(this.xScale)) << 1 | ObjectConverter.toNumber(!ObjectConverter.toBoolean(this.yScale))];
        return this;
    }

    public AbstractScale y() {
        return this.yScale;
    }

    public Brush y(AbstractScale z) {
        this.yScale = z;
        this.resizes = this.brushResizes[ObjectConverter.toNumber(!ObjectConverter.toBoolean(this.xScale)) << 1 | ObjectConverter.toNumber(!ObjectConverter.toBoolean(this.yScale))];
        return this;
    }

    public Object clamp() {
        return ObjectConverter.toBoolean(this.xScale) && ObjectConverter.toBoolean(this.yScale) ? new ArrayEx<Boolean>(this.xClamp, this.yClamp) : (ObjectConverter.toBoolean(this.xScale) ? Boolean.valueOf(this.xClamp) : (ObjectConverter.toBoolean(this.yScale) ? Boolean.valueOf(this.yClamp) : null));
    }

    @SwiftMethodOverload(overloads={"Bool"})
    public Brush clamp(Object z) {
        if (ObjectConverter.toBoolean(this.xScale) && ObjectConverter.toBoolean(this.yScale)) {
            this.xClamp = (Boolean)((ArrayEx)z).get(0);
            this.yClamp = (Boolean)((ArrayEx)z).get(1);
        } else if (ObjectConverter.toBoolean(this.xScale)) {
            this.xClamp = ObjectConverter.toBoolean(z);
        } else if (ObjectConverter.toBoolean(this.yScale)) {
            this.yClamp = ObjectConverter.toBoolean(z);
        }
        return this;
    }

    public List extent() {
        double t = 0.0;
        double y1 = 0.0;
        double y0 = 0.0;
        double x1 = 0.0;
        double x0 = 0.0;
        if (ObjectConverter.toBoolean(this.xScale)) {
            if (ObjectConverter.toBoolean(this.xExtentDomain)) {
                x0 = this.xExtentDomain[0];
                x1 = this.xExtentDomain[1];
            } else {
                x0 = this.xExtent[0];
                x1 = this.xExtent[1];
                if (this.xScale.getInvert() != null) {
                    x0 = ObjectConverter.asDouble(this.xScale.getInvert().getValue(x0));
                    x1 = ObjectConverter.asDouble(this.xScale.getInvert().getValue(x1));
                }
                if (x1 < x0) {
                    t = x0;
                    x0 = x1;
                    x1 = t;
                }
            }
        }
        if (ObjectConverter.toBoolean(this.yScale)) {
            if (ObjectConverter.toBoolean(this.yExtentDomain)) {
                y0 = this.yExtentDomain[0];
                y1 = this.yExtentDomain[1];
            } else {
                y0 = this.yExtent[0];
                y1 = this.yExtent[1];
                if (this.yScale.getInvert() != null) {
                    y0 = ObjectConverter.asDouble(this.yScale.getInvert().getValue(y0));
                    y1 = ObjectConverter.asDouble(this.yScale.getInvert().getValue(y1));
                }
                if (y1 < y0) {
                    t = y0;
                    y0 = y1;
                    y1 = t;
                }
            }
        }
        return ObjectConverter.toBoolean(this.xScale) && ObjectConverter.toBoolean(this.yScale) ? new ArrayEx<ArrayEx>(new ArrayEx<Double>(x0, y0), new ArrayEx<Double>(x1, y1)) : (ObjectConverter.toBoolean(this.xScale) ? new ArrayEx<Double>(x0, x1) : (ObjectConverter.toBoolean(this.yScale) ? new ArrayEx<Double>(y0, y1) : null));
    }

    public Brush extent(List z) {
        double t = 0.0;
        double y1 = 0.0;
        double y0 = 0.0;
        double x1 = 0.0;
        double x0 = 0.0;
        if (ObjectConverter.toBoolean(this.xScale)) {
            Object xObj0 = z.get(0);
            Object xObj1 = z.get(1);
            if (ObjectConverter.toBoolean(this.yScale)) {
                x0 = (Double)((List)xObj0).get(0);
                x1 = (Double)((List)xObj1).get(0);
            } else {
                x0 = ObjectConverter.asDouble(xObj0);
                x1 = ObjectConverter.asDouble(xObj1);
            }
            this.xExtentDomain = new Double[]{x0, x1};
            if (this.xScale.getInvert() != null) {
                x0 = ObjectConverter.asDouble(this.xScale.getValue(this.xScale, x0, -1, -1));
                x1 = ObjectConverter.asDouble(this.xScale.getValue(this.xScale, x1, -1, -1));
            }
            if (x1 < x0) {
                t = x0;
                x0 = x1;
                x1 = t;
            }
            if (x0 != this.xExtent[0] || x1 != this.xExtent[1]) {
                this.xExtent = new Double[]{x0, x1};
            }
        }
        if (ObjectConverter.toBoolean(this.yScale)) {
            Object yObj0 = z.get(0);
            Object yObj1 = z.get(1);
            if (ObjectConverter.toBoolean(this.xScale)) {
                y0 = (Double)((List)yObj0).get(1);
                y1 = (Double)((List)yObj1).get(1);
            } else {
                y0 = ObjectConverter.asDouble(yObj0);
                y1 = ObjectConverter.asDouble(yObj1);
            }
            this.yExtentDomain = new Double[]{y0, y1};
            if (this.yScale.getInvert() != null) {
                y0 = ObjectConverter.asDouble(this.yScale.getValue(this.yScale, y0, -1, -1));
                y1 = ObjectConverter.asDouble(this.yScale.getValue(this.yScale, y1, -1, -1));
            }
            if (y1 < y0) {
                t = y0;
                y0 = y1;
                y1 = t;
            }
            if (y0 != this.yExtent[0] || y1 != this.yExtent[1]) {
                this.yExtent = new Double[]{y0, y1};
            }
        }
        return this;
    }

    static /* synthetic */ double[] access$202(Brush x0, double[] x1) {
        x0.center = x1;
        return x1;
    }

    static /* synthetic */ Double[] access$1902(Brush x0, Double[] x1) {
        x0.xExtentDomain = x1;
        return x1;
    }

    static /* synthetic */ Double[] access$2002(Brush x0, Double[] x1) {
        x0.yExtentDomain = x1;
        return x1;
    }

    static /* synthetic */ Double[] access$402(Brush x0, Double[] x1) {
        x0.xExtent = x1;
        return x1;
    }

    static /* synthetic */ Double[] access$502(Brush x0, Double[] x1) {
        x0.yExtent = x1;
        return x1;
    }

    private static final class BrushExtent {
        Double[] x;
        Double[] y;
        Double[] i;
        Double[] j;

        BrushExtent(Double[] x, Double[] y, Double[] i, Double[] j) {
            this.x = x;
            this.y = y;
            this.i = i;
            this.j = j;
        }
    }

    public static final class EventObject
    extends BaseEvent<Brush> {
        private final String mode;

        private EventObject(String type, String mode) {
            super(type);
            this.mode = mode;
        }

        public String getMode() {
            return this.mode;
        }
    }
}

