/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.svg;

import com.ibm.rave.core.functions.SingleValueFunction;
import com.ibm.rave.core.layout.chord.ChordData;
import com.ibm.rave.core.layout.chord.SubGroupData;
import com.ibm.rave.core.nativeImpl.arrays.ArraysUtil;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.core.svg.Arc;

public class Chord
implements ValueFunction<Object, String> {
    private static ValueFunction<Object, SubGroupData> SOURCE = new ValueFunction<Object, SubGroupData>(){

        @Override
        public SubGroupData getValue(Object context, Object data, int index, int groupIndex) {
            return ((ChordData)data).source;
        }
    };
    private static ValueFunction<Object, SubGroupData> TARGET = new ValueFunction<Object, SubGroupData>(){

        @Override
        public SubGroupData getValue(Object context, Object data, int index, int groupIndex) {
            return ((ChordData)data).target;
        }
    };
    private static ValueFunction<Object, ? extends Number> RAIDUS = new ValueFunction<Object, Double>(){

        @Override
        public Double getValue(Object context, Object data, int index, int groupIndex) {
            return ((SubGroupData)data).radius;
        }
    };
    private ValueFunction<Object, SubGroupData> _source = SOURCE;
    private ValueFunction<Object, SubGroupData> _target = TARGET;
    private ValueFunction<Object, ? extends Number> _radius = RAIDUS;
    private ValueFunction<Object, ? extends Number> _startAngle = Arc.START_ANGLE;
    private ValueFunction<Object, ? extends Number> _endAngle = Arc.END_ANGLE;
    private static SingleValueFunction<Object, Object> DEFAULT_ACCESSOR_FN = new SingleValueFunction<Object, Object>(){

        @Override
        public Object getValue(Object data) {
            return data;
        }
    };
    private SingleValueFunction<Object, Object> dataAccessor = DEFAULT_ACCESSOR_FN;

    @Override
    public String getValue(Object context, Object data, int index, int groupIndex) {
        ChordData chordData = (ChordData)this.dataAccessor.getValue(data);
        SubGroup s = this.subgroup(context, this._source, chordData, index, groupIndex);
        SubGroup t = this.subgroup(context, this._target, chordData, index, groupIndex);
        return "M" + ArraysUtil.toString(s.p0) + this.arc(s.r, s.p1, s.a1 - s.a0) + (this.equals(s, t) ? this.curve(s.r, s.p1, s.r, s.p0) : this.curve(s.r, s.p1, t.r, t.p0) + this.arc(t.r, t.p1, t.a1 - t.a0) + this.curve(t.r, t.p1, s.r, s.p0)) + "Z";
    }

    private SubGroup subgroup(Object context, ValueFunction<Object, SubGroupData> f, Object d, int i, int groupIndex) {
        SubGroupData subgroup = f.getValue(context, d, i, groupIndex);
        double r = ObjectConverter.toDouble(this._radius.getValue(context, subgroup, i, groupIndex));
        double a0 = ObjectConverter.toDouble(this._startAngle.getValue(context, subgroup, i, groupIndex)) - 1.5707963267948966;
        double a1 = ObjectConverter.toDouble(this._endAngle.getValue(context, subgroup, i, groupIndex)) - 1.5707963267948966;
        return new SubGroup(r, a0, a1, new double[]{r * Math.cos(a0), r * Math.sin(a0)}, new double[]{r * Math.cos(a1), r * Math.sin(a1)});
    }

    private boolean equals(SubGroup a, SubGroup b) {
        return a.a0 == b.a0 && a.a1 == b.a1;
    }

    private String arc(double r, double[] p, double a) {
        return "A" + r + "," + r + " 0 " + ObjectConverter.toNumber(a > Math.PI) + ",1 " + ArraysUtil.toString(p);
    }

    private String curve(double r0, double[] p0, double r1, double[] p1) {
        return "Q 0,0 " + ArraysUtil.toString(p1);
    }

    public Chord endAngle(ValueFunction<Object, Double> endAngleFn) {
        this._endAngle = endAngleFn;
        return this;
    }

    public Chord setDataAccessor(SingleValueFunction<Object, Object> valueFn) {
        this.dataAccessor = valueFn;
        return this;
    }

    public Chord endAngle(final double value) {
        this._endAngle = new ValueFunction<Object, Double>(){

            @Override
            public Double getValue(Object context, Object data, int index, int groupIndex) {
                return value;
            }
        };
        return this;
    }

    public ValueFunction<Object, ? extends Number> endAngle() {
        return this._endAngle;
    }

    public Chord startAngle(ValueFunction<Object, Double> startAngleFn) {
        this._startAngle = startAngleFn;
        return this;
    }

    public Chord startAngle(final double value) {
        this._startAngle = new ValueFunction<Object, Double>(){

            @Override
            public Double getValue(Object context, Object data, int index, int groupIndex) {
                return value;
            }
        };
        return this;
    }

    public ValueFunction<Object, ? extends Number> startAngle() {
        return this._startAngle;
    }

    public Chord source(ValueFunction<Object, SubGroupData> sourceFn) {
        this._source = sourceFn;
        return this;
    }

    public Chord source(final SubGroupData sourceValue) {
        this._source = new ValueFunction<Object, SubGroupData>(){

            @Override
            public SubGroupData getValue(Object context, Object data, int index, int groupIndex) {
                return sourceValue;
            }
        };
        return this;
    }

    public ValueFunction<Object, SubGroupData> source() {
        return this._source;
    }

    public Chord target(ValueFunction<Object, SubGroupData> targetFn) {
        this._target = targetFn;
        return this;
    }

    public Chord target(final SubGroupData value) {
        this._target = new ValueFunction<Object, SubGroupData>(){

            @Override
            public SubGroupData getValue(Object context, Object data, int index, int groupIndex) {
                return value;
            }
        };
        return this;
    }

    public ValueFunction<Object, SubGroupData> target() {
        return this._target;
    }

    public Chord radius(ValueFunction<Object, Double> radiusFn) {
        this._radius = radiusFn;
        return this;
    }

    public Chord radius(final double value) {
        this._radius = new ValueFunction<Object, Double>(){

            @Override
            public Double getValue(Object context, Object data, int index, int groupIndex) {
                return value;
            }
        };
        return this;
    }

    public ValueFunction<Object, ? extends Number> radius() {
        return this._radius;
    }

    private static class SubGroup {
        double r;
        double a0;
        double a1;
        double[] p0;
        double[] p1;

        SubGroup(double r, double a0, double a1, double[] p0, double[] p1) {
            this.r = r;
            this.a0 = a0;
            this.a1 = a1;
            this.p0 = p0;
            this.p1 = p1;
        }
    }
}

