/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.svg;

import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.geom.Point;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.core.svg.CoreNode;
import com.ibm.rave.core.svg.JSONPoint;

@FunctionClass(value="create", contextInvocation=true)
public class DiagonalPathGenerator {
    private ArrayEx.ArrayValueFunction<Object, Point> projectionFn;
    private ValueFunction<Object, JSONPoint> sourceFn = DEFAULT_SOURCE_FN;
    private ValueFunction<Object, JSONPoint> targetFn = DEFAULT_TARGET_FN;
    private JSONPoint sourceVal = null;
    private JSONPoint targetVal = null;
    private static ValueFunction<Object, JSONPoint> DEFAULT_SOURCE_FN = new ValueFunction<Object, JSONPoint>(){

        @Override
        public JSONPoint getValue(Object context, Object data, int index, int groupIndex) {
            return ((CoreNode)data).source;
        }
    };
    private static ValueFunction<Object, JSONPoint> DEFAULT_TARGET_FN = new ValueFunction<Object, JSONPoint>(){

        @Override
        public JSONPoint getValue(Object context, Object data, int index, int groupIndex) {
            return ((CoreNode)data).target;
        }
    };
    public static ArrayEx.ArrayValueFunction<Object, Point> r2_svg_diagonalProjection = new ArrayEx.ArrayValueFunction<Object, Point>(){

        @Override
        public Point getValue(Object currentValue, int index, ArrayEx<Object> array) {
            JSONPoint input = (JSONPoint)currentValue;
            return new Point(input.x, input.y);
        }
    };

    public DiagonalPathGenerator(ArrayEx.ArrayValueFunction<Object, Point> projection) {
        this.projectionFn = projection;
    }

    @SwiftMethodOverload(skipParameters={1})
    public String create(Object context, Object data, int index) {
        JSONPoint p0 = this.sourceFn != null ? this.sourceFn.getValue(context, data, index, -1) : this.sourceVal;
        JSONPoint p3 = this.targetFn != null ? this.targetFn.getValue(context, data, index, -1) : this.targetVal;
        double m = (p0.y + p3.y) / 2.0;
        JSONPoint ap1 = new JSONPoint();
        ap1.x = p0.x;
        ap1.y = m;
        JSONPoint ap2 = new JSONPoint();
        ap2.x = p3.x;
        ap2.y = m;
        ArrayEx<Object> array = new ArrayEx<Object>(p0, ap1, ap2, p3);
        ArrayEx<Point> pointArray = array.map(this.projectionFn);
        return "M" + pointArray.get(0) + "C" + pointArray.get(1) + " " + pointArray.get(2) + " " + pointArray.get(3);
    }

    public Object source() {
        if (this.sourceFn != null) {
            return this.sourceFn;
        }
        return this.sourceVal;
    }

    public DiagonalPathGenerator source(ValueFunction<Object, JSONPoint> valFn) {
        this.sourceFn = valFn;
        return this;
    }

    public DiagonalPathGenerator source(JSONPoint val) {
        this.sourceFn = null;
        this.sourceVal = val;
        return this;
    }

    public Object target() {
        if (this.targetFn != null) {
            return this.targetFn;
        }
        return this.targetVal;
    }

    public DiagonalPathGenerator target(ValueFunction<Object, JSONPoint> valFn) {
        this.targetFn = valFn;
        return this;
    }

    public DiagonalPathGenerator target(JSONPoint val) {
        this.targetFn = null;
        this.targetVal = val;
        return this;
    }

    public ArrayEx.ArrayValueFunction<Object, Point> projection() {
        return this.projectionFn;
    }

    public DiagonalPathGenerator projection(ArrayEx.ArrayValueFunction<Object, Point> projection) {
        this.projectionFn = projection;
        return this;
    }
}

