/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.svg;

import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.geom.Point;
import com.ibm.rave.core.svg.DiagonalPathGenerator;

public class RadialDiagonalPathGenerator
extends DiagonalPathGenerator {
    public RadialDiagonalPathGenerator() {
        super(DiagonalPathGenerator.r2_svg_diagonalProjection);
    }

    @Override
    public DiagonalPathGenerator projection(ArrayEx.ArrayValueFunction<Object, Point> projectionVal) {
        super.projection(new DiagonalRadialProjection(projectionVal));
        return this;
    }

    static RadialDiagonalPathGenerator createRadialAreaGenerator() {
        return new RadialDiagonalPathGenerator();
    }

    private static class DiagonalRadialProjection
    implements ArrayEx.ArrayValueFunction<Object, Point> {
        private ArrayEx.ArrayValueFunction<Object, Point> innerProjectionFn;

        DiagonalRadialProjection(ArrayEx.ArrayValueFunction<Object, Point> projectionVal) {
            this.innerProjectionFn = projectionVal;
        }

        @Override
        public Point getValue(Object currentValue, int index, ArrayEx<Object> array) {
            Point p = this.innerProjectionFn.getValue(currentValue, index, array);
            double r = p.getX();
            double a = p.getY() - 1.5707963267948966;
            return new Point(r * Math.cos(a), r * Math.sin(a));
        }
    }
}

