/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.svg;

import com.ibm.rave.core.svg.Arc;
import com.ibm.rave.core.svg.AreaPathGeneratorFactory;
import com.ibm.rave.core.svg.Axis;
import com.ibm.rave.core.svg.Brush;
import com.ibm.rave.core.svg.Chord;
import com.ibm.rave.core.svg.DiagonalPathGeneratorFactory;
import com.ibm.rave.core.svg.LinePathGeneratorFactory;
import com.ibm.rave.core.svg.Symbol;
import com.ibm.rave.core.svg.SymbolCreator;
import java.util.List;

public class SVG {
    private static volatile SVG INSTANCE;
    public LinePathGeneratorFactory line = new LinePathGeneratorFactory();
    public AreaPathGeneratorFactory area = new AreaPathGeneratorFactory();
    public DiagonalPathGeneratorFactory diagonal = new DiagonalPathGeneratorFactory();
    public List<String> symbolTypes = Symbol.getSymbolTypes();

    private SVG() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SVG getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<SVG> clazz = SVG.class;
        synchronized (SVG.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new SVG();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public Arc arc() {
        return new Arc();
    }

    public Chord chord() {
        return new Chord();
    }

    public Axis axis() {
        return new Axis();
    }

    public Symbol symbol() {
        return new Symbol();
    }

    public Brush brush() {
        return Brush.newBrush();
    }

    public boolean symbolCreator(String id, SymbolCreator symbolCreator) {
        return Symbol.register(id, symbolCreator);
    }
}

