/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.svg;

import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.geom.Point;
import com.ibm.rave.core.internal.util.Identity;
import com.ibm.rave.core.internal.util.TrueFunction;
import com.ibm.rave.core.nativeImpl.arrays.ES6Map;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.core.svg.AbstractLineInterpolator;
import com.ibm.rave.core.svg.LinePathGenerator;

public class SVGLine {
    public static final ValueFunction<Object, Object> DEFAULT_X_FN = new ValueFunction<Object, Object>(){

        @Override
        public Object getValue(Object context, Object data, int index, int groupIndex) {
            return ((Point)data).getX();
        }
    };
    public static final ValueFunction<Object, Object> DEFAULT_Y_FN = new ValueFunction<Object, Object>(){

        @Override
        public Object getValue(Object context, Object data, int index, int groupIndex) {
            return ((Point)data).getY();
        }
    };
    private static ValueFunction<Object, ArrayEx<?>> DEFAULT_PROJECTION = Identity.create();
    private static ArrayEx<Double> r2_svg_lineBasisBezier1 = new ArrayEx<Double>(0.0, 0.6666666666666666, 0.3333333333333333, 0.0);
    private static ArrayEx<Double> r2_svg_lineBasisBezier2 = new ArrayEx<Double>(0.0, 0.3333333333333333, 0.6666666666666666, 0.0);
    private static ArrayEx<Double> r2_svg_lineBasisBezier3 = new ArrayEx<Double>(0.0, 0.16666666666666666, 0.6666666666666666, 0.16666666666666666);
    private static AbstractLineInterpolator r2_svg_lineStep = new AbstractLineInterpolator("step", false){

        @Override
        public String getValue(ArrayEx<Point> points, double tension) {
            int i = 0;
            int n = points.size();
            Point p = (Point)points.get(0);
            ArrayEx<Object> path = new ArrayEx<Object>(p.getX(), ",", p.getY());
            while (++i < n) {
                Object[] objectArray = new Object[4];
                objectArray[0] = "H";
                double d = p.getX();
                p = (Point)points.get(i);
                objectArray[1] = (d + p.getX()) / 2.0;
                objectArray[2] = "V";
                objectArray[3] = p.getY();
                path.push((Object[])objectArray);
            }
            if (n > 1) {
                path.push((Object[])new Object[]{"H", p.getX()});
            }
            return path.join("");
        }
    };
    private static AbstractLineInterpolator r2_svg_lineStepBefore = new AbstractLineInterpolator("step-before", false){

        @Override
        public String getValue(ArrayEx<Point> points, double tension) {
            int i = 0;
            int n = points.size();
            Point p = (Point)points.get(0);
            ArrayEx<Object> path = new ArrayEx<Object>(p.getX(), ",", p.getY());
            while (++i < n) {
                Object[] objectArray = new Object[4];
                objectArray[0] = "V";
                p = (Point)points.get(i);
                objectArray[1] = p.getY();
                objectArray[2] = "H";
                objectArray[3] = p.getX();
                path.push((Object[])objectArray);
            }
            return path.join("");
        }
    };
    private static AbstractLineInterpolator r2_svg_lineStepAfter = new AbstractLineInterpolator("step-after", false){

        @Override
        public String getValue(ArrayEx<Point> points, double tension) {
            int i = 0;
            int n = points.size();
            Point p = (Point)points.get(0);
            ArrayEx<Object> path = new ArrayEx<Object>(p.getX(), ",", p.getY());
            while (++i < n) {
                Object[] objectArray = new Object[4];
                objectArray[0] = "H";
                p = (Point)points.get(i);
                objectArray[1] = p.getX();
                objectArray[2] = "V";
                objectArray[3] = p.getY();
                path.push((Object[])objectArray);
            }
            return path.join("");
        }
    };
    private static AbstractLineInterpolator r2_svg_lineCardinalOpen = new AbstractLineInterpolator("cardinal-open", false){

        @Override
        public String getValue(ArrayEx<Point> points, double tension) {
            return points.size() < 4 ? r2_svg_lineLinear.getValue(points, tension) : points.get(1) + SVGLine.r2_svg_lineHermite(points.slice(1, -1), SVGLine.r2_svg_lineCardinalTangents(points, tension));
        }
    };
    private static AbstractLineInterpolator r2_svg_lineCardinalClosed = new AbstractLineInterpolator("cardinal-closed", true){

        @Override
        public String getValue(ArrayEx<Point> points, double tension) {
            if (points.size() < 3) {
                return r2_svg_lineLinear.getValue(points, tension);
            }
            Point p1 = (Point)points.get(0);
            points.push((Point[])new Point[]{p1});
            ArrayEx p2 = new ArrayEx();
            p2.add(points.get(points.size() - 2));
            ArrayEx array = new ArrayEx();
            array.add(points.get(1));
            p2 = p2.concat(points, array);
            ArrayEx tangents = SVGLine.r2_svg_lineCardinalTangents(p2, tension);
            return p1 + SVGLine.r2_svg_lineHermite(points, tangents);
        }
    };
    private static AbstractLineInterpolator r2_svg_lineCardinal = new AbstractLineInterpolator("cardinal", false){

        @Override
        public String getValue(ArrayEx<Point> points, double tension) {
            return points.size() < 3 ? r2_svg_lineLinear.getValue(points, tension) : points.get(0) + SVGLine.r2_svg_lineHermite(points, SVGLine.r2_svg_lineCardinalTangents(points, tension));
        }
    };
    private static AbstractLineInterpolator r2_svg_lineBasis = new AbstractLineInterpolator("basis", false){

        @Override
        public String getValue(ArrayEx<Point> points, double tension) {
            if (points.size() < 3) {
                return r2_svg_lineLinear.getValue(points, tension);
            }
            int i = 1;
            int n = points.size();
            Point pi = (Point)points.get(0);
            double x0 = pi.getX();
            double y0 = pi.getY();
            Double[] doubleArray = new Double[4];
            doubleArray[0] = x0;
            doubleArray[1] = x0;
            doubleArray[2] = x0;
            pi = (Point)points.get(1);
            doubleArray[3] = pi.getX();
            ArrayEx<Double> px = new ArrayEx<Double>(doubleArray);
            ArrayEx<Double> py = new ArrayEx<Double>(y0, y0, y0, pi.getY());
            ArrayEx<Object> path = new ArrayEx<Object>(x0, ",", y0, "L", SVGLine.r2_svg_lineDot4(r2_svg_lineBasisBezier3, px), ",", SVGLine.r2_svg_lineDot4(r2_svg_lineBasisBezier3, py));
            points.push((Point[])new Point[]{(Point)points.get(n - 1)});
            while (++i <= n) {
                pi = (Point)points.get(i);
                px.shift();
                px.push((Double[])new Double[]{pi.getX()});
                py.shift();
                py.push((Double[])new Double[]{pi.getY()});
                SVGLine.r2_svg_lineBasisBezier(path, px, py);
            }
            points.pop();
            path.push((Object[])new Object[]{"L", pi});
            return path.join("");
        }
    };
    private static AbstractLineInterpolator r2_svg_lineBasisOpen = new AbstractLineInterpolator("basis-open", false){

        @Override
        public String getValue(ArrayEx<Point> points, double tension) {
            Point pi;
            if (points.size() < 4) {
                return r2_svg_lineLinear.getValue(points, 0.0);
            }
            ArrayEx<Object> path = new ArrayEx<Object>();
            int i = -1;
            int n = points.size();
            ArrayEx<Double> px = new ArrayEx<Double>();
            ArrayEx<Double> py = new ArrayEx<Double>();
            px.add(0.0);
            py.add(0.0);
            while (++i < 3) {
                pi = (Point)points.get(i);
                px.push(pi.getX());
                py.push(pi.getY());
            }
            path.push(SVGLine.r2_svg_lineDot4(r2_svg_lineBasisBezier3, px) + "," + SVGLine.r2_svg_lineDot4(r2_svg_lineBasisBezier3, py));
            --i;
            while (++i < n) {
                pi = (Point)points.get(i);
                px.shift();
                px.push(pi.getX());
                py.shift();
                py.push(pi.getY());
                SVGLine.r2_svg_lineBasisBezier(path, px, py);
            }
            return path.join("");
        }
    };
    private static AbstractLineInterpolator r2_svg_lineBasisClosed = new AbstractLineInterpolator("basis-closed", true){

        @Override
        public String getValue(ArrayEx<Point> points, double tension) {
            Point pi;
            if (points.size() < 4) {
                return r2_svg_lineLinear.getValue(points, 0.0);
            }
            int i = -1;
            int n = points.size();
            int m = n + 4;
            ArrayEx<Double> px = new ArrayEx<Double>();
            ArrayEx<Double> py = new ArrayEx<Double>();
            while (++i < 4) {
                pi = (Point)points.get(i % n);
                px.push(pi.getX());
                py.push(pi.getY());
            }
            ArrayEx<Object> path = new ArrayEx<Object>(SVGLine.r2_svg_lineDot4(r2_svg_lineBasisBezier3, px), ",", SVGLine.r2_svg_lineDot4(r2_svg_lineBasisBezier3, py));
            --i;
            while (++i < m) {
                pi = (Point)points.get(i % n);
                px.shift();
                px.push(pi.getX());
                py.shift();
                py.push(pi.getY());
                SVGLine.r2_svg_lineBasisBezier(path, px, py);
            }
            return path.join("");
        }
    };
    private static AbstractLineInterpolator r2_svg_lineBundle = new AbstractLineInterpolator("bundle", false){

        @Override
        public String getValue(ArrayEx<Point> points, double tension) {
            int n = points.size() - 1;
            if (n != 0) {
                Point p = (Point)points.get(0);
                double x0 = p.getX();
                double y0 = p.getY();
                p = (Point)points.get(n);
                double dx = p.getX() - x0;
                double dy = p.getY() - y0;
                int i = -1;
                while (++i <= n) {
                    p = (Point)points.get(i);
                    double t = (double)i / (double)n;
                    p.setX(tension * p.getX() + (1.0 - tension) * (x0 + t * dx));
                    p.setY(tension * p.getY() + (1.0 - tension) * (y0 + t * dy));
                }
            }
            return r2_svg_lineBasis.getValue(points, 0.0);
        }
    };
    public static AbstractLineInterpolator r2_svg_lineLinear = new AbstractLineInterpolator("linear", false){

        @Override
        public final String getValue(ArrayEx<Point> data, double tension) {
            return data.join("L");
        }
    };
    public static AbstractLineInterpolator r2_svg_lineLinearClosed = new AbstractLineInterpolator("linear-closed", true){

        @Override
        public String getValue(ArrayEx<Point> data, double tension) {
            return r2_svg_lineLinear.getValue(data, tension) + "Z";
        }
    };
    private static AbstractLineInterpolator r2_svg_lineMonotone = new AbstractLineInterpolator("monotone", false){

        @Override
        public String getValue(ArrayEx<Point> points, double tension) {
            return points.size() < 3 ? r2_svg_lineLinear.getValue(points, tension) : points.get(0) + SVGLine.r2_svg_lineHermite(points, SVGLine.r2_svg_lineMonotoneTangents(points));
        }
    };
    static ES6Map<String, AbstractLineInterpolator> r2_svg_lineInterpolators = SVGLine.initialize_r2_svg_lineInterpolators();
    static ValueFunction<Object, Boolean> DEFAULT_DEFINED_FN = new TrueFunction();

    public static LinePathGenerator createLine(ValueFunction<Object, ArrayEx<?>> projection) {
        return new LinePathGenerator(projection);
    }

    public static LinePathGenerator createLine() {
        return new LinePathGenerator(DEFAULT_PROJECTION);
    }

    private static String r2_svg_lineHermite(ArrayEx<Point> points, ArrayEx<Point> tangents) {
        Point t0;
        if (tangents.size() < 1 || points.size() != tangents.size() && points.size() != tangents.size() + 2) {
            return r2_svg_lineLinear.getValue(points, 0.0);
        }
        boolean quad = points.size() != tangents.size();
        StringBuilder path = new StringBuilder("");
        Point p0 = (Point)points.get(0);
        Point p = (Point)points.get(1);
        Point t = t0 = (Point)tangents.get(0);
        int pi = 1;
        if (quad) {
            double x = p.getX() - t0.getX() * 2.0 / 3.0;
            double y = p.getY() - t0.getY() * 2.0 / 3.0;
            path.append("Q" + x + "," + y + "," + p.getX() + "," + p.getY());
            p0 = (Point)points.get(1);
            pi = 2;
        }
        if (tangents.size() > 1) {
            t = (Point)tangents.get(1);
            p = (Point)points.get(pi);
            ++pi;
            path.append("C" + (p0.getX() + t0.getX()) + "," + (p0.getY() + t0.getY()) + "," + (p.getX() - t.getX()) + "," + (p.getY() - t.getY()) + "," + p.getX() + "," + p.getY());
            int i = 2;
            while (i < tangents.size()) {
                p = (Point)points.get(pi);
                t = (Point)tangents.get(i);
                path.append("S" + (p.getX() - t.getX()) + "," + (p.getY() - t.getY()) + "," + p.getX() + "," + p.getY());
                ++i;
                ++pi;
            }
        }
        if (quad) {
            Point lp = (Point)points.get(pi);
            double x = p.getX() + t.getX() * 2.0 / 3.0;
            double y = p.getY() + t.getY() * 2.0 / 3.0;
            path.append("Q" + x + "," + y + "," + lp.getX() + "," + lp.getY());
        }
        return path.toString();
    }

    private static ArrayEx<Point> r2_svg_lineCardinalTangents(ArrayEx<Point> points, double tension) {
        ArrayEx<Point> tangents = new ArrayEx<Point>();
        double a = (1.0 - tension) / 2.0;
        Point p1 = (Point)points.get(0);
        Point p2 = (Point)points.get(1);
        int i = 1;
        int n = points.size();
        while (++i < n) {
            Point p0 = p1;
            p1 = p2;
            p2 = (Point)points.get(i);
            tangents.push((Point[])new Point[]{new Point(a * (p2.getX() - p0.getX()), a * (p2.getY() - p0.getY()))});
        }
        return tangents;
    }

    private static double r2_svg_lineDot4(ArrayEx<Double> a, ArrayEx<Double> b) {
        return (Double)a.get(0) * (Double)b.get(0) + (Double)a.get(1) * (Double)b.get(1) + (Double)a.get(2) * (Double)b.get(2) + (Double)a.get(3) * (Double)b.get(3);
    }

    private static void r2_svg_lineBasisBezier(ArrayEx<Object> path, ArrayEx<Double> x, ArrayEx<Double> y) {
        path.push((Object[])new Object[]{"C", SVGLine.r2_svg_lineDot4(r2_svg_lineBasisBezier1, x), ",", SVGLine.r2_svg_lineDot4(r2_svg_lineBasisBezier1, y), ",", SVGLine.r2_svg_lineDot4(r2_svg_lineBasisBezier2, x), ",", SVGLine.r2_svg_lineDot4(r2_svg_lineBasisBezier2, y), ",", SVGLine.r2_svg_lineDot4(r2_svg_lineBasisBezier3, x), ",", SVGLine.r2_svg_lineDot4(r2_svg_lineBasisBezier3, y)});
    }

    private static double r2_svg_lineSlope(Point p0, Point p1) {
        return (p1.getY() - p0.getY()) / (p1.getX() - p0.getX());
    }

    private static ArrayEx<Double> r2_svg_lineFiniteDifferences(ArrayEx<Point> points) {
        int i = 0;
        int j = points.size() - 1;
        ArrayEx<Double> m = new ArrayEx<Double>();
        Point p0 = (Point)points.get(0);
        Point p1 = (Point)points.get(1);
        double d = SVGLine.r2_svg_lineSlope(p0, p1);
        m.add(d);
        while (++i < j) {
            double d2 = d;
            p0 = p1;
            p1 = (Point)points.get(i + 1);
            d = SVGLine.r2_svg_lineSlope(p0, p1);
            m.add((d2 + d) / 2.0);
        }
        m.add(d);
        return m;
    }

    private static ArrayEx<Point> r2_svg_lineMonotoneTangents(ArrayEx<Point> points) {
        double s;
        ArrayEx<Point> tangents = new ArrayEx<Point>();
        ArrayEx<Double> m = SVGLine.r2_svg_lineFiniteDifferences(points);
        int i = -1;
        int j = points.size() - 1;
        while (++i < j) {
            double b;
            double d = SVGLine.r2_svg_lineSlope((Point)points.get(i), (Point)points.get(i + 1));
            if (Math.abs(d) < 1.0E-6) {
                m.set(i, 0.0);
                m.set(i + 1, 0.0);
                continue;
            }
            double a = (Double)m.get(i) / d;
            s = a * a + (b = (Double)m.get(i + 1) / d) * b;
            if (!(s > 9.0)) continue;
            s = d * 3.0 / Math.sqrt(s);
            m.set(i, s * a);
            m.set(i + 1, s * b);
        }
        i = -1;
        while (++i <= j) {
            s = (((Point)points.get(Math.min(j, i + 1))).getX() - ((Point)points.get(Math.max(0, i - 1))).getX()) / (6.0 * (1.0 + (Double)m.get(i) * (Double)m.get(i)));
            if (s != s) {
                s = 0.0;
            }
            double difference = (Double)m.get(i) * s;
            double s1 = ObjectConverter.toBoolean(s) ? s : 0.0;
            double s2 = ObjectConverter.toBoolean(difference) ? difference : 0.0;
            tangents.push((Point[])new Point[]{new Point(s1, s2)});
        }
        return tangents;
    }

    private static ES6Map<String, AbstractLineInterpolator> initialize_r2_svg_lineInterpolators() {
        ES6Map<String, AbstractLineInterpolator> r2_svg_lineInterpolators = ES6Map.create();
        r2_svg_lineInterpolators.set(r2_svg_lineLinear.getKey(), r2_svg_lineLinear);
        r2_svg_lineInterpolators.set(r2_svg_lineLinearClosed.getKey(), r2_svg_lineLinearClosed);
        r2_svg_lineInterpolators.set(r2_svg_lineStep.getKey(), r2_svg_lineStep);
        r2_svg_lineInterpolators.set(r2_svg_lineStepBefore.getKey(), r2_svg_lineStepBefore);
        r2_svg_lineInterpolators.set(r2_svg_lineStepAfter.getKey(), r2_svg_lineStepAfter);
        r2_svg_lineInterpolators.set(r2_svg_lineBasis.getKey(), r2_svg_lineBasis);
        r2_svg_lineInterpolators.set(r2_svg_lineBasisOpen.getKey(), r2_svg_lineBasisOpen);
        r2_svg_lineInterpolators.set(r2_svg_lineBasisClosed.getKey(), r2_svg_lineBasisClosed);
        r2_svg_lineInterpolators.set(r2_svg_lineBundle.getKey(), r2_svg_lineBundle);
        r2_svg_lineInterpolators.set(r2_svg_lineCardinal.getKey(), r2_svg_lineCardinal);
        r2_svg_lineInterpolators.set(r2_svg_lineCardinalOpen.getKey(), r2_svg_lineCardinalOpen);
        r2_svg_lineInterpolators.set(r2_svg_lineCardinalClosed.getKey(), r2_svg_lineCardinalClosed);
        r2_svg_lineInterpolators.set(r2_svg_lineMonotone.getKey(), r2_svg_lineMonotone);
        r2_svg_lineStepBefore.setReverse(r2_svg_lineStepAfter);
        r2_svg_lineStepAfter.setReverse(r2_svg_lineStepBefore);
        return r2_svg_lineInterpolators;
    }
}

