/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.time;

import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.rave.core.arrays.Bisector;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.internal.nativeImpl.Lang;
import com.ibm.rave.core.internal.scales.Nice;
import com.ibm.rave.core.internal.scales.NiceIdentity;
import com.ibm.rave.core.internal.time.ITimeRangeProvider;
import com.ibm.rave.core.interpolate.InterpolatorFactory;
import com.ibm.rave.core.nativeImpl.time.Date;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scales.AbstractScale;
import com.ibm.rave.core.scales.LinearScale;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.core.time.IDate;
import com.ibm.rave.core.time.ITimeInterval;
import com.ibm.rave.core.time.Time;
import com.ibm.rave.core.time.TimeInterval;
import com.ibm.rave.core.time.TimeRangeValueFunction;
import java.util.List;

public class DateTimeScale
extends LinearScale {
    static final ArrayEx.ArrayValueFunction<Object, Object> scaleDate = new ScaleDate();
    private ValueFunction<Object, String> _format;
    private ArrayEx<ArrayEx<Object>> _methods;
    private ITimeInterval _methodsYear;
    private static ArrayEx<Object> scaleSteps = new ArrayEx<Object>(new Double(1000.0), new Double(5000.0), new Double(15000.0), new Double(30000.0), new Double(60000.0), new Double(300000.0), new Double(900000.0), new Double(1800000.0), new Double(3600000.0), new Double(1.08E7), new Double(2.16E7), new Double(4.32E7), new Double(8.64E7), new Double(1.728E8), new Double(6.048E8), new Double(2.592E9), new Double(7.776E9), new Double(3.1536E10));
    public static ArrayEx<ArrayEx<Object>> localMethods = new ArrayEx<ArrayEx>(new ArrayEx<Object>(Time.getInstance().second, 1), new ArrayEx<Object>(Time.getInstance().second, 5), new ArrayEx<Object>(Time.getInstance().second, 15), new ArrayEx<Object>(Time.getInstance().second, 30), new ArrayEx<Object>(Time.getInstance().minute, 1), new ArrayEx<Object>(Time.getInstance().minute, 5), new ArrayEx<Object>(Time.getInstance().minute, 15), new ArrayEx<Object>(Time.getInstance().minute, 30), new ArrayEx<Object>(Time.getInstance().hour, 1), new ArrayEx<Object>(Time.getInstance().hour, 3), new ArrayEx<Object>(Time.getInstance().hour, 6), new ArrayEx<Object>(Time.getInstance().hour, 12), new ArrayEx<Object>(Time.getInstance().day, 1), new ArrayEx<Object>(Time.getInstance().day, 2), new ArrayEx<Object>(Time.getInstance().week, 1), new ArrayEx<Object>(Time.getInstance().month, 1), new ArrayEx<Object>(Time.getInstance().month, 3), new ArrayEx<Object>(Time.getInstance().year, 1));
    public static final ArrayEx<ArrayEx<Object>> utcMethods = localMethods.map(new ArrayEx.ArrayValueFunction<ArrayEx<Object>, ArrayEx<Object>>(){

        @Override
        public ArrayEx<Object> getValue(ArrayEx<Object> currentValue, int index, ArrayEx<ArrayEx<Object>> array) {
            return new ArrayEx<Object>(((TimeInterval)currentValue.get((int)0)).utc, currentValue.get(1));
        }
    });
    public static final ValueFunction<Object, String> localFormat = Time.getInstance().format.multi(new Object[][]{{".%L", new ValueFunction<Object, Integer>(){

        @Override
        public Integer getValue(Object context, Object data, int index, int groupIndex) {
            return ((IDate)data).getMilliseconds();
        }
    }}, {":%S", new ValueFunction<Object, Integer>(){

        @Override
        public Integer getValue(Object context, Object data, int index, int groupIndex) {
            return ((IDate)data).getSeconds();
        }
    }}, {"%I:%M", new ValueFunction<Object, Integer>(){

        @Override
        public Integer getValue(Object context, Object data, int index, int groupIndex) {
            return ((IDate)data).getMinutes();
        }
    }}, {"%I %p", new ValueFunction<Object, Integer>(){

        @Override
        public Integer getValue(Object context, Object data, int index, int groupIndex) {
            return ((IDate)data).getHours();
        }
    }}, {"%a %d", new ValueFunction<Object, Integer>(){

        @Override
        public Integer getValue(Object context, Object data, int index, int groupIndex) {
            IDate date = (IDate)data;
            return ObjectConverter.toBoolean(date.getDay()) && date.getDate() != 1 ? 1 : 0;
        }
    }}, {"%b %d", new ValueFunction<Object, Integer>(){

        @Override
        public Integer getValue(Object context, Object data, int index, int groupIndex) {
            return ((IDate)data).getDate() != 1 ? 1 : 0;
        }
    }}, {"%B", new ValueFunction<Object, Integer>(){

        @Override
        public Integer getValue(Object context, Object data, int index, int groupIndex) {
            return ((IDate)data).getMonth();
        }
    }}, {"%Y", new ValueFunction<Object, Integer>(){

        @Override
        public Integer getValue(Object context, Object data, int index, int groupIndex) {
            return 1;
        }
    }}});
    public static final ValueFunction<Object, String> utcFormat = Time.getInstance().format.utc.multi(new Object[][]{{".%L", new ValueFunction<Object, Integer>(){

        @Override
        public Integer getValue(Object context, Object data, int index, int groupIndex) {
            return ((IDate)data).getUTCMilliseconds();
        }
    }}, {":%S", new ValueFunction<Object, Integer>(){

        @Override
        public Integer getValue(Object context, Object data, int index, int groupIndex) {
            return ((IDate)data).getUTCSeconds();
        }
    }}, {"%I:%M", new ValueFunction<Object, Integer>(){

        @Override
        public Integer getValue(Object context, Object data, int index, int groupIndex) {
            return ((IDate)data).getUTCMinutes();
        }
    }}, {"%I %p", new ValueFunction<Object, Integer>(){

        @Override
        public Integer getValue(Object context, Object data, int index, int groupIndex) {
            return ((IDate)data).getUTCHours();
        }
    }}, {"%a %d", new ValueFunction<Object, Integer>(){

        @Override
        public Integer getValue(Object context, Object data, int index, int groupIndex) {
            IDate date = (IDate)data;
            return ObjectConverter.toBoolean(date.getUTCDay()) && date.getUTCDate() != 1 ? 1 : 0;
        }
    }}, {"%b %d", new ValueFunction<Object, Integer>(){

        @Override
        public Integer getValue(Object context, Object data, int index, int groupIndex) {
            return ((IDate)data).getUTCDate() != 1 ? 1 : 0;
        }
    }}, {"%B", new ValueFunction<Object, Integer>(){

        @Override
        public Integer getValue(Object context, Object data, int index, int groupIndex) {
            return ((IDate)data).getUTCMonth();
        }
    }}, {"%Y", new ValueFunction<Object, Integer>(){

        @Override
        public Integer getValue(Object context, Object data, int index, int groupIndex) {
            return 1;
        }
    }}});
    public static final ITimeInterval localMethodsYear = Time.getInstance().year;
    public static final ITimeInterval utcMethodsYear = Time.getInstance().year.utc;

    @Override
    public ArrayEx<Object> domain() {
        return ((ArrayEx)super.domain()).map(scaleDate);
    }

    @Override
    public DateTimeScale copy() {
        return new DateTimeScale(this.domain(), this.range(), this._interpolate, this._clamp, this._format, this._methods, this._methodsYear);
    }

    DateTimeScale(List<Object> domain, List<Object> range, InterpolatorFactory<Object> interpolate, Boolean clamp, ValueFunction<Object, String> format, ArrayEx<ArrayEx<Object>> methods, ITimeInterval methodsYear) {
        super(domain, range, interpolate, clamp);
        this._format = format;
        this._methods = methods;
        this._methodsYear = methodsYear;
        final DateTimeScale self = this;
        this.setInvert(new AbstractScale.InvertValueFunction<Object>(){

            @Override
            public Object getValue(Object y) {
                return self.invertDate(y);
            }
        });
        this.setTicks(new AbstractScale.TicksValueFunction(){

            @Override
            public ArrayEx<Object> getValue(Object ... tickArguments) {
                return self.timeTicks(tickArguments);
            }
        });
        this.setTickFormat(new AbstractScale.TickFormatValueFunction(){

            @Override
            public ValueFunction<Object, String> getValue(Object ... tickArguments) {
                return self.timeTickFormat(tickArguments);
            }
        });
    }

    private ArrayEx<Object> tickMethod(ArrayEx<Object> extent, Number tickCount) {
        double span = ObjectConverter.toDouble(extent.get(1)) - ObjectConverter.toDouble(extent.get(0));
        Double target = span / (double)tickCount.intValue();
        int i = Bisector.bisect.bisect(scaleSteps, target);
        if (i == scaleSteps.length()) {
            ArrayEx<Object> list = extent.map(new ArrayEx.ArrayValueFunction<Object, Object>(){

                @Override
                public Object getValue(Object currentValue, int index, ArrayEx<Object> array) {
                    return ObjectConverter.toDouble(currentValue) / 3.1536E10;
                }
            });
            return new ArrayEx<Object>(this._methodsYear, DateTimeScale.linearTickRange(list, tickCount).get(2));
        }
        if (i == 0) {
            return new ArrayEx<Object>(Time.getInstance().millisecond, DateTimeScale.linearTickRange(extent, tickCount).get(2));
        }
        int index = target / ObjectConverter.asDouble(scaleSteps.get(i - 1)) < ObjectConverter.asDouble(scaleSteps.get(i)) / target ? i - 1 : i;
        return (ArrayEx)this._methods.get(index);
    }

    @Override
    public LinearScale nice() {
        return this.nice(10);
    }

    @Override
    public LinearScale nice(Number tickCount) {
        List domain = this.domain();
        ArrayEx<Object> extent = AbstractScale.scaleExtent(domain);
        ArrayEx<Object> method = this.tickMethod(extent, tickCount);
        return this.nice((ITimeInterval)method.get(0), (Number)method.get(1));
    }

    @Override
    public LinearScale nice(ITimeInterval interval) {
        return this.nice(interval, (Number)0);
    }

    @Override
    public LinearScale nice(final ITimeInterval interval, Number tickCount) {
        int skip = ObjectConverter.toInt(tickCount);
        return this.domain(Nice.scaleNice((ArrayEx<Object>)this.domain(), skip > 1 ? new TimeNiceIdentity(interval, skip) : new NiceIdentity(new Nice.ValueFunction(){

            @Override
            public Number getValue(Number x) {
                return interval.floor(new Date(x.longValue())).getTime();
            }
        }, new Nice.ValueFunction(){

            @Override
            public Number getValue(Number x) {
                return interval.ceil(new Date(x.longValue())).getTime();
            }
        })));
    }

    private ArrayEx<Object> timeTicks(Object ... tickArguments) {
        List domain = this.domain();
        ArrayEx<Object> extent = AbstractScale.scaleExtent(domain);
        ITimeRangeProvider interval = null;
        Number count = 0;
        if (tickArguments.length > 0) {
            if (Lang.isNumber(tickArguments[0])) {
                count = (Number)tickArguments[0];
            } else {
                interval = (ITimeRangeProvider)tickArguments[0];
            }
        }
        if (interval != null && tickArguments.length > 1 && Lang.isNumber(tickArguments[1])) {
            count = (Number)tickArguments[1];
        }
        if (interval == null) {
            if (tickArguments.length > 1) {
                count = 0;
            }
            ArrayEx<Object> method = this.tickMethod(extent, count == null || count.intValue() == 0 ? (Number)10 : (Number)count);
            interval = (ITimeRangeProvider)method.get(0);
            count = (Number)method.get(1);
        }
        int skip = count.intValue();
        IDate date1 = (IDate)extent.get(0);
        IDate date2 = (IDate)extent.get(1);
        if (interval.hasRangeMethod()) {
            return ((ITimeInterval)interval).range(date1, new Date(date2.getTime() + 1L), skip < 1 ? 1 : skip);
        }
        return ((TimeRangeValueFunction)interval).getValue(date1, new Date(date2.getTime() + 1L), skip < 1 ? 1 : skip);
    }

    private ValueFunction<Object, String> timeTickFormat(Object ... tickArguments) {
        return this._format;
    }

    private IDate invertDate(Object x) {
        return (IDate)scaleDate.getValue(this.input.getValue(x), 0, null);
    }

    public class TimeNiceIdentity
    extends NiceIdentity {
        private final ITimeInterval interval;
        private final int skip;

        TimeNiceIdentity(final ITimeInterval interval, int skip) {
            this.interval = interval;
            this.skip = skip;
            final TimeNiceIdentity self = this;
            this.floor = new Nice.ValueFunction(){

                @Override
                public Number getValue(Number dateNumber) {
                    IDate newDate = new Date(dateNumber.longValue());
                    while (self.skipped(newDate = interval.floor(newDate))) {
                        newDate = new Date(newDate.getTime() - 1L);
                    }
                    return newDate.getTime();
                }
            };
            this.ceil = new Nice.ValueFunction(){

                @Override
                public Number getValue(Number dateNumber) {
                    IDate newDate = new Date(dateNumber.longValue());
                    while (self.skipped(newDate = interval.ceil(newDate))) {
                        newDate = new Date(newDate.getTime() + 1L);
                    }
                    return newDate.getTime();
                }
            };
        }

        boolean skipped(IDate date) {
            return this.interval.range(date, new Date(date.getTime() + 1L), this.skip).size() == 0;
        }
    }

    private static class ScaleDate
    implements ArrayEx.ArrayValueFunction<Object, Object> {
        private ScaleDate() {
        }

        @Override
        @SwiftMethodOverload(skipOverloads={"Bool"})
        public Object getValue(Object currentValue, int index, ArrayEx<Object> array) {
            return new Date(ObjectConverter.toLong(currentValue));
        }
    }
}

