/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.time;

import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.time.DateUTC;
import com.ibm.rave.core.time.IDate;
import com.ibm.rave.core.time.ITimeInterval;
import com.ibm.rave.core.time.TimeInterval;
import com.ibm.rave.core.time.TimeIntervalFunction;

public class TimeIntervalUTC
implements TimeIntervalFunction,
ITimeInterval {
    private final ITimeInterval delegate;

    public TimeIntervalUTC(TimeInterval interval) {
        this.delegate = interval;
    }

    @Override
    public boolean hasRangeMethod() {
        return true;
    }

    @Override
    public IDate round(IDate date) {
        return this.delegate.round(new DateUTC(date.getTime())).getDateObject();
    }

    @Override
    public IDate ceil(IDate date) {
        return this.delegate.ceil(new DateUTC(date.getTime())).getDateObject();
    }

    @Override
    public IDate offset(IDate date, int k) {
        return this.delegate.offset(new DateUTC(date.getTime()), k).getDateObject();
    }

    @Override
    public ArrayEx<Object> range(IDate t0, IDate t1, int dt) {
        return this.delegate.range(new DateUTC(t0.getTime()), new DateUTC(t1.getTime()), dt);
    }

    @Override
    public IDate floor(IDate date) {
        return this.delegate.floor(new DateUTC(date.getTime())).getDateObject();
    }

    @Override
    public void step(IDate date, int offset) {
        this.delegate.step(new DateUTC(date.getTime()), offset);
    }

    @Override
    public int number(IDate date) {
        return this.delegate.number(new DateUTC(date.getTime()));
    }

    @Override
    public IDate getValue(IDate start) {
        return this.floor(start);
    }
}

