/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.transform;

import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.geom.PointStruct;
import com.ibm.rave.core.geom.RectStruct;
import com.ibm.rave.core.transform.Matrix;
import java.util.ArrayList;
import java.util.List;

public final class MatrixUtil {
    private MatrixUtil() {
    }

    public static void mapPoints(double[] points, Matrix matrix) {
        int len = points.length;
        for (int i = 0; i < len; i += 2) {
            double x = MatrixUtil.multiplyX(matrix, points[i], points[i + 1]);
            double y = MatrixUtil.multiplyY(matrix, points[i], points[i + 1]);
            points[i] = x;
            points[i + 1] = y;
        }
    }

    public static Matrix create(double a, double b, double c, double d, double e, double f) {
        Matrix matrix = MatrixUtil.identity();
        matrix.a = a;
        matrix.b = b;
        matrix.c = c;
        matrix.d = d;
        matrix.e = e;
        matrix.f = f;
        return matrix;
    }

    private static PointStruct transformPoint(PointStruct point, Matrix matrix) {
        double x = MatrixUtil.multiplyX(matrix, point.x, point.y);
        double y = MatrixUtil.multiplyY(matrix, point.x, point.y);
        return new PointStruct(x, y);
    }

    private static double multiplyX(Matrix matrix, double x, double y) {
        return x * matrix.a + y * matrix.c + matrix.e;
    }

    private static double multiplyY(Matrix matrix, double x, double y) {
        return x * matrix.b + y * matrix.d + matrix.f;
    }

    public static RectStruct transformBounds(RectStruct rect, Matrix matrix) {
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        for (PointStruct point : MatrixUtil.transformCorners(rect, matrix)) {
            minX = Math.min(minX, point.x);
            maxX = Math.max(maxX, point.x);
            minY = Math.min(minY, point.y);
            maxY = Math.max(maxY, point.y);
        }
        return new RectStruct(minX, minY, maxX - minX, maxY - minY);
    }

    private static ArrayEx<PointStruct> transformCorners(RectStruct rect, Matrix matrix) {
        ArrayList<PointStruct> corners = new ArrayList<PointStruct>();
        corners.add(new PointStruct(rect.x, rect.y));
        corners.add(new PointStruct(rect.x + rect.width, rect.y));
        corners.add(new PointStruct(rect.x, rect.y + rect.height));
        corners.add(new PointStruct(rect.x + rect.width, rect.y + rect.height));
        return MatrixUtil.transformPoints(corners, matrix);
    }

    private static ArrayEx<PointStruct> transformPoints(List<PointStruct> points, Matrix matrix) {
        ArrayEx<PointStruct> transformedPoints = new ArrayEx<PointStruct>();
        for (PointStruct point : points) {
            transformedPoints.add(MatrixUtil.transformPoint(point, matrix));
        }
        return transformedPoints;
    }

    public static Matrix identity() {
        return new Matrix(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
    }

    public static String matrixToString(Matrix matrix) {
        return "matrix(" + matrix.a + ',' + matrix.b + ',' + matrix.c + ',' + matrix.d + ',' + matrix.e + ',' + matrix.f + ')';
    }

    public static boolean isIdentityMatrix(Matrix m) {
        return m.a == 1.0 && m.b == 0.0 && m.c == 0.0 && m.d == 1.0 && m.e == 0.0 && m.f == 0.0;
    }
}

