/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.transform;

import com.ibm.rave.core.transform.Matrix;
import com.ibm.rave.core.transform.MatrixUtil;

public final class Transform {
    Matrix m;
    double kx;
    double ky;
    double kz;
    public double[] translate;
    public double rotate;
    public double skew;
    public double[] scale;

    public Transform(Matrix m0) {
        this.m = m0 != null ? new Matrix(m0.a, m0.b, m0.c, m0.d, m0.e, m0.f) : MatrixUtil.identity();
        double[] r0 = new double[]{this.m.a, this.m.b};
        double[] r1 = new double[]{this.m.c, this.m.d};
        this.kx = this.transformNormalize(r0);
        this.kz = this.transformDot(r0, r1);
        this.ky = this.transformNormalize(this.transformCombine(r1, r0, -this.kz));
        if (this.m.a * this.m.d < this.m.c * this.m.b) {
            this.m.a *= -1.0;
            this.m.b *= -1.0;
            this.kx *= -1.0;
            this.kz *= -1.0;
        }
        this.translate = this.getTranslation();
        this.rotate = this.getRotation();
        this.skew = this.getSkew();
        this.scale = this.getScale();
    }

    private double getRotation() {
        double rotateResult = this.kx != 0.0 ? Math.atan2(this.m.b, this.m.a) : Math.atan2(-this.m.c, this.m.d);
        return rotateResult * 57.29577951308232;
    }

    private double[] getTranslation() {
        return new double[]{this.m.e, this.m.f};
    }

    private double[] getScale() {
        double[] list = new double[]{this.kx, this.ky};
        return list;
    }

    private double getSkew() {
        double skewResult = this.ky != 0.0 ? Math.atan2(this.kz, this.ky) * 57.29577951308232 : 0.0;
        return skewResult;
    }

    public String toString() {
        return "translate(" + this.translate[0] + "," + this.translate[1] + ")rotate(" + this.rotate + ")skewX(" + this.skew + ")scale(" + this.scale[0] + "," + this.scale[1] + ")";
    }

    private double transformDot(double[] a, double[] b) {
        return a[0] * b[0] + a[1] * b[1];
    }

    private double transformNormalize(double[] r) {
        double k = Math.sqrt(this.transformDot(r, r));
        if (k != 0.0) {
            r[0] = r[0] / k;
            r[1] = r[1] / k;
        }
        return k;
    }

    private double[] transformCombine(double[] a, double[] b, double k) {
        a[0] = a[0] + k * b[0];
        a[1] = a[1] + k * b[1];
        return a;
    }
}

