/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.transition;

import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.context.RaveContextManager;
import com.ibm.rave.core.transition.Transition;
import java.util.List;

public class TransitionCollector {
    @InlineStringConstant
    private static final String TRANSITIONS_LIST_KEY = "TRANSITIONS_LIST_KEY";

    public static boolean isCollectingTransitions() {
        return RaveContextManager.INSTANCE.getRaveContext().getData(TRANSITIONS_LIST_KEY) != null;
    }

    public static void startCollectingTransitions() {
        RaveContextManager.INSTANCE.getRaveContext().putData(TRANSITIONS_LIST_KEY, new ArrayEx());
    }

    public static List<Transition> stopCollectingTransitions() {
        ArrayEx list = (ArrayEx)RaveContextManager.INSTANCE.getRaveContext().getData(TRANSITIONS_LIST_KEY);
        RaveContextManager.INSTANCE.getRaveContext().removeData(TRANSITIONS_LIST_KEY);
        return list;
    }

    static boolean addTransition(Transition trans) {
        ArrayEx transitionList = (ArrayEx)RaveContextManager.INSTANCE.getRaveContext().getData(TRANSITIONS_LIST_KEY);
        if (transitionList != null) {
            transitionList.add(trans);
            return true;
        }
        return false;
    }

    public static void removeTransition(Transition transition) {
        ArrayEx transitionList = (ArrayEx)RaveContextManager.INSTANCE.getRaveContext().getData(TRANSITIONS_LIST_KEY);
        if (transitionList != null) {
            for (int i = 0; i < transitionList.size(); ++i) {
                Transition trans = (Transition)transitionList.get(i);
                if (trans != transition) continue;
                transitionList.splice(i, 1, new Transition[0]);
                i = transitionList.size();
            }
        }
    }
}

