/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.core.util;

import com.ibm.rave.core.internal.nativeImpl.RegExp;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;

public class StringFormatter {
    public static final String OPEN_BRACE_ESCAPE = "'\\{'";
    public static final String CLOSED_BRACE_ESCAPE = "'\\}'";
    public static final StringFormatter INSTANCE = new StringFormatter();

    private StringFormatter() {
    }

    public String format(String pattern, String ... args) {
        if (args == null) {
            return pattern;
        }
        RegExp regex = new RegExp("\\{(\\d+)\\}", "g");
        String formatted = pattern;
        RegExp.RegExpResult matched = null;
        while ((matched = regex.exec(formatted)) != null) {
            int number = ObjectConverter.toInt(matched.get(1));
            if (number >= args.length) continue;
            String match = (String)matched.get(0);
            formatted = formatted.replace(match, args[number]);
        }
        regex = new RegExp(OPEN_BRACE_ESCAPE, "");
        matched = null;
        while ((matched = regex.exec(formatted)) != null) {
            String match = (String)matched.get(0);
            formatted = formatted.replace(match, "{");
        }
        regex = new RegExp(CLOSED_BRACE_ESCAPE, "");
        matched = null;
        while ((matched = regex.exec(formatted)) != null) {
            String match = (String)matched.get(0);
            formatted = formatted.replace(match, "}");
        }
        return formatted;
    }
}

