/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.accessibility.navigation;

import com.ibm.rave.accessibility.ShadowTreeBuilder;
import com.ibm.rave.accessibility.internal.AccessibilityUtil;
import com.ibm.rave.accessibility.internal.nativeImpl.AccessibleContext;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.behavior.FocusEventHandler;
import com.ibm.rave.core.event.UIEvent;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.CallbackFunction;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.core.selector.SelectorEventListener;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.navigation.Navigation;
import com.ibm.rave.navigation.focus.FocusController;
import com.ibm.rave.navigation.internal.Keyboard;
import com.ibm.rave.navigation.keyboard.KeyBinding;

public final class AccessibleKeyboard
implements Keyboard {
    private static final String NATIVATION_ROOT = "__rave-kbnav-root__";
    private static final int STEP = 20;
    private final KeyBinding kb = Navigation.keybinding();
    private FocusEventHandler eventHandler = Rave.behavior.focusEventHandler();
    private static final SelectorEventListener<UIEvent> FOCUS_LISTENER = new SelectorEventListener<UIEvent>(){

        public void onEvent(SceneNode context, Object data, int index, int groupIndex, UIEvent event) {
            ShadowTreeBuilder stb = AccessibilityUtil.getShadowTreeBuilder((SceneNode)event.target);
            if (event.target != null) {
                stb.focus((SceneNode)event.target);
            } else {
                stb.focus(null);
            }
        }
    };
    private ValueFunction<? super SceneNode, ? extends ShadowTreeBuilder> treeBuilder = new ValueFunction<SceneNode, ShadowTreeBuilder>(){

        public ShadowTreeBuilder getValue(SceneNode context, Object data, int index, int groupIndex) {
            return AccessibleContext.createShadowTreeBuilder();
        }
    };
    private final RunFunction<SceneNode> next;
    private final RunFunction<SceneNode> previous;
    private final RunFunction<SceneNode> nextStep;
    private final RunFunction<SceneNode> previousStep;
    private final RunFunction<SceneNode> first;
    private final RunFunction<SceneNode> last;
    private final RunFunction<SceneNode> nextLevel;
    private final RunFunction<SceneNode> previousLevel;

    public AccessibleKeyboard() {
        final AccessibleKeyboard self = this;
        this.next = new RunFunction<SceneNode>(){

            public Object run(SceneNode context, Object ... args) {
                SceneNode focused = self.eventHandler.focused();
                if (focused != null && !AccessibleKeyboard.isNavigationRoot(focused)) {
                    SceneNode nextSibling = focused;
                    while ((nextSibling = FocusController.nextFocusableNode((SceneNode)nextSibling)) != null) {
                        if (!AccessibilityUtil.hasAccessibleInfo(nextSibling)) continue;
                        self.eventHandler.fireFocus(nextSibling);
                        break;
                    }
                }
                Rave.event.preventDefault();
                return null;
            }
        };
        this.previous = new RunFunction<SceneNode>(){

            public Object run(SceneNode context, Object ... args) {
                SceneNode focused = self.eventHandler.focused();
                if (focused != null && !AccessibleKeyboard.isNavigationRoot(focused)) {
                    SceneNode previousSibling = focused;
                    while ((previousSibling = FocusController.previousFocusableNode((SceneNode)previousSibling)) != null) {
                        if (!AccessibilityUtil.hasAccessibleInfo(previousSibling)) continue;
                        self.eventHandler.fireFocus(previousSibling);
                        break;
                    }
                }
                Rave.event.preventDefault();
                return null;
            }
        };
        this.nextStep = new RunFunction<SceneNode>(){

            public Object run(SceneNode context, Object ... args) {
                SceneNode focused = self.eventHandler.focused();
                if (focused != null && !AccessibleKeyboard.isNavigationRoot(focused)) {
                    int stepCount = 0;
                    SceneNode nextSibling = focused;
                    SceneNode temp = focused;
                    while (stepCount < 20 && temp != null) {
                        if ((temp = FocusController.nextFocusableNode((SceneNode)temp)) == null || !AccessibilityUtil.hasAccessibleInfo(temp)) continue;
                        nextSibling = temp;
                        ++stepCount;
                    }
                    if (nextSibling != focused) {
                        self.eventHandler.fireFocus(nextSibling);
                    }
                }
                Rave.event.preventDefault();
                return null;
            }
        };
        this.previousStep = new RunFunction<SceneNode>(){

            public Object run(SceneNode context, Object ... args) {
                SceneNode focused = self.eventHandler.focused();
                if (focused != null && !AccessibleKeyboard.isNavigationRoot(focused)) {
                    int stepCount = 0;
                    SceneNode previousSibling = focused;
                    SceneNode temp = focused;
                    while (stepCount < 20 && temp != null) {
                        if ((temp = FocusController.previousFocusableNode((SceneNode)temp)) == null || !AccessibilityUtil.hasAccessibleInfo(temp)) continue;
                        previousSibling = temp;
                        ++stepCount;
                    }
                    if (previousSibling != focused) {
                        self.eventHandler.fireFocus(previousSibling);
                    }
                }
                Rave.event.preventDefault();
                return null;
            }
        };
        this.first = new RunFunction<SceneNode>(){

            public Object run(SceneNode context, Object ... args) {
                SceneNode focused = self.eventHandler.focused();
                if (focused != null && !AccessibleKeyboard.isNavigationRoot(focused)) {
                    SceneNode firstNode = FocusController.nextFocusableNodeFromStart((SceneNode)focused);
                    if (!AccessibilityUtil.hasAccessibleInfo(firstNode)) {
                        while ((firstNode = FocusController.nextFocusableNode((SceneNode)firstNode)) != null && !AccessibilityUtil.hasAccessibleInfo(firstNode)) {
                        }
                    }
                    if (firstNode != null && focused != firstNode) {
                        self.eventHandler.fireFocus(firstNode);
                    }
                }
                Rave.event.preventDefault();
                return null;
            }
        };
        this.last = new RunFunction<SceneNode>(){

            public Object run(SceneNode context, Object ... args) {
                SceneNode focused = self.eventHandler.focused();
                if (focused != null && !AccessibleKeyboard.isNavigationRoot(focused)) {
                    SceneNode lastNode = FocusController.previousFocusableNodeFromEnd((SceneNode)focused);
                    if (!AccessibilityUtil.hasAccessibleInfo(lastNode)) {
                        while ((lastNode = FocusController.previousFocusableNode((SceneNode)lastNode)) != null && !AccessibilityUtil.hasAccessibleInfo(lastNode)) {
                        }
                    }
                    if (lastNode != null && focused != lastNode) {
                        self.eventHandler.fireFocus(lastNode);
                    }
                }
                Rave.event.preventDefault();
                return null;
            }
        };
        this.nextLevel = new RunFunction<SceneNode>(){

            public Object run(SceneNode context, Object ... args) {
                SceneNode focused = self.eventHandler.focused();
                if (focused != null && focused.hasChildNodes()) {
                    SceneNode child = FocusController.nextLevelFocusableNode((SceneNode)focused);
                    if (!AccessibilityUtil.hasAccessibleInfo(child)) {
                        while ((child = FocusController.nextFocusableNode((SceneNode)child)) != null && !AccessibilityUtil.hasAccessibleInfo(child)) {
                        }
                    }
                    if (child != null) {
                        self.eventHandler.fireFocus(child);
                    }
                }
                Rave.event.preventDefault();
                return null;
            }
        };
        this.previousLevel = new RunFunction<SceneNode>(){

            public Object run(SceneNode context, Object ... args) {
                SceneNode parent;
                SceneNode focused = self.eventHandler.focused();
                if (focused != null && !AccessibleKeyboard.isNavigationRoot(focused) && (parent = FocusController.previousLevelFocusableNode((SceneNode)focused)) != null) {
                    self.eventHandler.fireFocus(parent);
                }
                Rave.event.preventDefault();
                return null;
            }
        };
        this.kb.on(40, this.next).on(38, this.previous).on(34, this.nextStep).on(33, this.previousStep).on(36, this.first).on(35, this.last).on(39, this.nextLevel).on(37, this.previousLevel);
    }

    public Object run(Object context, Object ... args) {
        this.bind((Selector)args[0]);
        return null;
    }

    public void bind(Selector g) {
        final AccessibleKeyboard self = this;
        g.each((CallbackFunction)new CallbackFunction<SceneNode>(){

            public void run(SceneNode context, Object data, int index, int groupIndex) {
                Selector s = Rave.select((SceneNode)context);
                ShadowTreeBuilder stb = (ShadowTreeBuilder)self.treeBuilder.getValue((Object)context, data, index, groupIndex);
                AccessibilityUtil.recursiveSetShadowTreeBuilder(context, stb);
                Rave.configuration.extendRecursive(context);
                stb.setUp(context, self.eventHandler);
                s.on("ravefocus", FOCUS_LISTENER);
                Rave.select((SceneNode)context.getOwner()).call((RunFunction)self.keyBinding(), new Object[0]);
                s.property(AccessibleKeyboard.NATIVATION_ROOT, (Object)true);
                self.eventHandler.focused(context);
            }
        });
    }

    public ValueFunction<? super SceneNode, ? extends ShadowTreeBuilder> shadowTreeBuilder() {
        return this.treeBuilder;
    }

    public AccessibleKeyboard shadowTreeBuilder(ValueFunction<? super SceneNode, ? extends ShadowTreeBuilder> shadowTreeBuilder) {
        this.treeBuilder = shadowTreeBuilder;
        return this;
    }

    public KeyBinding keyBinding() {
        return this.kb;
    }

    public FocusEventHandler focusEventHandler() {
        return this.eventHandler;
    }

    public AccessibleKeyboard focusEventHandler(FocusEventHandler handler) {
        this.eventHandler = handler;
        return this;
    }

    private static boolean isNavigationRoot(SceneNode item) {
        return item.getProperty(NATIVATION_ROOT) != null;
    }
}

