/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.accessibility.selector;

import com.ibm.rave.accessibility.AccessibleInfo;
import com.ibm.rave.accessibility.internal.nativeImpl.AccessibleContext;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.CallbackFunction;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.core.selector.SelectorDelegate;
import com.ibm.rave.core.selector.ValueFunction;

public final class AccessibilitySelector
extends SelectorDelegate {
    protected Selector create(Selector s) {
        AccessibilitySelector as = new AccessibilitySelector();
        return as.setDelegate(s);
    }

    public String description() {
        SceneNode node = this.node();
        SceneNode owner = node != null ? node.getOwner() : null;
        return owner == null ? null : AccessibleContext.getDescription(owner);
    }

    public AccessibilitySelector description(final String description) {
        this.each((CallbackFunction)new CallbackFunction<SceneNode>(){

            public void run(SceneNode context, Object data, int index, int groupIndex) {
                SceneNode owner = context.getOwner();
                if (owner != null) {
                    AccessibleInfo info;
                    AccessibleContext.setDescription(owner, description);
                    if (description != null && (info = (AccessibleInfo)owner.getProperty("__accessibleInfo__")) == null) {
                        info = new AccessibleInfo();
                        info.label = description;
                        owner.setProperty("__accessibleInfo__", (Object)info);
                    }
                }
            }
        });
        return this;
    }

    public Selector description(final ValueFunction<? super SceneNode, ?> valueFunction) {
        this.each((CallbackFunction)new CallbackFunction<SceneNode>(){

            public void run(SceneNode context, Object data, int index, int groupIndex) {
                SceneNode owner = context.getOwner();
                if (owner != null) {
                    AccessibleInfo info;
                    Object value = valueFunction.getValue((Object)owner, owner.getData(), index, groupIndex);
                    String description = value != null ? value + "" : "";
                    AccessibleContext.setDescription(owner, description);
                    if (description != null && (info = (AccessibleInfo)owner.getProperty("__accessibleInfo__")) == null) {
                        info = new AccessibleInfo();
                        info.label = description;
                        owner.setProperty("__accessibleInfo__", (Object)info);
                    }
                }
            }
        });
        return this;
    }

    public AccessibleInfo info() {
        SceneNode node = this.node();
        return node == null ? null : (AccessibleInfo)node.getProperty("__accessibleInfo__");
    }

    public AccessibilitySelector info(final AccessibleInfo info) {
        this.each((CallbackFunction)new CallbackFunction<SceneNode>(){

            public void run(SceneNode context, Object data, int index, int groupIndex) {
                context.setProperty("__accessibleInfo__", (Object)info);
            }
        });
        return this;
    }

    public AccessibilitySelector info(final ValueFunction<? super SceneNode, ?> valueFunction) {
        this.each((CallbackFunction)new CallbackFunction<SceneNode>(){

            public void run(SceneNode context, Object data, int index, int groupIndex) {
                context.setProperty("__accessibleInfo__", valueFunction.getValue((Object)context, data, index, groupIndex));
            }
        });
        return this;
    }
}

