/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.ext.internal.layout.bubble;

import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.functions.SingleValueFunction;
import com.ibm.rave.core.geom.Dim;
import com.ibm.rave.core.geom.Point;
import com.ibm.rave.core.layout.PackNode;
import com.ibm.rave.core.layout.XYMin_Max;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.util.Comparator;
import com.ibm.rave.ext.internal.layout.bubble.BubblePackLayoutMethod;
import com.ibm.rave.ext.internal.layout.utils.DoubleUtils;
import com.ibm.rave.ext.internal.layout.utils.QTreeNode;
import com.ibm.rave.ext.internal.layout.utils.Qtree;
import java.util.ArrayList;

public class CirclePackMethod
extends BubblePackLayoutMethod {
    protected double[] radii;
    protected Dim extent;
    protected ArrayList<BubbleEdgeData> edges;
    protected Point[] locations;
    protected Qtree<Integer> tree;
    private QTreeNode<Integer> collision_test;

    protected static ArrayEx<Integer> makeSortOrder(final ArrayEx<PackNode> nodes) {
        int size = nodes.size();
        ArrayEx result = new ArrayEx(size);
        for (int i = 0; i < size; ++i) {
            result.set(i, (Object)i);
        }
        result.sort((Comparator)new Comparator<Integer>(){

            public int compare(Integer a, Integer b) {
                int indexA = ObjectConverter.toInt((Object)a);
                int indexB = ObjectConverter.toInt((Object)b);
                double d1 = ((PackNode)nodes.get((int)indexA)).r;
                double d2 = ((PackNode)nodes.get((int)indexB)).r;
                return DoubleUtils.compare(d1, d2);
            }
        });
        return result;
    }

    public CirclePackMethod(Dim extent) {
        this.extent = extent;
    }

    private Point getLocationForCanonicalCircles(double r, double r0, double r1, Point p) {
        double A = r0 + r1;
        double B = r0 + r;
        double C = r1 + r;
        double x = (A * A + B * B - C * C) / 2.0 / A;
        double y = Math.sqrt(B * B - x * x);
        if (p == null) {
            return new Point(x, y);
        }
        p.setX(x);
        p.setY(y);
        return p;
    }

    protected static double getLargestInsideCircleRadius(double r1, double r2, double r3) {
        double a = 1.0 / r1;
        double b = 1.0 / r2;
        double c = 1.0 / r3;
        return 1.0 / (a + b + c + 2.0 * Math.sqrt(a * b + b * c + c * a));
    }

    protected QTreeNode<Integer> _createRootNode(PackNode node) {
        QTreeNode<Integer> root = new QTreeNode<Integer>();
        root.item = null;
        this._updateRectangle(root, new Point(node.x, node.y), node.r);
        return root;
    }

    protected QTreeNode<Integer> _createQTNode(int index) {
        QTreeNode<Integer> node = new QTreeNode<Integer>();
        node.item = index;
        this._updateRectangle(node, this.locations[index], this.radii[index]);
        return node;
    }

    protected void _updateRectangle(QTreeNode<Integer> node, Point point, double r) {
        double size = 2.0 * r;
        node.x = point.getX() - r;
        node.y = point.getY() - r;
        node.width = size;
        node.height = size;
    }

    @Override
    public void pack(PackNode root) {
        int i;
        ArrayEx nodes = root.children;
        if (nodes == null || nodes.length() == 0) {
            return;
        }
        int n = nodes.length();
        this.radii = new double[n];
        int[] reverseOrder = new int[n];
        this.edges = new ArrayList();
        ArrayEx<Integer> o = CirclePackMethod.makeSortOrder((ArrayEx<PackNode>)nodes);
        for (i = 0; i < n; ++i) {
            int idx = (Integer)o.get(n - i - 1);
            reverseOrder[idx] = i;
            PackNode child = (PackNode)nodes.get(idx);
            this.radii[i] = child.r;
        }
        this.locations = new Point[n];
        this.tree = new Qtree<Integer>(0, this._createRootNode(root));
        this.collision_test = Qtree.newQTreeNode(0.0, 0.0, 0.0, 0.0, null);
        this.locations[0] = new Point(0.0, 0.0);
        if (n > 1) {
            double d = this.radii[0] + this.radii[1];
            this.locations[1] = new Point(d, 0.0);
        }
        if (n > 2) {
            Point q;
            double r0 = this.radii[0];
            double r1 = this.radii[1];
            double r2 = this.radii[2];
            this.locations[2] = q = this.getLocationForCanonicalCircles(r2, r0, r1, null);
            double w = r0 * r0 + r1 * r1 + r2 * r2;
            double sx = r1 * r1 * (r1 + r0) + r2 * r2 * q.getX();
            double sy = r2 * r2 * q.getY();
            for (int i2 = 0; i2 < 3; ++i2) {
                this.locations[i2].setX(this.locations[i2].getX() - sx / w);
                this.locations[i2].setY(this.locations[i2].getY() - sy / w);
            }
            this.addEdge(new BubbleEdgeData(0, 1));
            this.addEdge(new BubbleEdgeData(1, 0));
            this.addEdge(new BubbleEdgeData(0, 2));
            this.addEdge(new BubbleEdgeData(2, 0));
            this.addEdge(new BubbleEdgeData(1, 2));
            this.addEdge(new BubbleEdgeData(2, 1));
        }
        int p = ~(~Math.min(3, n));
        for (i = 0; i < p; ++i) {
            this.tree.insert(this._createQTNode(i));
        }
        if (n > 3) {
            for (int k = 3; k < n; ++k) {
                this.placeOnEdge(k);
            }
        }
        XYMin_Max minMax = new XYMin_Max();
        for (int i3 = 0; i3 < n; ++i3) {
            Point location = this.locations[reverseOrder[i3]];
            PackNode node = (PackNode)nodes.get(i3);
            node.x = location.getX();
            node.y = location.getY();
            minMax.bound(node);
        }
        double cx = (minMax.xMin + minMax.xMax) / 2.0;
        double cy = (minMax.yMin + minMax.yMax) / 2.0;
        double cr = 0.0;
        for (int i4 = 0; i4 < n; ++i4) {
            PackNode node = (PackNode)nodes.get(i4);
            node.x -= cx;
            node.y -= cy;
            cr = Math.max(cr, node.r + Math.sqrt(node.x * node.x + node.y * node.y));
        }
        root.r = cr;
    }

    private void placeOnEdge(int k) {
        double r = this.radii[k];
        Point q = new Point(0.0, 0.0);
        for (int i = 0; i < this.edges.size(); ++i) {
            boolean isCrSet;
            BubbleEdgeData edge = this.edges.get(i);
            double cr = edge.cr;
            boolean bl = isCrSet = cr != -1.0;
            if (isCrSet && !(r <= cr)) continue;
            int e1 = edge.e1;
            int e2 = edge.e2;
            this.placeTouching(this.locations[e1], this.radii[e1], this.locations[e2], this.radii[e2], r, q);
            boolean intersects = isCrSet ? false : (edge.nearShapes != null ? this.intersectsNearShapes(q, r, edge) : this.intersectsExisting(q, r, k));
            if (intersects) continue;
            this.locations[k] = q;
            this.tree.insert(this._createQTNode(k));
            edge.cr = CirclePackMethod.getLargestInsideCircleRadius(r, this.radii[e1], this.radii[e2]);
            BubbleEdgeData bed1 = new BubbleEdgeData(k, e2);
            BubbleEdgeData bed2 = new BubbleEdgeData(e1, k);
            this.addEdge(bed1);
            this.addEdge(bed2);
            if (edge.nearShapes != null) {
                bed1.nearShapes = edge.nearShapes;
                bed2.nearShapes = edge.nearShapes;
                edge.nearShapes.add(k);
            } else if (edge.nearShapes == null && isCrSet) {
                bed1.nearShapes = new ArrayList();
                bed1.nearShapes.add(k);
                bed1.nearShapes.add(e1);
                bed1.nearShapes.add(e2);
                bed1.nearShapes.add(edge.e3);
                bed2.nearShapes = bed1.nearShapes;
            }
            edge.e3 = k;
            return;
        }
    }

    protected boolean intersectsExisting(final Point p, final double r, int n) {
        this._updateRectangle(this.collision_test, p, r);
        final CirclePackMethod method = this;
        SingleValueFunction<Boolean, QTreeNode<Integer>> tester = new SingleValueFunction<Boolean, QTreeNode<Integer>>(){

            public Boolean getValue(QTreeNode<Integer> node) {
                double rt = r + method.radii[(Integer)node.item] - 0.01;
                Point p2 = method.locations[(Integer)node.item];
                return BubblePackLayoutMethod.distance(p, p2) < rt;
            }
        };
        return this.tree.collide(tester, this.collision_test);
    }

    protected Point placeTouching(Point c0, double r0, Point c1, double r1, double r, Point point) {
        double x1 = c1.getX() - c0.getX();
        double y1 = c1.getY() - c0.getY();
        double R = r0 + r1;
        double cosA = x1 / R;
        double sinA = y1 / R;
        Point p = this.getLocationForCanonicalCircles(r, r0, r1, point);
        double x = p.getX() * cosA - p.getY() * sinA + c0.getX();
        double y = p.getX() * sinA + p.getY() * cosA + c0.getY();
        p.setX(x);
        p.setY(y);
        return p;
    }

    protected boolean intersectsNearShapes(Point p, double r, BubbleEdgeData edgeData) {
        ArrayList<Integer> nearShapes = edgeData.nearShapes;
        int adjacent1 = edgeData.e1;
        int adjacent2 = edgeData.e2;
        int len = nearShapes.size();
        for (int j = 0; j < len; ++j) {
            int i = nearShapes.get(j);
            if (i == adjacent1 || i == adjacent2) continue;
            double rt = r + this.radii[i] - 0.01;
            Point p2 = this.locations[i];
            if (!(CirclePackMethod.distance(p, p2) < rt)) continue;
            return true;
        }
        return false;
    }

    protected void addEdge(BubbleEdgeData e) {
        double dp;
        e.touchPointDistance = dp = this.getTouchPointDistance(e);
        int size = this.edges.size();
        if (size == 0) {
            this.edges.add(e);
            return;
        }
        int a = 0;
        if (dp < this.edges.get((int)a).touchPointDistance) {
            this.edges.add(0, e);
            return;
        }
        int b = size - 1;
        if (dp >= this.edges.get((int)b).touchPointDistance) {
            this.edges.add(e);
            return;
        }
        while (b > a + 1) {
            int c = (int)Math.floor((a + b) / 2);
            double dc = this.edges.get((int)c).touchPointDistance;
            if (dp < dc) {
                b = c;
                continue;
            }
            a = c;
        }
        this.edges.add(b, e);
    }

    protected double getTouchPointDistance(BubbleEdgeData e) {
        Point a = this.locations[e.e1];
        Point b = this.locations[e.e2];
        double ra = this.radii[e.e1];
        double rb = this.radii[e.e2];
        double x = (a.getX() * rb + b.getX() * ra) / (ra + rb);
        double y = (a.getY() * rb + b.getY() * ra) / (ra + rb);
        return x * x + y * y;
    }

    protected final class BubbleEdgeData {
        final int e1;
        final int e2;
        int e3 = -1;
        double cr = -1.0;
        double touchPointDistance;
        ArrayList<Integer> nearShapes = null;

        BubbleEdgeData(int e1, int e2) {
            this.e1 = e1;
            this.e2 = e2;
        }
    }
}

