/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.ext.internal.layout.utils;

import com.ibm.rave.codegenerator.annotations.SwiftWeak;
import com.ibm.rave.core.functions.SingleValueFunction;
import com.ibm.rave.ext.internal.layout.utils.QTreeNode;
import java.util.ArrayList;
import java.util.List;

public final class Qtree<T> {
    private static final int TOP_RIGHT = 0;
    private static final int TOP_LEFT = 1;
    private static final int BOTTOM_LEFT = 2;
    private static final int BOTTOM_RIGHT = 3;
    public int max_objects = 30;
    public int MAX_LEVELS = 15;
    private int size = 0;
    private int level;
    private List<QTreeNode<T>> objects;
    private QTreeNode<T> bounds;
    @SwiftWeak(value=false)
    private Qtree<T>[] quadrants;
    private final double subWidth;
    private final double subHeight;
    private final double xMidpoint;
    private final double yMidpoint;

    public Qtree(int pLevel, QTreeNode<T> pBounds) {
        this.level = pLevel;
        this.objects = new ArrayList<QTreeNode<T>>();
        this.bounds = pBounds;
        this.subWidth = this.bounds.width / 2.0;
        this.subHeight = this.bounds.height / 2.0;
        this.xMidpoint = this.bounds.x + this.subWidth;
        this.yMidpoint = this.bounds.y + this.subHeight;
    }

    public void clear() {
        this.objects = new ArrayList<QTreeNode<T>>();
        this.quadrants = null;
        this.size = 0;
    }

    public static <T> QTreeNode<T> newQTreeNode(double x, double y, double width, double height, T item) {
        QTreeNode node = new QTreeNode();
        node.x = x;
        node.y = y;
        node.width = width;
        node.height = height;
        node.item = item;
        return node;
    }

    private void split() {
        this.quadrants = new Qtree[4];
        this.quadrants[1] = new Qtree<Object>(this.level + 1, Qtree.newQTreeNode(this.bounds.x, this.bounds.y + this.subHeight, this.subWidth, this.subHeight, null));
        this.quadrants[0] = new Qtree<Object>(this.level + 1, Qtree.newQTreeNode(this.bounds.x + this.subWidth, this.bounds.y + this.subHeight, this.subWidth, this.subHeight, null));
        this.quadrants[2] = new Qtree<Object>(this.level + 1, Qtree.newQTreeNode(this.bounds.x, this.bounds.y, this.subWidth, this.subHeight, null));
        this.quadrants[3] = new Qtree<Object>(this.level + 1, Qtree.newQTreeNode(this.bounds.x + this.subWidth, this.bounds.y, this.subWidth, this.subHeight, null));
        ArrayList<QTreeNode<T>> new_objects = new ArrayList<QTreeNode<T>>();
        for (QTreeNode<T> node : this.objects) {
            int index = this.getQuadrant(node);
            if (index != -1) {
                this.quadrants[index].insert(node);
                continue;
            }
            new_objects.add(node);
        }
        this.objects = new_objects;
    }

    private int getQuadrant(QTreeNode<T> pRect) {
        boolean bottomQuadrant;
        if (pRect.width > this.subWidth || pRect.height > this.subHeight) {
            return -1;
        }
        boolean topQuadrant = pRect.y >= this.yMidpoint;
        boolean bl = bottomQuadrant = pRect.y + pRect.height <= this.yMidpoint;
        if (pRect.x >= this.xMidpoint) {
            if (topQuadrant) {
                return 0;
            }
            if (bottomQuadrant) {
                return 3;
            }
        }
        if (pRect.x + pRect.width <= this.xMidpoint) {
            if (topQuadrant) {
                return 1;
            }
            if (bottomQuadrant) {
                return 2;
            }
        }
        return -1;
    }

    public void insert(QTreeNode<T> pRect) {
        int index;
        ++this.size;
        if (this.quadrants != null && (index = this.getQuadrant(pRect)) != -1) {
            this.quadrants[index].insert(pRect);
            return;
        }
        this.objects.add(pRect);
        if (this.quadrants == null && this.objects.size() > this.max_objects && this.level < this.MAX_LEVELS) {
            this.split();
        }
    }

    protected boolean intersectsRectangle(QTreeNode<T> rect) {
        return this.intersects(rect.x, rect.y, rect.width, rect.height);
    }

    public boolean intersects(double x, double y, double width, double height) {
        return x < this.bounds.x + this.bounds.width && y < this.bounds.y + this.bounds.height && x + width > this.bounds.x && y + height > this.bounds.y;
    }

    public boolean collide(SingleValueFunction<Boolean, QTreeNode<T>> tester, QTreeNode<T> test) {
        if (this.quadrants != null) {
            for (int i = 0; i < 4; ++i) {
                if (!this.quadrants[i].intersectsRectangle(test) || !this.quadrants[i].collide(tester, test)) continue;
                return true;
            }
        }
        for (QTreeNode<T> node : this.objects) {
            if (!((Boolean)tester.getValue(node)).booleanValue()) continue;
            return true;
        }
        return false;
    }
}

