/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.ext.layout.bubble;

import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.functions.SingleValueFunction;
import com.ibm.rave.core.geom.Dim;
import com.ibm.rave.core.layout.AbstractPackLayout;
import com.ibm.rave.core.layout.PackNode;
import com.ibm.rave.core.layout.hierarchy.HierarchyNode;
import com.ibm.rave.core.layout.hierarchy.HierarchyUtil;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.ext.internal.layout.bubble.BubblePackLayoutMethod;
import com.ibm.rave.ext.internal.layout.bubble.CirclePackMethod;
import com.ibm.rave.ext.internal.layout.bubble.SquarePackMethod;

public class BubbleLayout
extends AbstractPackLayout<BubbleLayout> {
    public static final String CIRCLE = "circle";
    public static final String SQUARE = "square";
    private String methodVal = "circle";
    private static SingleValueFunction<Object, Object> DEFAULT_FN = new SingleValueFunction<Object, Object>(){

        public Object getValue(Object data) {
            return ObjectConverter.toDouble((Object)data);
        }
    };

    public BubbleLayout() {
        this.sort(null);
    }

    public ArrayEx<PackNode> create(PackNode root) {
        ArrayEx nodes = super.create((HierarchyNode)root);
        final Object localR = this.radiusFn == null && this.radiusVal == null ? DEFAULT_FN : (this.radiusFn == null ? new AbstractPackLayout.ConstantSingleValueFunction(this.radiusVal) : this.radiusFn);
        root.y = 0.0;
        root.x = 0.0;
        HierarchyUtil.visitAfter((HierarchyNode)root, (HierarchyUtil.Visitor)new HierarchyUtil.Visitor<PackNode>(){

            public void visit(PackNode node) {
                node.r = ObjectConverter.toDouble((Object)localR.getValue((Object)node.value));
            }
        });
        final Dim extent = new Dim(this.sizeVal[0], this.sizeVal[1]);
        final String type = this.method();
        HierarchyUtil.visitAfter((HierarchyNode)root, (HierarchyUtil.Visitor)new HierarchyUtil.Visitor<PackNode>(){

            public void visit(PackNode node) {
                CirclePackMethod algorithm = BubbleLayout.SQUARE.equals(type) ? new SquarePackMethod(extent) : new CirclePackMethod(extent);
                ((BubblePackLayoutMethod)algorithm).pack(node);
            }
        });
        double x = extent.getWidth() / 2.0;
        double y = extent.getHeight() / 2.0;
        double scale = this.radiusFn != null || ObjectConverter.toBoolean((Object)this.radiusVal) ? 1.0 : 1.0 / Math.max(2.0 * root.r / extent.getWidth(), 2.0 * root.r / extent.getHeight());
        double dr = ObjectConverter.toBoolean((double)this.padding()) ? this.padding() / 2.0 : 0.0;
        this.layout_packTransform(root, x, y, scale, dr);
        return nodes;
    }

    @SwiftMethodOverload(overloads={"String"})
    public BubbleLayout method(Object value) {
        String _method = value.toString();
        if (CIRCLE.equals(_method)) {
            this.methodVal = CIRCLE;
            return this;
        }
        if (SQUARE.equals(_method)) {
            this.methodVal = SQUARE;
            return this;
        }
        this.methodVal = CIRCLE;
        return this;
    }

    public String method() {
        return this.methodVal;
    }

    protected void layout_packTransform(PackNode node, double x, double y, double scale, double _padding) {
        double _x = x;
        double _y = y;
        ArrayEx children = node.children;
        node.x = _x += scale * node.x;
        node.y = _y += scale * node.y;
        node.r *= scale;
        node.r -= _padding;
        node.r = Math.max(0.0, node.r);
        if (children != null) {
            int i = -1;
            int n = children.length();
            while (++i < n) {
                this.layout_packTransform((PackNode)children.get(i), node.x, node.y, scale, _padding);
            }
        }
    }
}

