/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.ext.layout.fill;

import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.geom.Dim;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.ext.layout.fill.DoesNotFitCallback;
import com.ibm.rave.ext.layout.fill.FillNode;
import com.ibm.rave.ext.layout.fill.SetValueFunction;

@FunctionClass(value="layout")
public class FillLayout<T extends FillNode> {
    public static final String PACKED = "packed";
    public static final String GRID = "grid";
    public static final String ROW = "row";
    public static final String COLUMN = "column";
    public static final String DOWN = "down";
    public static final String UP = "up";
    public static final String LEFT = "left";
    public static final String RIGHT = "right";
    public static final String ALIGN_START = "start";
    public static final String ALIGN_END = "end";
    public static final String ALIGN_MIDDLE = "middle";
    private String hAlignVal = "start";
    private String vAlignVal = "middle";
    private String methodVal = "packed";
    private String directionVal = "column";
    private int rowsVal = 0;
    private int columnsVal = 0;
    private String rowOrderVal = "down";
    private String columnOrderVal = "left";
    private double[] sizeVal = new double[]{1.0, 1.0};
    private double paddingVal = 0.0;
    private Dim gridCellSize;
    private SetValueFunction<FillNode> cellSizeFn;
    private DoesNotFitCallback errorCallback = null;
    private int numberOfVerticalCellsVal = -1;
    private int numberOfHorizontalCellsVal = -1;

    public String method() {
        return this.methodVal;
    }

    public FillLayout<T> method(String method) {
        this.methodVal = GRID.equals(method) ? GRID : PACKED;
        return this;
    }

    public String direction() {
        return this.directionVal;
    }

    public FillLayout<T> direction(String direction) {
        this.directionVal = ROW.equals(direction) ? ROW : COLUMN;
        return this;
    }

    @SwiftMethodOverload(skipOverloads={"Bool"})
    public FillLayout<T> rows(Object rows) {
        this.rowsVal = ObjectConverter.toInt((Object)rows);
        return this;
    }

    public int rows() {
        return this.rowsVal;
    }

    @SwiftMethodOverload(skipOverloads={"Bool"})
    public FillLayout<T> columns(Object columns) {
        this.columnsVal = ObjectConverter.toInt((Object)columns);
        return this;
    }

    public int columns() {
        return this.columnsVal;
    }

    public FillLayout<T> rowOrder(String order) {
        this.rowOrderVal = DOWN.equals(order) ? DOWN : UP;
        return this;
    }

    public String rowOrder() {
        return this.rowOrderVal;
    }

    public FillLayout<T> columnOrder(String order) {
        this.columnOrderVal = RIGHT.equals(order) ? RIGHT : LEFT;
        return this;
    }

    public String columnOrder() {
        return this.columnOrderVal;
    }

    public double[] size() {
        return this.sizeVal;
    }

    public FillLayout<T> size(double[] newSize) {
        this.sizeVal = newSize;
        return this;
    }

    @SwiftMethodOverload(skipOverloads={"Bool"})
    public FillLayout<T> padding(Object padding) {
        this.paddingVal = ObjectConverter.toDouble((Object)padding);
        return this;
    }

    public double padding() {
        return this.paddingVal;
    }

    public FillLayout<T> valign(String alignment) {
        this.vAlignVal = ALIGN_START.equals(alignment) ? ALIGN_START : (ALIGN_END.equals(alignment) ? ALIGN_END : ALIGN_MIDDLE);
        return this;
    }

    public String valign() {
        return this.vAlignVal;
    }

    public FillLayout<T> halign(String alignment) {
        this.hAlignVal = ALIGN_MIDDLE.equals(alignment) ? ALIGN_MIDDLE : (ALIGN_END.equals(alignment) ? ALIGN_END : ALIGN_START);
        return this;
    }

    public String halign() {
        return this.hAlignVal;
    }

    public FillLayout<T> cellSize(SetValueFunction<FillNode> fn) {
        this.cellSizeFn = fn;
        return this;
    }

    public SetValueFunction<FillNode> cellSize() {
        return this.cellSizeFn;
    }

    public FillLayout<T> error(DoesNotFitCallback fn) {
        this.errorCallback = fn;
        return this;
    }

    public DoesNotFitCallback error() {
        return this.errorCallback;
    }

    public ArrayEx<FillNode> layout(ArrayEx<FillNode> nodes) {
        Object sizeLocal;
        if (this.cellSizeFn == null) {
            sizeLocal = this.size();
            double c = this.columns();
            double r = this.rows();
            double p = this.padding();
            this.cellSizeFn = new SetValueFunction<FillNode>((double[])sizeLocal, p, c, r){
                final /* synthetic */ double[] val$sizeLocal;
                final /* synthetic */ double val$p;
                final /* synthetic */ double val$c;
                final /* synthetic */ double val$r;
                {
                    this.val$sizeLocal = dArray;
                    this.val$p = d;
                    this.val$c = d2;
                    this.val$r = d3;
                }

                @Override
                public void set(FillNode node) {
                    double width = this.val$sizeLocal[0];
                    double height = this.val$sizeLocal[1];
                    node.width = (width - this.val$p * this.val$c) / this.val$c;
                    node.height = (height - this.val$p * this.val$r) / this.val$r;
                }
            };
        }
        sizeLocal = nodes.iterator();
        while (sizeLocal.hasNext()) {
            FillNode node = (FillNode)sizeLocal.next();
            node.x = 0.0;
            node.y = 0.0;
            this.cellSize().set(node);
        }
        this.layout_computeCellSize(nodes);
        int numRows = Math.max((int)Math.floor(this.size()[1] / this.gridCellSize.getHeight()), 1);
        int numColumns = Math.max((int)Math.floor(this.size()[0] / this.gridCellSize.getWidth()), 1);
        if (this.rows() > 0) {
            numRows = Math.min(numRows, this.rows());
        }
        if (this.columns() > 0) {
            numColumns = Math.min(numColumns, this.columns());
        }
        if (PACKED == this.method()) {
            if (ROW == this.direction()) {
                numColumns = Math.max(0, this.columns());
            } else {
                numRows = Math.max(0, this.rows());
            }
        }
        return this.layout_packShapes(nodes, numRows, numColumns);
    }

    private void layout_computeCellSize(ArrayEx<FillNode> nodes) {
        double maxW = 1.0;
        double maxH = 1.0;
        for (FillNode node : nodes) {
            maxW = Math.max(maxW, node.width);
            maxH = Math.max(maxH, node.height);
        }
        this.gridCellSize = new Dim(maxW + this.padding(), maxH + this.padding());
    }

    private ArrayEx<FillNode> layout_packShapes(ArrayEx<FillNode> nodes, int numRows, int numColumns) {
        int majorIndex;
        double minorChartSize;
        double majorChartSize;
        double majorShapeSize;
        int minorCount;
        int majorCount;
        boolean gridMethod;
        ArrayEx result = new ArrayEx();
        this.numberOfVerticalCellsVal = -1;
        this.numberOfHorizontalCellsVal = -1;
        boolean reportDoNotFit = this.error() != null;
        ArrayEx didNotFit = null;
        if (reportDoNotFit) {
            didNotFit = new ArrayEx();
            for (FillNode node : nodes) {
                didNotFit.add((Object)node);
            }
        }
        int shapeCount = nodes.size();
        int shapeIndex = 0;
        boolean bl = gridMethod = GRID == this.method();
        if (ROW == this.direction()) {
            majorCount = numRows;
            minorCount = numColumns;
            majorShapeSize = this.gridCellSize.getHeight();
            majorChartSize = this.size()[1];
            minorChartSize = this.size()[0];
        } else {
            majorCount = numColumns;
            minorCount = numRows;
            majorShapeSize = this.gridCellSize.getWidth();
            majorChartSize = this.size()[0];
            minorChartSize = this.size()[1];
        }
        if (minorCount == 0) {
            minorCount = (int)minorChartSize;
        }
        double majorPosition = 0.0;
        double minorPosition = 0.0;
        int minorIndex = 0;
        FillNode last = null;
        for (majorIndex = 0; shapeIndex < shapeCount && majorIndex < majorCount; ++majorIndex) {
            majorPosition = (double)majorIndex * majorShapeSize;
            minorPosition = 0.0;
            minorIndex = 0;
            while (shapeIndex < shapeCount && minorIndex < minorCount) {
                double minorShapeSize;
                FillNode node = (FillNode)nodes.get(shapeIndex);
                if (gridMethod) {
                    minorShapeSize = ROW == this.direction() ? this.gridCellSize.getWidth() : this.gridCellSize.getHeight();
                } else {
                    double d = minorShapeSize = ROW == this.direction() ? node.width + this.padding() : node.height + this.padding();
                }
                if (!gridMethod && minorShapeSize > minorChartSize) {
                    ++shapeIndex;
                    continue;
                }
                if (!(minorPosition + minorShapeSize <= minorChartSize) || !(majorPosition <= majorChartSize)) break;
                this.layout_placeShape(node, majorPosition, minorPosition, majorShapeSize, minorShapeSize, 0.0);
                result.add((Object)node);
                if (reportDoNotFit) {
                    didNotFit.set(shapeIndex, null);
                    last = node;
                }
                ++shapeIndex;
                ++minorIndex;
                minorPosition += minorShapeSize;
            }
            if (ROW == this.direction()) {
                this.numberOfHorizontalCellsVal = Math.max(minorIndex, this.numberOfHorizontalCellsVal);
                continue;
            }
            this.numberOfVerticalCellsVal = Math.max(minorIndex, this.numberOfVerticalCellsVal);
        }
        if (ROW == this.direction()) {
            this.numberOfVerticalCellsVal = majorIndex;
        } else {
            this.numberOfHorizontalCellsVal = majorIndex;
        }
        if (reportDoNotFit) {
            ArrayEx orphans = new ArrayEx();
            for (FillNode node : didNotFit) {
                if (node == null) continue;
                orphans.add((Object)node);
            }
            if (shapeIndex < shapeCount || orphans.size() > 0) {
                this.error().callback(last == null ? Double.NaN : last.x, last == null ? Double.NaN : last.y, (ArrayEx<FillNode>)orphans);
            }
        }
        return result;
    }

    private void layout_placeShape(FillNode node, double majorPosition, double minorPosition, double majorSize, double minorSize, double deltaX) {
        double ysize;
        double xsize;
        double ypos;
        double xpos;
        if (ROW == this.direction()) {
            xpos = minorPosition;
            ypos = majorPosition;
            xsize = minorSize;
            ysize = majorSize;
        } else {
            xpos = majorPosition;
            ypos = minorPosition;
            xsize = majorSize;
            ysize = minorSize;
        }
        if (UP == this.rowOrder()) {
            ypos = this.size()[1] - ypos - ysize;
        }
        if (RIGHT == this.columnOrder()) {
            xpos = this.size()[0] - xpos - xsize;
        }
        xpos += this.padding();
        ypos += this.padding();
        xpos += deltaX;
        double availableX = xsize - node.width - deltaX - this.padding();
        double availableY = ysize - node.height - this.padding();
        if (ALIGN_MIDDLE == this.halign()) {
            xpos += availableX / 2.0;
        } else if (ALIGN_END == this.halign()) {
            xpos += availableX;
        }
        if (ALIGN_MIDDLE == this.valign()) {
            ypos += availableY / 2.0;
        } else if (ALIGN_END == this.valign()) {
            ypos += availableY;
        }
        node.x = xpos - node.x;
        node.y = ypos - node.y;
    }

    public int numberOfVerticalCells() {
        return this.numberOfVerticalCellsVal;
    }

    public int numberOfHorizontalCells() {
        return this.numberOfHorizontalCellsVal;
    }
}

