/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.ext.legend;

import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.geom.Dim;
import com.ibm.rave.core.geom.Insets;
import com.ibm.rave.core.geom.RaveRect;
import com.ibm.rave.core.nativeImpl.arrays.ES6Map;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scales.AbstractScale;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.core.svg.Symbol;
import com.ibm.rave.ext.legend.ExtraLegendEntry;
import com.ibm.rave.ext.legend.LegendTruncationIndicator;
import com.ibm.rave.ext.text.wrap.TextFlow;
import java.util.List;

public abstract class AbstractLegend<T extends AbstractLegend<T>>
implements RunFunction<Object> {
    @InlineStringConstant
    protected static final String EM_1 = "1em";
    @InlineStringConstant
    protected static final String EM_07 = ".7em";
    @InlineStringConstant
    protected static final String EM_035 = ".35em";
    @InlineStringConstant
    protected static final String EM_0 = "0em";
    @InlineStringConstant
    protected static final String HORIZONTAL_ORIENT = "horizontal";
    @InlineStringConstant
    protected static final String VERTICAL_ORIENT = "vertical";
    @InlineStringConstant
    protected static final String START_ALIGN = "start";
    @InlineStringConstant
    protected static final String MIDDLE_ALIGN = "middle";
    @InlineStringConstant
    protected static final String END_ALIGN = "end";
    @InlineStringConstant
    protected static final String DEFAULT_TRUNCATION_TEXT = "...";
    @InlineStringConstant
    protected static final String DEFAULT_ORIENT = "vertical";
    @InlineStringConstant
    protected static final String DEFAULT_TITLE_ALIGN = "middle";
    @InlineStringConstant
    protected static final String LEGEND_ENTRY_CLASS_SELECTOR = ".legendEntry";
    @InlineStringConstant
    protected static final String LEGEND_GROUP_CLASS_SELECTOR = ".legendGroup";
    @InlineStringConstant
    protected static final String LEGEND_SHAPE_CLASS_SELECTOR = ".legendShape";
    @InlineStringConstant
    protected static final String LEGEND_TICK_LINE_CLASS_SELECTOR = ".legendTickLine";
    @InlineStringConstant
    protected static final String LEGEND_LABEL_CLASS_SELECTOR = ".legendLabel";
    @InlineStringConstant
    protected static final String FONT = "font";
    protected static final double DEFAULT_TRUNCATION_SHAPE_SIZE = 400.0;
    protected static final double DEFAULT_LABEL_PADDING = 3.0;
    protected static final Object[] DEFAULT_SCALE_ARGS = new Object[]{5.0};
    protected static final Dim DEFAULT_LEGEND_SIZE = new Dim(100.0, 100.0);
    protected static final int DEFAULT_INSETS_VALUE = 3;
    protected static final double MIN_TEXT_DIM = 4.0;
    protected static final double LINE_SPACING_RATIO = 1.0;
    protected static final Insets DEFAULT_INSETS = AbstractLegend.createDefaultInsets();
    protected static final ValueFunction<Object, String> _IDENTITY_FN = new ValueFunction<Object, String>(){

        public String getValue(Object context, Object data, int index, int groupIndex) {
            return ObjectConverter.toString((Object)data);
        }
    };
    private boolean _reverse = false;
    private int _minDataLen;
    private AbstractScale _scale;
    private String _orient = "vertical";
    private Object _labelPadding = 3.0;
    private Object[] _scaleArguments = DEFAULT_SCALE_ARGS;
    private Dim _size = DEFAULT_LEGEND_SIZE;
    private List<?> _dataValues;
    private Object _labelFormat;
    private String _title;
    private String _labelTruncationText = "...";
    private LegendTruncationIndicator _legendTruncationIndicator;
    protected double _spaceUsed = 0.0;
    private Object _legendBorderColor;
    private Object _legendBackgroundColor;
    private Object _shapeBorderColor;
    private String _titleAlignment = "middle";
    private Insets _titleInsets = DEFAULT_INSETS;
    private Insets _entryInsets = DEFAULT_INSETS;
    private Insets _legendInsets = DEFAULT_INSETS;
    private String _titleFontSize = null;
    private String _titleFontFamily = null;
    private String _titleFill = null;
    protected ES6Map<String, ExtraLegendEntry> _extraLegendEntries = Rave.map.createMap();

    private static final Insets createDefaultInsets() {
        Insets result = new Insets();
        result.top = 3;
        result.left = 3;
        result.bottom = 3;
        result.right = 3;
        return result;
    }

    public ES6Map<String, ExtraLegendEntry> extraLegendEntries() {
        return this._extraLegendEntries;
    }

    protected AbstractLegend() {
    }

    protected int minDataLen() {
        return this._minDataLen;
    }

    protected void minDataLen(int minDataLen) {
        this._minDataLen = minDataLen;
    }

    public T scale(AbstractScale scale) {
        this._scale = scale;
        return (T)this;
    }

    public AbstractScale scale() {
        return this._scale;
    }

    public T orient(String orientation) {
        this._orient = HORIZONTAL_ORIENT.equals(orientation) || "vertical".equals(orientation) ? orientation : "vertical";
        return (T)this;
    }

    public String orient() {
        return this._orient;
    }

    public String title() {
        return this._title;
    }

    public T title(String t) {
        this._title = t;
        return (T)this;
    }

    public Dim size() {
        return this._size;
    }

    public T size(Dim t) {
        this._size = t;
        return (T)this;
    }

    public T scaleArguments(Object ... scaleArgs) {
        this._scaleArguments = scaleArgs;
        return (T)this;
    }

    public Object[] scaleArguments() {
        return this._scaleArguments;
    }

    public T dataValues(List<?> values) {
        this._dataValues = values;
        return (T)this;
    }

    public List<?> dataValues() {
        return this._dataValues;
    }

    public T labelFormat(String format) {
        this._labelFormat = format;
        return (T)this;
    }

    public T labelFormat(ValueFunction<? super SceneNode, ?> valueFunction) {
        this._labelFormat = valueFunction;
        return (T)this;
    }

    public Object labelFormat() {
        return this._labelFormat;
    }

    @SwiftMethodOverload(overloads={"Double", "String"})
    public T labelPadding(Object padding) {
        this._labelPadding = padding;
        return (T)this;
    }

    public Object labelPadding() {
        return this._labelPadding;
    }

    public Object borderColor() {
        return this._legendBorderColor;
    }

    @SwiftMethodOverload(overloads={"String"})
    public T borderColor(Object borderColor) {
        this._legendBorderColor = borderColor;
        return (T)this;
    }

    public Object shapeBorderColor() {
        return this._shapeBorderColor;
    }

    @SwiftMethodOverload(overloads={"String"})
    public T shapeBorderColor(Object shapeBorderColor) {
        this._shapeBorderColor = shapeBorderColor;
        return (T)this;
    }

    public Object backgroundColor() {
        return this._legendBackgroundColor;
    }

    @SwiftMethodOverload(overloads={"String"})
    public T backgroundColor(Object backgroundColor) {
        this._legendBackgroundColor = backgroundColor;
        return (T)this;
    }

    public String titleAlignment() {
        return this._titleAlignment;
    }

    public T titleAlignment(String titleAlignment) {
        this._titleAlignment = START_ALIGN.equals(titleAlignment) || "middle".equals(titleAlignment) || END_ALIGN.equals(titleAlignment) ? titleAlignment : "middle";
        return (T)this;
    }

    public Insets titleInsets() {
        return this._titleInsets;
    }

    public T titleInsets(Insets titleInsets) {
        this._titleInsets = ObjectConverter.toBoolean((Object)titleInsets) ? this.sanitizeInsets(titleInsets) : DEFAULT_INSETS;
        return (T)this;
    }

    public String titleFill() {
        return this._titleFill;
    }

    public T titleFill(String f) {
        this._titleFill = f;
        return (T)this;
    }

    public String titleFontSize() {
        return this._titleFontSize;
    }

    public T titleFontSize(String s) {
        this._titleFontSize = s;
        return (T)this;
    }

    public String titleFontFamily() {
        return this._titleFontFamily;
    }

    public T titleFontFamily(String f) {
        this._titleFontFamily = f;
        return (T)this;
    }

    public Insets entryInsets() {
        return this._entryInsets;
    }

    public T entryInsets(Insets entryInsets) {
        this._entryInsets = ObjectConverter.toBoolean((Object)entryInsets) ? this.sanitizeInsets(entryInsets) : DEFAULT_INSETS;
        return (T)this;
    }

    public Insets insets() {
        return this._legendInsets;
    }

    public T insets(Insets legendInsets) {
        this._legendInsets = ObjectConverter.toBoolean((Object)legendInsets) ? this.sanitizeInsets(legendInsets) : DEFAULT_INSETS;
        return (T)this;
    }

    private Insets sanitizeInsets(Insets legendInsets) {
        legendInsets.top = legendInsets.top instanceof Number ? legendInsets.top : AbstractLegend.DEFAULT_INSETS.top;
        legendInsets.bottom = legendInsets.bottom instanceof Number ? legendInsets.bottom : AbstractLegend.DEFAULT_INSETS.bottom;
        legendInsets.left = legendInsets.left instanceof Number ? legendInsets.left : AbstractLegend.DEFAULT_INSETS.left;
        legendInsets.right = legendInsets.right instanceof Number ? legendInsets.right : AbstractLegend.DEFAULT_INSETS.right;
        return legendInsets;
    }

    public boolean reverse() {
        return this._reverse;
    }

    public String labelTruncationText() {
        return this._labelTruncationText;
    }

    public T labelTruncationText(String labelTruncationText) {
        this._labelTruncationText = labelTruncationText;
        return (T)this;
    }

    public LegendTruncationIndicator truncationIndicator() {
        return this._legendTruncationIndicator;
    }

    public T truncationIndicator(LegendTruncationIndicator legendTruncationIndicator) {
        this._legendTruncationIndicator = legendTruncationIndicator;
        return (T)this;
    }

    public T reverse(boolean reverse) {
        this._reverse = reverse;
        return (T)this;
    }

    public Object run(Object context, Object ... args) {
        this.legend((Selector)args[0]);
        return null;
    }

    protected Selector addTruncationIndicator(Selector gSelection, double titleVerticalShift, double availableWidth, double availableHeight, TextFlow textFlow) {
        double midHorizontalPoint = (this.size().getWidth() - (double)(this.insets().left + this.insets().right)) / 2.0 + (double)this.insets().left.intValue();
        return this.addTruncationIndicator(gSelection.append("g").attr("class", (Object)"legendTruncationEntry"), midHorizontalPoint, titleVerticalShift - (double)this.insets().bottom.intValue() + 3.0, availableWidth + (double)this.entryInsets().left.intValue() + (double)this.entryInsets().right.intValue(), availableHeight + (double)this.entryInsets().top.intValue() + (double)this.entryInsets().bottom.intValue() - 3.0, textFlow, true);
    }

    protected Selector addTruncationIndicator(Selector truncationSelector, double midHorizontalPoint, double y, double availableWidth, double availableHeight, TextFlow textFlow, boolean transform) {
        Symbol truncationSymbol = this.getLegendTruncationIndicatorShapeSymbol();
        String truncationText = this.getLegendTruncationIndicatorText();
        double shapeWidth = 0.0;
        if (truncationSymbol != null) {
            Selector shape = truncationSelector.append("path").attr("class", (Object)"legendTruncationShape").attr("d", (ValueFunction)truncationSymbol);
            String shapeColor = this.getLegendTruncationIndicatorShapeColor();
            if (ObjectConverter.toBoolean((Object)shapeColor)) {
                shape.style("fill", (Object)shapeColor);
            } else {
                shape.style("fill-opacity", (Object)0);
            }
            String borderColor = this.getLegendTruncationIndicatorShapeBorderColor();
            if (ObjectConverter.toBoolean((Object)borderColor)) {
                shape.attr("stroke", (Object)borderColor);
            }
            RaveRect shapeBbox = shape.node().getBBox();
            shapeWidth = shapeBbox.width;
            shape.attr("transform", (Object)("translate(" + shapeWidth / 2.0 + ",0)"));
        }
        Selector text = truncationSelector.append("text").attr("class", (Object)"legendTruncationLabel").text((Object)truncationText);
        textFlow.wrap(true);
        textFlow.extent((int)(availableWidth - shapeWidth - 3.0), (int)availableHeight);
        textFlow.flow(text);
        double textX = truncationSymbol != null ? 3.0 + shapeWidth : 0.0;
        text.attr("text-anchor", (Object)START_ALIGN).attr("x", (Object)textX).attr("dy", (Object)this.getTextDyPlacement(text.node()));
        text.selectAll("tspan").attr("x", (Object)textX).attr("width", null);
        text.select((Object)"tspan").attr("x", null).attr("dy", null);
        RaveRect trunctationBBox = truncationSelector.node().getBBox();
        if (trunctationBBox.height > availableHeight || trunctationBBox.width > availableWidth) {
            if (truncationSymbol != null) {
                truncationSelector.select((Object)"path").remove();
                trunctationBBox = truncationSelector.node().getBBox();
                if (trunctationBBox.height > availableHeight || trunctationBBox.width > availableWidth) {
                    truncationSelector.remove();
                    return null;
                }
                text.attr("x", (Object)0);
                text.selectAll("tspan").attr("x", (Object)0);
                text.select((Object)"tspan").attr("x", null);
            } else {
                truncationSelector.remove();
                return null;
            }
        }
        if (transform) {
            truncationSelector.attr("transform", (Object)("translate(" + (midHorizontalPoint - trunctationBBox.width / 2.0) + "," + y + ")"));
        }
        return truncationSelector;
    }

    protected Symbol getLegendTruncationIndicatorShapeSymbol() {
        if (ObjectConverter.toBoolean((Object)this._legendTruncationIndicator) && ObjectConverter.toBoolean((Object)this._legendTruncationIndicator.shape)) {
            double size = ObjectConverter.toBoolean((Object)this._legendTruncationIndicator.shapeSize) ? ObjectConverter.toDouble((Object)this._legendTruncationIndicator.shapeSize) : 400.0;
            Symbol shapeSymbol = this._legendTruncationIndicator.shape instanceof Symbol ? ((Symbol)this._legendTruncationIndicator.shape).size(size) : Rave.svg.symbol().size(size).type((String)this._legendTruncationIndicator.shape);
            return shapeSymbol;
        }
        return null;
    }

    protected String getLegendTruncationIndicatorShapeColor() {
        if (ObjectConverter.toBoolean((Object)this._legendTruncationIndicator) && ObjectConverter.toBoolean((Object)this._legendTruncationIndicator.shape)) {
            return ObjectConverter.toBoolean((Object)this._legendTruncationIndicator.shapeColor) ? Rave.rgb((Object)this._legendTruncationIndicator.shapeColor).toString() : null;
        }
        return null;
    }

    protected String getLegendTruncationIndicatorShapeBorderColor() {
        if (ObjectConverter.toBoolean((Object)this._legendTruncationIndicator) && ObjectConverter.toBoolean((Object)this._legendTruncationIndicator.shape)) {
            return ObjectConverter.toBoolean((Object)this._legendTruncationIndicator.shapeBorderColor) ? Rave.rgb((Object)this._legendTruncationIndicator.shapeBorderColor).toString() : null;
        }
        return null;
    }

    protected String getLegendTruncationIndicatorText() {
        if (ObjectConverter.toBoolean((Object)this._legendTruncationIndicator)) {
            return ObjectConverter.toBoolean((Object)this._legendTruncationIndicator.text) ? this._legendTruncationIndicator.text : null;
        }
        return DEFAULT_TRUNCATION_TEXT;
    }

    protected Selector prepareLegendGroup(SceneNode context) {
        Selector gSelection = Rave.select((SceneNode)context);
        gSelection.selectAll(LEGEND_GROUP_CLASS_SELECTOR).remove();
        gSelection = gSelection.append("g").attr("class", (Object)"legendGroup");
        return gSelection;
    }

    protected String getTextDyPlacement(SceneNode node) {
        int numChildren = node.getChildNodes().size();
        if (numChildren < 2) {
            return EM_035;
        }
        if (numChildren == 2) {
            return "-0.0em";
        }
        double spacing = (double)(numChildren - 1) * 0.0;
        double dy = (double)numChildren * 0.7 - 0.35;
        double placement = (dy + spacing) / 2.0;
        return "-" + placement + "em";
    }

    protected Object getLabelFormat() {
        ValueFunction<Object, String> labelFormat = this._labelFormat;
        if (labelFormat == null) {
            labelFormat = _IDENTITY_FN;
        }
        return labelFormat;
    }

    protected Selector prepareLegendTitle(Selector gSelection, TextFlow textFlow) {
        this._spaceUsed = 0.0;
        if (ObjectConverter.toBoolean((Object)this._title)) {
            Selector titleSelector = gSelection.append("text").attr("class", (Object)"legendTitle").text((Object)this._title).style("font-size", (Object)this._titleFontSize).style("font-family", (Object)this._titleFontFamily).style("fill", (Object)this._titleFill);
            double vertical = this._legendInsets.top + this._titleInsets.top + this._legendInsets.bottom + this._titleInsets.bottom;
            double availableHeight = this._size.getHeight() - vertical;
            double left = this._titleInsets.left + this._legendInsets.left;
            double right = this._titleInsets.right + this._legendInsets.right;
            double availableWidth = START_ALIGN.equals(this._titleAlignment) ? this._size.getWidth() - left - (double)this._legendInsets.right.intValue() : ("middle".equals(this._titleAlignment) ? this._size.getWidth() - (double)(this._legendInsets.left + this._legendInsets.right) : this._size.getWidth() - right - (double)this._legendInsets.left.intValue());
            if (availableHeight <= 4.0 || availableWidth <= 4.0) {
                titleSelector.remove();
                return titleSelector;
            }
            textFlow.extent((int)availableWidth, (int)availableHeight);
            textFlow.flow(titleSelector);
            titleSelector.attr("dy", (Object)EM_07).attr("text-anchor", (Object)this._titleAlignment);
            RaveRect titleBbox = titleSelector.node().getBBox();
            if (titleBbox.height > availableHeight || titleBbox.width > availableWidth) {
                titleSelector.text((Object)DEFAULT_TRUNCATION_TEXT);
                titleBbox = titleSelector.node().getBBox();
                if (titleBbox.height <= availableHeight && titleBbox.width <= availableWidth) {
                    this._spaceUsed = this._orient.equals("vertical") ? titleBbox.width + (double)this._titleInsets.left.intValue() + (double)this._titleInsets.right.intValue() : titleBbox.height + (double)this._titleInsets.top.intValue() + (double)this._titleInsets.bottom.intValue();
                    titleSelector.remove();
                    Selector titleTruncationSelector = gSelection.append("text").attr("class", (Object)"legendTruncationTitle").text((Object)DEFAULT_TRUNCATION_TEXT).attr("y", (Object)(this._legendInsets.top + this._titleInsets.top)).attr("dy", (Object)EM_07).attr("text-anchor", (Object)"middle").attr("x", (Object)((double)(this._legendInsets.left + this._titleInsets.left) + availableWidth / 2.0));
                    return titleTruncationSelector;
                }
                titleSelector.remove();
            } else {
                this._spaceUsed = this._orient.equals("vertical") ? titleBbox.width + (double)this._titleInsets.left.intValue() + (double)this._titleInsets.right.intValue() : titleBbox.height + (double)this._titleInsets.top.intValue() + (double)this._titleInsets.bottom.intValue();
            }
            return titleSelector;
        }
        return null;
    }

    protected double calculateTitleVerticalShift(Selector titleSelector) {
        double titleHeight = 0.0;
        double top = this._legendInsets.top.intValue();
        double bottom = this._legendInsets.bottom.intValue();
        if (titleSelector != null) {
            bottom += (double)this._titleInsets.bottom.intValue();
            titleSelector.attr("y", (Object)(top += (double)this._titleInsets.top.intValue()));
            SceneNode node = titleSelector.node();
            RaveRect titleBBox = node.getBBox();
            titleHeight = titleBBox.height;
        }
        return top + bottom + titleHeight;
    }

    protected void alignTitleHorizontally(Selector titleSelector) {
        if (titleSelector != null) {
            double left = this._titleInsets.left + this._legendInsets.left;
            double right = this._titleInsets.right + this._legendInsets.right;
            double x = START_ALIGN.equals(this._titleAlignment) ? left : ("middle".equals(this._titleAlignment) ? this._size.getWidth() / 2.0 : this._size.getWidth() - right);
            titleSelector.attr("x", (Object)x);
            titleSelector.selectAll("tspan").attr("x", (Object)x).attr("width", null);
            titleSelector.select((Object)"tspan").attr("x", null).attr("dy", null);
        }
    }

    protected void alignTitleHorizontally(Selector titleSelector, double width) {
        if (titleSelector != null) {
            double diff;
            double x = START_ALIGN.equals(this._titleAlignment) ? (double)(this._titleInsets.left + this._legendInsets.left) : (END_ALIGN.equals(this._titleAlignment) ? ((diff = this.size().getWidth() - width) > (double)(this._titleInsets.right + this._legendInsets.right) ? width : width + (diff - (double)(this._titleInsets.right + this._legendInsets.right))) : width / 2.0 + (double)this._legendInsets.left.intValue());
            titleSelector.attr("x", (Object)x);
            titleSelector.selectAll("tspan").attr("x", (Object)x).attr("width", null);
            titleSelector.select((Object)"tspan").attr("x", null).attr("dy", null);
        }
    }

    protected TextFlow createTextFlowComponent() {
        TextFlow textFlow = (TextFlow)Rave.capabilities.extension("textflow");
        textFlow.wrap(true).spacing(1.0).truncate(true).dropTextOnFail(false).textTruncateIndicator(this.labelTruncationText());
        return textFlow;
    }

    protected void prepareLegendBounds(Selector gSelection) {
        Selector legendBounds = gSelection.append("rect").attr("class", (Object)"legendBBox").attr("width", (Object)this._size.getWidth()).attr("height", (Object)this._size.getHeight());
        if (ObjectConverter.toBoolean((Object)this._legendBorderColor)) {
            legendBounds.attr("stroke", (Object)Rave.rgb((Object)this._legendBorderColor).toString());
        }
        if (ObjectConverter.toBoolean((Object)this._legendBackgroundColor)) {
            legendBounds.style("fill", (Object)Rave.rgb((Object)this._legendBackgroundColor).toString());
        } else {
            legendBounds.style("fill-opacity", (Object)0);
        }
    }

    protected List<Object> getDataFromScale() {
        if (this._scale == null) {
            return null;
        }
        List ticksData = null;
        if (this._scale.ticksInRange != null) {
            ticksData = this._scale.ticksInRange.ticksInRange(new Object[0]);
        }
        if ((ticksData == null || ticksData.size() == 0) && this._scale.ticks != null) {
            ticksData = this._scale.ticks.getValue(this._scaleArguments);
        }
        if (ticksData == null || ticksData.size() == 0) {
            ticksData = this._scale.domain();
        }
        return ticksData;
    }

    protected List<Object> getData() {
        List<Object> ticksData = this._dataValues;
        if (ticksData == null) {
            ticksData = this.getDataFromScale();
        }
        if (ticksData == null || ticksData.size() < this._minDataLen) {
            return null;
        }
        ArrayEx ticksDataClone = new ArrayEx();
        for (int i = 0; i < ticksData.size(); ++i) {
            ticksDataClone.add(ticksData.get(i));
        }
        if (this._reverse) {
            ticksDataClone.reverse();
        }
        return ticksDataClone;
    }

    public abstract void legend(Selector var1);

    public ExtraLegendEntry extraEntry(Object label) {
        String extraEntryLabel;
        ExtraLegendEntry ele = new ExtraLegendEntry();
        if (label != null && (extraEntryLabel = label.toString()).replaceAll("\\s+", "").length() > 0) {
            this._extraLegendEntries.set((Object)extraEntryLabel, (Object)ele);
        }
        return ele;
    }

    public void clearExtraLegendEntries() {
        List extraEntryKeys = this._extraLegendEntries.keys();
        for (String key : extraEntryKeys) {
            this._extraLegendEntries.remove((Object)key);
        }
    }

    public double getUsedSize() {
        if (this._orient.equals("vertical")) {
            return this._spaceUsed + (double)this._legendInsets.left.intValue() + (double)this._legendInsets.right.intValue() + 2.0;
        }
        return this._spaceUsed + (double)this._legendInsets.top.intValue() + (double)this._legendInsets.bottom.intValue() + 2.0;
    }
}

