/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.ext.legend.continuous;

import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.context.RaveContextManager;
import com.ibm.rave.core.geom.Dim;
import com.ibm.rave.core.geom.Insets;
import com.ibm.rave.core.geom.Point;
import com.ibm.rave.core.geom.RaveRect;
import com.ibm.rave.core.geom.RectStruct;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scales.AbstractScale;
import com.ibm.rave.core.scales.LinearScale;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.CallbackFunction;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selection;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.core.selector.SelectorGroup;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.ext.legend.AbstractLegend;
import com.ibm.rave.ext.legend.ExtraLegendEntry;
import com.ibm.rave.ext.legend.RaveLegend;
import com.ibm.rave.ext.legend.swatch.SwatchLegend;
import com.ibm.rave.ext.position.RavePosition;
import com.ibm.rave.ext.position.drop.DropOverlap;
import com.ibm.rave.ext.text.wrap.TextFlow;
import java.util.List;

public class ContinuousLegend
extends AbstractLegend<ContinuousLegend> {
    @InlineStringConstant
    private static final String AXIS_METHOD = "axis";
    @InlineStringConstant
    private static final String STAGGER_METHOD = "stagger";
    @InlineStringConstant
    private static final String CONTINUOUS_METHOD = "continuous";
    @InlineStringConstant
    private static final String DEFAULT_METHOD = "continuous";
    @InlineStringConstant
    private static final String AXIS_DEFAULT_COLOR = "black";
    @InlineStringConstant
    private static final String GRADIENT_ID = "legendGradient";
    private static final int AXIS_DEFAULT_MINOR_DIMENSION_LEN = 1;
    private static final int MAX_TICK_LABEL_DIGITS = 6;
    private static final int MINOR_SHAPE_MAX_LENGTH = 40;
    private static final int MIN_DATA_COUNT = 2;
    private static final double DEFAULT_STAGGER_RECT_SIDE_LEN = 20.0;
    private static final int MAX_STAGGER_SQUARE_COUNT = 15;
    private static final int PREFERRED_DECIMAL_PLACES_COUNT = 4;
    @InlineStringConstant
    private static final String GRADIENT_ID_COUNT_KEY = "GRADIENT_ID_COUNT_KEY";
    private double _tickLen = 6.0;
    private double _startAt = 0.0;
    private String _method = "continuous";
    private Dim _shapeRectSize;

    private static GradientIdCount getGradientIdCount() {
        GradientIdCount gradientIdCount = (GradientIdCount)RaveContextManager.INSTANCE.getRaveContext().getData(GRADIENT_ID_COUNT_KEY);
        if (gradientIdCount == null) {
            gradientIdCount = new GradientIdCount();
            RaveContextManager.INSTANCE.getRaveContext().putData(GRADIENT_ID_COUNT_KEY, (Object)gradientIdCount);
        }
        return gradientIdCount;
    }

    public ContinuousLegend() {
        this.minDataLen(2);
    }

    public ContinuousLegend method(String method) {
        this._method = AXIS_METHOD.equals(method) || STAGGER_METHOD.equals(method) || "continuous".equals(method) ? method : "continuous";
        return this;
    }

    public String method() {
        return this._method;
    }

    @SwiftMethodOverload(skipOverloads={"Bool"})
    public final ContinuousLegend ticklength(Object length) {
        this._tickLen = ObjectConverter.toDouble((Object)length);
        return this;
    }

    public final double ticklength() {
        return this._tickLen;
    }

    @SwiftMethodOverload(skipOverloads={"Bool"})
    public final ContinuousLegend startAt(Object startAt) {
        this._startAt = ObjectConverter.toDouble((Object)startAt);
        return this;
    }

    public final double startAt() {
        return this._startAt;
    }

    public Dim shapeRectSize() {
        return this._shapeRectSize;
    }

    public ContinuousLegend shapeRectSize(Dim size) {
        this._shapeRectSize = size;
        return this;
    }

    private OrientationValues getOrientationValues(boolean isHorizontal, RaveRect digitBbox, double tickPadding, double availableWidth, double availableHeight) {
        double shapeAvailableWidth;
        double shapeAvailableHeight;
        if (isHorizontal) {
            shapeAvailableHeight = availableHeight - (this._tickLen + tickPadding + digitBbox.height);
            shapeAvailableWidth = availableWidth - digitBbox.width * 6.0;
        } else {
            shapeAvailableWidth = availableWidth - (this._tickLen + tickPadding + digitBbox.width * 6.0);
            shapeAvailableHeight = availableHeight - digitBbox.height;
        }
        OrientationValues vals = new OrientationValues();
        if (isHorizontal) {
            vals.shape_changing_coord2 = "x2";
            vals.shape_const_coord2 = "y2";
            vals.tick_len_coord1 = "y1";
            vals.tick_len_coord2 = "y2";
            vals.tick_place_coord1 = "x1";
            vals.tick_place_coord2 = "x2";
            vals.label_place_coord = "x";
            vals.label_shift_coord = "y";
            vals.label_anchor = "middle";
            vals.label_adjust_dy_value = ".7em";
            vals.shape_major_dimension = "width";
            vals.shape_minor_dimension = "height";
            if (ObjectConverter.toBoolean((Object)this._shapeRectSize)) {
                vals.shapeRectSize = new Dim(this._shapeRectSize.getWidth(), this._shapeRectSize.getHeight());
                if (vals.shapeRectSize.getHeight() <= 0.0) {
                    vals.shapeRectSize.setHeight(Math.min(shapeAvailableHeight, 40.0));
                }
                if (vals.shapeRectSize.getWidth() <= 0.0) {
                    vals.shapeRectSize.setWidth(shapeAvailableWidth);
                }
            } else {
                vals.shapeRectSize = new Dim(shapeAvailableWidth, Math.min(shapeAvailableHeight, 40.0));
            }
            if (AXIS_METHOD.equals(this._method)) {
                vals.shape_major_dimension_len = ((Number)this.scale().range().get(this.scale().range().size() - 1)).doubleValue();
                vals.shape_major_dimension_len += this._startAt;
            } else {
                vals.shape_major_dimension_len = vals.shapeRectSize.getWidth();
            }
            vals.shape_minor_dimension_len = vals.shapeRectSize.getHeight();
            vals.tickPlacementScaleRange = new ArrayEx(new Object[]{0, vals.shape_major_dimension_len});
        } else {
            vals.shape_changing_coord2 = "y2";
            vals.shape_const_coord2 = "x2";
            vals.tick_len_coord1 = "x1";
            vals.tick_len_coord2 = "x2";
            vals.tick_place_coord1 = "y1";
            vals.tick_place_coord2 = "y2";
            vals.label_place_coord = "y";
            vals.label_shift_coord = "x";
            vals.label_anchor = "start";
            vals.label_adjust_dy_value = ".35em";
            vals.shape_major_dimension = "height";
            vals.shape_minor_dimension = "width";
            if (ObjectConverter.toBoolean((Object)this._shapeRectSize)) {
                vals.shapeRectSize = new Dim(this._shapeRectSize.getWidth(), this._shapeRectSize.getHeight());
                if (vals.shapeRectSize.getHeight() <= 0.0) {
                    vals.shapeRectSize.setHeight(shapeAvailableHeight);
                }
                if (vals.shapeRectSize.getWidth() <= 0.0) {
                    vals.shapeRectSize.setWidth(Math.min(shapeAvailableWidth, 40.0));
                }
            } else {
                vals.shapeRectSize = new Dim(Math.min(shapeAvailableWidth, 40.0), shapeAvailableHeight);
            }
            if (AXIS_METHOD.equals(this._method)) {
                vals.shape_major_dimension_len = ObjectConverter.asDouble(this.scale().range().get(this.scale().range().size() - 1));
                vals.shape_major_dimension_len += this._startAt;
            } else {
                vals.shape_major_dimension_len = vals.shapeRectSize.getHeight();
            }
            vals.shape_minor_dimension_len = vals.shapeRectSize.getWidth();
            vals.tickPlacementScaleRange = new ArrayEx(new Object[]{vals.shape_major_dimension_len, 0});
        }
        vals.tickShift = AXIS_METHOD.equals(this._method) ? 1.0 : vals.shape_minor_dimension_len;
        return vals;
    }

    private TickPlacementValues getTickPlacementValues(boolean isHorizontal, List<Object> ticksData, final OrientationValues ov) {
        TickPlacementValues vals = new TickPlacementValues();
        vals.extent = Rave.extent((Object[])ticksData.toArray());
        if (this.reverse()) {
            vals.extent = new ArrayEx(new Object[]{vals.extent.get(1), vals.extent.get(0)});
        }
        boolean horizontal = this.reverse() ? !isHorizontal : isHorizontal;
        LinearScale placementScale = Rave.scale.linear().domain(vals.extent).range(ov.tickPlacementScaleRange);
        if (AXIS_METHOD.equals(this._method)) {
            vals.ticksPlacementData = placementScale.ticks.getValue(new Object[0]).toArray();
            final ContinuousLegend self = this;
            vals.tickPlacementValueFunction = horizontal ? new ValueFunction<Object, Number>(){

                public Number getValue(Object context, Object data, int index, int groupIndex) {
                    Number val = (Number)self.scale().getValue(context, data, index, groupIndex);
                    return val.doubleValue() + self._startAt;
                }
            } : new ValueFunction<Object, Number>(){

                public Number getValue(Object context, Object data, int index, int groupIndex) {
                    Number val = (Number)self.scale().getValue(context, data, index, groupIndex);
                    return ov.shape_major_dimension_len - val.doubleValue() - self._startAt;
                }
            };
        } else if (STAGGER_METHOD.equals(this._method)) {
            double stagger_rect_major_dim_len;
            int numRects = (int)(ov.shape_major_dimension_len / 20.0);
            if (numRects < 2) {
                numRects = 1;
                stagger_rect_major_dim_len = ov.shape_major_dimension_len;
                vals.ticksPlacementData = vals.extent.toArray();
            } else {
                if (numRects > 15) {
                    numRects = 15;
                }
                double extentStart = ObjectConverter.toDouble((Object)vals.extent.get(0));
                double extentEnd = ObjectConverter.toDouble((Object)vals.extent.get(1));
                double diff = extentEnd - extentStart;
                if (diff == 0.0) {
                    stagger_rect_major_dim_len = ov.shape_major_dimension_len;
                    vals.ticksPlacementData = new Object[0];
                } else {
                    double step = diff / (double)(numRects + 1);
                    ArrayEx ticks = Rave.range((Object)extentStart, (Object)extentEnd, (Object)step);
                    this.fixTicksDecimalPlaces((ArrayEx<Number>)ticks, 4);
                    if (((Number)ticks.get(ticks.size() - 1)).doubleValue() != extentEnd) {
                        ticks.set(ticks.size() - 1, (Object)extentEnd);
                    }
                    vals.ticksPlacementData = ticks.toArray();
                    stagger_rect_major_dim_len = ov.shape_major_dimension_len / (double)(ticks.size() - 1);
                }
            }
            vals.tickPlacementValueFunction = horizontal ? new ValueFunction<Object, Number>(){

                public Number getValue(Object context, Object data, int index, int groupIndex) {
                    return stagger_rect_major_dim_len * (double)index;
                }
            } : new ValueFunction<Object, Number>(){

                public Number getValue(Object context, Object data, int index, int groupIndex) {
                    return ov.shape_major_dimension_len - stagger_rect_major_dim_len * (double)index;
                }
            };
        } else {
            vals.tickPlacementValueFunction = placementScale;
            vals.ticksPlacementData = placementScale.ticks.getValue(new Object[0]).toArray();
        }
        return vals;
    }

    private void fixTicksDecimalPlaces(ArrayEx<Number> ticks, int numPlaces) {
        for (int i = 0; i < ticks.size(); ++i) {
            double tickValue = ((Number)ticks.get(i)).doubleValue();
            tickValue = this.fixDecimalPlaces(tickValue, numPlaces);
            ticks.set(i, (Object)tickValue);
        }
    }

    private double fixDecimalPlaces(double val, int numPlaces) {
        if (val == 0.0) {
            return 0.0;
        }
        double f = Math.pow(10.0, numPlaces);
        while ((int)(val * f) == 0) {
            f *= 10.0;
        }
        return (double)((int)(val * f)) / f;
    }

    private TickEntrySelectors getTickEntrySelectors(Selector gSelection, Object labelFormat, String tickColor, double tickPadding, OrientationValues ov, TickPlacementValues tv) {
        TickEntrySelectors ts = new TickEntrySelectors();
        ts.tickEntry = gSelection.selectAll(".legendEntry").data(tv.ticksPlacementData).enter().append("g").attr("class", (Object)"legendEntry");
        ts.tick = ts.tickEntry.append("line").attr("class", (Object)"legendTickLine").attr(ov.tick_len_coord1, (Object)ov.tickShift).attr(ov.tick_len_coord2, (Object)(ov.tickShift + this._tickLen)).attr(ov.tick_place_coord1, tv.tickPlacementValueFunction).attr(ov.tick_place_coord2, tv.tickPlacementValueFunction).style("stroke", (Object)tickColor);
        ts.text = ts.tickEntry.append("text").attr("class", (Object)"legendLabel").attr(ov.label_place_coord, tv.tickPlacementValueFunction).attr(ov.label_shift_coord, (Object)(ov.tickShift + this._tickLen + tickPadding)).attr("dy", (Object)ov.label_adjust_dy_value).attr("text-anchor", (Object)ov.label_anchor);
        if (labelFormat instanceof ValueFunction) {
            ts.text.text((ValueFunction)labelFormat);
        } else {
            ts.text.text(labelFormat);
        }
        return ts;
    }

    private TickEntrySelectors updateTickEntrySelectors(Selector gSelection) {
        TickEntrySelectors ts = new TickEntrySelectors();
        ts.tickEntry = gSelection.selectAll(".legendEntry");
        ts.tick = gSelection.selectAll(".legendTickLine");
        ts.text = gSelection.selectAll(".legendLabel");
        return ts;
    }

    private TickEntryBBoxes getTickEntryBBoxes(TickEntrySelectors ts) {
        final TickEntryBBoxes tb = new TickEntryBBoxes();
        ts.text.each((CallbackFunction)new CallbackFunction<SceneNode>(){

            public void run(SceneNode context, Object data, int index, int groupIndex) {
                RaveRect labelBbox = context.getBBox();
                if (labelBbox.width > tb.largestLabelWidth) {
                    tb.largestLabelWidth = labelBbox.width;
                }
                if (labelBbox.height > tb.largestLabelHeight) {
                    tb.largestLabelHeight = labelBbox.height;
                }
                tb.labelBboxes.add((Object)labelBbox);
                tb.labelTexts.add((Object)context.getText());
                tb.labelBboxesPoints.add((Object)new Point(ObjectConverter.toDouble((Object)context.getAttribute("x")), ObjectConverter.toDouble((Object)context.getAttribute("y"))));
            }
        });
        ts.tick.each((CallbackFunction)new CallbackFunction<SceneNode>(){

            public void run(SceneNode context, Object data, int index, int groupIndex) {
                tb.tickBboxes.add((Object)context.getBBox());
            }
        });
        return tb;
    }

    private ShapeSelectors getShapeSelectors(boolean isHorizontal, Selector gSelection, OrientationValues ov, TickPlacementValues tv, List<Object> ticksData, String axisColor, String borderColor) {
        ShapeSelectors ss = new ShapeSelectors();
        if (AXIS_METHOD.equals(this._method)) {
            ss.shapeSelector = gSelection.append("line").attr("class", (Object)"legendShape").attr("x1", (Object)0).attr("y1", (Object)0).attr(ov.shape_changing_coord2, (Object)ov.shape_major_dimension_len).attr(ov.shape_const_coord2, (Object)0).style("stroke", (Object)axisColor);
        } else if (STAGGER_METHOD.equals(this._method)) {
            int i;
            Object[] staggerRectData;
            if (tv.ticksPlacementData.length > 1) {
                staggerRectData = new Double[tv.ticksPlacementData.length - 1];
                double tickValue = ObjectConverter.toDouble((Object)tv.ticksPlacementData[0]);
                for (int i2 = 1; i2 < tv.ticksPlacementData.length; ++i2) {
                    double nextTickValue = ObjectConverter.toDouble((Object)tv.ticksPlacementData[i2]);
                    staggerRectData[i2 - 1] = (tickValue + nextTickValue) / 2.0;
                    tickValue = nextTickValue;
                }
            } else {
                staggerRectData = new Double[]{ObjectConverter.toDouble((Object)tv.ticksPlacementData[0])};
            }
            ArrayEx colors = new ArrayEx();
            for (int i3 = 0; i3 < ticksData.size(); ++i3) {
                Object color = this.scale().getValue(null, ticksData.get(i3), -1, -1);
                colors.add(color);
            }
            AbstractScale colorScale = this.scale().copy();
            colorScale.domain(ticksData);
            colorScale.range((List)colors);
            final ArrayEx staggerRectColor = new ArrayEx();
            if (isHorizontal) {
                for (i = 0; i < staggerRectData.length; ++i) {
                    staggerRectColor.add((Object)colorScale.getValue(null, (Object)staggerRectData[i], -1, -1).toString());
                }
            } else {
                for (i = staggerRectData.length - 1; i >= 0; --i) {
                    staggerRectColor.add((Object)colorScale.getValue(null, (Object)staggerRectData[i], -1, -1).toString());
                }
            }
            if (this.reverse()) {
                staggerRectColor.reverse();
            }
            final double stagger_rect_major_dim_len = ov.shape_major_dimension_len / (double)staggerRectData.length;
            ss.shapeSelector = gSelection.selectAll(".legendShape").data(staggerRectData).enter().append("rect").attr("class", (Object)"legendShape").attr(ov.shape_major_dimension, (Object)stagger_rect_major_dim_len).attr(ov.shape_minor_dimension, (Object)ov.shape_minor_dimension_len).style("fill", (ValueFunction)new ValueFunction<SceneNode, String>(){

                public String getValue(SceneNode context, Object data, int index, int groupIndex) {
                    return (String)staggerRectColor.get(index);
                }
            }).attr(ov.label_place_coord, (ValueFunction)new ValueFunction<SceneNode, Double>(){

                public Double getValue(SceneNode context, Object data, int index, int groupIndex) {
                    return stagger_rect_major_dim_len * (double)index;
                }
            });
            if (borderColor != null) {
                ss.boundsSelector = gSelection.append("rect").attr("class", (Object)"legendStaggerBorder").attr(ov.shape_minor_dimension, (Object)ov.shape_minor_dimension_len).attr(ov.shape_major_dimension, (Object)ov.shape_major_dimension_len).style("fill-opacity", (Object)0).attr("stroke", (Object)borderColor);
            }
        } else {
            GradientIdCount gradientIdCount = ContinuousLegend.getGradientIdCount();
            String gradientID = GRADIENT_ID + gradientIdCount.idCount++;
            Selector gradient = gSelection.append("defs").append("linearGradient").attr("id", (Object)gradientID).attr("x1", (Object)"0%").attr("y1", (Object)"0%").attr(ov.shape_const_coord2, (Object)"0%").attr(ov.shape_changing_coord2, (Object)"100%").attr("spreadMethod", (Object)"pad");
            if (isHorizontal) {
                LinearScale stopsScale = Rave.scale.linear().domain(tv.extent).range((List)new ArrayEx(new Object[]{0, 100}));
                for (int i = 0; i < ticksData.size(); ++i) {
                    Number stop = (Number)stopsScale.getValue(null, ticksData.get(i), -1, -1);
                    gradient.append("stop").attr("offset", (Object)(stop.doubleValue() + "%")).attr("stop-color", this.scale().getValue(null, ticksData.get(i), -1, -1)).attr("stop-opacity", (Object)1);
                }
            } else {
                LinearScale stopsScale = Rave.scale.linear().domain(tv.extent).range((List)new ArrayEx(new Object[]{100, 0}));
                for (int i = ticksData.size() - 1; i >= 0; --i) {
                    Number stop = (Number)stopsScale.getValue(null, ticksData.get(i), -1, -1);
                    gradient.append("stop").attr("offset", (Object)(stop.doubleValue() + "%")).attr("stop-color", this.scale().getValue(null, ticksData.get(i), -1, -1)).attr("stop-opacity", (Object)1);
                }
            }
            ss.shapeSelector = gSelection.append("rect").attr("class", (Object)"legendShape").attr(ov.shape_minor_dimension, (Object)ov.shape_minor_dimension_len).attr(ov.shape_major_dimension, (Object)ov.shape_major_dimension_len);
            if (borderColor != null) {
                ss.shapeSelector.attr("stroke", (Object)borderColor);
            }
            ss.shapeSelector.style("fill", (Object)("url(#" + gradientID + ")"));
        }
        return ss;
    }

    private void transformShapes(boolean isHorizontal, TickEntryBBoxes tb, OrientationValues ov, TickEntrySelectors ts, ShapeSelectors ss, Selector titleSelector, double titleVerticalShift) {
        double label_vertical_shift = 0.0;
        double label_horizontal_shift = 0.0;
        if (isHorizontal) {
            if (((RaveRect)tb.labelBboxes.get((int)0)).width / 2.0 - ((Point)tb.labelBboxesPoints.get(0)).getX() > 0.0) {
                label_horizontal_shift = ((RaveRect)tb.labelBboxes.get((int)0)).width / 2.0;
            }
        } else if (((RaveRect)tb.labelBboxes.get((int)(tb.labelBboxes.size() - 1))).height / 2.0 - ((Point)tb.labelBboxesPoints.get(tb.labelBboxesPoints.size() - 1)).getY() > 0.0) {
            label_vertical_shift = ((RaveRect)tb.labelBboxes.get((int)(tb.labelBboxes.size() - 1))).height / 2.0;
        }
        double horizontal_shift = (double)(this.entryInsets().left + this.insets().left) + label_horizontal_shift;
        double vertical_shift = titleVerticalShift - (double)this.insets().bottom.intValue() + label_vertical_shift + (double)this.entryInsets().top.intValue();
        String transformStr = "translate(" + horizontal_shift + "," + vertical_shift + ")";
        if (ObjectConverter.toBoolean((Object)ss.boundsSelector)) {
            ss.boundsSelector.attr("transform", (Object)transformStr);
        }
        ss.shapeSelector.attr("transform", (Object)transformStr);
        ts.tickEntry.attr("transform", (Object)transformStr);
        this.alignContinuousLegendTitleHorizontally(isHorizontal, horizontal_shift, ov, titleSelector);
    }

    private void alignContinuousLegendTitleHorizontally(boolean isHorizontal, double horizontal_shift, OrientationValues ov, Selector titleSelector) {
        if (titleSelector != null) {
            RaveRect titleBbox = titleSelector.node().getBBox();
            double legendProperWidth = isHorizontal ? ov.shape_major_dimension_len : ov.shape_minor_dimension_len;
            double title_horizontal_shift = horizontal_shift;
            if ("start".equals(this.titleAlignment())) {
                title_horizontal_shift = 0.0;
            } else if ("end".equals(this.titleAlignment())) {
                title_horizontal_shift += titleBbox.width > legendProperWidth ? (double)(this.titleInsets().right + this.insets().right) : 0.0;
            } else {
                title_horizontal_shift *= 2.0;
                title_horizontal_shift -= (double)this.insets().left.intValue();
            }
            double w = Math.max(titleBbox.width, legendProperWidth += title_horizontal_shift);
            this.alignTitleHorizontally(titleSelector, w);
        }
    }

    private void cleanUpTextFlowSettings(Selector text, OrientationValues ov) {
        text.selectAll("tspan").attr("x", null).attr("dy", null).attr("width", null);
        text.attr("dy", (Object)ov.label_adjust_dy_value).attr("text-anchor", (Object)ov.label_anchor);
    }

    private Dim getLegendProperDim(boolean isHorizontal, OrientationValues ov, TickEntryBBoxes tb, double tickPadding) {
        double legend_shape_height;
        double legend_shape_width;
        if (isHorizontal) {
            legend_shape_width = ov.shape_major_dimension_len;
            if (((RaveRect)tb.labelBboxes.get((int)0)).width / 2.0 + ((Point)tb.labelBboxesPoints.get(0)).getX() >= ov.shape_major_dimension_len) {
                legend_shape_width += ((RaveRect)tb.labelBboxes.get((int)0)).width / 2.0;
            }
            if (((RaveRect)tb.labelBboxes.get((int)(tb.labelBboxes.size() - 1))).width / 2.0 + ((Point)tb.labelBboxesPoints.get(tb.labelBboxesPoints.size() - 1)).getX() >= ov.shape_major_dimension_len) {
                legend_shape_width += ((RaveRect)tb.labelBboxes.get((int)(tb.labelBboxes.size() - 1))).width / 2.0;
            }
            legend_shape_height = ov.tickShift + tb.largestLabelHeight + this._tickLen + tickPadding;
        } else {
            legend_shape_height = ov.shape_major_dimension_len;
            if (((RaveRect)tb.labelBboxes.get((int)0)).height / 2.0 + ((Point)tb.labelBboxesPoints.get(0)).getY() >= ov.shape_major_dimension_len) {
                legend_shape_height += ((RaveRect)tb.labelBboxes.get((int)0)).height / 2.0;
            }
            if (((RaveRect)tb.labelBboxes.get((int)(tb.labelBboxes.size() - 1))).height / 2.0 + ((Point)tb.labelBboxesPoints.get(tb.labelBboxesPoints.size() - 1)).getY() >= ov.shape_major_dimension_len) {
                legend_shape_height += ((RaveRect)tb.labelBboxes.get((int)(tb.labelBboxes.size() - 1))).height / 2.0;
            }
            legend_shape_width = ov.tickShift + tb.largestLabelWidth + this._tickLen + tickPadding;
        }
        return new Dim(legend_shape_width, legend_shape_height);
    }

    private boolean verifyResults(Selector gSelection, Selector titleSelector, double titleVerticalShift, boolean isHorizontal, double tickPadding, OrientationValues ov, TickEntryBBoxes tb, TickEntrySelectors ts, ShapeSelectors ss, double availableWidth, double availableHeight, TextFlow textFlow) {
        TickEntryBBoxes _tb = tb;
        TickEntrySelectors _ts = ts;
        Dim legendDim = this.getLegendProperDim(isHorizontal, ov, _tb, tickPadding);
        Insets entryInsets = this.entryInsets();
        if (isHorizontal) {
            this._spaceUsed += legendDim.getHeight() + (double)(entryInsets.top + entryInsets.bottom);
        } else if (legendDim.getWidth() > this._spaceUsed) {
            this._spaceUsed = legendDim.getWidth() + (double)(entryInsets.left + entryInsets.right);
        }
        if (legendDim.getWidth() > availableWidth || legendDim.getHeight() > availableHeight) {
            if (legendDim.getWidth() > availableWidth) {
                textFlow.wrap(false);
                if (isHorizontal) {
                    double extraWidth = Math.ceil(legendDim.getWidth() - availableWidth) * 2.0;
                    if (((RaveRect)_tb.labelBboxes.get((int)0)).width / 2.0 + ((Point)_tb.labelBboxesPoints.get(0)).getX() >= ov.shape_major_dimension_len) {
                        double halfFirstlabel = ((RaveRect)_tb.labelBboxes.get((int)0)).width / 2.0;
                        double halfLastLabel = 0.0;
                        if (((RaveRect)_tb.labelBboxes.get((int)(_tb.labelBboxes.size() - 1))).width / 2.0 + ((Point)_tb.labelBboxesPoints.get(_tb.labelBboxesPoints.size() - 1)).getX() > ov.shape_major_dimension_len) {
                            halfLastLabel = ((RaveRect)_tb.labelBboxes.get((int)(_tb.labelBboxes.size() - 1))).width / 2.0;
                        }
                        double firstLabelRatio = halfFirstlabel / (halfFirstlabel + halfLastLabel);
                        double firstLabelReduction = Math.ceil(firstLabelRatio * extraWidth);
                        Selector firstLabelSelection = Rave.select((SceneNode)_ts.text.node());
                        textFlow.extent((int)(((RaveRect)_tb.labelBboxes.get((int)0)).width - firstLabelReduction), (int)_tb.largestLabelHeight);
                        textFlow.flow(firstLabelSelection);
                        this.cleanUpTextFlowSettings(firstLabelSelection, ov);
                        if (extraWidth - firstLabelReduction > 0.0) {
                            double lastLabelReduction = Math.ceil(extraWidth - firstLabelReduction);
                            Selector lastLabelSelection = Rave.select((SceneNode)((SceneNode)((SelectorGroup)_ts.text.get(0)).get(_ts.text.size() - 1)));
                            textFlow.extent((int)(((RaveRect)_tb.labelBboxes.get((int)(_tb.labelBboxes.size() - 1))).width - lastLabelReduction), (int)_tb.largestLabelHeight);
                            textFlow.flow(lastLabelSelection);
                            this.cleanUpTextFlowSettings(lastLabelSelection, ov);
                        }
                    }
                } else {
                    double truncationWidth = _tb.largestLabelWidth - (legendDim.getWidth() - availableWidth);
                    textFlow.extent((int)truncationWidth, (int)_tb.largestLabelHeight);
                    textFlow.flow(_ts.text);
                    this.cleanUpTextFlowSettings(_ts.text, ov);
                }
                this.transformShapes(isHorizontal, _tb, ov, _ts, ss, titleSelector, titleVerticalShift);
                _tb = this.getTickEntryBBoxes(_ts);
                legendDim = this.getLegendProperDim(isHorizontal, ov, _tb, tickPadding);
            }
            if (legendDim.getWidth() > availableWidth || legendDim.getHeight() > availableHeight) {
                this.alignTitleHorizontally(titleSelector);
                _ts.tickEntry.remove();
                ss.shapeSelector.remove();
                if (ss.boundsSelector != null) {
                    ss.boundsSelector.remove();
                }
                this.addTruncationIndicator(gSelection, titleVerticalShift, availableWidth, availableHeight, textFlow);
                return false;
            }
            _ts = this.updateTickEntrySelectors(gSelection);
            _tb = this.getTickEntryBBoxes(_ts);
            this.transformShapes(isHorizontal, _tb, ov, _ts, ss, titleSelector, titleVerticalShift);
        }
        return true;
    }

    @Override
    protected List<Object> getDataFromScale() {
        if (this.scale() == null) {
            return null;
        }
        return this.scale().domain();
    }

    @Override
    public void legend(Selector g) {
        final ContinuousLegend self = this;
        g.each((CallbackFunction)new CallbackFunction<SceneNode>(){

            public void run(SceneNode context, Object data, int index, int groupIndex) {
                self._spaceUsed = 0.0;
                Selector gSelection = self.prepareLegendGroup(context);
                self.prepareLegendBounds(gSelection);
                Object labelFormat = self.getLabelFormat();
                TextFlow textFlow = self.createTextFlowComponent();
                Selector titleSelector = self.prepareLegendTitle(gSelection, textFlow);
                if (titleSelector != null && titleSelector.node().getParentNode() == null) {
                    return;
                }
                double titleVerticalShift = self.calculateTitleVerticalShift(titleSelector);
                double tickPadding = ObjectConverter.toDouble((Object)self.labelPadding());
                boolean isHorizontal = "horizontal".equals(self.orient());
                double availableWidth = self.size().getWidth() - (double)self.insets().left.intValue() - (double)self.insets().right.intValue() - (double)self.entryInsets().left.intValue() - (double)self.entryInsets().right.intValue();
                double availableHeight = self.size().getHeight() - titleVerticalShift - (double)self.entryInsets().top.intValue() - (double)self.entryInsets().bottom.intValue();
                if (availableHeight <= 0.0 || availableWidth <= 0.0) {
                    self.alignTitleHorizontally(titleSelector);
                    return;
                }
                if (!ObjectConverter.toBoolean((Object)self.scale())) {
                    self.alignTitleHorizontally(titleSelector);
                    return;
                }
                List ticksData = self.getData();
                if (ticksData == null) {
                    self.alignTitleHorizontally(titleSelector);
                    return;
                }
                ticksData = self.sanitizeData(ticksData);
                RaveRect digitBbox = self.getSingleDigitBbox(gSelection);
                OrientationValues ov = self.getOrientationValues(isHorizontal, digitBbox, tickPadding, availableWidth, availableHeight);
                String tickColor = ContinuousLegend.AXIS_DEFAULT_COLOR;
                String axisColor = ContinuousLegend.AXIS_DEFAULT_COLOR;
                String borderColor = null;
                if (ObjectConverter.toBoolean((Object)self.shapeBorderColor())) {
                    tickColor = borderColor = Rave.rgb((Object)self.shapeBorderColor()).toString();
                    axisColor = borderColor;
                }
                TickPlacementValues tv = self.getTickPlacementValues(isHorizontal, ticksData, ov);
                if (tv.ticksPlacementData == null || tv.ticksPlacementData.length == 0) {
                    self.alignTitleHorizontally(titleSelector);
                    return;
                }
                TickEntrySelectors ts = self.getTickEntrySelectors(gSelection, labelFormat, tickColor, tickPadding, ov, tv);
                TickEntryBBoxes tb = self.getTickEntryBBoxes(ts);
                if (tb.labelBboxes.size() == 0) {
                    self.alignTitleHorizontally(titleSelector);
                    return;
                }
                ShapeSelectors ss = self.getShapeSelectors(isHorizontal, gSelection, ov, tv, ticksData, axisColor, borderColor);
                self.transformShapes(isHorizontal, tb, ov, ts, ss, titleSelector, titleVerticalShift);
                self.handleCollidingLabels(ts);
                ts = self.updateTickEntrySelectors(gSelection);
                tb = self.getTickEntryBBoxes(ts);
                self.verifyResults(gSelection, titleSelector, titleVerticalShift, isHorizontal, tickPadding, ov, tb, ts, ss, availableWidth, availableHeight, textFlow);
                self.createSwatchExtraEntries(gSelection, self.size().getWidth(), self.size().getHeight(), self.getLegendProperDim(isHorizontal, ov, tb, tickPadding).getWidth(), self.getLegendProperDim(isHorizontal, ov, tb, tickPadding).getHeight(), availableWidth, availableHeight, self.insets(), titleVerticalShift);
            }
        });
    }

    private RaveRect getSingleDigitBbox(Selector gSelection) {
        Selector selector = gSelection.append("text").text((Object)"0");
        RaveRect digitBbox = selector.node().getBBox();
        selector.remove();
        return digitBbox;
    }

    private List<Object> sanitizeData(List<Object> ticksData) {
        if (this.dataValues() != null) {
            boolean hasInvalidValues = false;
            List domainExtent = Rave.extent((Object[])this.scale().domain().toArray());
            double minVal = ObjectConverter.toDouble(domainExtent.get(0));
            double maxVal = ObjectConverter.toDouble(domainExtent.get(1));
            ArrayEx newData = new ArrayEx();
            for (int i = 0; i < ticksData.size(); ++i) {
                double val = ObjectConverter.toDouble((Object)ticksData.get(i));
                if (val > maxVal || val < minVal) {
                    hasInvalidValues = true;
                    continue;
                }
                newData.add((Object)val);
            }
            if (newData.size() > 0) {
                return newData;
            }
            if (hasInvalidValues) {
                return this.scale().domain();
            }
        }
        return ticksData;
    }

    private void handleCollidingLabels(TickEntrySelectors ts) {
        RavePosition ravePosition = (RavePosition)Rave.capabilities.extension("position");
        DropOverlap dropOverlap = ravePosition.drop();
        dropOverlap.remove(true).dropOverlap((Selection)ts.text);
    }

    private void createSwatchExtraEntries(Selector gSelection, double overallWidth, double overallHeight, double legendWidth, double legendHeight, double availableWidth, double availableHeight, Insets insets, double verticalTitleShift) {
        ContinuousLegend self = this;
        RectStruct extraLegendRect = null;
        extraLegendRect = self.orient().equals("vertical") ? new RectStruct((double)(insets.left * 2) + legendWidth, overallHeight - availableHeight, availableWidth - legendWidth, legendHeight) : new RectStruct(overallWidth - availableWidth, (double)(insets.top * 2) + legendHeight + verticalTitleShift, legendWidth, availableHeight - legendHeight);
        if (!self._extraLegendEntries.empty()) {
            ArrayEx swatchData = new ArrayEx();
            for (Object key : self._extraLegendEntries.keys()) {
                swatchData.add(key);
            }
            RaveLegend rl = (RaveLegend)Rave.capabilities.extension("legend");
            SwatchLegend swatchLegend = (SwatchLegend)((SwatchLegend)((SwatchLegend)rl.swatch().size(new Dim(extraLegendRect.width, extraLegendRect.height))).orient(self.orient())).scale((AbstractScale)Rave.scale.category20b().domain((List)swatchData));
            for (int i = 0; i < self._extraLegendEntries.size(); ++i) {
                ExtraLegendEntry ele = swatchLegend.extraEntry(self._extraLegendEntries.keys().get(i));
                if (((ExtraLegendEntry)self._extraLegendEntries.get(self._extraLegendEntries.keys().get(i))).colorSet()) {
                    ele.color(((ExtraLegendEntry)self._extraLegendEntries.get(self._extraLegendEntries.keys().get(i))).color());
                }
                if (((ExtraLegendEntry)self._extraLegendEntries.get(self._extraLegendEntries.keys().get(i))).sizeSet()) {
                    ele.size(((ExtraLegendEntry)self._extraLegendEntries.get(self._extraLegendEntries.keys().get(i))).size());
                }
                if (!((ExtraLegendEntry)self._extraLegendEntries.get(self._extraLegendEntries.keys().get(i))).shapeSet()) continue;
                ele.shape(((ExtraLegendEntry)self._extraLegendEntries.get(self._extraLegendEntries.keys().get(i))).shape());
            }
            Selector swatchLegendSelector = gSelection.append("g").attr("class", (Object)"extraLegend").attr("transform", (Object)("translate(" + extraLegendRect.x + "," + extraLegendRect.y + ")")).attr("width", (Object)extraLegendRect.width).attr("height", (Object)extraLegendRect.height).call((RunFunction)swatchLegend, new Object[0]);
            if (swatchLegendSelector.selectAll(".legendEntry").size() == 0) {
                gSelection.selectAll(".extraLegend").remove();
            }
        }
    }

    private static class GradientIdCount {
        int idCount = 0;

        private GradientIdCount() {
        }
    }

    private static class ShapeSelectors {
        Selector shapeSelector;
        Selector boundsSelector;

        private ShapeSelectors() {
        }
    }

    private static class TickEntryBBoxes {
        double largestLabelWidth = 0.0;
        double largestLabelHeight = 0.0;
        ArrayEx<RaveRect> tickBboxes = new ArrayEx();
        ArrayEx<RaveRect> labelBboxes = new ArrayEx();
        final ArrayEx<String> labelTexts = new ArrayEx();
        ArrayEx<Point> labelBboxesPoints = new ArrayEx();

        TickEntryBBoxes() {
        }
    }

    private static class TickEntrySelectors {
        Selector tickEntry;
        Selector tick;
        Selector text;

        private TickEntrySelectors() {
        }
    }

    private static class TickPlacementValues {
        List<Object> extent;
        ValueFunction tickPlacementValueFunction;
        Object[] ticksPlacementData;

        private TickPlacementValues() {
        }
    }

    private static class OrientationValues {
        double tickShift;
        double shape_major_dimension_len;
        double shape_minor_dimension_len;
        String shape_major_dimension;
        String shape_minor_dimension;
        String shape_changing_coord2;
        String shape_const_coord2;
        String tick_len_coord1;
        String tick_len_coord2;
        String tick_place_coord1;
        String tick_place_coord2;
        String label_place_coord;
        String label_shift_coord;
        String label_adjust_dy_value;
        String label_anchor;
        Dim shapeRectSize;
        ArrayEx<Object> tickPlacementScaleRange;

        private OrientationValues() {
        }
    }
}

