/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.ext.legend.swatch;

import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.geom.Insets;
import com.ibm.rave.core.geom.RaveRect;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.CallbackFunction;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.core.svg.Symbol;
import com.ibm.rave.core.util.Comparator;
import com.ibm.rave.ext.layout.fill.FillLayout;
import com.ibm.rave.ext.layout.fill.FillNode;
import com.ibm.rave.ext.layout.fill.SetValueFunction;
import com.ibm.rave.ext.legend.AbstractLegend;
import com.ibm.rave.ext.legend.ExtraLegendEntry;
import com.ibm.rave.ext.text.internal.wrap.FontStyleStruct;
import com.ibm.rave.ext.text.internal.wrap.TextData;
import com.ibm.rave.ext.text.internal.wrap.TextOperation;
import com.ibm.rave.ext.text.wrap.TextFlow;
import java.util.List;

public class SwatchLegend
extends AbstractLegend<SwatchLegend> {
    private static final int MIN_DATA_COUNT = 1;
    private static final int TOLERANCE_PIXELS = 1;
    private static final int MIN_ADJUSTED_NODE_COUNT = 2;
    private static final double DEFAULT_SWATCH_SIZE = 400.0;
    @InlineStringConstant
    private static final String DEFAULT_SHAPE = "square";
    @InlineStringConstant
    private static final String PACKED = "packed";
    @InlineStringConstant
    private static final String GRID = "grid";
    @InlineStringConstant
    private static final String DEFAULT_LABEL_VALIGN = "middle";
    @InlineStringConstant
    private static final String DEFAULT_LABEL_HALIGN = "start";
    @InlineStringConstant
    private static final String FONT_STYLE = "font-style";
    @InlineStringConstant
    private static final String FONT_VARIANT = "font-variant";
    @InlineStringConstant
    private static final String FONT_WEIGHT = "font-weight";
    @InlineStringConstant
    private static final String FONT_SIZE = "font-size";
    @InlineStringConstant
    private static final String LINE_HEIGHT = "line-height";
    @InlineStringConstant
    private static final String FONT_FAMILY = "font-family";
    private static final SetValueFunction<FillNode> _NULL_SETVALUE_FN = new SetValueFunction<FillNode>(){

        public void set(FillNode node) {
        }
    };
    private boolean _wrapLabels = true;
    private int _rows = 0;
    private int _columns = 0;
    private Object _shape;
    private Object _swatchSize;
    private String _layoutMethod = "grid";

    public SwatchLegend() {
        this.minDataLen(1);
        this.shape(DEFAULT_SHAPE);
        this.swatchSize(400.0);
    }

    public Object shape() {
        return this._shape;
    }

    @SwiftMethodOverload(overloads={"String"})
    public SwatchLegend shape(Object shape) {
        this._shape = ObjectConverter.toBoolean((Object)shape) ? shape : DEFAULT_SHAPE;
        return this;
    }

    public Object swatchSize() {
        return this._swatchSize;
    }

    @SwiftMethodOverload(skipOverloads={"Bool"})
    public SwatchLegend swatchSize(Object size) {
        this._swatchSize = size;
        return this;
    }

    public boolean wrapLabels() {
        return this._wrapLabels;
    }

    public SwatchLegend wrapLabels(boolean wrapLabels) {
        this._wrapLabels = wrapLabels;
        return this;
    }

    @SwiftMethodOverload(skipOverloads={"Bool"})
    public SwatchLegend rows(Object rows) {
        this._rows = ObjectConverter.toInt((Object)rows);
        return this;
    }

    public int rows() {
        return this._rows;
    }

    @SwiftMethodOverload(skipOverloads={"Bool"})
    public SwatchLegend columns(Object columns) {
        this._columns = ObjectConverter.toInt((Object)columns);
        return this;
    }

    public int columns() {
        return this._columns;
    }

    public String layoutMethod() {
        return this._layoutMethod;
    }

    public SwatchLegend layoutMethod(String layoutMethod) {
        this._layoutMethod = PACKED.equals(layoutMethod) ? PACKED : GRID;
        return this;
    }

    private ValueFunction<Object, ? extends Number> getSwatchSizeFunction() {
        ValueFunction swatchSizeFn;
        if (this._swatchSize instanceof ValueFunction) {
            swatchSizeFn = (ValueFunction)this._swatchSize;
        } else {
            final Double swatchSize = ObjectConverter.toDouble((Object)this._swatchSize);
            swatchSizeFn = new ValueFunction<Object, Double>(){

                public Double getValue(Object context, Object data, int index, int groupIndex) {
                    return swatchSize;
                }
            };
        }
        return swatchSizeFn;
    }

    private Symbol getShapeSymbol(ValueFunction<Object, ? extends Number> swatchSizeFn) {
        Symbol shapeSymbol = this._shape instanceof Symbol ? ((Symbol)this._shape).size(swatchSizeFn) : Rave.svg.symbol().size(swatchSizeFn).type((String)this._shape);
        return shapeSymbol;
    }

    private LegendEntrySelectors getLegendEntrySelectors(Selector gSelection, List<Object> swatchsData, final Symbol shapeSymbol, Object labelFormat) {
        final SwatchLegend self = this;
        LegendEntrySelectors es = new LegendEntrySelectors();
        if (!self._extraLegendEntries.empty()) {
            List keys = self._extraLegendEntries.keys();
            for (int i = 0; i < keys.size(); ++i) {
                if (swatchsData.contains(keys.get(i))) continue;
                swatchsData.add(keys.get(i));
            }
        }
        es.legendEntry = gSelection.selectAll(".legendEntry").data(swatchsData.toArray()).enter().append("g").attr("class", (Object)"legendEntry");
        es.shape = es.legendEntry.append("path").attr("class", (Object)"legendShape").attr("d", (ValueFunction)new ValueFunction<SceneNode, String>(){

            @SwiftMethodOverload(skipParameters={1})
            public String getValue(SceneNode context, Object data, int index, int groupIndex) {
                ExtraLegendEntry ele = (ExtraLegendEntry)self._extraLegendEntries.get((Object)ObjectConverter.asString((Object)data));
                if (ele != null) {
                    double extraSymbolSize = 0.0;
                    String extraSymbolShape = null;
                    if (ele.sizeSet()) {
                        extraSymbolSize = ele.size();
                    } else {
                        extraSymbolSize = ObjectConverter.asDouble((Object)shapeSymbol.size().getValue((Object)context, data, index, groupIndex));
                        ele.size(extraSymbolSize);
                    }
                    if (ele.shapeSet()) {
                        extraSymbolShape = ele.shape();
                    } else {
                        extraSymbolShape = (String)shapeSymbol.type().getValue((Object)context, data, index, groupIndex);
                        ele.shape(extraSymbolShape);
                    }
                    Symbol extraLegendEntrySymbol = Rave.svg.symbol().size(extraSymbolSize).type(extraSymbolShape);
                    return extraLegendEntrySymbol.getValue((Object)context, data, index, groupIndex);
                }
                return shapeSymbol.getValue((Object)context, data, index, groupIndex);
            }
        }).style("fill", (ValueFunction)new ValueFunction<SceneNode, Object>(){

            @SwiftMethodOverload(skipParameters={1})
            public Object getValue(SceneNode context, Object data, int index, int groupIndex) {
                Object customColor = null;
                ExtraLegendEntry ele = (ExtraLegendEntry)self._extraLegendEntries.get((Object)ObjectConverter.asString((Object)data));
                customColor = self.scale().getValue((Object)context, data, index, groupIndex);
                if (ele != null) {
                    if (ele.colorSet()) {
                        return ((ExtraLegendEntry)self._extraLegendEntries.get((Object)ObjectConverter.asString((Object)data))).color();
                    }
                    ele.color(ObjectConverter.asString((Object)customColor));
                }
                return customColor;
            }
        });
        es.text = es.legendEntry.append("text").attr("class", (Object)"legendLabel");
        if (labelFormat instanceof ValueFunction) {
            es.text.text((ValueFunction)labelFormat);
        } else {
            es.text.text(labelFormat);
        }
        if (ObjectConverter.toBoolean((Object)this.shapeBorderColor())) {
            es.shape.attr("stroke", (Object)Rave.rgb((Object)this.shapeBorderColor()).toString());
        }
        return es;
    }

    private LegendEntryBBoxes getLegendEntryBBoxes(LegendEntrySelectors es) {
        final LegendEntryBBoxes eb = new LegendEntryBBoxes();
        es.text.each((CallbackFunction)new CallbackFunction<SceneNode>(){

            public void run(SceneNode context, Object data, int index, int groupIndex) {
                RaveRect labelBbox = context.getBBox();
                eb.labelBboxes.add((Object)labelBbox);
                eb.labelTexts.add((Object)context.getText());
            }
        });
        es.shape.each((CallbackFunction)new CallbackFunction<SceneNode>(){

            public void run(SceneNode context, Object data, int index, int groupIndex) {
                eb.shapeBboxes.add((Object)context.getBBox());
            }
        });
        return eb;
    }

    private FillLayout<FillNode> createLayout(boolean isHorizontal, double availableWidth, double availableHeight) {
        FillLayout layout = (FillLayout)Rave.layout.extension("fill");
        layout.cellSize(_NULL_SETVALUE_FN).direction(isHorizontal ? "row" : "column").size(new double[]{availableWidth, availableHeight}).method(this._layoutMethod).valign(DEFAULT_LABEL_HALIGN).halign(DEFAULT_LABEL_HALIGN);
        if (PACKED.equals(this._layoutMethod)) {
            if (isHorizontal) {
                layout.rows((Object)1);
            } else {
                layout.columns((Object)1);
            }
        } else {
            if (this._rows > 0) {
                layout.rows((Object)this._rows);
            }
            if (this._columns > 0) {
                layout.columns((Object)this._columns);
            }
        }
        return layout;
    }

    private ArrayEx<FillNode> buildFillNodes(double swatchPadding, LegendEntryBBoxes eb) {
        Insets entryInsets = this.entryInsets();
        ArrayEx nodes = new ArrayEx();
        for (int i = 0; i < eb.shapeBboxes.size(); ++i) {
            FillNode fillNode = new FillNode();
            RaveRect shapeBbox = (RaveRect)eb.shapeBboxes.get(i);
            RaveRect labelBbox = (RaveRect)eb.labelBboxes.get(i);
            fillNode.height = Math.max(shapeBbox.height, labelBbox.height) + (double)(entryInsets.top + entryInsets.bottom);
            fillNode.width = shapeBbox.width + labelBbox.width + (double)entryInsets.left.intValue() + (double)entryInsets.right.intValue() + swatchPadding;
            fillNode.data = i;
            nodes.add((Object)fillNode);
        }
        return nodes;
    }

    private ArrayEx<GridDescr> buildGridDescrs(boolean isHorizontal, LegendEntryBBoxes eb, double swatchPadding, double availableWidth, double availableHeight) {
        Insets entryInsets = this.entryInsets();
        int numEntries = eb.shapeBboxes.size();
        ArrayEx fillNodes = new ArrayEx();
        for (int i = 0; i < numEntries; ++i) {
            FillNode fillNode = new FillNode();
            RaveRect shapeBbox = (RaveRect)eb.shapeBboxes.get(i);
            fillNode.height = entryInsets.top + entryInsets.bottom;
            fillNode.width = shapeBbox.width + (double)entryInsets.left.intValue() + (double)entryInsets.right.intValue() + swatchPadding;
            fillNode.data = i;
            fillNodes.add((Object)fillNode);
        }
        int maxRows = numEntries;
        int maxColumns = numEntries;
        boolean packed = PACKED.equals(this._layoutMethod);
        if (packed) {
            if (isHorizontal) {
                maxRows = 1;
            } else {
                maxColumns = 1;
            }
        } else {
            if (this._rows > 0) {
                maxRows = this._rows;
            }
            if (this._columns > 0) {
                maxColumns = this._columns;
            }
        }
        if (isHorizontal) {
            if (maxColumns > 1) {
                int calculatedMaxCol = maxColumns;
                double totWidth = 0.0;
                double firstLabelBboxHeight = ((RaveRect)eb.labelBboxes.get((int)0)).height;
                for (int i = 0; i < numEntries; ++i) {
                    FillNode fillNode = (FillNode)fillNodes.get(i);
                    if (!(availableWidth < (totWidth += fillNode.width + firstLabelBboxHeight))) continue;
                    calculatedMaxCol = i;
                    break;
                }
                maxColumns = Math.min(maxColumns, calculatedMaxCol);
            }
        } else if (maxRows > 1) {
            int calculatedMaxRow = maxRows;
            double totHeight = 0.0;
            for (int i = 0; i < numEntries; ++i) {
                FillNode fillNode = (FillNode)fillNodes.get(i);
                RaveRect shapeBbox = (RaveRect)eb.shapeBboxes.get(i);
                RaveRect labelBbox = (RaveRect)eb.labelBboxes.get(i);
                if (!(availableHeight < (totHeight += fillNode.height + Math.max(labelBbox.height, shapeBbox.height)))) continue;
                calculatedMaxRow = i;
                break;
            }
            maxRows = Math.min(maxRows, calculatedMaxRow);
        }
        int maxNumNodes = Math.min(numEntries, maxRows * maxColumns);
        int maxIteration = isHorizontal ? maxColumns : maxRows;
        ArrayEx gridDescrs = new ArrayEx();
        int lastSeenNumColumns = -1;
        int lastSeenNumRows = -1;
        int largestSeenFailureIndex = 0;
        for (int i = maxIteration; i > 0; --i) {
            int numRows;
            int numColumns;
            if (isHorizontal) {
                numColumns = i;
                numRows = (int)Math.ceil((double)maxNumNodes / (double)numColumns);
            } else {
                numRows = i;
                numColumns = (int)Math.ceil((double)maxNumNodes / (double)numRows);
            }
            if (numColumns > maxColumns || numRows > maxRows) continue;
            numColumns = this.getMaxColumn(isHorizontal, maxNumNodes, numColumns, numRows);
            numRows = this.getMaxRow(isHorizontal, maxNumNodes, numColumns, numRows);
            if (numColumns == lastSeenNumColumns && numRows == lastSeenNumRows) continue;
            ColumnRowLists crl = this.buildColumnRowLists(isHorizontal, numColumns, numRows, (ArrayEx<FillNode>)fillNodes, maxNumNodes, eb);
            lastSeenNumColumns = numColumns;
            lastSeenNumRows = numRows;
            double cellHeight = availableHeight / (double)numRows;
            double cellWidth = availableWidth / (double)numColumns;
            GridDescr gridDescr = this.createGridDescr(numColumns, numRows, cellHeight, cellWidth, eb, (ArrayEx<FillNode>)fillNodes, maxNumNodes, crl.columnListShapes, crl.rowListShapes);
            if (packed) {
                gridDescrs.add((Object)gridDescr);
                continue;
            }
            if (maxNumNodes > largestSeenFailureIndex) {
                if (gridDescr.firstFailureIndex > largestSeenFailureIndex) {
                    largestSeenFailureIndex = gridDescr.firstFailureIndex;
                }
                if (gridDescr.firstFailureIndex < maxNumNodes) {
                    int rowIndex = this.determineRow(isHorizontal, gridDescr.firstFailureIndex, gridDescr.numColumns, gridDescr.numRows);
                    int colIndex = this.determineColumn(isHorizontal, gridDescr.firstFailureIndex, gridDescr.numColumns, gridDescr.numRows);
                    Integer columnListIndex = (Integer)crl.columnListShapes.get(colIndex);
                    RaveRect labelBbox = (RaveRect)eb.labelBboxes.get(columnListIndex.intValue());
                    FillNode colFillNode = (FillNode)fillNodes.get(columnListIndex.intValue());
                    double minCellWidth = colFillNode.width + labelBbox.height;
                    Integer rowListIndex = (Integer)crl.rowListShapes.get(rowIndex);
                    labelBbox = (RaveRect)eb.labelBboxes.get(rowListIndex.intValue());
                    RaveRect shapeBbox = (RaveRect)eb.shapeBboxes.get(rowListIndex.intValue());
                    FillNode rowFillNode = (FillNode)fillNodes.get(rowListIndex.intValue());
                    double minCellHeight = rowFillNode.height + Math.max(labelBbox.height, shapeBbox.height);
                    GridDescr gridDescr2 = this.adjustFailedGridDescr(gridDescr, (ArrayEx<FillNode>)fillNodes, maxNumNodes, isHorizontal, eb, availableWidth, availableHeight, minCellWidth, minCellHeight, largestSeenFailureIndex);
                    if (gridDescr2 != null) {
                        gridDescr = gridDescr2;
                        if (gridDescr.firstFailureIndex > largestSeenFailureIndex) {
                            largestSeenFailureIndex = gridDescr.firstFailureIndex;
                        }
                    }
                }
                if (gridDescr.firstFailureIndex <= 0 || gridDescr.firstFailureIndex < largestSeenFailureIndex) continue;
                gridDescrs.add((Object)gridDescr);
                continue;
            }
            if (maxNumNodes != gridDescr.firstFailureIndex) continue;
            gridDescrs.add((Object)gridDescr);
        }
        return gridDescrs;
    }

    private int getMaxColumn(boolean isHorizontal, int numNodes, int numCols, int numRows) {
        if (isHorizontal) {
            if (numNodes >= numCols) {
                return numCols;
            }
            return numNodes;
        }
        return (int)Math.ceil((double)numNodes / (double)numRows);
    }

    private int getMaxRow(boolean isHorizontal, int numNodes, int numCols, int numRows) {
        if (isHorizontal) {
            return (int)Math.ceil((double)numNodes / (double)numCols);
        }
        if (numNodes >= numRows) {
            return numRows;
        }
        return numNodes;
    }

    private GridDescr adjustFailedGridDescr(GridDescr gridDescr, ArrayEx<FillNode> fillNodes, int numNodes, boolean isHorizontal, LegendEntryBBoxes eb, double availableWidth, double availableHeight, double minCellWidth, double minCellHeight, int largestSeenFailureIndex) {
        double minIncrease;
        double lastSeenlength;
        double availableLength;
        int numRowCol;
        boolean increaseHeight;
        ArrayEx<FillNode> _fillNodes = fillNodes;
        GridDescr bestGridDescr = null;
        double lastSeenCellWidth = gridDescr.cellWidth;
        double lastSeenCellHeight = gridDescr.cellHeight;
        boolean increaseWidth = lastSeenCellWidth < minCellWidth;
        boolean bl = increaseHeight = lastSeenCellHeight < minCellHeight;
        if (increaseWidth && increaseHeight) {
            return null;
        }
        int minNodeCount = Math.max(2, largestSeenFailureIndex);
        int _numNodes = numNodes;
        if (isHorizontal) {
            if (increaseHeight) {
                numRowCol = gridDescr.numColumns;
                availableLength = availableHeight;
                lastSeenlength = lastSeenCellHeight;
                minIncrease = Math.max(1.0, minCellHeight - lastSeenCellHeight);
            } else {
                numRowCol = 1;
                availableLength = availableWidth;
                lastSeenlength = lastSeenCellWidth;
                minIncrease = Math.max(1.0, minCellWidth - lastSeenCellWidth);
            }
        } else if (increaseWidth) {
            numRowCol = gridDescr.numRows;
            availableLength = availableWidth;
            lastSeenlength = lastSeenCellWidth;
            minIncrease = Math.max(1.0, minCellWidth - lastSeenCellWidth);
        } else {
            numRowCol = 1;
            availableLength = availableHeight;
            lastSeenlength = lastSeenCellHeight;
            minIncrease = Math.max(1.0, minCellHeight - lastSeenCellHeight);
        }
        _numNodes = (int)Math.floor(availableLength / (lastSeenlength + minIncrease)) * numRowCol;
        minIncrease = 1.0;
        while (_numNodes >= minNodeCount) {
            int numColumns = this.getMaxColumn(isHorizontal, _numNodes, gridDescr.numColumns, gridDescr.numRows);
            int numRows = this.getMaxRow(isHorizontal, _numNodes, gridDescr.numColumns, gridDescr.numRows);
            if (!(numRows == gridDescr.numRows && numColumns == gridDescr.numColumns || bestGridDescr != null && numRows == bestGridDescr.numRows && numColumns == bestGridDescr.numColumns)) {
                double cellHeight = availableHeight / (double)numRows;
                double cellWidth = availableWidth / (double)numColumns;
                if (cellHeight - lastSeenCellHeight >= minIncrease || cellWidth - lastSeenCellWidth >= minIncrease) {
                    lastSeenCellHeight = cellHeight;
                    lastSeenCellWidth = cellWidth;
                    double d = lastSeenlength = increaseHeight ? lastSeenCellHeight : lastSeenCellWidth;
                    if (cellHeight >= minCellHeight && cellWidth >= minCellWidth) {
                        ColumnRowLists crl = this.buildColumnRowLists(isHorizontal, gridDescr.numColumns, gridDescr.numRows, _fillNodes, _numNodes, eb);
                        GridDescr gridDescr2 = this.createGridDescr(gridDescr.numColumns, gridDescr.numRows, cellHeight, cellWidth, eb, _fillNodes, _numNodes, crl.columnListShapes, crl.rowListShapes);
                        if (gridDescr2.firstFailureIndex >= largestSeenFailureIndex && (bestGridDescr == null || bestGridDescr.firstFailureIndex < gridDescr2.firstFailureIndex)) {
                            int j;
                            bestGridDescr = gridDescr2;
                            for (j = crl.rowListShapes.size(); j < gridDescr.numRows; ++j) {
                                bestGridDescr.heightAvailableForTextPerRow.add((Object)4.0);
                            }
                            for (j = crl.columnListShapes.size(); j < gridDescr.numColumns; ++j) {
                                bestGridDescr.widthAvailableForTextPerColumn.add((Object)4.0);
                            }
                            if (bestGridDescr.firstFailureIndex == _numNodes) {
                                return bestGridDescr;
                            }
                            if (bestGridDescr.firstFailureIndex > minNodeCount) {
                                minNodeCount = bestGridDescr.firstFailureIndex;
                            }
                        }
                    }
                }
            }
            _numNodes = (int)Math.floor(availableLength / (lastSeenlength + minIncrease)) * numRowCol;
        }
        return bestGridDescr;
    }

    private GridDescr createGridDescr(int numColumns, int numRows, double cellHeight, double cellWidth, LegendEntryBBoxes eb, ArrayEx<FillNode> fillNodes, int nodeCount, ArrayEx<Integer> columnListShapes, ArrayEx<Integer> rowListShapes) {
        ArrayEx widthAvailableForTextPerColumn = new ArrayEx();
        ArrayEx heightAvailableForTextPerRow = new ArrayEx();
        int firstFailureIndex = nodeCount;
        for (int j = 0; j < columnListShapes.size(); ++j) {
            Integer columnListIndex = (Integer)columnListShapes.get(j);
            RaveRect labelBbox = (RaveRect)eb.labelBboxes.get(columnListIndex.intValue());
            FillNode colFillNode = (FillNode)fillNodes.get(columnListIndex.intValue());
            double widthAvailableForText = cellWidth - colFillNode.width;
            if (widthAvailableForText < labelBbox.height && columnListIndex < firstFailureIndex) {
                firstFailureIndex = columnListIndex;
            }
            widthAvailableForTextPerColumn.add((Object)(widthAvailableForText > 4.0 ? widthAvailableForText : 4.0));
        }
        for (int k = 0; k < rowListShapes.size(); ++k) {
            Integer rowListIndex = (Integer)rowListShapes.get(k);
            RaveRect shapeBbox = (RaveRect)eb.shapeBboxes.get(rowListIndex.intValue());
            RaveRect labelBbox = (RaveRect)eb.labelBboxes.get(rowListIndex.intValue());
            FillNode rowFillNode = (FillNode)fillNodes.get(rowListIndex.intValue());
            double heightAvailableForText = cellHeight - rowFillNode.height;
            if (heightAvailableForText < Math.max(labelBbox.height, shapeBbox.height) && rowListIndex < firstFailureIndex) {
                firstFailureIndex = rowListIndex;
            }
            heightAvailableForTextPerRow.add((Object)(heightAvailableForText > 4.0 ? heightAvailableForText : 4.0));
        }
        return new GridDescr(numColumns, numRows, columnListShapes.size(), rowListShapes.size(), firstFailureIndex, cellWidth, cellHeight, (ArrayEx<Double>)widthAvailableForTextPerColumn, (ArrayEx<Double>)heightAvailableForTextPerRow);
    }

    private TextResult applyTextWrapping(final boolean isHorizontal, final TextFlow textFlow, final LegendEntryBBoxes eb, LegendEntrySelectors es, double swatchPadding, double availableWidth, double availableHeight) {
        ArrayEx<GridDescr> gridDescrs = this.buildGridDescrs(isHorizontal, eb, swatchPadding, availableWidth, availableHeight);
        if (gridDescrs.size() > 0) {
            TextResult textResult;
            if (gridDescrs.size() > 1) {
                gridDescrs.sort((Comparator)new Comparator<GridDescr>(){

                    public int compare(GridDescr obj1, GridDescr obj2) {
                        int result = obj2.firstFailureIndex - obj1.firstFailureIndex;
                        if (result == 0) {
                            if (isHorizontal) {
                                return obj2.numColumnsUsed - obj1.numColumnsUsed;
                            }
                            return obj2.numRowsUsed - obj1.numRowsUsed;
                        }
                        return result;
                    }
                });
            }
            TextOperation text_operation = TextOperation.getOperation((byte)(this._wrapLabels ? (byte)1 : 0), (String)this.labelTruncationText());
            text_operation.font(SwatchLegend.createFontStruct((OMap<String, String>)es.text.node().getComputedStyles()));
            text_operation.em(1.0);
            TextResult bestFailedResult = null;
            TextResult bestSuccessResult = null;
            int numEntries = eb.shapeBboxes.size();
            for (int i = 0; i < gridDescrs.size(); ++i) {
                int j;
                boolean success = true;
                int noTruncation = 0;
                GridDescr gridDescr = (GridDescr)gridDescrs.get(i);
                if (bestFailedResult != null && (gridDescr.firstFailureIndex < bestFailedResult.gridDescr.firstFailureIndex || gridDescr.cellHeight == bestFailedResult.gridDescr.cellHeight && gridDescr.cellWidth == bestFailedResult.gridDescr.cellWidth)) continue;
                for (j = 0; j < gridDescr.firstFailureIndex; ++j) {
                    double height;
                    RaveRect labelBbox = (RaveRect)eb.labelBboxes.get(j);
                    int rowIndex = this.determineRow(isHorizontal, j, gridDescr.numColumns, gridDescr.numRows);
                    int colIndex = this.determineColumn(isHorizontal, j, gridDescr.numColumns, gridDescr.numRows);
                    double width = colIndex < gridDescr.widthAvailableForTextPerColumn.size() ? (Double)gridDescr.widthAvailableForTextPerColumn.get(colIndex) : 4.0;
                    double d = height = rowIndex < gridDescr.heightAvailableForTextPerRow.size() ? (Double)gridDescr.heightAvailableForTextPerRow.get(rowIndex) : 4.0;
                    if (width < labelBbox.height || height < labelBbox.height) {
                        success = false;
                        break;
                    }
                    text_operation.size(width, height);
                    text_operation.fontSize(labelBbox.height);
                    String text = (String)eb.labelTexts.get(j);
                    if (text.isEmpty()) {
                        ++noTruncation;
                        break;
                    }
                    text_operation.text(text);
                    TextData result = text_operation.run();
                    if (result.lines.size() == 0 || result.clipped || result.tooTall || result.truncated) {
                        success = false;
                        if (result.lines.size() != 0) continue;
                        break;
                    }
                    ++noTruncation;
                }
                if (success && gridDescr.firstFailureIndex == numEntries) {
                    bestSuccessResult = new TextResult(numEntries, noTruncation, gridDescr);
                    break;
                }
                if (bestFailedResult != null && gridDescr.firstFailureIndex <= bestFailedResult.gridDescr.firstFailureIndex && (gridDescr.firstFailureIndex != bestFailedResult.gridDescr.firstFailureIndex || j <= bestFailedResult.entriesCount) && (gridDescr.firstFailureIndex != bestFailedResult.gridDescr.firstFailureIndex || j != bestFailedResult.entriesCount || noTruncation <= bestFailedResult.noTruncation)) continue;
                bestFailedResult = new TextResult(j, noTruncation, gridDescr);
            }
            TextResult textResult2 = textResult = bestSuccessResult != null ? bestSuccessResult : bestFailedResult;
            if (textResult != null) {
                textFlow.wrap(this._wrapLabels);
                if (textResult.entriesCount > 0) {
                    final SwatchLegend self = this;
                    es.text.each((CallbackFunction)new CallbackFunction<SceneNode>(){

                        public void run(SceneNode context, Object data, int index, int groupIndex) {
                            if (index < textResult.entriesCount) {
                                int rowIndex = self.determineRow(isHorizontal, index, textResult.gridDescr.numColumns, textResult.gridDescr.numRows);
                                int colIndex = self.determineColumn(isHorizontal, index, textResult.gridDescr.numColumns, textResult.gridDescr.numRows);
                                double width = colIndex < textResult.gridDescr.widthAvailableForTextPerColumn.size() ? (Double)textResult.gridDescr.widthAvailableForTextPerColumn.get(colIndex) : 4.0;
                                double height = rowIndex < textResult.gridDescr.heightAvailableForTextPerRow.size() ? (Double)textResult.gridDescr.heightAvailableForTextPerRow.get(rowIndex) : 4.0;
                                textFlow.extent((int)width, (int)height);
                                textFlow.flow(Rave.select((SceneNode)context));
                                String text = context.getText();
                                RaveRect labelBbox = context.getBBox();
                                eb.labelBboxes.set(index, (Object)labelBbox);
                                eb.labelTexts.set(index, (Object)text);
                            }
                        }
                    });
                }
            }
            return textResult;
        }
        return null;
    }

    private LayoutResults layoutLegendEntries(boolean isHorizontal, TextFlow textFlow, LegendEntryBBoxes eb, LegendEntrySelectors es, double swatchPadding, double availableWidth, double availableHeight) {
        ArrayEx elements;
        TextResult textResult = this.applyTextWrapping(isHorizontal, textFlow, eb, es, swatchPadding, availableWidth, availableHeight);
        LayoutResults lr = new LayoutResults();
        lr.textResult = textResult;
        lr.layout = this.createLayout(isHorizontal, availableWidth, availableHeight);
        lr.nodes = this.buildFillNodes(swatchPadding, eb);
        int firstFailureIndex = lr.nodes.size();
        double entrySpaceUsed = 0.0;
        if (textResult != null && !PACKED.equals(this._layoutMethod)) {
            Insets entryInsets = this.entryInsets();
            boolean isVertical = this.orient().equals("vertical");
            int entriesCount = textResult.entriesCount;
            firstFailureIndex = textResult.gridDescr.firstFailureIndex;
            double largestWidth = -1.0;
            double largestHeight = -1.0;
            for (int i = 0; i < entriesCount; ++i) {
                FillNode node = (FillNode)lr.nodes.get(i);
                if (node.width > largestWidth) {
                    largestWidth = node.width;
                    if (isVertical) {
                        entrySpaceUsed = largestWidth;
                    }
                }
                if (!(node.height > largestHeight)) continue;
                largestHeight = node.height;
                if (isVertical) continue;
                entrySpaceUsed = largestHeight;
            }
            if (isVertical) {
                entrySpaceUsed *= (double)lr.textResult.gridDescr.numColumnsUsed;
                if ((entrySpaceUsed += (double)(entryInsets.left + entryInsets.right)) > this._spaceUsed) {
                    this._spaceUsed = entrySpaceUsed;
                }
            } else {
                entrySpaceUsed *= (double)lr.textResult.gridDescr.numRowsUsed;
                this._spaceUsed += (entrySpaceUsed += (double)(entryInsets.top + entryInsets.bottom));
            }
            if (textResult.entriesCount == lr.nodes.length() && firstFailureIndex == lr.nodes.length() && textResult.gridDescr.cellHeight >= largestHeight && textResult.gridDescr.cellWidth >= largestWidth) {
                lr.layout.rows((Object)lr.textResult.gridDescr.numRowsUsed);
                lr.layout.columns((Object)lr.textResult.gridDescr.numColumnsUsed);
            }
        }
        lr.elements = lr.layout.layout(lr.nodes);
        lr.numCols = lr.layout.numberOfHorizontalCells();
        lr.numRows = lr.layout.numberOfVerticalCells();
        if (firstFailureIndex != lr.nodes.size() && lr.elements.size() < firstFailureIndex && !PACKED.equals(this._layoutMethod) && (elements = lr.layout.layout(lr.nodes.slice(0, firstFailureIndex))).size() > lr.elements.size()) {
            lr.elements = elements;
            lr.numCols = lr.layout.numberOfHorizontalCells();
            lr.numRows = lr.layout.numberOfVerticalCells();
        }
        lr.crl = this.buildColumnRowLists(isHorizontal, lr.numCols, lr.numRows, lr.elements, lr.elements.size(), eb);
        return lr;
    }

    private ColumnRowLists buildColumnRowLists(boolean isHorizontal, int numCols, int numRows, ArrayEx<FillNode> fillNodes, int nodeCount, LegendEntryBBoxes eb) {
        ColumnRowLists crl = new ColumnRowLists();
        for (int i = 0; i < nodeCount; ++i) {
            FillNode node = (FillNode)fillNodes.get(i);
            Integer currentNodeIndex = (Integer)node.data;
            int currentColumnNumber = this.determineColumn(isHorizontal, currentNodeIndex, numCols, numRows);
            if (currentColumnNumber < crl.columnListShapes.size()) {
                Integer curColIndex = (Integer)crl.columnListShapes.get(currentColumnNumber);
                RaveRect currentShape = (RaveRect)eb.shapeBboxes.get(currentNodeIndex.intValue());
                RaveRect curColShape = (RaveRect)eb.shapeBboxes.get(curColIndex.intValue());
                if (currentShape.width > curColShape.width) {
                    crl.columnListShapes.set(currentColumnNumber, (Object)currentNodeIndex);
                }
            } else {
                crl.columnListShapes.set(currentColumnNumber, (Object)currentNodeIndex);
            }
            int currentRowNumber = this.determineRow(isHorizontal, currentNodeIndex, numCols, numRows);
            if (currentRowNumber < crl.rowListShapes.size()) {
                Integer curRowIndex = (Integer)crl.rowListShapes.get(currentRowNumber);
                RaveRect currentShape = (RaveRect)eb.shapeBboxes.get(currentNodeIndex.intValue());
                RaveRect curRowShape = (RaveRect)eb.shapeBboxes.get(curRowIndex.intValue());
                if (!(currentShape.height > curRowShape.height)) continue;
                crl.rowListShapes.set(currentRowNumber, (Object)currentNodeIndex);
                continue;
            }
            crl.rowListShapes.set(currentRowNumber, (Object)currentNodeIndex);
        }
        return crl;
    }

    private boolean handleFailedLayout(boolean isHorizontal, Selector gSelection, LayoutResults lr, LegendEntrySelectors es, LegendEntryBBoxes eb, List<Object> swatchsData, double availableWidth, double availableHeight, double titleVerticalShift, TextFlow textFlow) {
        FillNode removedFillNode = null;
        if (lr.elements.size() > 0) {
            removedFillNode = (FillNode)lr.elements.pop();
        }
        if (lr.elements.size() == 0 || removedFillNode == null) {
            gSelection.selectAll(".legendEntry").remove();
            this.addTruncationIndicator(gSelection, titleVerticalShift, availableWidth, availableHeight, textFlow);
            return false;
        }
        Object[] newSwatchsData = new Object[lr.elements.size()];
        for (int i = 0; i < lr.elements.size(); ++i) {
            newSwatchsData[i] = swatchsData.get(i);
        }
        es.legendEntry = gSelection.selectAll(".legendEntry").data(newSwatchsData);
        es.legendEntry.exit().remove();
        es.shape = es.legendEntry.select((Object)"path");
        es.text = es.legendEntry.select((Object)"text");
        lr.crl = this.buildColumnRowLists(isHorizontal, lr.numCols, lr.numRows, lr.elements, lr.elements.size(), eb);
        lr.numCols = lr.crl.columnListShapes.size();
        lr.numRows = lr.crl.rowListShapes.size();
        Selector truncationSelector = gSelection.append("g").attr("class", (Object)"legendTruncationEntry");
        int removedFillNodeIndex = lr.elements.size();
        int rowVal = this.determineRow(isHorizontal, removedFillNodeIndex, lr.numCols, lr.numRows);
        double width = availableWidth - removedFillNode.x;
        double height = availableHeight - removedFillNode.y;
        double midHorizontalPoint = removedFillNode.x + (double)this.entryInsets().left.intValue() + (double)this.insets().left.intValue() + width / 2.0;
        double yShift = rowVal == 0 || rowVal == lr.numRows - 1 ? removedFillNode.height - (double)this.entryInsets().bottom.intValue() : removedFillNode.height - (double)this.entryInsets().bottom.intValue() - (double)this.entryInsets().top.intValue();
        this.addTruncationIndicator(truncationSelector, midHorizontalPoint, removedFillNode.y + titleVerticalShift - (double)this.insets().bottom.intValue() + yShift / 2.0, width, height, textFlow, true);
        return true;
    }

    private void alignLabelsShapes(final boolean isHorizontal, final LegendEntryBBoxes eb, LegendEntrySelectors es, final LayoutResults lr, final double swatchPadding) {
        final SwatchLegend self = this;
        es.shape.attr("transform", (ValueFunction)new ValueFunction<SceneNode, String>(){

            public String getValue(SceneNode context, Object data, int index, int groupIndex) {
                int val = self.determineColumn(isHorizontal, index, lr.numCols, lr.numRows);
                RaveRect shapeBbox = (RaveRect)eb.shapeBboxes.get(((Integer)lr.crl.columnListShapes.get(val)).intValue());
                return "translate(" + shapeBbox.width / 2.0 + ",0)";
            }
        });
        es.text.each((CallbackFunction)new CallbackFunction<SceneNode>(){

            public void run(SceneNode context, Object data, int index, int groupIndex) {
                Selector textSelection = Rave.select((SceneNode)context);
                int val = self.determineColumn(isHorizontal, index, lr.numCols, lr.numRows);
                RaveRect shapeBbox = (RaveRect)eb.shapeBboxes.get(((Integer)lr.crl.columnListShapes.get(val)).intValue());
                double x = swatchPadding + shapeBbox.width;
                textSelection.attr("x", (Object)x).attr("text-anchor", (Object)SwatchLegend.DEFAULT_LABEL_HALIGN).attr("dy", (Object)self.getTextDyPlacement(context));
                textSelection.selectAll("tspan").attr("x", (Object)x).attr("width", null);
                textSelection.select((Object)"tspan").attr("x", null).attr("dy", null);
            }
        });
    }

    private ArrayEx<Integer> buildRowListFillNodes(boolean isHorizontal, int numCols, int numRows, ArrayEx<FillNode> fillNodes) {
        ArrayEx rowListFillNodes = new ArrayEx();
        for (int i = 0; i < fillNodes.size(); ++i) {
            FillNode node = (FillNode)fillNodes.get(i);
            Integer currentNodeIndex = (Integer)node.data;
            int currentRowNumber = this.determineRow(isHorizontal, currentNodeIndex, numCols, numRows);
            if (currentRowNumber < rowListFillNodes.size()) {
                Integer curRowIndex = (Integer)rowListFillNodes.get(currentRowNumber);
                FillNode curRowNode = (FillNode)fillNodes.get(curRowIndex.intValue());
                if (!(node.height > curRowNode.height)) continue;
                rowListFillNodes.set(currentRowNumber, (Object)currentNodeIndex);
                continue;
            }
            rowListFillNodes.set(currentRowNumber, (Object)currentNodeIndex);
        }
        return rowListFillNodes;
    }

    private void transformShapes(final boolean isHorizontal, LegendEntrySelectors es, final LayoutResults lr, final double titleVerticalShift) {
        final SwatchLegend self = this;
        final Insets entryInsets = this.entryInsets();
        final Insets legendInsets = this.insets();
        final ArrayEx<Integer> rowListFillNodes = this.buildRowListFillNodes(isHorizontal, lr.numCols, lr.numRows, lr.elements);
        es.legendEntry.attr("transform", (ValueFunction)new ValueFunction<SceneNode, String>(){

            public String getValue(SceneNode context, Object data, int index, int groupIndex) {
                FillNode fillNode = (FillNode)lr.elements.get(index);
                int val = self.determineRow(isHorizontal, index, lr.numCols, lr.numRows);
                double nodeHeight = ((FillNode)lr.elements.get((int)((Integer)rowListFillNodes.get((int)val)).intValue())).height;
                double height = nodeHeight - (double)entryInsets.bottom.intValue() - (double)entryInsets.top.intValue();
                double x = fillNode.x + (double)entryInsets.left.intValue() + (double)legendInsets.left.intValue();
                double y = fillNode.y + (double)entryInsets.top.intValue() + titleVerticalShift - (double)legendInsets.bottom.intValue() + height / 2.0;
                return "translate(" + x + "," + y + ")";
            }
        });
    }

    private static FontStyleStruct createFontStruct(OMap<String, String> style) {
        FontStyleStruct struct = new FontStyleStruct();
        struct.fontStyle = (String)style.get((Object)FONT_STYLE);
        struct.fontVariant = (String)style.get((Object)FONT_VARIANT);
        struct.fontWeight = (String)style.get((Object)FONT_WEIGHT);
        struct.fontSize = (String)style.get((Object)FONT_SIZE);
        struct.lineHeight = (String)style.get((Object)LINE_HEIGHT);
        struct.fontFamily = (String)style.get((Object)FONT_FAMILY);
        return struct;
    }

    private void verifyResults(boolean isHorizontal, LegendEntryBBoxes eb, LayoutResults lr, double availableWidth, double availableHeight) {
        ArrayEx columnNodesHorizontalExtent = new ArrayEx();
        for (int row = 0; row < lr.numRows; ++row) {
            ArrayEx column = new ArrayEx();
            columnNodesHorizontalExtent.add((Object)column);
        }
        int firstFailure = -1;
        for (int i = 0; i < lr.elements.size(); ++i) {
            double precedingNodeExtent;
            FillNode fillNode = (FillNode)lr.elements.get(i);
            if ((Integer)fillNode.data != i) {
                firstFailure = i;
                break;
            }
            if (fillNode.x + fillNode.width - availableWidth > 1.0) {
                firstFailure = i;
                break;
            }
            if (fillNode.y + fillNode.height - availableHeight > 1.0) {
                firstFailure = i;
                break;
            }
            int colIndex = this.determineColumn(isHorizontal, i, lr.numCols, lr.numRows);
            int columnListIndex = (Integer)lr.crl.columnListShapes.get(colIndex);
            RaveRect currentShapeBbox = (RaveRect)eb.shapeBboxes.get(i);
            RaveRect shapeBbox = (RaveRect)eb.shapeBboxes.get(columnListIndex);
            double width = fillNode.width - currentShapeBbox.width + shapeBbox.width;
            double horizontalExtent = fillNode.x + width;
            if (horizontalExtent - availableWidth > 1.0) {
                firstFailure = i;
                break;
            }
            int rowIndex = this.determineRow(isHorizontal, i, lr.numCols, lr.numRows);
            ArrayEx columnsPerRow = (ArrayEx)columnNodesHorizontalExtent.get(rowIndex);
            columnsPerRow.add((Object)horizontalExtent);
            if (colIndex <= 0 || !((precedingNodeExtent = ((Double)columnsPerRow.get(colIndex - 1)).doubleValue()) - fillNode.x > 1.0)) continue;
            firstFailure = i;
            break;
        }
        if (firstFailure != -1) {
            lr.elements = lr.elements.slice(0, firstFailure);
            lr.crl = this.buildColumnRowLists(isHorizontal, lr.numCols, lr.numRows, lr.elements, lr.elements.size(), eb);
            lr.numCols = lr.crl.columnListShapes.size();
            lr.numRows = lr.crl.rowListShapes.size();
        }
    }

    private void alignSwatchLegendTitleHorizontally(boolean isHorizontal, Selector titleSelector, LegendEntryBBoxes eb, LayoutResults lr) {
        if (titleSelector != null) {
            double legendProperWidth = 0.0;
            int lastColIndex = lr.numCols - 1;
            int columnListIndex = (Integer)lr.crl.columnListShapes.get(lastColIndex);
            RaveRect shapeBbox = (RaveRect)eb.shapeBboxes.get(columnListIndex);
            for (int i = 0; i < lr.elements.size(); ++i) {
                int colIndex = this.determineColumn(isHorizontal, i, lr.numCols, lr.numRows);
                if (colIndex != lastColIndex) continue;
                FillNode fillNode = (FillNode)lr.elements.get(i);
                RaveRect currentShapeBbox = (RaveRect)eb.shapeBboxes.get(i);
                double fillNodeWidth = fillNode.width - currentShapeBbox.width + shapeBbox.width;
                double horizontalExtent = fillNode.x + fillNodeWidth;
                if (!(horizontalExtent > legendProperWidth)) continue;
                legendProperWidth = horizontalExtent;
            }
            if (legendProperWidth > 0.0) {
                RaveRect titleBbox = titleSelector.node().getBBox();
                double w = Math.max(titleBbox.width, legendProperWidth);
                this.alignTitleHorizontally(titleSelector, w);
            } else {
                this.alignTitleHorizontally(titleSelector);
            }
        }
    }

    private int determineColumn(boolean isHorizontal, int index, int numCols, int numRows) {
        if (isHorizontal) {
            return index % numCols;
        }
        return ObjectConverter.toInt((Object)(index / numRows));
    }

    private int determineRow(boolean isHorizontal, int index, int numCols, int numRows) {
        if (isHorizontal) {
            return ObjectConverter.toInt((Object)(index / numCols));
        }
        return index % numRows;
    }

    @Override
    public void legend(Selector g) {
        final SwatchLegend self = this;
        g.each((CallbackFunction)new CallbackFunction<SceneNode>(){

            public void run(SceneNode context, Object data, int index, int groupIndex) {
                self._spaceUsed = 0.0;
                Selector gSelection = self.prepareLegendGroup(context);
                self.prepareLegendBounds(gSelection);
                Object labelFormat = self.getLabelFormat();
                ValueFunction swatchSizeFn = self.getSwatchSizeFunction();
                Symbol shapeSymbol = self.getShapeSymbol((ValueFunction<Object, ? extends Number>)swatchSizeFn);
                TextFlow textFlow = self.createTextFlowComponent();
                Selector titleSelector = self.prepareLegendTitle(gSelection, textFlow);
                if (titleSelector != null && titleSelector.node().getParentNode() == null) {
                    return;
                }
                double titleVerticalShift = self.calculateTitleVerticalShift(titleSelector);
                double availableWidth = self.size().getWidth() - (double)self.insets().left.intValue() - (double)self.insets().right.intValue();
                double availableHeight = self.size().getHeight() - titleVerticalShift;
                if (availableHeight <= 0.0 || availableWidth <= 0.0) {
                    self.alignTitleHorizontally(titleSelector);
                    return;
                }
                if (!ObjectConverter.toBoolean((Object)self.scale())) {
                    self.alignTitleHorizontally(titleSelector);
                    return;
                }
                List swatchsData = self.getData();
                if (swatchsData == null) {
                    self.alignTitleHorizontally(titleSelector);
                    return;
                }
                LegendEntrySelectors es = self.getLegendEntrySelectors(gSelection, swatchsData, shapeSymbol, labelFormat);
                LegendEntryBBoxes eb = self.getLegendEntryBBoxes(es);
                if (eb.shapeBboxes.size() == 0) {
                    self.alignTitleHorizontally(titleSelector);
                    return;
                }
                double swatchPadding = ObjectConverter.toDouble((Object)self.labelPadding());
                for (int i = 0; i < Math.min(eb.labelBboxes.size(), 2); ++i) {
                    boolean test2;
                    RaveRect labelBBox = (RaveRect)eb.labelBboxes.get(i);
                    RaveRect shapeBBox = (RaveRect)eb.shapeBboxes.get(i);
                    boolean test1 = availableHeight < Math.max(labelBBox.height, shapeBBox.height);
                    boolean bl = test2 = availableWidth < labelBBox.height / 2.0 + shapeBBox.width + (double)self.entryInsets().left.intValue() + (double)self.entryInsets().right.intValue() + swatchPadding;
                    if (!test1 && !test2) continue;
                    es.legendEntry.remove();
                    self.addTruncationIndicator(gSelection, titleVerticalShift, availableWidth, availableHeight, textFlow);
                    self.alignTitleHorizontally(titleSelector);
                    return;
                }
                boolean isHorizontal = "horizontal".equals(self.orient());
                LayoutResults lr = self.layoutLegendEntries(isHorizontal, textFlow, eb, es, swatchPadding, availableWidth, availableHeight);
                self.verifyResults(isHorizontal, eb, lr, availableWidth, availableHeight);
                if (lr.nodes.size() != lr.elements.size() && !self.handleFailedLayout(isHorizontal, gSelection, lr, es, eb, swatchsData, availableWidth, availableHeight, titleVerticalShift, textFlow)) {
                    self.alignTitleHorizontally(titleSelector);
                    return;
                }
                self.alignLabelsShapes(isHorizontal, eb, es, lr, swatchPadding);
                self.transformShapes(isHorizontal, es, lr, titleVerticalShift);
                self.alignSwatchLegendTitleHorizontally(isHorizontal, titleSelector, eb, lr);
            }
        });
    }

    private static class TextResult {
        int entriesCount;
        int noTruncation;
        GridDescr gridDescr;

        TextResult(int entriesCount, int noTruncation, GridDescr gridDescr) {
            this.entriesCount = entriesCount;
            this.noTruncation = noTruncation;
            this.gridDescr = gridDescr;
        }
    }

    private static class GridDescr {
        int numColumnsUsed;
        int numRowsUsed;
        int numColumns;
        int numRows;
        int firstFailureIndex;
        double cellWidth;
        double cellHeight;
        ArrayEx<Double> widthAvailableForTextPerColumn;
        ArrayEx<Double> heightAvailableForTextPerRow;

        GridDescr(int numColumns, int numRows, int numColumnsUsed, int numRowsUsed, int firstFailureIndex, double cellWidth, double cellHeight, ArrayEx<Double> widthAvailableForTextPerColumn, ArrayEx<Double> heightAvailableForTextPerRow) {
            this.numColumns = numColumns;
            this.numRows = numRows;
            this.numColumnsUsed = numColumnsUsed;
            this.numRowsUsed = numRowsUsed;
            this.firstFailureIndex = firstFailureIndex;
            this.cellWidth = cellWidth;
            this.cellHeight = cellHeight;
            this.widthAvailableForTextPerColumn = widthAvailableForTextPerColumn;
            this.heightAvailableForTextPerRow = heightAvailableForTextPerRow;
        }
    }

    private static class LayoutResults {
        int numCols;
        int numRows;
        FillLayout<FillNode> layout;
        ArrayEx<FillNode> nodes;
        ArrayEx<FillNode> elements;
        ColumnRowLists crl;
        TextResult textResult;

        private LayoutResults() {
        }
    }

    private static class ColumnRowLists {
        ArrayEx<Integer> columnListShapes = new ArrayEx();
        ArrayEx<Integer> rowListShapes = new ArrayEx();

        ColumnRowLists() {
        }
    }

    private static class LegendEntryBBoxes {
        ArrayEx<RaveRect> shapeBboxes = new ArrayEx();
        ArrayEx<RaveRect> labelBboxes = new ArrayEx();
        ArrayEx<String> labelTexts = new ArrayEx();

        LegendEntryBBoxes() {
        }
    }

    private static class LegendEntrySelectors {
        Selector legendEntry;
        Selector shape;
        Selector text;

        private LegendEntrySelectors() {
        }
    }
}

