/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.navigation;

import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.rave.core.ExtensionFactory;
import com.ibm.rave.core.context.RaveContextManager;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.core.selector.SelectorDelegate;
import com.ibm.rave.navigation.keyboard.DefaultKeyboard;
import com.ibm.rave.navigation.keyboard.KeyBinding;
import com.ibm.rave.navigation.keys.Keys;
import com.ibm.rave.navigation.selector.NavigationSelector;

public final class Navigation {
    public static final Keys keys = Keys.INSTANCE;
    public static final String SELECTOR_ID = "raveNavigation";
    @InlineStringConstant
    private static final String EXTENSION_REGISTRATION_STATUS_KEY = "NAVIGATION_EXTENSION_REGISTRATION_STATUS_KEY";

    private Navigation() {
    }

    public static KeyBinding keybinding() {
        return new KeyBinding();
    }

    public static DefaultKeyboard keyboard() {
        return new DefaultKeyboard();
    }

    private static RegistrationStatus getRegistrationStatus() {
        RegistrationStatus registrationStatus = (RegistrationStatus)RaveContextManager.INSTANCE.getRaveContext().getData(EXTENSION_REGISTRATION_STATUS_KEY);
        if (registrationStatus == null) {
            registrationStatus = new RegistrationStatus();
            RaveContextManager.INSTANCE.getRaveContext().putData(EXTENSION_REGISTRATION_STATUS_KEY, (Object)registrationStatus);
        }
        return registrationStatus;
    }

    public static void init() {
        RegistrationStatus registrationStatus = Navigation.getRegistrationStatus();
        if (!registrationStatus.registered) {
            registrationStatus.registered = Selector.extension((String)SELECTOR_ID, (ExtensionFactory)new ExtensionFactory<SelectorDelegate>(){

                public SelectorDelegate create() {
                    return new NavigationSelector();
                }
            });
        }
    }

    private static class RegistrationStatus {
        boolean registered = false;

        private RegistrationStatus() {
        }
    }
}

