/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.navigation.keyboard;

import com.ibm.rave.core.Rave;
import com.ibm.rave.core.behavior.FocusEventHandler;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.CallbackFunction;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.navigation.Navigation;
import com.ibm.rave.navigation.focus.FocusController;
import com.ibm.rave.navigation.internal.Keyboard;
import com.ibm.rave.navigation.keyboard.KeyBinding;

public final class DefaultKeyboard
implements Keyboard {
    private static final String NATIVATION_ROOT = "__rave-kbnav-root__";
    private final KeyBinding kb = new KeyBinding();
    private FocusEventHandler eventHandler = Rave.behavior.focusEventHandler();
    public final RunFunction<SceneNode> next;
    public final RunFunction<SceneNode> previous;
    public final RunFunction<SceneNode> nextLevel;
    public final RunFunction<SceneNode> previousLevel;

    public DefaultKeyboard() {
        final DefaultKeyboard self = this;
        this.next = new RunFunction<SceneNode>(){

            public Object run(SceneNode context, Object ... args) {
                SceneNode focused = self.eventHandler.focused();
                if (focused != null && !DefaultKeyboard.isNavigationRoot(focused)) {
                    SceneNode nextSibling = FocusController.nextFocusableNode(focused);
                    if (nextSibling == null) {
                        nextSibling = FocusController.nextFocusableNodeFromStart(focused);
                    }
                    if (nextSibling != null) {
                        self.eventHandler.fireFocus(nextSibling);
                    }
                    Rave.event.preventDefault();
                }
                return null;
            }
        };
        this.previous = new RunFunction<SceneNode>(){

            public Object run(SceneNode context, Object ... args) {
                SceneNode focused = self.eventHandler.focused();
                if (focused != null && !DefaultKeyboard.isNavigationRoot(focused)) {
                    SceneNode previousSibling = FocusController.previousFocusableNode(focused);
                    if (previousSibling == null) {
                        previousSibling = FocusController.previousFocusableNodeFromEnd(focused);
                    }
                    if (previousSibling != null) {
                        self.eventHandler.fireFocus(previousSibling);
                    }
                    Rave.event.preventDefault();
                }
                return null;
            }
        };
        this.nextLevel = new RunFunction<SceneNode>(){

            public Object run(SceneNode context, Object ... args) {
                SceneNode focused = self.eventHandler.focused();
                if (focused != null && (focused = FocusController.nextLevelFocusableNode(focused)) != null) {
                    self.eventHandler.fireFocus(focused);
                }
                Rave.event.preventDefault();
                return null;
            }
        };
        this.previousLevel = new RunFunction<SceneNode>(){

            public Object run(SceneNode context, Object ... args) {
                SceneNode focused = self.eventHandler.focused();
                if (focused != null) {
                    SceneNode parent = FocusController.previousLevelFocusableNode(focused);
                    if (DefaultKeyboard.isNavigationRoot(parent)) {
                        self.eventHandler.fireBlur(focused);
                        self.eventHandler.focused(parent);
                    } else if (!DefaultKeyboard.isNavigationRoot(focused)) {
                        self.eventHandler.fireFocus(parent);
                    }
                    Rave.event.preventDefault();
                }
                return null;
            }
        };
        this.kb.on(Navigation.keys.ENTER, this.nextLevel).on(Navigation.keys.RETURN, this.nextLevel).on(Navigation.keys.ESC, this.previousLevel).on(Navigation.keys.TAB, this.next).on(Navigation.keys.TAB, this.previous, Navigation.keys.SHIFT);
    }

    public Object run(Object context, Object ... args) {
        this.bind((Selector)args[0]);
        return null;
    }

    @Override
    public void bind(Selector g) {
        final DefaultKeyboard self = this;
        g.each((CallbackFunction)new CallbackFunction<SceneNode>(){

            public void run(SceneNode context, Object data, int index, int groupIndex) {
                Selector s = Rave.select((SceneNode)context);
                Rave.select((SceneNode)context.getOwner()).call((RunFunction)self.keyBinding(), new Object[0]);
                s.property(DefaultKeyboard.NATIVATION_ROOT, (Object)true);
                self.eventHandler.focused(context);
            }
        });
    }

    public KeyBinding keyBinding() {
        return this.kb;
    }

    public FocusEventHandler focusEventHandler() {
        return this.eventHandler;
    }

    public DefaultKeyboard focusEventHandler(FocusEventHandler handler) {
        this.eventHandler = handler;
        return this;
    }

    private static boolean isNavigationRoot(SceneNode item) {
        return item.getProperty(NATIVATION_ROOT) != null;
    }
}

