/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.render;

import com.ibm.rave.core.Rave;
import com.ibm.rave.core.context.RaveOperationalMode;
import com.ibm.rave.core.geom.RaveRect;
import com.ibm.rave.core.internal.nativeImpl.Lang;
import com.ibm.rave.core.nativeImpl.timer.TimerEvent;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.core.transform.Matrix;
import com.ibm.rave.render.Renderer;
import com.ibm.rave.render.event.EventManager;
import com.ibm.rave.render.internal.DirtyRegionManager;
import com.ibm.rave.render.internal.nodes.AbstractSceneNode;
import com.ibm.rave.render.internal.nodes.CircleSceneItem;
import com.ibm.rave.render.internal.nodes.ClipPathSceneItem;
import com.ibm.rave.render.internal.nodes.EllipseSceneItem;
import com.ibm.rave.render.internal.nodes.ImageSceneItem;
import com.ibm.rave.render.internal.nodes.LineSceneItem;
import com.ibm.rave.render.internal.nodes.NodeUtil;
import com.ibm.rave.render.internal.nodes.PathSceneItem;
import com.ibm.rave.render.internal.nodes.RectSceneItem;
import com.ibm.rave.render.internal.nodes.TextPathSceneItem;
import com.ibm.rave.render.internal.nodes.TextSceneItem;
import com.ibm.rave.render.internal.style.AbstractStyle;
import com.ibm.rave.render.internal.style.RenderStyleManager;
import com.ibm.rave.render.internal.style.StrokeStyle;

public abstract class AbstractRenderer
implements Renderer {
    private boolean drawRunning;
    private double lastDrawTime;
    private DirtyRegionManager dirtyManager;
    public final SceneNode root;
    private EventManager eventManager;
    private double lastWidth = 0.0;
    private double lastHeight = 0.0;

    public boolean isDirtyRegionEnabled() {
        return this.dirtyManager != null;
    }

    protected boolean getDirtyRegionFlagFromRoot() {
        return ObjectConverter.toBoolean((Object)this.root.getProperty("rave-dirtyRegions"));
    }

    protected double getWidth() {
        return ObjectConverter.toDouble((Object)this.root.getAttribute("width"));
    }

    protected double getHeight() {
        return ObjectConverter.toDouble((Object)this.root.getAttribute("height"));
    }

    @Override
    public void repaint() {
        if (this.getDirtyRegionFlagFromRoot()) {
            if (this.dirtyManager == null) {
                this.dirtyManager = new DirtyRegionManager();
            }
        } else {
            this.dirtyManager = null;
        }
        double width = this.getWidth();
        double height = this.getHeight();
        if (this.dirtyManager != null && (width != this.lastWidth || height != this.lastHeight)) {
            this.dirtyManager.forceRedraw();
        }
        this.start(this.dirtyManager == null || this.dirtyManager.isGloballyDirty());
        this.render(this.root);
        this.finish();
        this.lastWidth = width;
        this.lastHeight = height;
    }

    public AbstractRenderer(SceneNode root) {
        this.root = root;
    }

    public final void makeDirty(AbstractSceneNode node) {
        if (this.dirtyManager != null) {
            this.dirtyManager.add(node);
        }
    }

    protected abstract EventManager createEventManager();

    @Override
    public void registerEvent(String eventType, SceneNode node) {
        if (this.eventManager == null) {
            this.eventManager = this.createEventManager();
        }
        this.eventManager.registerEvent(eventType, node);
    }

    @Override
    public void unregisterEvent(String eventType, SceneNode node) {
        if (this.eventManager != null) {
            this.eventManager.unregisterEvent(eventType, node);
        }
    }

    @Override
    public void handleDrawEvent(int type, SceneNode item) {
        if (RaveOperationalMode.MODE != 1 && !this.drawRunning) {
            this.drawRunning = true;
            final AbstractRenderer renderer = this;
            TimerEvent event = new TimerEvent(){

                public boolean run(double elapsed) {
                    renderer.repaint();
                    renderer.lastDrawTime = Lang.now();
                    renderer.drawRunning = false;
                    return true;
                }
            };
            double diff = Lang.now() - this.lastDrawTime;
            double delay = diff > 15.0 ? 0.0 : diff;
            Rave.timer.addEvent(event, delay);
        }
    }

    @Override
    public final void render(SceneNode node) {
        AbstractSceneNode anode = (AbstractSceneNode)node;
        SceneNode parentNode = node;
        while (parentNode.getParentNode() != null) {
            parentNode = parentNode.getParentNode();
        }
        this.recursiveComputeStyles((AbstractSceneNode)parentNode);
        RaveRect dirtyClip = null;
        if (this.dirtyManager != null && !this.dirtyManager.isGloballyDirty() && (dirtyClip = this.dirtyManager.getClip()) != null) {
            this.saveGraphicsState();
            this.addRectClip(dirtyClip);
            this.clearRect(dirtyClip);
        }
        this.doRender(anode);
        if (this.dirtyManager != null) {
            this.dirtyManager.clear();
            if (dirtyClip != null) {
                this.restoreGraphicsState();
            }
        }
    }

    private void recursiveComputeStyles(AbstractSceneNode node) {
        node.computeStyles();
        for (SceneNode child : node.getChildNodes()) {
            this.recursiveComputeStyles((AbstractSceneNode)child);
        }
    }

    private void doRender(AbstractSceneNode node) {
        ClipPathSceneItem clipNode;
        if (!node.isDrawable()) {
            return;
        }
        this.saveGraphicsState();
        Matrix matrix = (Matrix)node.getComputedStyleValue(11);
        if (matrix != null) {
            this.applyMatrix(matrix);
        }
        if ((clipNode = (ClipPathSceneItem)NodeUtil.findSceneNode(node, (String)node.getComputedStyleValue(44), new int[]{1014})) != null) {
            clipNode.layout();
            clipNode.paint(this);
        }
        this.shapeRendering((String)node.getComputedStyleValue(47));
        boolean painted = false;
        if (node.getDrawType() != -1 && (this.dirtyManager == null || node.isDirty() || this.dirtyManager.intersects(node))) {
            node.layout();
            if (node.isVisible()) {
                node.paint(this);
                painted = true;
            }
        }
        if (node.hasChildNodes()) {
            for (SceneNode child : node.getChildrenArray()) {
                this.doRender((AbstractSceneNode)child);
            }
        }
        if (painted) {
            node.postPaint(this);
        }
        node.setDirty(false, false);
        this.restoreGraphicsState();
    }

    @Override
    public abstract void start(boolean var1);

    @Override
    public abstract void finish();

    private void applyMatrix(Matrix matrix) {
        this.transform(matrix.a, matrix.b, matrix.c, matrix.d, matrix.e, matrix.f);
    }

    public void setStrokeAndFill(AbstractSceneNode node) {
        AbstractStyle style = RenderStyleManager.getFill(node);
        this.fill(style);
        this.stroke(RenderStyleManager.getStroke(node));
    }

    public abstract void drawPath(PathSceneItem var1);

    @Override
    public abstract void addClip(ClipPathSceneItem var1);

    @Override
    public abstract void drawEllipse(EllipseSceneItem var1);

    @Override
    public abstract void drawRect(RectSceneItem var1);

    @Override
    public abstract void drawLine(LineSceneItem var1);

    @Override
    public abstract void drawText(TextSceneItem var1);

    @Override
    public abstract void drawTextPath(TextPathSceneItem var1, Selector var2);

    @Override
    public abstract void drawCircle(CircleSceneItem var1);

    @Override
    public abstract void push();

    @Override
    public abstract void pop(double var1);

    @Override
    public abstract void drawImage(ImageSceneItem var1);

    @Override
    public abstract void fill(AbstractStyle var1);

    @Override
    public abstract void stroke(StrokeStyle var1);

    @Override
    public abstract void transform(double var1, double var3, double var5, double var7, double var9, double var11);

    @Override
    public abstract void saveGraphicsState();

    @Override
    public abstract void restoreGraphicsState();

    @Override
    public abstract void addRectClip(RaveRect var1);

    @Override
    public abstract void clearRect(RaveRect var1);

    @Override
    public abstract void shapeRendering(String var1);
}

