/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.render.event;

import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.rave.codegenerator.annotations.SwiftWeak;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.event.Event;
import com.ibm.rave.core.event.Touch;
import com.ibm.rave.core.event.TouchEvent;
import com.ibm.rave.core.event.UIEvent;
import com.ibm.rave.core.geom.NodeRect;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.render.AbstractRenderer;
import com.ibm.rave.render.event.NativeEventListener;
import java.util.ArrayList;
import java.util.List;

public abstract class EventManager {
    @InlineStringConstant
    private static final String CACHE_KEY_PREFIX = "__rave-eventmanager";
    private final OMap<String, EventListenerInfo> eventHandlers = new OMap();
    @SwiftWeak
    private final AbstractRenderer renderer;

    public EventManager(AbstractRenderer renderer) {
        this.renderer = renderer;
    }

    public void registerEvent(String eventType, SceneNode node) {
        EventListenerInfo info = (EventListenerInfo)this.eventHandlers.get((Object)eventType);
        String key = CACHE_KEY_PREFIX + eventType;
        if (info == null) {
            info = this.createNativeEventHandler(eventType);
            if (info != null) {
                this.eventHandlers.put((Object)eventType, (Object)info);
                node.setProperty(key, (Object)eventType);
                info.addNode(node);
            }
        } else if (!node.hasProperty(key)) {
            node.setProperty(key, (Object)eventType);
            info.addNode(node);
        }
    }

    public void unregisterEvent(String eventType, SceneNode node) {
        String key;
        EventListenerInfo info = (EventListenerInfo)this.eventHandlers.get((Object)eventType);
        if (info != null && node.hasProperty(key = CACHE_KEY_PREFIX + eventType)) {
            node.removeProperty(key);
            info.removeNode(node);
            if (info.canDispose()) {
                info.dispose();
                this.eventHandlers.remove((Object)eventType);
            }
        }
    }

    private EventListenerInfo createNativeEventHandler(String eventType) {
        EventListenerInfo result = null;
        if ("mouseover".equals(eventType)) {
            result = this.createMouseOverListener(eventType);
        } else if ("mouseout".equals(eventType)) {
            result = this.createMouseOutListener(eventType);
        } else if ("mouseenter".equals(eventType)) {
            result = this.createMouseEnterListener(eventType);
        } else if ("mouseleave".equals(eventType)) {
            result = this.createMouseLeaveListener(eventType);
        } else if ("click".equals(eventType) || "dblclick".equals(eventType) || "mousemove".equals(eventType) || "mouseup".equals(eventType) || "mousedown".equals(eventType) || "contextmenu".equals(eventType) || "wheel".equals(eventType)) {
            result = this.createSimpleEventListener(eventType);
        } else if ("touchmove".equals(eventType) || "touchend".equals(eventType) || "touchcancel".equals(eventType)) {
            result = this.createTouchEventListener(eventType);
        } else if ("touchstart".equals(eventType)) {
            result = this.createTouchStartEventListener(eventType);
        } else if ("keydown".equals(eventType) || "keypress".equals(eventType) || "keyup".equals(eventType)) {
            result = this.createKeyboardEventListener(eventType);
        }
        return result;
    }

    private EventListenerInfo createMouseOverListener(final String eventType) {
        final SceneNode[] target = new SceneNode[1];
        final EventManager self = this;
        EventListenerInfo info = new EventListenerInfo(this, eventType);
        info.bundles.add(new NativeListenerBundle("mousemove", this.addNativeEventListener("mousemove", new NativeEventListener(){

            @Override
            public void onEvent(UIEvent event) {
                SceneNode hit = self.findHit(event.clientX, event.clientY);
                if (hit != null && hit != target[0]) {
                    event.type = eventType;
                    hit.dispatchEvent((Event)event);
                    event.type = "mousemove";
                }
                target[0] = hit;
            }
        })));
        info.bundles.add(new NativeListenerBundle("mouseout", this.addNativeEventListener("mouseout", new NativeEventListener(){

            @Override
            public void onEvent(UIEvent event) {
                target[0] = null;
            }
        })));
        return info;
    }

    private EventListenerInfo createMouseOutListener(final String eventType) {
        final SceneNode[] target = new SceneNode[1];
        final EventManager self = this;
        EventListenerInfo info = new EventListenerInfo(this, eventType);
        info.bundles.add(new NativeListenerBundle("mousemove", this.addNativeEventListener("mousemove", new NativeEventListener(){

            @Override
            public void onEvent(UIEvent event) {
                SceneNode hit = self.findHit(event.clientX, event.clientY);
                if (target[0] != null && hit != target[0]) {
                    event.type = eventType;
                    target[0].dispatchEvent((Event)event);
                    event.type = "mousemove";
                }
                target[0] = hit;
            }
        })));
        info.bundles.add(new NativeListenerBundle("mouseout", this.addNativeEventListener("mouseout", new NativeEventListener(){

            @Override
            public void onEvent(UIEvent event) {
                if (target[0] != null) {
                    target[0].dispatchEvent((Event)event);
                    target[0] = null;
                }
            }
        })));
        return info;
    }

    private EventListenerInfo createMouseEnterListener(final String eventType) {
        final SceneNode[] target = new SceneNode[1];
        final EventManager self = this;
        final ArrayEx ancestors = new ArrayEx();
        EventListenerInfo info = new EventListenerInfo(this, eventType);
        info.bundles.add(new NativeListenerBundle("mousemove", this.addNativeEventListener("mousemove", new NativeEventListener(){

            @Override
            public void onEvent(UIEvent event) {
                SceneNode hit = self.findHit(event.clientX, event.clientY);
                if (hit != null) {
                    if (hit != target[0]) {
                        int index = ancestors.indexOf((Object)hit);
                        if (index >= 0) {
                            ancestors.setLength(index + 1);
                        } else {
                            event.type = eventType;
                            boolean bubbles = event.bubbles;
                            event.bubbles = false;
                            boolean isDescendant = false;
                            for (int i = ancestors.size() - 1; i >= 0; --i) {
                                SceneNode ancestor = (SceneNode)ancestors.get(i);
                                if (!EventManager.isDescendant(ancestor, hit)) continue;
                                ancestors.setLength(i + 1);
                                ArrayEx newAncestors = new ArrayEx();
                                SceneNode parent = hit;
                                do {
                                    newAncestors.add((Object)parent);
                                    parent.dispatchEvent((Event)event);
                                } while ((parent = parent.getParentNode()) != ancestor);
                                for (int j = newAncestors.size() - 1; j >= 0; --j) {
                                    ancestors.add(newAncestors.get(j));
                                }
                                isDescendant = true;
                                break;
                            }
                            if (!isDescendant) {
                                ancestors.clear();
                                SceneNode parent = hit;
                                do {
                                    ancestors.add((Object)parent);
                                    parent.dispatchEvent((Event)event);
                                } while ((parent = parent.getParentNode()) != null);
                                ancestors.reverse();
                            }
                            event.bubbles = bubbles;
                            event.type = "mousemove";
                        }
                    }
                } else if (target[0] != null) {
                    ancestors.clear();
                }
                target[0] = hit;
            }
        })));
        info.bundles.add(new NativeListenerBundle("mouseout", this.addNativeEventListener("mouseout", new NativeEventListener(){

            @Override
            public void onEvent(UIEvent event) {
                target[0] = null;
                ancestors.clear();
            }
        })));
        return info;
    }

    private static boolean isDescendant(SceneNode ancestor, SceneNode node) {
        SceneNode parent = node;
        while ((parent = parent.getParentNode()) != null) {
            if (parent != ancestor) continue;
            return true;
        }
        return false;
    }

    private EventListenerInfo createMouseLeaveListener(final String eventType) {
        final SceneNode[] target = new SceneNode[1];
        final EventManager self = this;
        final ArrayEx ancestors = new ArrayEx();
        EventListenerInfo info = new EventListenerInfo(this, eventType);
        info.bundles.add(new NativeListenerBundle("mousemove", this.addNativeEventListener("mousemove", new NativeEventListener(){

            @Override
            public void onEvent(UIEvent event) {
                SceneNode hit = self.findHit(event.clientX, event.clientY);
                if (hit != target[0]) {
                    if (target[0] == null) {
                        SceneNode parent = hit;
                        do {
                            ancestors.add((Object)parent);
                        } while ((parent = parent.getParentNode()) != null);
                        ancestors.reverse();
                    } else {
                        int index = ancestors.indexOf((Object)hit);
                        if (index >= 0) {
                            for (int i = ancestors.size() - 1; i > index; --i) {
                                ((SceneNode)ancestors.get(i)).dispatchEvent((Event)event);
                            }
                            ancestors.setLength(index + 1);
                        } else {
                            event.type = eventType;
                            boolean bubbles = event.bubbles;
                            event.bubbles = false;
                            boolean isDescendant = false;
                            for (int i = ancestors.size() - 1; i >= 0; --i) {
                                SceneNode ancestor = (SceneNode)ancestors.get(i);
                                if (hit != null && EventManager.isDescendant(ancestor, hit)) {
                                    ancestors.setLength(i + 1);
                                    ArrayEx newAncestors = new ArrayEx();
                                    SceneNode parent = hit;
                                    do {
                                        newAncestors.add((Object)parent);
                                    } while ((parent = parent.getParentNode()) != ancestor);
                                    for (int j = newAncestors.size() - 1; j >= 0; --j) {
                                        ancestors.add(newAncestors.get(j));
                                    }
                                    isDescendant = true;
                                    break;
                                }
                                ancestor.dispatchEvent((Event)event);
                            }
                            if (!isDescendant && hit != null) {
                                SceneNode parent = hit;
                                do {
                                    ancestors.add((Object)parent);
                                } while ((parent = parent.getParentNode()) != null);
                                ancestors.reverse();
                            }
                            event.bubbles = bubbles;
                            event.type = "mousemove";
                        }
                    }
                    target[0] = hit;
                }
            }
        })));
        info.bundles.add(new NativeListenerBundle("mouseout", this.addNativeEventListener("mouseout", new NativeEventListener(){

            @Override
            public void onEvent(UIEvent event) {
                if (target[0] != null) {
                    event.type = eventType;
                    target[0].dispatchEvent((Event)event);
                    target[0] = null;
                    ancestors.clear();
                    event.type = "mouseout";
                }
            }
        })));
        return info;
    }

    private EventListenerInfo createSimpleEventListener(String eventType) {
        final EventManager self = this;
        EventListenerInfo info = new EventListenerInfo(this, eventType);
        NativeEventListener listener = new NativeEventListener(){

            @Override
            public void onEvent(UIEvent event) {
                SceneNode hit = self.findHit(event.clientX, event.clientY);
                if (hit != null) {
                    hit.dispatchEvent((Event)event);
                }
            }
        };
        info.bundles.add(new NativeListenerBundle(info.eventType, this.addNativeEventListener(info.eventType, listener)));
        return info;
    }

    private EventListenerInfo createKeyboardEventListener(String eventType) {
        final EventManager self = this;
        EventListenerInfo info = new EventListenerInfo(this, eventType);
        NativeEventListener listener = new NativeEventListener(){

            @Override
            public void onEvent(UIEvent event) {
                ((EventManager)self).renderer.root.dispatchEvent((Event)event);
            }
        };
        info.bundles.add(new NativeListenerBundle(info.eventType, this.addNativeEventListener(info.eventType, listener)));
        return info;
    }

    private EventListenerInfo createTouchStartEventListener(String eventType) {
        final EventManager self = this;
        EventListenerInfo info = new EventListenerInfo(this, eventType);
        NativeEventListener listener = new NativeEventListener(){

            @Override
            public void onEvent(UIEvent event) {
                for (Touch touch : ((TouchEvent)event).changedTouches) {
                    SceneNode hit = self.findHit(touch.clientX, touch.clientY);
                    if (hit == null) continue;
                    hit.dispatchEvent((Event)event);
                }
            }
        };
        info.bundles.add(new NativeListenerBundle(info.eventType, this.addNativeEventListener(info.eventType, listener)));
        return info;
    }

    private EventListenerInfo createTouchEventListener(String eventType) {
        final EventManager self = this;
        final OMap touchPoints = new OMap();
        EventListenerInfo info = new EventListenerInfo(this, eventType);
        NativeEventListener listener1 = new NativeEventListener(){

            @Override
            public void onEvent(UIEvent event) {
                for (Touch touch : ((TouchEvent)event).changedTouches) {
                    SceneNode node = (SceneNode)touchPoints.get((Object)touch.identifier);
                    if (node == null) continue;
                    node.dispatchEvent((Event)event);
                }
            }
        };
        info.bundles.add(new NativeListenerBundle(info.eventType, this.addNativeEventListener(info.eventType, listener1)));
        NativeEventListener listener2 = new NativeEventListener(){

            @Override
            public void onEvent(UIEvent event) {
                for (Touch touch : ((TouchEvent)event).changedTouches) {
                    SceneNode hit = self.findHit(touch.clientX, touch.clientY);
                    if (hit == null) continue;
                    touchPoints.put((Object)touch.identifier, (Object)hit);
                }
            }
        };
        info.bundles.add(new NativeListenerBundle("touchstart", this.addNativeEventListener("touchstart", listener2)));
        NativeEventListener listener3 = new NativeEventListener(){

            @Override
            public void onEvent(UIEvent event) {
                for (Touch touch : ((TouchEvent)event).changedTouches) {
                    touchPoints.remove((Object)touch.identifier);
                }
            }
        };
        info.bundles.add(new NativeListenerBundle("touchend", this.addNativeEventListener("touchend", listener3)));
        info.bundles.add(new NativeListenerBundle("touchcancel", this.addNativeEventListener("touchcancel", listener3)));
        return info;
    }

    private SceneNode findHit(double x, double y) {
        SceneNode root = this.renderer.root;
        NodeRect nodeClientRect = root.getOwner().getBoundingClientRect();
        return root.intersection(x - nodeClientRect.left, y - nodeClientRect.top);
    }

    protected abstract Object addNativeEventListener(String var1, NativeEventListener var2);

    protected abstract void removeNativeEventListener(String var1, Object var2);

    private static class EventListenerInfo {
        final List<NativeListenerBundle> bundles = new ArrayList<NativeListenerBundle>();
        final String eventType;
        @SwiftWeak
        private final EventManager em;
        protected int nodeCount = 0;

        EventListenerInfo(EventManager em, String eventType) {
            this.em = em;
            this.eventType = eventType;
        }

        void dispose() {
            for (NativeListenerBundle bundle : this.bundles) {
                this.em.removeNativeEventListener(bundle.eventType, bundle.nativeListenerObject);
            }
        }

        void addNode(SceneNode node) {
            ++this.nodeCount;
        }

        void removeNode(SceneNode node) {
            --this.nodeCount;
        }

        boolean canDispose() {
            return this.nodeCount == 0;
        }
    }

    private static class NativeListenerBundle {
        final String eventType;
        final Object nativeListenerObject;

        public NativeListenerBundle(String eventType, Object listener) {
            this.eventType = eventType;
            this.nativeListenerObject = listener;
        }
    }
}

