/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.render.internal.nodes;

import com.ibm.rave.codegenerator.annotations.SwiftWeak;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.css.CSSSize;
import com.ibm.rave.core.css.CSSStyleDeclaration;
import com.ibm.rave.core.css.CSSStyleRule;
import com.ibm.rave.core.css.CSSStyleSheet;
import com.ibm.rave.core.event.Event;
import com.ibm.rave.core.event.EventListener;
import com.ibm.rave.core.geom.NodeRect;
import com.ibm.rave.core.geom.RaveRect;
import com.ibm.rave.core.geom.RectStruct;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.internal.css.CSSParser;
import com.ibm.rave.core.internal.css.CSSStyle;
import com.ibm.rave.core.internal.nativeImpl.Lang;
import com.ibm.rave.core.internal.util.CollectionsUtil;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.transform.Matrix;
import com.ibm.rave.core.transform.MatrixUtil;
import com.ibm.rave.render.AbstractRenderer;
import com.ibm.rave.render.internal.nodes.ClipPathSceneItem;
import com.ibm.rave.render.internal.nodes.NodeUtil;
import com.ibm.rave.render.internal.nodes.SceneNodeStyleManager;
import com.ibm.rave.render.internal.nodes.SceneTreeContext;
import com.ibm.rave.render.internal.properties.DynamicAttributesCollection;
import com.ibm.rave.render.internal.properties.SceneNodeAttributes;
import com.ibm.rave.render.internal.properties.SceneNodeDefaultStyles;
import com.ibm.rave.render.internal.style.ShadowStyle;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractSceneNode
extends SceneNode {
    private static final SceneNode.SetPropertyExtension SET_PROPERTY_EXT = new SceneNode.SetPropertyExtension(){

        public void setProperty(SceneNode context, String key, Object value) {
            if ("__rave-mirrored__".equals(key)) {
                ((AbstractSceneNode)context).invalidateLayout();
            }
            ((AbstractSceneNode)context).getPropertyBag().put((Object)key, value);
        }
    };
    private static final SceneNode.RemovePropertyExtension REMOVE_PROPERTY_EXT = new SceneNode.RemovePropertyExtension(){

        public void removeProperty(SceneNode context, String key) {
            ((AbstractSceneNode)context).getPropertyBag().remove((Object)key);
        }
    };
    private static final SceneNode.AppendChildExtension APPEND_CHILD_EXT = new SceneNode.AppendChildExtension(){

        public void appendChild(SceneNode context, SceneNode node) {
            ((AbstractSceneNode)context).internalAppendChild(node);
            ((AbstractSceneNode)node).notifyAfterUpdate(1001, 3000, null, null, null);
        }
    };
    private static final SceneNode.InsertBeforeExtension INSERT_BEFORE_EXT = new SceneNode.InsertBeforeExtension(){

        public void insertBefore(SceneNode context, SceneNode node, SceneNode before) {
            ((AbstractSceneNode)context).insertChildBefore(node, before);
            ((AbstractSceneNode)node).notifyAfterUpdate(1001, 3000, null, null, null);
        }
    };
    private static final SceneNode.GetNextSiblingExtension GET_NEXT_SIBLING_EXT = new SceneNode.GetNextSiblingExtension(){

        public SceneNode getNextSibling(SceneNode context) {
            return ((AbstractSceneNode)context).getSibling(1);
        }
    };
    private static final SceneNode.GetPreviousSiblingExtension GET_PREVIOUS_SIBLING_EXT = new SceneNode.GetPreviousSiblingExtension(){

        public SceneNode getPreviousSibling(SceneNode context) {
            return ((AbstractSceneNode)context).getSibling(-1);
        }
    };
    private static final SceneNode.GetFirstChildExtension GET_FIRST_CHILD = new SceneNode.GetFirstChildExtension(){

        public SceneNode getFirstChild(SceneNode context) {
            AbstractSceneNode asc = (AbstractSceneNode)context;
            if (asc.children != null && asc.children.size() > 0) {
                return asc.children.get(0);
            }
            return asc.getSibling(1);
        }
    };
    private static final SceneNode.HasChildNodesExtension HAS_CHILD_NODES_EXT = new SceneNode.HasChildNodesExtension(){

        public boolean hasChildNodes(SceneNode context) {
            AbstractSceneNode asc = (AbstractSceneNode)context;
            return asc.children != null && asc.children.size() > 0;
        }
    };
    private static final SceneNode.GetChildNodesExtension GET_CHILD_NODES_EXT = new SceneNode.GetChildNodesExtension(){

        public List<SceneNode> getChildNodes(SceneNode context) {
            AbstractSceneNode asc = (AbstractSceneNode)context;
            if (asc.children == null) {
                asc.createChildren();
            }
            return asc.children;
        }
    };
    private static final SceneNode.RemoveChildExtension REMOVE_CHILD_EXT = new SceneNode.RemoveChildExtension(){

        public boolean removeChild(SceneNode context, SceneNode node) {
            AbstractSceneNode asc = (AbstractSceneNode)context;
            boolean removed = false;
            int idx = asc.children.indexOf(node);
            if (idx >= 0) {
                removed = true;
                ((AbstractSceneNode)node).setDirty(true, true);
                asc.children.remove(idx);
                ((AbstractSceneNode)node).notifyAfterUpdate(1002, 3000, null, null, null);
                node.setParentNode(null);
            }
            return removed;
        }
    };
    private static final SceneNode.GetParentNodeExtension PARENT_NODE_EXT = new SceneNode.GetParentNodeExtension(){

        public SceneNode getParentNode(SceneNode context) {
            return ((AbstractSceneNode)context).parent;
        }
    };
    private static final SceneNode.SetTextExtension SET_TEXT_EXT = new SceneNode.SetTextExtension(){

        public void setText(SceneNode context, String text) {
            ((AbstractSceneNode)context).setDirty(true, true);
            String oldValue = ((AbstractSceneNode)context).text;
            String newValue = text == null ? "" : text;
            ArrayEx copy = new ArrayEx();
            for (SceneNode child : ((AbstractSceneNode)context).getChildNodes()) {
                copy.add((Object)child);
            }
            for (SceneNode child : copy) {
                ((AbstractSceneNode)context).removeChild(child);
            }
            ((AbstractSceneNode)context).text = newValue;
            ((AbstractSceneNode)context).notifyAfterUpdate(1000, 2004, "text", newValue, oldValue);
        }
    };
    private static final SceneNode.SetAttributeExtension SET_ATTRIBUTE_EXT = new SceneNode.SetAttributeExtension(){

        public void setAttribute(SceneNode context, String key, Object value) {
            if (key != null) {
                Object oldValue;
                String k = key.toLowerCase();
                AbstractSceneNode acontext = (AbstractSceneNode)context;
                int index = acontext.attributes.getIndex(k);
                switch (index) {
                    case 2: {
                        if (acontext.classList != null) {
                            acontext.classList = null;
                        }
                        if (value != null) {
                            acontext.addClassAndUpdateClassAttr(ObjectConverter.toString((Object)value), false);
                            break;
                        }
                        acontext.setDirty(true, false);
                        break;
                    }
                    case 1: {
                        acontext.styleManager.removeAllInlineStyles();
                        CSSStyleSheet styleSheet = CSSParser.parse((String)("a{" + ObjectConverter.toString((Object)value) + "}"));
                        for (CSSStyleRule rule : styleSheet.getCssRules()) {
                            CSSStyleDeclaration styleDecl = rule.getStyle();
                            for (int i = 0; i < styleDecl.length(); ++i) {
                                String styleName = styleDecl.item(i);
                                acontext.setStyle(styleName, styleDecl.getPropertyValue(styleName), styleDecl.getPropertyPriority(styleName));
                            }
                        }
                        break;
                    }
                    default: {
                        int styleIndex = SceneNodeDefaultStyles.getIndex(k);
                        if (styleIndex >= 0) {
                            CSSStyle style = acontext.styleManager.getStyleByIndex(styleIndex);
                            if (style == null) {
                                acontext.setStyle(k, value, null);
                                style = acontext.styleManager.getStyleByIndex(styleIndex);
                                if (style == null) break;
                                style.fromAttribute = true;
                                break;
                            }
                            if (!style.fromAttribute) break;
                            acontext.setStyle(k, value, null);
                            style.fromAttribute = true;
                            break;
                        }
                        acontext.setDirty(true, true);
                    }
                }
                if (index == -1) {
                    oldValue = acontext.attributes.get(k);
                    index = acontext.attributes.put(k, value);
                } else {
                    oldValue = acontext.attributes.getByIndex(index);
                    acontext.attributes.setPropertyValue(index, value);
                }
                acontext.notifyAfterUpdate(1000, 2000, k, value, oldValue);
            }
        }
    };
    private static final SceneNode.SetStyleExtension SET_STYLE_EXT = new SceneNode.SetStyleExtension(){

        public void setStyle(SceneNode context, String styleName, Object value, String priority) {
            ((AbstractSceneNode)context).styleManager.setStyle(context, styleName, value, priority);
        }
    };
    protected RaveRect cachedBBox;
    private NodeRect cachedBoundingClientRect;
    @SwiftWeak
    private SceneNode parent;
    @SwiftWeak
    private SceneNode owner;
    @SwiftWeak(value=false)
    protected List<SceneNode> children;
    protected String namespaceURI;
    protected DynamicAttributesCollection<Object> attributes = new SceneNodeAttributes();
    private OMap<String, Object> propertyBag;
    private List<String> classList;
    protected OMap<String, ListenerInfo> eventListeners;
    protected OMap<String, List<ListenerInfo>> listenersByGroup;
    protected OMap<String, ArrayEx<ListenerInfo>> listenersByType;
    private String qname;
    protected String text = "";
    protected String html = "";
    @SwiftWeak(value=false)
    private SceneTreeContext sceneTreeContext;
    public Object nativeSceneNode;
    final SceneNodeStyleManager styleManager;
    boolean invalidLayout = true;
    boolean dirty;
    protected Matrix cachedCTM;
    protected Matrix cachedScreenCTM;
    private static final SceneNode.GetCTMExtension GET_CTM_EXT = new SceneNode.GetCTMExtension(){

        public Matrix getCTM(SceneNode context) {
            AbstractSceneNode abstractContext = (AbstractSceneNode)context;
            if (abstractContext.cachedCTM == null) {
                abstractContext.cachedCTM = abstractContext.computeCTM(context, false);
            }
            return abstractContext.cachedCTM;
        }
    };
    private static final SceneNode.GetScreenCTMExtension GET_SCREEN_CTM_EXT = new SceneNode.GetScreenCTMExtension(){

        public Matrix getScreenCTM(SceneNode context) {
            AbstractSceneNode abstractContext = (AbstractSceneNode)context;
            if (abstractContext.cachedScreenCTM == null) {
                abstractContext.cachedScreenCTM = abstractContext.computeCTM(context, true);
            }
            return abstractContext.cachedScreenCTM;
        }
    };

    public AbstractSceneNode(String nsuri, SceneNode context) {
        this.initExtensions();
        this.namespaceURI = nsuri;
        if (context != null) {
            this.sceneTreeContext = ((AbstractSceneNode)context).sceneTreeContext;
        }
        this.styleManager = new SceneNodeStyleManager(this);
    }

    public final String getId() {
        Object id = this.attributes.getByIndex(0);
        if (id == null) {
            return null;
        }
        return ObjectConverter.toString((Object)id);
    }

    public boolean hasProperty(String propName) {
        return this.propertyBag != null ? this.propertyBag.containsKey((Object)propName) : false;
    }

    private final void createChildren() {
        this.children = new ArrayList<SceneNode>();
    }

    public EventListener<?> getEventListener(String eventType) {
        ListenerInfo info = this.eventListeners != null ? (ListenerInfo)this.eventListeners.get((Object)eventType) : null;
        return info != null ? info.listener : null;
    }

    public void addEventListener(String eventType, EventListener<?> listener) {
        this.addEventListener(eventType, listener, false, null);
    }

    public void addEventListener(String eventType, EventListener<?> listener, boolean useCapture) {
        this.addEventListener(eventType, listener, useCapture, null);
    }

    public void addEventListener(String eventType, EventListener<?> listener, boolean useCapture, String group) {
        String eventId = AbstractSceneNode.createEventId(eventType, group);
        if (this.eventListeners == null) {
            this.eventListeners = new OMap();
            this.listenersByGroup = new OMap();
            this.listenersByType = new OMap();
        } else if (this.eventListeners.containsKey((Object)eventId)) {
            this.removeEventListener(eventType, group);
        }
        ListenerInfo info = new ListenerInfo(eventId, eventType, listener, useCapture);
        this.eventListeners.put((Object)eventId, (Object)info);
        ArrayList<ListenerInfo> groupList = (ArrayList<ListenerInfo>)this.listenersByGroup.get((Object)group);
        if (groupList == null) {
            groupList = new ArrayList<ListenerInfo>();
            this.listenersByGroup.put((Object)group, groupList);
        }
        groupList.add(info);
        ArrayEx typeList = (ArrayEx)this.listenersByType.get((Object)eventType);
        if (typeList == null) {
            AbstractRenderer renderer;
            typeList = new ArrayEx();
            this.listenersByType.put((Object)eventType, (Object)typeList);
            AbstractRenderer abstractRenderer = renderer = this.sceneTreeContext != null ? this.sceneTreeContext.getRenderer() : null;
            if (renderer != null) {
                renderer.registerEvent(eventType, this);
            }
        }
        typeList.add((Object)info);
    }

    public void removeEventListener(String eventType) {
        if (this.eventListeners != null) {
            this.removeEventListener(eventType, null);
        }
    }

    public void removeEventListener(String eventType, String group) {
        String eventId;
        ListenerInfo info;
        if (this.eventListeners != null && (info = (ListenerInfo)this.eventListeners.get((Object)(eventId = AbstractSceneNode.createEventId(eventType, group)))) != null) {
            List byTypeList;
            this.eventListeners.remove((Object)eventId);
            info.isRemoved = true;
            List byGroupList = (List)this.listenersByGroup.get((Object)group);
            if (CollectionsUtil.remove((List)byGroupList, (Object)info) && byGroupList.size() == 0) {
                this.listenersByGroup.remove((Object)group);
            }
            if (CollectionsUtil.remove((List)(byTypeList = (List)this.listenersByType.get((Object)eventType)), (Object)info) && byTypeList.size() == 0) {
                AbstractRenderer renderer;
                this.listenersByType.remove((Object)eventType);
                AbstractRenderer abstractRenderer = renderer = this.sceneTreeContext != null ? this.sceneTreeContext.getRenderer() : null;
                if (renderer != null) {
                    renderer.unregisterEvent(eventType, this);
                }
            }
        }
    }

    public void removeEventListeners(String group) {
        List list;
        if (this.listenersByGroup != null && (list = (List)this.listenersByGroup.get((Object)group)) != null) {
            AbstractRenderer renderer = this.sceneTreeContext != null ? this.sceneTreeContext.getRenderer() : null;
            for (ListenerInfo info : list) {
                this.eventListeners.remove((Object)info.id);
                info.isRemoved = true;
                List byTypeList = (List)this.listenersByType.get((Object)info.type);
                if (!CollectionsUtil.remove((List)byTypeList, (Object)info) || byTypeList.size() != 0) continue;
                this.listenersByType.remove((Object)info.type);
                if (renderer == null) continue;
                renderer.unregisterEvent(info.type, this);
            }
            this.listenersByGroup.remove((Object)group);
        }
    }

    private static final String createEventId(String eventType, String group) {
        return eventType + (group != null ? "." + group : "");
    }

    private static boolean dispatchToTargets(Event event, List<AbstractSceneNode> targetList, boolean capturing, boolean atTargetPhase) {
        int start = 0;
        int inc = 1;
        int end = targetList.size();
        if (capturing) {
            start = targetList.size() - 1;
            end = -1;
            inc = -1;
        }
        for (int i = start; i != end && !event.propagationStopped && !event.immediatePropagationStopped; i += inc) {
            AbstractSceneNode.dispatchToTarget(event, targetList.get(i), capturing, atTargetPhase);
        }
        return !event.propagationStopped;
    }

    private static boolean dispatchToTarget(Event event, AbstractSceneNode currentTarget, boolean capturing, boolean atTargetPhase) {
        ArrayEx list;
        if (currentTarget.listenersByType != null && (list = (ArrayEx)currentTarget.listenersByType.get((Object)event.type)) != null) {
            list = list.slice();
            int currentListener = list.size();
            while (--currentListener >= 0) {
                ListenerInfo info = (ListenerInfo)list.get(currentListener);
                if (info.isRemoved || !atTargetPhase && info.capture != capturing) continue;
                event.currentTarget = currentTarget;
                info.listener.onEvent((SceneNode)currentTarget, event);
            }
        }
        return !event.propagationStopped;
    }

    public boolean dispatchEvent(Event event) {
        if (event == null) {
            throw new RuntimeException("Null event");
        }
        if (event.type == null || event.type.length() == 0) {
            throw new RuntimeException("Uninitialized event");
        }
        ArrayList<AbstractSceneNode> targetList = new ArrayList<AbstractSceneNode>();
        event.target = this;
        SceneNode targetParent = this.getParentNode();
        while (targetParent instanceof AbstractSceneNode) {
            targetList.add((AbstractSceneNode)targetParent);
            targetParent = targetParent.getParentNode();
        }
        event.eventPhase = 1;
        if (AbstractSceneNode.dispatchToTargets(event, targetList, true, false)) {
            event.eventPhase = 2;
            if (AbstractSceneNode.dispatchToTarget(event, this, false, true) && event.bubbles && !event.propagationStopped) {
                event.eventPhase = 3;
                AbstractSceneNode.dispatchToTargets(event, targetList, false, false);
            }
        }
        event.currentTarget = null;
        event.eventPhase = 0;
        return event.defaultPrevented;
    }

    public final Object getAttribute(String attribute) {
        return attribute != null ? this.attributes.get(attribute) : null;
    }

    public final void setSceneTreeContext(SceneTreeContext stc) {
        this.sceneTreeContext = stc;
        if (this.children != null) {
            for (SceneNode child : this.children) {
                ((AbstractSceneNode)child).setSceneTreeContext(stc);
            }
        }
    }

    protected void notifyAfterUpdate(int type, int subType, String key, Object toValue, Object fromValue) {
        if (this.sceneTreeContext != null) {
            if (this.sceneTreeContext.getCacheManager() != null) {
                this.sceneTreeContext.getCacheManager().afterUpdate(type, subType, key, toValue, fromValue, this);
            }
            if (this.sceneTreeContext.getRenderer() != null) {
                this.sceneTreeContext.getRenderer().handleDrawEvent(type, this);
            }
        }
    }

    public final Object getStyle(String attribute) {
        CSSStyle style = this.styleManager.getStyleByName(attribute);
        if (style != null && !style.fromAttribute) {
            return style.value != null ? style.value.toString() : "";
        }
        return "";
    }

    public final Object computeStyleValue(int id) {
        this.computeStylesToRoot();
        return this.styleManager.getComputedCSSStyle((int)id).value;
    }

    protected final CSSStyle computeCSSStyle(int id) {
        this.computeStylesToRoot();
        return this.styleManager.getComputedCSSStyle(id);
    }

    public final Object getComputedStyleValue(int id) {
        return this.styleManager.getComputedStyleValue(id);
    }

    protected final CSSStyle getComputedCSSStyle(int id) {
        return this.styleManager.getComputedCSSStyle(id);
    }

    public final Object getComputedStyle(String attribute) {
        this.computeStylesToRoot();
        CSSStyle cssStyle = this.styleManager.getComputedCSSStyle(SceneNodeDefaultStyles.getIndex(attribute));
        return cssStyle != null ? (cssStyle.value != null ? cssStyle.value.toString() : "") : Lang.undefined();
    }

    public final OMap<String, String> getComputedStyles() {
        this.computeStylesToRoot();
        OMap results = new OMap();
        for (Integer index : this.styleManager.computedStyles.keySet()) {
            String value;
            CSSStyle style = (CSSStyle)this.styleManager.computedStyles.get((Object)index);
            if (style.value instanceof String || style.value instanceof Number) {
                value = ObjectConverter.toString((Object)style.value);
            } else if (Lang.isArray((Object)style.value)) {
                value = "";
                Object[] array = (Object[])style.value;
                for (int i = 0; i < array.length; ++i) {
                    value = value + array[i].toString();
                    if (i >= array.length - 1) continue;
                    value = value + ",";
                }
            } else {
                value = style.value == null ? "" : style.value.toString();
            }
            results.put((Object)style.name, (Object)value);
        }
        return results;
    }

    protected void computeStylesToRoot() {
        SceneNode parentNode = this.getParentNode();
        if (parentNode != null) {
            ((AbstractSceneNode)parentNode).computeStylesToRoot();
        }
        this.computeStyles();
    }

    public final String getText() {
        String result = this.text;
        for (SceneNode child : this.getChildNodes()) {
            result = result + child.getText();
        }
        return result;
    }

    public final String getHtml() {
        StringBuilder builder = new StringBuilder();
        builder.append("<" + this.getName() + " " + this.attributes.serialize() + " " + this.styleManager.serialize());
        if (this.hasChildNodes()) {
            builder.append(">");
            for (SceneNode child : this.getChildNodes()) {
                builder.append(((AbstractSceneNode)child).getHtml());
            }
            builder.append(this.text + "</" + this.getName() + ">");
        } else if (this.text != null && this.text.length() > 0) {
            builder.append(">" + this.text + "</" + this.getName() + ">");
        } else {
            builder.append("/>");
        }
        return builder.toString();
    }

    public final void setHtml(String html) {
        String newValue;
        this.setDirty(true, true);
        this.html = newValue = html == null ? "" : html;
        this.notifyAfterUpdate(1000, 2003, "html", newValue, null);
    }

    public boolean addClass(String className) {
        return this.addClassAndUpdateClassAttr(className, true);
    }

    private boolean addClassAndUpdateClassAttr(String className, boolean updateClassAttr) {
        boolean added = false;
        String[] classes = className.split("\\s+");
        if (classes.length > 0) {
            if (this.classList == null) {
                this.classList = new ArrayList<String>();
            }
            String newClassName = null;
            for (String clazz : classes) {
                if (clazz.length() <= 0 || this.classList.contains(clazz)) continue;
                if (!added) {
                    added = true;
                    this.setDirty(true, true);
                    this.styleManager.setDirtyExternalStyles(true);
                    newClassName = (String)this.attributes.getByIndex(2);
                    if (newClassName == null) {
                        newClassName = "";
                    }
                }
                if (newClassName.length() > 0) {
                    newClassName = newClassName + " ";
                }
                newClassName = newClassName + clazz;
                this.classList.add(clazz);
                this.notifyAfterUpdate(1001, 2001, "class", clazz, null);
            }
            if (added && updateClassAttr) {
                this.attributes.setPropertyValue(2, newClassName);
            }
        }
        return added;
    }

    public boolean removeClass(String className) {
        String[] classes;
        boolean removed = false;
        if (this.classList != null && this.classList.size() > 0 && (classes = className.split("\\s+")).length > 0) {
            for (String clazz : classes) {
                if (clazz.length() <= 0 || !this.classList.contains(clazz)) continue;
                if (!removed) {
                    removed = true;
                    this.setDirty(true, true);
                    this.styleManager.setDirtyExternalStyles(true);
                }
                CollectionsUtil.remove(this.classList, (Object)clazz);
                this.notifyAfterUpdate(1002, 2001, "class", null, clazz);
            }
            if (removed) {
                this.attributes.setPropertyValue(2, Lang.join(this.classList, (String)" "));
            }
        }
        return removed;
    }

    public final boolean containsClass(String className) {
        String[] classes;
        if (this.classList == null) {
            return false;
        }
        for (String clazz : classes = className.trim().split("\\s")) {
            if (this.classList.contains(clazz.trim())) continue;
            return false;
        }
        return true;
    }

    public final String getNamespaceURI() {
        return this.namespaceURI;
    }

    public String getQualifiedName() {
        if (this.qname == null) {
            this.qname = this.namespaceURI + ":" + this.getName();
        }
        return this.qname;
    }

    public Object getAttributeNS(String namespace, String attribute) {
        return this.getAttribute(namespace + ":" + attribute);
    }

    public void setAttributeNS(String namespace, String attribute, Object value) {
        this.setAttribute(namespace + ":" + attribute, value);
    }

    public void removeAttribute(String attribute) {
        Object oldValue = this.attributes.get(attribute);
        if (oldValue == null) {
            return;
        }
        this.setAttribute(attribute, null);
        this.notifyAfterUpdate(1002, 2000, attribute, null, oldValue);
    }

    public void removeAttributeNS(String namespace, String attribute) {
        this.removeAttribute(namespace + ":" + attribute);
    }

    public final void removeStyle(String styleName) {
        this.styleManager.removeStyle(styleName);
    }

    public final void computeStyles() {
        this.styleManager.computeStyles();
    }

    public Object getProperty(String key) {
        return this.propertyBag != null ? this.propertyBag.get((Object)key) : null;
    }

    public final List<String> getClassList() {
        if (this.classList == null) {
            this.classList = new ArrayList<String>();
        }
        return this.classList;
    }

    protected final OMap<String, Object> getPropertyBag() {
        if (this.propertyBag == null) {
            this.propertyBag = new OMap();
        }
        return this.propertyBag;
    }

    public final void setParentNode(SceneNode parent) {
        SceneTreeContext r;
        boolean rendererSet = false;
        if (this.sceneTreeContext == null && parent != null && (r = ((AbstractSceneNode)parent).sceneTreeContext) != null) {
            this.setSceneTreeContext(r);
            rendererSet = true;
        }
        if (this.sceneTreeContext != null && this.sceneTreeContext.getRenderer() != null) {
            if (this.parent == null && parent != null || rendererSet) {
                this.recursiveRegisterEventListeners();
            } else if (this.parent != null && parent == null) {
                this.recursiveUnregisterEventListeners();
            }
            if (parent == null) {
                this.setSceneTreeContext(null);
            }
        }
        this.parent = parent;
    }

    public final SceneNode getOwner() {
        if (this.owner != null) {
            return this.owner;
        }
        SceneNode p = this.getParentNode();
        return p == null ? null : p.getOwner();
    }

    public final void setOwner(SceneNode owner) {
        this.owner = owner;
    }

    Matrix computeCTM(SceneNode context, boolean isScreenCTM) {
        SceneNode parent;
        AbstractSceneNode abstractContext = (AbstractSceneNode)context;
        Matrix ctm = MatrixUtil.identity();
        Matrix t = (Matrix)abstractContext.computeStyleValue(11);
        if (t != null) {
            ctm = t;
        }
        if ((parent = context.getParentNode()) != null) {
            Matrix pctm;
            Matrix matrix = pctm = isScreenCTM ? parent.getScreenCTM() : parent.getCTM();
            if (pctm != null) {
                if (ctm == null) {
                    ctm = pctm;
                } else if (!MatrixUtil.isIdentityMatrix((Matrix)pctm)) {
                    ctm = pctm.multiply(ctm);
                }
            }
        }
        return ctm != null ? ctm : MatrixUtil.identity();
    }

    private void recursiveRegisterEventListeners() {
        if (this.eventListeners != null) {
            AbstractRenderer renderer = this.sceneTreeContext.getRenderer();
            for (String type : this.eventListeners.keySet()) {
                renderer.registerEvent(type, this);
            }
        }
        if (this.children != null) {
            for (SceneNode child : this.children) {
                ((AbstractSceneNode)child).recursiveRegisterEventListeners();
            }
        }
    }

    private void recursiveUnregisterEventListeners() {
        if (this.eventListeners != null) {
            AbstractRenderer renderer = this.sceneTreeContext.getRenderer();
            for (String type : this.eventListeners.keySet()) {
                renderer.unregisterEvent(type, this);
            }
        }
        if (this.children != null) {
            for (SceneNode child : this.children) {
                ((AbstractSceneNode)child).recursiveUnregisterEventListeners();
            }
        }
    }

    private void internalRemoveChild(SceneNode child) {
        int idx = this.children.indexOf(child);
        if (idx >= 0) {
            this.children.remove(idx);
        }
    }

    private int internalAppendChild(SceneNode item) {
        if (this.children == null) {
            this.createChildren();
        }
        this.setDirty(true, true);
        if (item.getParentNode() != null) {
            item.getParentNode().removeChild(item);
        }
        this.children.add(item);
        item.setParentNode((SceneNode)this);
        return this.children.size() - 1;
    }

    private int insertChildBefore(SceneNode item, SceneNode before) {
        if (this.children == null) {
            this.createChildren();
        }
        int bidx = this.children.indexOf(before);
        if (before != null && bidx >= 0) {
            if (item == before) {
                return bidx;
            }
            this.setDirty(true, true);
            this.internalRemoveChild(item);
            bidx = this.children.indexOf(before);
            item.setParentNode((SceneNode)this);
            this.children.add(bidx, item);
            return bidx;
        }
        this.setDirty(true, true);
        this.children.add(item);
        item.setParentNode((SceneNode)this);
        return this.children.size() - 1;
    }

    private SceneNode getSibling(int offset) {
        SceneNode sibling = null;
        if (this.parent != null) {
            List c = this.parent.getChildNodes();
            int idx = c.indexOf((Object)this);
            int idxOffset = idx + offset;
            if (idx > -1 && idxOffset >= 0 && idxOffset < c.size()) {
                sibling = (SceneNode)c.get(idxOffset);
            }
        }
        return sibling;
    }

    private void _detectHits(ArrayEx<SceneNode> list, RectStruct rectangle) {
        if (this._hitDetectionEntryTest()) {
            return;
        }
        if (this.intersects(rectangle)) {
            if (this.hasChildNodes()) {
                List<SceneNode> childNodes = this.getChildrenArray();
                for (int i = childNodes.size() - 1; i >= 0; --i) {
                    AbstractSceneNode child;
                    Matrix ctm = (Matrix)(child = (AbstractSceneNode)childNodes.get(i)).getComputedStyleValue(11);
                    child._detectHits(list, ctm != null ? MatrixUtil.transformBounds((RectStruct)rectangle, (Matrix)ctm.inverse()) : rectangle);
                }
            } else if (!"none".equals(this.getComputedStyleValue(42))) {
                list.add((Object)this);
            }
        }
    }

    private AbstractSceneNode _detectHit(RectStruct rectangle) {
        if (this._hitDetectionEntryTest()) {
            return null;
        }
        if (this.intersects(rectangle)) {
            if (this.hasChildNodes()) {
                List<SceneNode> childNodes = this.getChildrenArray();
                for (int i = childNodes.size() - 1; i >= 0; --i) {
                    AbstractSceneNode child;
                    Matrix ctm = (Matrix)(child = (AbstractSceneNode)childNodes.get(i)).getComputedStyleValue(11);
                    AbstractSceneNode hit = child._detectHit(ctm != null ? MatrixUtil.transformBounds((RectStruct)rectangle, (Matrix)ctm.inverse()) : rectangle);
                    if (hit == null) continue;
                    return hit;
                }
            } else if (!"none".equals(this.getComputedStyleValue(42))) {
                return this;
            }
            return this.getParentNode() == null ? this : null;
        }
        return null;
    }

    private boolean _hitDetectionEntryTest() {
        return !this.isVisible() || "none".equals(this.getComputedStyleValue(26));
    }

    protected boolean intersects(RectStruct rect) {
        if ("none".equals(this.computeStyleValue(26)) || "none".equals(this.getComputedStyleValue(42)) || !this.intersectsClip(rect)) {
            return false;
        }
        RaveRect r = this.getBBox();
        return r.intersects(rect);
    }

    protected final boolean intersectsClip(RectStruct rect) {
        ClipPathSceneItem clip = (ClipPathSceneItem)NodeUtil.findSceneNode(this, (String)this.getComputedStyleValue(44), new int[]{1014});
        return clip == null || clip.intersects(rect);
    }

    public final ArrayEx<SceneNode> intersectionList(RectStruct r) {
        ArrayEx list = new ArrayEx();
        this._detectHits((ArrayEx<SceneNode>)list, r);
        return list;
    }

    public final SceneNode intersection(double x, double y) {
        return this._detectHit(new RectStruct(x, y, 0.5, 0.5));
    }

    public void initExtensions() {
        this.setPropertyExt = SET_PROPERTY_EXT;
        this.removePropertyExt = REMOVE_PROPERTY_EXT;
        this.appendChildExt = APPEND_CHILD_EXT;
        this.getParentNodeExt = PARENT_NODE_EXT;
        this.insertBeforeExt = INSERT_BEFORE_EXT;
        this.getNextSiblingExt = GET_NEXT_SIBLING_EXT;
        this.getPreviousSiblingExt = GET_PREVIOUS_SIBLING_EXT;
        this.getFirstChildExt = GET_FIRST_CHILD;
        this.hasChildNodesExt = HAS_CHILD_NODES_EXT;
        this.getChildNodesExt = GET_CHILD_NODES_EXT;
        this.removeChildExt = REMOVE_CHILD_EXT;
        this.setStyleExt = SET_STYLE_EXT;
        this.setAttributeExt = SET_ATTRIBUTE_EXT;
        this.setTextExt = SET_TEXT_EXT;
        this.getCTMExt = GET_CTM_EXT;
        this.getScreenCTMExt = GET_SCREEN_CTM_EXT;
    }

    public int getSiblingIndex() {
        return this.parent.getChildNodes().indexOf((Object)this);
    }

    public abstract void paint(AbstractRenderer var1);

    public void postPaint(AbstractRenderer renderer) {
    }

    public boolean isDrawable() {
        return true;
    }

    public double getSizePx(CSSSize size) {
        double value = 0.0;
        if (size != null) {
            value = size.value;
            switch (size.unit.type) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    value = 37.795275590399996 * value;
                    break;
                }
                case 3: {
                    value = 96.0 * value;
                    break;
                }
                case 6: {
                    value = 1.3333333344 * value;
                    break;
                }
                case 7: {
                    value = 16.0000000032 * value;
                    break;
                }
                case 5: {
                    value = 3.7795275551999996 * value;
                }
            }
        }
        return value;
    }

    public double getComputedSizePx(int styleId) {
        return this.getSizePx((CSSSize)this.getComputedCSSStyle((int)styleId).value);
    }

    public RaveRect getBBox() {
        if (this.invalidLayout) {
            this.layout();
        }
        if (this.cachedBBox == null) {
            this.cachedBBox = this.calculateBBox();
        }
        return this.cachedBBox;
    }

    protected abstract RaveRect calculateBBox();

    public RaveRect getBoundingClientRectBBox() {
        return this.getBBox();
    }

    public final void layout() {
        if (this.invalidLayout) {
            this.computeStylesToRoot();
            this.doLayout();
        }
        this.invalidLayout = false;
    }

    protected void invalidateLayout() {
        this.invalidLayout = true;
        this.cachedBBox = null;
        AbstractSceneNode parent = this;
        if ((parent = parent.getParentNode()) != null && !parent.invalidLayout) {
            parent.invalidateLayout();
        }
    }

    private void invalidateTransform() {
        this.cachedBoundingClientRect = null;
        this.cachedScreenCTM = null;
        this.cachedCTM = null;
        if (this.hasChildNodes()) {
            for (SceneNode child : this.getChildrenArray()) {
                ((AbstractSceneNode)child).invalidateTransform();
            }
        }
    }

    public NodeRect getBoundingClientRect() {
        if (this.invalidLayout) {
            this.layout();
        }
        if (this.cachedBoundingClientRect == null) {
            RaveRect bb = this.getBoundingClientRectBBox();
            double ownerLeft = 0.0;
            double ownerTop = 0.0;
            if (this.getOwner() != this) {
                NodeRect ownerRect = this.getOwner().getBoundingClientRect();
                ownerLeft = ownerRect.left;
                ownerTop = ownerRect.top;
            }
            RectStruct bstruct = MatrixUtil.transformBounds((RectStruct)new RectStruct(bb.x, bb.y, bb.width, bb.height), (Matrix)this.getCTM());
            double left = bstruct.x + ownerLeft;
            double right = left + bstruct.width;
            double top = bstruct.y + ownerTop;
            double bottom = top + bstruct.height;
            this.cachedBoundingClientRect = new NodeRect(left, right, bottom, top, bstruct.width, bstruct.height);
        }
        return this.cachedBoundingClientRect;
    }

    protected abstract void doLayout();

    public boolean isVisible() {
        return this.styleManager.isVisible();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty_, boolean invalidateLayout) {
        if (dirty_) {
            boolean notifyChildren = false;
            if (!this.dirty) {
                this.dirty = true;
                notifyChildren = true;
                switch (this.getDrawType()) {
                    case -1: 
                    case 1004: 
                    case 1015: {
                        break;
                    }
                    default: {
                        if (this.sceneTreeContext == null || this.sceneTreeContext.getRenderer() == null) break;
                        this.sceneTreeContext.getRenderer().makeDirty(this);
                    }
                }
            }
            if (invalidateLayout) {
                this.invalidateLayout();
                this.invalidateTransform();
            }
            if (notifyChildren && this.hasChildNodes()) {
                for (SceneNode child : this.getChildrenArray()) {
                    ((AbstractSceneNode)child).setDirty(true, false);
                }
            }
        } else {
            this.dirty = false;
        }
    }

    public List<SceneNode> getChildrenArray() {
        return this.children;
    }

    public ShadowStyle getShadow() {
        return ShadowStyle.parse(this.getProperty("_rave_drop_shadow"));
    }

    private static class ListenerInfo {
        final String id;
        final String type;
        final EventListener listener;
        final boolean capture;
        boolean isRemoved;

        ListenerInfo(String id, String type, EventListener listener, boolean capture) {
            this.id = id;
            this.type = type;
            this.listener = listener;
            this.capture = capture;
        }
    }
}

