/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.render.internal.nodes;

import com.ibm.rave.core.css.CSSSize;
import com.ibm.rave.core.geom.RaveRect;
import com.ibm.rave.core.geom.RectStruct;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.render.AbstractRenderer;
import com.ibm.rave.render.internal.nodes.AbstractSceneNode;
import com.ibm.rave.render.internal.nodes.GeometricHelper;
import java.util.ArrayList;

public class RectSceneItem
extends AbstractSceneNode {
    protected double x;
    protected double y;
    protected double width;
    protected double height;
    protected double rx;
    protected double ry;

    public RectSceneItem(String nsuri, SceneNode context) {
        super(nsuri, context);
    }

    @Override
    protected RaveRect calculateBBox() {
        return new RaveRect(this.x, this.y, this.width, this.height);
    }

    public int getDrawType() {
        return 1000;
    }

    public String getName() {
        return "rect";
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public double getRx() {
        return this.rx;
    }

    public double getRy() {
        return this.ry;
    }

    @Override
    protected boolean intersects(RectStruct rect) {
        double rx = this.getRx();
        double ry = this.getRy();
        if (rx < 1.0 && ry < 1.0) {
            return super.intersects(rect);
        }
        double x = this.getX();
        double y = this.getY();
        double w = this.getWidth();
        double h = this.getHeight();
        rx = rx == 0.0 ? ry : rx;
        double d = ry = ry == 0.0 ? rx : ry;
        if (rx > w / 2.0) {
            rx = w / 2.0;
        }
        if (ry > h / 2.0) {
            ry = h / 2.0;
        }
        double kappa = 0.5522848;
        double ox = rx * kappa;
        double oy = ry * kappa;
        double xe = x + w;
        double ye = y + h;
        GeometricHelper.PathHandler pathHandler = new GeometricHelper.PathHandler();
        pathHandler.moveTo(x + rx, y);
        pathHandler.lineTo(x + w - rx, y);
        pathHandler.bezierCurveTo(xe - rx + ox, y, xe, y + ry - oy, xe, y + ry);
        pathHandler.lineTo(x + w, y + h - ry);
        pathHandler.bezierCurveTo(xe, ye - ry + oy, xe - rx + ox, ye, xe - rx, ye);
        pathHandler.lineTo(x + rx, y + h);
        pathHandler.bezierCurveTo(x + rx - ox, ye, x, ye - ry + oy, x, ye - ry);
        pathHandler.lineTo(x, y + ry);
        pathHandler.bezierCurveTo(x, y + ry - oy, x + rx - ox, y, x + rx, y);
        pathHandler.closePath();
        ArrayList<GeometricHelper.PathShape> shapes = pathHandler.getShapes();
        return shapes.get(0).intersect(rect) && this.intersectsClip(rect);
    }

    @Override
    public void paint(AbstractRenderer renderer) {
        renderer.setStrokeAndFill(this);
        renderer.drawRect(this);
    }

    @Override
    public void doLayout() {
        this.x = this.getSizePx((CSSSize)this.getComputedCSSStyle((int)0).value);
        this.y = this.getSizePx((CSSSize)this.getComputedCSSStyle((int)1).value);
        this.width = this.getSizePx((CSSSize)this.getComputedCSSStyle((int)2).value);
        this.height = this.getSizePx((CSSSize)this.getComputedCSSStyle((int)3).value);
        this.rx = this.getSizePx((CSSSize)this.getComputedCSSStyle((int)12).value);
        this.ry = this.getSizePx((CSSSize)this.getComputedCSSStyle((int)13).value);
    }
}

