/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.render.internal.nodes;

import com.ibm.rave.codegenerator.annotations.SwiftWeak;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.css.CSSStyleDeclaration;
import com.ibm.rave.core.css.CSSStyleRule;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.internal.css.CSSStyle;
import com.ibm.rave.core.internal.nativeImpl.Lang;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.render.internal.DefaultStyleValueConverter;
import com.ibm.rave.render.internal.css.collector.CSSStyleRuleCollector;
import com.ibm.rave.render.internal.nodes.AbstractSceneNode;
import com.ibm.rave.render.internal.properties.SceneNodeDefaultStyles;
import com.ibm.rave.render.internal.properties.SceneNodeStyles;
import com.ibm.rave.render.internal.style.ShorthandStyle;
import java.util.ArrayList;
import java.util.List;

public class SceneNodeStyleManager {
    private OMap<Integer, CSSStyle> changedStyles = null;
    private OMap<Integer, CSSStyle> importantChangedStyles = null;
    final OMap<Integer, CSSStyle> computedStyles = new OMap();
    private final OMap<Integer, CSSStyle> styles = new OMap();
    @SwiftWeak
    private final AbstractSceneNode node;
    private boolean invalidStyles = true;
    private boolean dirtyExternalStyles = true;
    private boolean dirtyInlineStyles = true;
    private static final Object EXTERNAL_STYLE_OWNER = new Object();
    private static final CSSStyle INVALIDATE_STYLE = new CSSStyle(-1, null, true);

    public SceneNodeStyleManager(AbstractSceneNode abstractSceneNode) {
        this.node = abstractSceneNode;
    }

    private void updateStyle(CSSStyle style, int index, boolean important, Object newValue, Object rawValue, String name) {
        this.styles.put((Object)index, (Object)style);
        this.dirtyInlineStyles = true;
        if (important) {
            if (this.importantChangedStyles == null) {
                this.importantChangedStyles = new OMap();
            }
            this.importantChangedStyles.put((Object)index, (Object)style);
            if (this.changedStyles != null) {
                this.changedStyles.remove((Object)index);
            }
        } else {
            if (this.changedStyles == null) {
                this.changedStyles = new OMap();
            }
            this.changedStyles.put((Object)index, (Object)style);
            if (this.importantChangedStyles != null) {
                this.importantChangedStyles.remove((Object)index);
            }
        }
        if (style != null) {
            style.value = newValue;
            style.rawValue = rawValue;
            style.important = important;
            style.fromAttribute = false;
        } else {
            this.dirtyExternalStyles = true;
        }
        this.node.setDirty(true, SceneNodeStyles.isLayoutStyle(index));
        Object oldValue = style != null ? style.value : null;
        this.node.notifyAfterUpdate(1000, 2002, name, newValue, oldValue);
    }

    void computeStyles() {
        if (this.dirtyInlineStyles || this.dirtyExternalStyles || this.invalidStyles) {
            ArrayList<Integer> inheritableStyleChanges = null;
            if (this.dirtyInlineStyles) {
                CSSStyle cstyle;
                int styleId;
                CSSStyle style;
                if (this.importantChangedStyles != null) {
                    for (Integer key : this.importantChangedStyles.keySet()) {
                        style = (CSSStyle)this.importantChangedStyles.get((Object)key);
                        styleId = style.id;
                        cstyle = (CSSStyle)this.computedStyles.get((Object)styleId);
                        if (cstyle == null || cstyle == INVALIDATE_STYLE || cstyle.owner != this.node) {
                            cstyle = style;
                            this.computedStyles.put((Object)cstyle.id, (Object)style);
                        }
                        if (!this.node.hasChildNodes() || !cstyle.inheritable) continue;
                        if (inheritableStyleChanges == null) {
                            inheritableStyleChanges = new ArrayList();
                        }
                        inheritableStyleChanges.add(styleId);
                    }
                    this.importantChangedStyles = null;
                }
                if (this.changedStyles != null) {
                    for (Integer key : this.changedStyles.keySet()) {
                        style = (CSSStyle)this.changedStyles.get((Object)key);
                        styleId = key;
                        cstyle = (CSSStyle)this.computedStyles.get((Object)styleId);
                        if (cstyle != null && cstyle.important) continue;
                        if (style == null) {
                            if (cstyle == null || cstyle.owner != this.node) continue;
                            this.computedStyles.put((Object)styleId, (Object)INVALIDATE_STYLE);
                            if (this.node.hasChildNodes() && cstyle.inheritable) {
                                if (inheritableStyleChanges == null) {
                                    inheritableStyleChanges = new ArrayList();
                                }
                                inheritableStyleChanges.add(styleId);
                            }
                            cstyle = null;
                            this.invalidStyles = true;
                            continue;
                        }
                        if (cstyle != null && cstyle != INVALIDATE_STYLE && cstyle.owner == this.node) continue;
                        cstyle = style;
                        this.computedStyles.put((Object)styleId, (Object)cstyle);
                        if (!this.node.hasChildNodes() || !cstyle.inheritable) continue;
                        if (inheritableStyleChanges == null) {
                            inheritableStyleChanges = new ArrayList();
                        }
                        inheritableStyleChanges.add(styleId);
                    }
                    this.changedStyles = null;
                }
            }
            if (this.dirtyExternalStyles || this.invalidStyles) {
                CSSStyle[] externalStyles = null;
                AbstractSceneNode parentNode = (AbstractSceneNode)this.node.getParentNode();
                int len = SceneNodeStyles.propertyNames.size();
                for (int i = 0; i < len; ++i) {
                    CSSStyle style = (CSSStyle)this.computedStyles.get((Object)i);
                    if (style != null && style == INVALIDATE_STYLE && this.node.hasChildNodes() && style.inheritable) {
                        if (inheritableStyleChanges == null) {
                            inheritableStyleChanges = new ArrayList<Integer>();
                        }
                        inheritableStyleChanges.add(i);
                    }
                    if (this.dirtyExternalStyles) {
                        if (externalStyles == null) {
                            externalStyles = this.getExternalStyles();
                        }
                        if (externalStyles.length > 0 && externalStyles[i] != null) {
                            if (externalStyles[i].important || style == null || style == INVALIDATE_STYLE || style.owner != this.node || style.fromAttribute) {
                                style = externalStyles[i];
                                this.computedStyles.put((Object)i, (Object)style);
                            }
                        } else if (style != null && style.owner == EXTERNAL_STYLE_OWNER) {
                            style = null;
                            this.computedStyles.put((Object)i, (Object)style);
                        }
                    }
                    if (style == null || style == INVALIDATE_STYLE) {
                        style = null;
                        if (parentNode != null && SceneNodeDefaultStyles.defaultStyles[i].inheritable && parentNode.getDrawType() != -1) {
                            style = parentNode.getComputedCSSStyle(i);
                        }
                    }
                    if (style == null) {
                        style = SceneNodeDefaultStyles.defaultStyles[i];
                    }
                    this.computedStyles.put((Object)i, (Object)style);
                }
                this.invalidStyles = false;
            }
            if (inheritableStyleChanges != null) {
                for (SceneNode child : this.node.getChildrenArray()) {
                    AbstractSceneNode achild = (AbstractSceneNode)child;
                    for (Integer key : inheritableStyleChanges) {
                        CSSStyle childStyle = (CSSStyle)achild.styleManager.computedStyles.get((Object)key);
                        if (childStyle == null || childStyle.owner == child || childStyle.owner == EXTERNAL_STYLE_OWNER) continue;
                        achild.styleManager.computedStyles.put((Object)key, (Object)INVALIDATE_STYLE);
                        achild.styleManager.dirtyInlineStyles = true;
                        achild.styleManager.invalidStyles = true;
                    }
                }
            }
            this.dirtyInlineStyles = false;
            this.setDirtyExternalStyles(false);
        }
    }

    private CSSStyle[] getExternalStyles() {
        CSSStyle[] styleValues = null;
        List<CSSStyleRule> rules = CSSStyleRuleCollector.collectAll(this.node);
        if (rules.size() > 0) {
            styleValues = new CSSStyle[SceneNodeDefaultStyles.defaultStyles.length];
            for (CSSStyleRule rule : rules) {
                CSSStyleDeclaration style = rule.getStyle();
                int len = style.length();
                for (int i = 0; i < len; ++i) {
                    String item = style.item(i);
                    this.updateExternalStyle(item, styleValues, style.getPropertyValue(item), "important".equals(style.getPropertyPriority(item)));
                }
            }
        } else {
            styleValues = new CSSStyle[]{};
        }
        return styleValues;
    }

    private void updateExternalStyle(String item, CSSStyle[] styleValues, Object value1, boolean isImportant) {
        CSSStyle existingStyle;
        int id = SceneNodeDefaultStyles.getIndex(item);
        if (id != -1 && ((existingStyle = styleValues[id]) == null || isImportant && !existingStyle.important)) {
            Object value = DefaultStyleValueConverter.convert(id, item, value1);
            if (value instanceof ShorthandStyle) {
                for (String key : ((ShorthandStyle)value).getKeys()) {
                    this.updateExternalStyle(key, styleValues, ((ShorthandStyle)value).getValue(key), isImportant);
                }
            }
            if (value != null) {
                styleValues[id] = SceneNodeDefaultStyles.createCSSStyle(id, item);
                styleValues[id].owner = EXTERNAL_STYLE_OWNER;
                styleValues[id].value = value;
                styleValues[id].rawValue = value.toString();
                styleValues[id].important = isImportant;
            }
        }
    }

    void removeAllInlineStyles() {
        for (Integer key : this.styles.keySet()) {
            if (this.styles.get((Object)key) == null) continue;
            this.node.removeStyle((String)SceneNodeStyles.propertyNames.get(key.intValue()));
        }
    }

    void removeStyle(String styleName) {
        if (styleName != null) {
            String name = styleName.toLowerCase();
            int idx = SceneNodeDefaultStyles.getIndex(styleName);
            CSSStyle style = (CSSStyle)this.styles.get((Object)idx);
            if (style != null) {
                Object newValue;
                Object attrValue;
                boolean hasNewStyle = false;
                if (!style.fromAttribute && (attrValue = this.node.attributes.get(styleName)) != null && (newValue = DefaultStyleValueConverter.convert(idx, name, attrValue)) != null) {
                    style.value = newValue;
                    style.rawValue = newValue.toString();
                    style.fromAttribute = true;
                    style.important = false;
                    hasNewStyle = true;
                }
                if (!hasNewStyle) {
                    this.updateStyle(null, idx, false, null, null, name);
                    if (this.importantChangedStyles != null) {
                        this.importantChangedStyles.remove((Object)idx);
                    }
                }
            }
        }
    }

    void setStyle(SceneNode context, String styleName, Object value, String priority) {
        if (styleName != null) {
            if (value == null) {
                this.removeStyle(styleName);
            } else {
                Object newValue;
                CSSStyle oldCssStyle;
                AbstractSceneNode acontext = (AbstractSceneNode)context;
                String name = styleName.toLowerCase();
                int index = SceneNodeDefaultStyles.getIndex(name);
                if (!(index < 0 || (oldCssStyle = acontext.styleManager.getComputedCSSStyle(index)) != null && Lang.isEqual((Object)value, (Object)oldCssStyle.rawValue) || (newValue = DefaultStyleValueConverter.convert(index, name, value)) == null)) {
                    CSSStyle style;
                    boolean important;
                    boolean bl = important = priority != null && "important".equals(priority.toLowerCase());
                    if (newValue instanceof ShorthandStyle) {
                        for (String key : ((ShorthandStyle)newValue).getKeys()) {
                            acontext.setStyle(key, ((ShorthandStyle)newValue).getValue(key), priority);
                        }
                    }
                    if ((style = (CSSStyle)this.styles.get((Object)index)) == null) {
                        style = SceneNodeDefaultStyles.createCSSStyle(index, name);
                        style.owner = acontext;
                    }
                    this.updateStyle(style, index, important, newValue, value, name);
                }
            }
        }
    }

    final Object getComputedStyleValue(int id) {
        CSSStyle style = this.getComputedCSSStyle(id);
        return style == null ? null : style.value;
    }

    final CSSStyle getComputedCSSStyle(int id) {
        return (CSSStyle)this.computedStyles.get((Object)id);
    }

    final void setDirtyExternalStyles(boolean dirtyExternalStyles) {
        this.dirtyExternalStyles = dirtyExternalStyles;
    }

    final CSSStyle getStyleByName(String styleName) {
        return this.getStyleByIndex(SceneNodeDefaultStyles.getIndex(styleName));
    }

    final CSSStyle getStyleByIndex(int styleIndex) {
        return (CSSStyle)this.styles.get((Object)styleIndex);
    }

    public boolean isVisible() {
        return !"hidden".equals(this.getComputedStyleValue(45));
    }

    public String serialize() {
        ArrayEx result = new ArrayEx();
        for (Integer index : this.styles.keySet()) {
            CSSStyle val = (CSSStyle)this.styles.get((Object)index);
            if (val == null) continue;
            result.push((Object[])new String[]{val.name + ":" + val.value + ";"});
        }
        String str = "";
        if (result.size() > 0) {
            str = "style=\"" + result.join((Object)" ") + "\"";
        }
        return str;
    }
}

