/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.render.internal.nodes.cache;

import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.rave.codegenerator.annotations.SwiftClosure;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.scene.SceneNode;
import java.util.List;

public abstract class SceneNodeCache<V> {
    protected SceneNodeCacheFactory<V> factory;
    private final OMap<String, V> cache = new OMap();
    private final boolean _isReady = true;

    SceneNodeCache() {
    }

    protected boolean isReady() {
        return true;
    }

    protected V add(String key, SceneNode node) {
        if (!this.isReady() || key == null) {
            return null;
        }
        V container = this.get(key);
        if (container == null) {
            container = this.factory.create(node);
            this.cache.put((Object)key, container);
        }
        return container;
    }

    protected Object[] addMany(List<String> keys, SceneNode node) {
        Object[] setValues;
        if (!this.isReady() || keys == null) {
            return null;
        }
        for (Object key : setValues = keys.toArray()) {
            this.add((String)key, node);
        }
        return setValues;
    }

    protected V get(String key) {
        if (!this.isReady() || key == null) {
            return null;
        }
        return (V)this.cache.get((Object)key);
    }

    protected void remove(String key, SceneNode node) {
        if (!this.isReady() || key == null) {
            return;
        }
        this.cache.remove((Object)key);
    }

    protected void remove(List<String> keys, SceneNode node) {
        Object[] setValues;
        if (!this.isReady() || keys == null) {
            return;
        }
        for (Object key : setValues = keys.toArray()) {
            this.remove((String)key, node);
        }
    }

    @FunctionClass(value="create")
    @SwiftClosure(value="create")
    static interface SceneNodeCacheFactory<V> {
        public V create(SceneNode var1);
    }
}

