/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.render.internal.nodes.path;

import com.ibm.rave.core.geom.Path2DHandler;
import com.ibm.rave.core.internal.nativeImpl.Lang;

public final class Path2DParser {
    private final Path2DHandler path;
    private double currentX;
    private double currentY;
    private double xCenter;
    private double yCenter;
    private int idx;
    private String d;
    private int dLength;
    private boolean fail;
    private char currentChar = '\u0000';
    private int currentCharIdx = -1;

    public Path2DParser(Path2DHandler path) {
        this.path = path;
    }

    public void parse(String pathString) {
        if (pathString != null) {
            this.idx = 0;
            this.xCenter = this.yCenter = (double)0;
            this.currentY = this.yCenter;
            this.currentX = this.yCenter;
            this.currentChar = '\u0000';
            this.currentCharIdx = -1;
            this.d = pathString;
            this.dLength = pathString.length();
            this.path.startPath();
            block21: while (this.idx < this.dLength) {
                this.fail = false;
                this.skipWhitespace();
                switch (this.getChar(this.idx++)) {
                    case 'm': {
                        this._moveTo(false);
                        continue block21;
                    }
                    case 'M': {
                        this._moveTo(true);
                        continue block21;
                    }
                    case 'l': {
                        this._lineTo(false, true, true);
                        continue block21;
                    }
                    case 'L': {
                        this._lineTo(true, true, true);
                        continue block21;
                    }
                    case 'c': {
                        this._bezierCurveTo(false, false);
                        continue block21;
                    }
                    case 'C': {
                        this._bezierCurveTo(true, false);
                        continue block21;
                    }
                    case 's': {
                        this._bezierCurveTo(false, true);
                        continue block21;
                    }
                    case 'S': {
                        this._bezierCurveTo(true, true);
                        continue block21;
                    }
                    case 'q': {
                        this._quadraticCurveTo(false, false);
                        continue block21;
                    }
                    case 'Q': {
                        this._quadraticCurveTo(true, false);
                        continue block21;
                    }
                    case 't': {
                        this._quadraticCurveTo(false, true);
                        continue block21;
                    }
                    case 'T': {
                        this._quadraticCurveTo(true, true);
                        continue block21;
                    }
                    case 'h': {
                        this._lineTo(false, false, true);
                        continue block21;
                    }
                    case 'H': {
                        this._lineTo(true, false, true);
                        continue block21;
                    }
                    case 'v': {
                        this._lineTo(false, true, false);
                        continue block21;
                    }
                    case 'V': {
                        this._lineTo(true, true, false);
                        continue block21;
                    }
                    case 'a': {
                        this._arcTo(false);
                        continue block21;
                    }
                    case 'A': {
                        this._arcTo(true);
                        continue block21;
                    }
                    case 'Z': 
                    case 'z': {
                        this.path.closePath();
                        continue block21;
                    }
                }
                this.path.fail(this.idx - 1);
                return;
            }
        }
    }

    private void skipWhitespace() {
        block3: while (this.idx < this.dLength) {
            switch (this.getChar(this.idx)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    ++this.idx;
                    continue block3;
                }
            }
            return;
        }
    }

    private void skipWhitespaceComma() {
        this.skipWhitespace();
        if (this.idx < this.dLength && this.getChar(this.idx) == ',') {
            ++this.idx;
            this.skipWhitespace();
        }
    }

    private void sign() {
        char c;
        if (this.idx < this.dLength && ((c = this.getChar(this.idx)) == '-' || c == '+')) {
            ++this.idx;
        }
    }

    private void digitSequence(boolean optional) {
        boolean found = optional;
        block3: while (this.idx < this.dLength) {
            switch (this.getChar(this.idx)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    ++this.idx;
                    found = true;
                    continue block3;
                }
            }
            if (!optional && !found) {
                this.fail = true;
            }
            return;
        }
    }

    private void exponent() {
        char c;
        if (this.idx < this.dLength && ((c = this.getChar(this.idx)) == 'e' || c == 'E')) {
            ++this.idx;
            this.sign();
            this.digitSequence(false);
        }
    }

    private double parseNumber(int start) {
        this.digitSequence(true);
        if (this.idx < this.dLength && this.getChar(this.idx) == '.') {
            ++this.idx;
            this.digitSequence(false);
            if (this.fail) {
                return Double.NaN;
            }
        }
        if (this.idx < this.dLength) {
            this.exponent();
        }
        if (this.idx == start) {
            this.fail = true;
            return Double.NaN;
        }
        double result = Lang.parseNumber((String)this.d.substring(start, this.idx));
        this.fail = Double.isNaN(result);
        return result;
    }

    private double number() {
        int start = this.idx;
        this.sign();
        return this.parseNumber(start);
    }

    private double nonNegativeNumber() {
        int start = this.idx;
        if (this.idx < this.dLength && this.getChar(this.idx) == '+') {
            ++this.idx;
        }
        return this.parseNumber(start);
    }

    private double whitespaceCommaNumber() {
        this.skipWhitespaceComma();
        return this.number();
    }

    private double whitespaceOptCommaNumber(boolean noComma) {
        if (noComma) {
            this.skipWhitespace();
        } else {
            this.skipWhitespaceComma();
        }
        return this.number();
    }

    private double whitespaceCommaNonNegativeNumber() {
        this.skipWhitespaceComma();
        return this.nonNegativeNumber();
    }

    private double whitespaceOptCommaNonNegativeNumber(boolean firstNumber) {
        if (firstNumber) {
            this.skipWhitespace();
        } else {
            this.skipWhitespaceComma();
        }
        return this.nonNegativeNumber();
    }

    private boolean flag() {
        this.skipWhitespaceComma();
        boolean result = true;
        if (this.idx < this.dLength) {
            char c = this.getChar(this.idx);
            if (c == '0') {
                result = false;
            } else if (c != '1') {
                this.fail = true;
            }
        } else {
            this.fail = true;
        }
        if (!this.fail) {
            ++this.idx;
        }
        return result;
    }

    private void _moveTo(boolean absolute) {
        this.skipWhitespace();
        double x = this.number();
        if (this.fail) {
            return;
        }
        double y = this.whitespaceCommaNumber();
        if (this.fail) {
            return;
        }
        if (!absolute) {
            x += this.currentX;
            y += this.currentY;
        }
        this.path.moveTo(x, y);
        this.xCenter = this.currentX = x;
        this.yCenter = this.currentY = y;
        this.skipWhitespaceComma();
        this._lineTo(absolute, true, true);
    }

    private void _lineTo(boolean absolute, boolean vertical, boolean horizontal) {
        boolean noComma = true;
        while (true) {
            double x = 0.0;
            double y = 0.0;
            if (horizontal) {
                x = this.whitespaceOptCommaNumber(noComma);
                noComma = false;
                if (this.fail) {
                    return;
                }
                if (!absolute) {
                    x += this.currentX;
                }
            } else {
                x = this.currentX;
            }
            if (vertical) {
                y = this.whitespaceOptCommaNumber(noComma);
                if (this.fail) {
                    return;
                }
                if (!absolute) {
                    y += this.currentY;
                }
            } else {
                y = this.currentY;
            }
            this.path.lineTo(x, y);
            this.xCenter = this.currentX = x;
            this.yCenter = this.currentY = y;
            noComma = false;
        }
    }

    private void _quadraticCurveTo(boolean absolute, boolean usePreviousCP) {
        boolean noComma = true;
        while (true) {
            double cpy;
            double cpx;
            if (usePreviousCP) {
                cpx = 2.0 * this.currentX - this.xCenter;
                cpy = 2.0 * this.currentY - this.yCenter;
            } else {
                cpx = this.whitespaceOptCommaNumber(noComma);
                noComma = false;
                if (this.fail) {
                    return;
                }
                cpy = this.whitespaceCommaNumber();
                if (this.fail) {
                    return;
                }
            }
            double x = this.whitespaceOptCommaNumber(noComma);
            if (this.fail) {
                return;
            }
            double y = this.whitespaceCommaNumber();
            if (this.fail) {
                return;
            }
            if (!absolute) {
                x += this.currentX;
                y += this.currentY;
            }
            this.path.quadraticCurveTo(cpx, cpy, x, y);
            this.currentX = x;
            this.currentY = y;
            this.xCenter = cpx;
            this.yCenter = cpy;
            noComma = false;
        }
    }

    private void _bezierCurveTo(boolean absolute, boolean usePreviousCP) {
        boolean noComma = true;
        while (true) {
            double cpy1;
            double cpx1;
            if (usePreviousCP) {
                cpx1 = 2.0 * this.currentX - this.xCenter;
                cpy1 = 2.0 * this.currentY - this.yCenter;
            } else {
                cpx1 = this.whitespaceOptCommaNumber(noComma);
                noComma = false;
                if (this.fail) {
                    return;
                }
                cpy1 = this.whitespaceCommaNumber();
                if (this.fail) {
                    return;
                }
            }
            double cpx2 = this.whitespaceOptCommaNumber(noComma);
            if (this.fail) {
                return;
            }
            double cpy2 = this.whitespaceCommaNumber();
            if (this.fail) {
                return;
            }
            double x = this.whitespaceCommaNumber();
            if (this.fail) {
                return;
            }
            double y = this.whitespaceCommaNumber();
            if (this.fail) {
                return;
            }
            if (!absolute) {
                cpx1 += this.currentX;
                cpy1 += this.currentY;
                cpx2 += this.currentX;
                cpy2 += this.currentY;
                x += this.currentX;
                y += this.currentY;
            }
            this.path.bezierCurveTo(cpx1, cpy1, cpx2, cpy2, x, y);
            this.currentX = x;
            this.currentY = y;
            this.xCenter = cpx2;
            this.yCenter = cpy2;
            noComma = false;
        }
    }

    private void _arcTo(boolean absolute) {
        boolean noComma = true;
        while (true) {
            double rx = this.whitespaceOptCommaNonNegativeNumber(noComma);
            if (this.fail) {
                return;
            }
            double ry = this.whitespaceCommaNonNegativeNumber();
            if (this.fail) {
                return;
            }
            double xAxisRotation = this.whitespaceCommaNumber();
            if (this.fail) {
                return;
            }
            boolean largeArcFlag = this.flag();
            if (this.fail) {
                return;
            }
            boolean sweepFlag = this.flag();
            if (this.fail) {
                return;
            }
            double x = this.whitespaceCommaNumber();
            if (this.fail) {
                return;
            }
            double y = this.whitespaceCommaNumber();
            if (this.fail) {
                return;
            }
            if (!absolute) {
                x += this.currentX;
                y += this.currentY;
            }
            if (this.currentX != x || this.currentY != y) {
                if (rx == 0.0 || ry == 0.0) {
                    this.path.lineTo(x, y);
                } else {
                    this.path.arcTo(this.currentX, this.currentY, rx, ry, xAxisRotation, largeArcFlag, sweepFlag, x, y);
                }
                this.xCenter = this.currentX = x;
                this.yCenter = this.currentY = y;
            }
            noComma = false;
        }
    }

    private char getChar(int i) {
        if (this.currentCharIdx != i) {
            this.currentCharIdx = i;
            this.currentChar = this.d.charAt(i);
        }
        return this.currentChar;
    }
}

