/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.render.internal.nodes.path;

import com.ibm.rave.core.geom.Path2DHandler;
import com.ibm.rave.core.transform.Matrix;
import com.ibm.rave.core.transform.MatrixUtil;

public final class Path2DUtil {
    private Path2DUtil() {
    }

    public static void arcToBezier(Path2DHandler path, double x0, double y0, double rx, double ry, double xAxisRotation, boolean largeArcFlag, boolean sweepFlag, double x, double y) {
        double ryAbs;
        double Pry;
        double Py1;
        double angle = xAxisRotation % 360.0;
        double dx2 = (x0 - x) / 2.0;
        double dy2 = (y0 - y) / 2.0;
        double angleRad = angle / 180.0 * Math.PI;
        double cosAngle = Math.cos(angleRad);
        double sinAngle = Math.sin(angleRad);
        double x1 = cosAngle * dx2 + sinAngle * dy2;
        double y1 = -sinAngle * dx2 + cosAngle * dy2;
        double Px1 = x1 * x1;
        double rxAbs = Math.abs(rx);
        double Prx = rxAbs * rxAbs;
        double radiiCheck = Px1 / Prx + (Py1 = y1 * y1) / (Pry = (ryAbs = Math.abs(ry)) * ryAbs);
        if (radiiCheck > 1.0) {
            rxAbs = Math.sqrt(radiiCheck) * rxAbs;
            ryAbs = Math.sqrt(radiiCheck) * ryAbs;
            Prx = rxAbs * rxAbs;
            Pry = ryAbs * ryAbs;
        }
        double sign = largeArcFlag == sweepFlag ? -1.0 : 1.0;
        double sq = (Prx * Pry - Prx * Py1 - Pry * Px1) / (Prx * Py1 + Pry * Px1);
        sq = sq < 0.0 ? 0.0 : sq;
        double coef = sign * Math.sqrt(sq);
        double cx1 = coef * (rxAbs * y1 / ryAbs);
        double cy1 = coef * -(ryAbs * x1 / rxAbs);
        double sx2 = (x0 + x) / 2.0;
        double sy2 = (y0 + y) / 2.0;
        double cx = sx2 + (cosAngle * cx1 - sinAngle * cy1);
        double cy = sy2 + (sinAngle * cx1 + cosAngle * cy1);
        double ux = (x1 - cx1) / rxAbs;
        double uy = (y1 - cy1) / ryAbs;
        double vx = (-x1 - cx1) / rxAbs;
        double vy = (-y1 - cy1) / ryAbs;
        double n = Math.sqrt(ux * ux + uy * uy);
        double p = ux;
        sign = uy < 0.0 ? -1.0 : 1.0;
        double angleStart = sign * Math.acos(p / n) * 180.0 / Math.PI;
        n = Math.sqrt((ux * ux + uy * uy) * (vx * vx + vy * vy));
        p = ux * vx + uy * vy;
        sign = ux * vy - uy * vx < 0.0 ? -1.0 : 1.0;
        double angleExtent = sign * Math.acos(p / n) * 180.0 / Math.PI;
        if (!sweepFlag && angleExtent > 0.0) {
            angleExtent -= 360.0;
        } else if (sweepFlag && angleExtent < 0.0) {
            angleExtent += 360.0;
        }
        double[] bezierPoints = Path2DUtil.arcToBeziers(angleStart %= 360.0, angleExtent %= 360.0);
        Matrix m = MatrixUtil.identity();
        MatrixUtil.mapPoints((double[])bezierPoints, (Matrix)m.scaleNonUniform(rxAbs, ryAbs));
        MatrixUtil.mapPoints((double[])bezierPoints, (Matrix)m.rotate(angle));
        MatrixUtil.mapPoints((double[])bezierPoints, (Matrix)m.translate(cx, cy));
        bezierPoints[bezierPoints.length - 2] = x;
        bezierPoints[bezierPoints.length - 1] = y;
        for (int i = 0; i < bezierPoints.length; i += 6) {
            path.bezierCurveTo(bezierPoints[i], bezierPoints[i + 1], bezierPoints[i + 2], bezierPoints[i + 3], bezierPoints[i + 4], bezierPoints[i + 5]);
        }
    }

    private static double[] arcToBeziers(double angleStart, double angleExtent) {
        int numSegments = (int)Math.ceil(Math.abs(angleExtent) / 90.0);
        double angleStartRad = angleStart / 180.0 * Math.PI;
        double angleExtentRad = angleExtent / 180.0 * Math.PI;
        double angleIncrement = angleExtentRad / (double)numSegments;
        double controlLength = 1.3333333333333333 * Math.sin(angleIncrement / 2.0) / (1.0 + Math.cos(angleIncrement / 2.0));
        double[] coords = new double[numSegments * 6];
        int pos = 0;
        for (int i = 0; i < numSegments; ++i) {
            double angle = angleStartRad + (double)i * angleIncrement;
            double dx = Math.cos(angle);
            double dy = Math.sin(angle);
            coords[pos++] = dx - controlLength * dy;
            coords[pos++] = dy + controlLength * dx;
            dx = Math.cos(angle += angleIncrement);
            dy = Math.sin(angle);
            coords[pos++] = dx + controlLength * dy;
            coords[pos++] = dy - controlLength * dx;
            coords[pos++] = dx;
            coords[pos++] = dy;
        }
        return coords;
    }
}

