/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.render.internal.select.jsoup.parser;

import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.rave.core.context.RaveContextManager;
import com.ibm.rave.core.internal.nativeImpl.RegExp;
import com.ibm.rave.render.internal.select.jsoup.helper.StringUtil;

public class TokenQueue {
    private final String queue;
    private int pos = 0;
    private static final char ESC = '\\';
    private static final char NIL = '\u0000';
    @InlineStringConstant
    private static final String TOKEN_QUEUE_REG_EXP_KEY = "TOKEN_QUEUE_REG_EXP_KEY";

    private static RegExp getTokenQueueRegExp() {
        RegExp regexp = (RegExp)RaveContextManager.INSTANCE.getRaveContext().getData(TOKEN_QUEUE_REG_EXP_KEY);
        if (regexp == null) {
            regexp = new RegExp("[A-Z\\d]", "i");
            RaveContextManager.INSTANCE.getRaveContext().putData(TOKEN_QUEUE_REG_EXP_KEY, (Object)regexp);
        }
        return regexp;
    }

    public TokenQueue(String data) {
        this.queue = data;
    }

    public boolean isEmpty() {
        return this.remainingLength() == 0;
    }

    private int remainingLength() {
        return this.queue.length() - this.pos;
    }

    public boolean matches(String seq) {
        return StringUtil.regionMatches(this.queue, true, this.pos, seq, 0, seq.length());
    }

    public boolean matchesCS(String seq) {
        return StringUtil.startsWith(this.queue, seq, this.pos);
    }

    public boolean matchesAny(String ... seq) {
        for (String s : seq) {
            if (!this.matches(s)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesAnyChar(char ... cs) {
        char c = this.queue.charAt(this.pos);
        for (int i = 0; i < cs.length; ++i) {
            if (cs[i] != c) continue;
            return true;
        }
        return false;
    }

    public boolean matchesChar(char cs) {
        return this.queue.charAt(this.pos) == cs;
    }

    public boolean matchChomp(String seq) {
        if (this.matches(seq)) {
            this.pos += seq.length();
            return true;
        }
        return false;
    }

    public boolean matchCharChomp(char c) {
        if (this.matchesChar(c)) {
            ++this.pos;
            return true;
        }
        return false;
    }

    public boolean matchesWhitespace() {
        return !this.isEmpty() && StringUtil.isWhitespace(this.queue.charAt(this.pos));
    }

    public boolean matchesWord() {
        char c = this.queue.charAt(this.pos);
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9';
    }

    public char consume() {
        return this.queue.charAt(this.pos++);
    }

    public void consume(String seq) {
        int len = seq.length();
        this.pos += len;
    }

    public String consumeTo(String seq) {
        int offset = this.queue.indexOf(seq, this.pos);
        if (offset != -1) {
            String consumed = this.queue.substring(this.pos, offset);
            this.pos += consumed.length();
            return consumed;
        }
        return this.remainder();
    }

    public String consumeToAny(String ... seq) {
        int start = this.pos;
        while (!this.isEmpty() && !this.matchesAny(seq)) {
            ++this.pos;
        }
        String data = this.queue.substring(start, this.pos);
        return data;
    }

    public String chompTo(String seq) {
        String data = this.consumeTo(seq);
        this.matchChomp(seq);
        return data;
    }

    public String chompBalanced(char open, char close) {
        int start = -1;
        int end = -1;
        int depth = 0;
        int last = 0;
        while (!this.isEmpty()) {
            char c = this.consume();
            if (last == 0 || last != 92) {
                if (c == open) {
                    ++depth;
                    if (start == -1) {
                        start = this.pos;
                    }
                } else if (c == close) {
                    --depth;
                }
            }
            if (depth > 0 && last != 0) {
                end = this.pos;
            }
            last = c;
            if (depth > 0) continue;
        }
        return end >= 0 ? this.queue.substring(start, end) : "";
    }

    public static String unescape(String text) {
        String out = "";
        char last = '\u0000';
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\\') {
                if (last != '\u0000' && last == '\\') {
                    out = out + c;
                }
            } else {
                out = out + c;
            }
            last = c;
        }
        return out.toString();
    }

    public boolean consumeWhitespace() {
        boolean seen = false;
        while (this.matchesWhitespace()) {
            ++this.pos;
            seen = true;
        }
        return seen;
    }

    public String consumeWord() {
        int start = this.pos;
        while (this.matchesWord()) {
            ++this.pos;
        }
        return this.queue.substring(start, this.pos);
    }

    public String consumeTagName() {
        int start = this.pos;
        while (!this.isEmpty() && (this.matchesWord() || this.matchesAnyChar(':', '_', '-'))) {
            ++this.pos;
        }
        return this.queue.substring(start, this.pos);
    }

    public String consumeElementSelector() {
        int start = this.pos;
        while (!this.isEmpty() && (this.matchesWord() || this.matchesAnyChar('|', '_', '-'))) {
            ++this.pos;
        }
        return this.queue.substring(start, this.pos);
    }

    public String consumeCssIdentifier() {
        int start = this.pos;
        while (!this.isEmpty() && (this.matchesWord() || this.matchesAnyChar('-', '_'))) {
            ++this.pos;
        }
        return this.queue.substring(start, this.pos);
    }

    public String consumeAttributeKey() {
        int start = this.pos;
        while (!this.isEmpty() && (this.matchesWord() || this.matchesAnyChar('-', '_', ':'))) {
            ++this.pos;
        }
        return this.queue.substring(start, this.pos);
    }

    public String remainder() {
        String remainder = this.queue.substring(this.pos, this.queue.length());
        this.pos = this.queue.length();
        return remainder;
    }
}

