/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.render.internal.select.jsoup.select;

import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.context.RaveContextManager;
import com.ibm.rave.core.internal.nativeImpl.RegExp;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.render.internal.select.jsoup.parser.TokenQueue;
import com.ibm.rave.render.internal.select.jsoup.select.CombiningEvaluator;
import com.ibm.rave.render.internal.select.jsoup.select.Evaluator;
import com.ibm.rave.render.internal.select.jsoup.select.StructuralEvaluator;
import java.util.ArrayList;
import java.util.List;

public class QueryParser {
    private static final char[] combinators = new char[]{',', '>', '+', '~', ' '};
    private static final String[] AttributeEvals = new String[]{"=", "!=", "^=", "$=", "*=", "~="};
    @InlineStringConstant
    private static final String QUERY_PARSER_REG_EXP_KEY = "QUERY_PARSER_REG_EXP_KEY";
    private final TokenQueue tq;
    private List<Evaluator> evals = new ArrayList<Evaluator>();

    private QueryParserRegExps getQueryParserRegExps() {
        QueryParserRegExps queryParserRegExps = (QueryParserRegExps)RaveContextManager.INSTANCE.getRaveContext().getData(QUERY_PARSER_REG_EXP_KEY);
        if (queryParserRegExps == null) {
            queryParserRegExps = new QueryParserRegExps();
            RaveContextManager.INSTANCE.getRaveContext().putData(QUERY_PARSER_REG_EXP_KEY, (Object)queryParserRegExps);
        }
        return queryParserRegExps;
    }

    private QueryParser(String query) {
        this.tq = new TokenQueue(query);
    }

    public static Evaluator parse(String query) {
        QueryParser p = new QueryParser(query);
        return p.parse();
    }

    Evaluator parse() {
        this.tq.consumeWhitespace();
        if (this.tq.matchesAnyChar(combinators)) {
            this.evals.add(new StructuralEvaluator.Root());
            this.combinator(this.tq.consume());
        } else if (!this.findElements()) {
            return null;
        }
        while (!this.tq.isEmpty()) {
            boolean seenWhite = this.tq.consumeWhitespace();
            if (this.tq.matchesAnyChar(combinators)) {
                this.combinator(this.tq.consume());
                continue;
            }
            if (seenWhite) {
                this.combinator(' ');
                continue;
            }
            if (this.findElements()) continue;
            return null;
        }
        if (this.evals.size() == 1) {
            return this.evals.get(0);
        }
        return new CombiningEvaluator.And(this.evals);
    }

    private void combinator(char combinator) {
        Evaluator rootEval;
        Evaluator currentEval;
        this.tq.consumeWhitespace();
        String subQuery = this.consumeSubQuery();
        Evaluator newEval = QueryParser.parse(subQuery);
        boolean replaceRightMost = false;
        if (this.evals.size() == 1) {
            currentEval = this.evals.get(0);
            rootEval = currentEval;
            if (rootEval instanceof CombiningEvaluator.Or && combinator != ',') {
                currentEval = ((CombiningEvaluator.Or)currentEval).rightMostEvaluator();
                replaceRightMost = true;
            }
        } else {
            rootEval = currentEval = new CombiningEvaluator.And(this.evals);
        }
        this.evals = new ArrayList<Evaluator>();
        if (combinator == '>') {
            currentEval = new CombiningEvaluator.And((List<Evaluator>)new ArrayEx((Object[])new Evaluator[]{newEval, new StructuralEvaluator.ImmediateParent(currentEval)}));
        } else if (combinator == ' ') {
            currentEval = new CombiningEvaluator.And((List<Evaluator>)new ArrayEx((Object[])new Evaluator[]{newEval, new StructuralEvaluator.Parent(currentEval)}));
        } else if (combinator == '+') {
            currentEval = new CombiningEvaluator.And((List<Evaluator>)new ArrayEx((Object[])new Evaluator[]{newEval, new StructuralEvaluator.ImmediatePreviousSibling(currentEval)}));
        } else if (combinator == '~') {
            currentEval = new CombiningEvaluator.And((List<Evaluator>)new ArrayEx((Object[])new Evaluator[]{newEval, new StructuralEvaluator.PreviousSibling(currentEval)}));
        } else if (combinator == ',') {
            CombiningEvaluator.Or or;
            if (currentEval instanceof CombiningEvaluator.Or) {
                or = (CombiningEvaluator.Or)currentEval;
                or.add(newEval);
            } else {
                or = new CombiningEvaluator.Or(null);
                or.add(currentEval);
                or.add(newEval);
            }
            currentEval = or;
        } else {
            return;
        }
        if (replaceRightMost) {
            ((CombiningEvaluator.Or)rootEval).replaceRightMostEvaluator(currentEval);
        } else {
            rootEval = currentEval;
        }
        this.evals.add(rootEval);
    }

    private String consumeSubQuery() {
        String sq = "";
        while (!this.tq.isEmpty()) {
            if (this.tq.matchesChar('(')) {
                sq = sq + "(" + this.tq.chompBalanced('(', ')') + ")";
                continue;
            }
            if (this.tq.matchesChar('[')) {
                sq = sq + "[" + this.tq.chompBalanced('[', ']') + "]";
                continue;
            }
            if (this.tq.matchesAnyChar(combinators)) break;
            sq = sq + this.tq.consume();
        }
        return sq;
    }

    private boolean findElements() {
        if (this.tq.matchCharChomp('.')) {
            this.byClass();
        } else if (this.tq.matchCharChomp('#')) {
            this.byId();
        } else if (this.tq.matchCharChomp('*')) {
            this.allElements();
        } else if (this.tq.matchesChar('[')) {
            this.byAttribute();
        } else if (this.tq.matchesWord()) {
            this.byTag();
        } else {
            if (this.tq.matchesChar(':')) {
                if (this.tq.matchChomp(":lt(")) {
                    this.indexLessThan();
                } else if (this.tq.matchChomp(":gt(")) {
                    this.indexGreaterThan();
                } else if (this.tq.matchChomp(":eq(")) {
                    this.indexEquals();
                } else if (this.tq.matches(":has(")) {
                    this.has();
                } else if (this.tq.matches(":contains(")) {
                    this.contains(false);
                } else if (this.tq.matches(":containsOwn(")) {
                    this.contains(true);
                } else if (this.tq.matches(":matches(")) {
                    this.matches(false);
                } else if (this.tq.matches(":matchesOwn(")) {
                    this.matches(true);
                } else if (this.tq.matches(":not(")) {
                    this.not();
                } else if (this.tq.matchChomp(":nth-child(")) {
                    this.cssNthChild(false, false);
                } else if (this.tq.matchChomp(":nth-last-child(")) {
                    this.cssNthChild(true, false);
                } else if (this.tq.matchChomp(":nth-of-type(")) {
                    this.cssNthChild(false, true);
                } else if (this.tq.matchChomp(":nth-last-of-type(")) {
                    this.cssNthChild(true, true);
                } else if (this.tq.matchChomp(":first-child")) {
                    this.evals.add(new Evaluator.IsFirstChild());
                } else if (this.tq.matchChomp(":last-child")) {
                    this.evals.add(new Evaluator.IsLastChild());
                } else if (this.tq.matchChomp(":first-of-type")) {
                    this.evals.add(new Evaluator.IsNthOfType(0, 1));
                } else if (this.tq.matchChomp(":last-of-type")) {
                    this.evals.add(new Evaluator.IsNthLastOfType(0, 1));
                } else if (this.tq.matchChomp(":only-child")) {
                    this.evals.add(new Evaluator.IsOnlyChild());
                } else if (this.tq.matchChomp(":only-of-type")) {
                    this.evals.add(new Evaluator.IsOnlyOfType());
                } else if (this.tq.matchChomp(":empty")) {
                    this.evals.add(new Evaluator.IsEmpty());
                } else if (this.tq.matchChomp(":root")) {
                    this.evals.add(new Evaluator.IsRoot());
                } else {
                    return false;
                }
                return true;
            }
            return false;
        }
        return true;
    }

    private void byId() {
        String id = this.tq.consumeCssIdentifier();
        this.evals.add(new Evaluator.Id(id));
    }

    private void byClass() {
        String className = this.tq.consumeCssIdentifier();
        this.evals.add(new Evaluator.Class(className.trim()));
    }

    private void byTag() {
        String tagName = this.tq.consumeElementSelector();
        if (tagName.contains("|")) {
            tagName = tagName.replace("|", ":");
        }
        this.evals.add(new Evaluator.Tag(tagName.trim()));
    }

    private void byAttribute() {
        TokenQueue cq = new TokenQueue(this.tq.chompBalanced('[', ']'));
        String key = cq.consumeToAny(AttributeEvals);
        cq.consumeWhitespace();
        if (cq.isEmpty()) {
            this.evals.add(new Evaluator.Attribute(key));
        } else if (cq.matchChomp("=")) {
            this.evals.add(new Evaluator.AttributeWithValue(key, cq.remainder()));
        } else if (cq.matchChomp("!=")) {
            this.evals.add(new Evaluator.AttributeWithValueNot(key, cq.remainder()));
        } else if (cq.matchChomp("^=")) {
            this.evals.add(new Evaluator.AttributeWithValueStarting(key, cq.remainder()));
        } else if (cq.matchChomp("$=")) {
            this.evals.add(new Evaluator.AttributeWithValueEnding(key, cq.remainder()));
        } else if (cq.matchChomp("*=")) {
            this.evals.add(new Evaluator.AttributeWithValueContaining(key, cq.remainder()));
        } else if (cq.matchChomp("~=")) {
            this.evals.add(new Evaluator.AttributeWithValueMatching(key, new RegExp(cq.remainder(), "i")));
        } else {
            return;
        }
    }

    private void allElements() {
        this.evals.add(new Evaluator.AllElements());
    }

    private void indexLessThan() {
        this.evals.add(new Evaluator.IndexLessThan(this.consumeIndex()));
    }

    private void indexGreaterThan() {
        this.evals.add(new Evaluator.IndexGreaterThan(this.consumeIndex()));
    }

    private void indexEquals() {
        this.evals.add(new Evaluator.IndexEquals(this.consumeIndex()));
    }

    private void cssNthChild(boolean backwards, boolean ofType) {
        int b;
        int a;
        String argS = this.tq.chompTo(")").trim().toLowerCase();
        QueryParserRegExps queryParserRegExps = this.getQueryParserRegExps();
        RegExp.RegExpResult mAB = queryParserRegExps.NTH_AB.exec(argS);
        RegExp.RegExpResult mB = queryParserRegExps.NTH_B.exec(argS);
        if ("odd".equals(argS)) {
            a = 2;
            b = 1;
        } else if ("even".equals(argS)) {
            a = 2;
            b = 0;
        } else if (mAB != null && mAB.size() > 0) {
            a = mAB.get(3) != null ? ObjectConverter.toInt((Object)((String)mAB.get(1)).replaceFirst("^\\+", "")) : 1;
            b = mAB.get(4) != null ? ObjectConverter.toInt((Object)((String)mAB.get(4)).replaceFirst("^\\+", "")) : 1;
        } else if (mB != null && mB.size() > 0) {
            a = 0;
            b = ObjectConverter.toInt((Object)((String)mB.get(0)).replaceFirst("^\\+", ""));
        } else {
            return;
        }
        if (ofType) {
            if (backwards) {
                this.evals.add(new Evaluator.IsNthLastOfType(a, b));
            } else {
                this.evals.add(new Evaluator.IsNthOfType(a, b));
            }
        } else if (backwards) {
            this.evals.add(new Evaluator.IsNthLastChild(a, b));
        } else {
            this.evals.add(new Evaluator.IsNthChild(a, b));
        }
    }

    private int consumeIndex() {
        String indexS = this.tq.chompTo(")").trim();
        return Integer.parseInt(indexS);
    }

    private void has() {
        this.tq.consume(":has");
        String subQuery = this.tq.chompBalanced('(', ')');
        this.evals.add(new StructuralEvaluator.Has(QueryParser.parse(subQuery)));
    }

    private void contains(boolean own) {
        this.tq.consume(own ? ":containsOwn" : ":contains");
        String searchText = TokenQueue.unescape(this.tq.chompBalanced('(', ')'));
        if (own) {
            this.evals.add(new Evaluator.ContainsOwnText(searchText));
        } else {
            this.evals.add(new Evaluator.ContainsText(searchText));
        }
    }

    private void matches(boolean own) {
        this.tq.consume(own ? ":matchesOwn" : ":matches");
        String regex = this.tq.chompBalanced('(', ')');
        if (own) {
            this.evals.add(new Evaluator.MatchesOwn(new RegExp(regex, "")));
        } else {
            this.evals.add(new Evaluator.Matches(new RegExp(regex, "")));
        }
    }

    private void not() {
        this.tq.consume(":not");
        String subQuery = this.tq.chompBalanced('(', ')');
        this.evals.add(new StructuralEvaluator.Not(QueryParser.parse(subQuery)));
    }

    private static class QueryParserRegExps {
        final RegExp NTH_AB = new RegExp("((\\+|-)?(\\d+)?)n(\\s*(\\+|-)?\\s*\\d*)?", "i");
        final RegExp NTH_B = new RegExp("(\\+|-)?(\\d+)", "");

        private QueryParserRegExps() {
        }
    }
}

