/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.ext.geo.tile;

import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.internal.util.MathUtil;

@FunctionClass(value="tile")
public class TileLayout {
    private double[] sizeVal = new double[]{960.0, 500.0};
    private double scaleVal = 256.0;
    private double[] translateVal = new double[]{this.sizeVal[0] / 2.0, this.sizeVal[1] / 2.0};
    private double zoomDeltaVal = 0.0;

    public TilesData tile() {
        final TilesData tiles = new TilesData();
        double z = Math.max(Math.log(this.scaleVal) / MathUtil.LN2 - 8.0, 0.0);
        final double z0 = Math.round(z + this.zoomDeltaVal);
        double k = Math.pow(2.0, z - z0 + 8.0);
        double[] origin = new double[]{(this.translateVal[0] - this.scaleVal / 2.0) / k, (this.translateVal[1] - this.scaleVal / 2.0) / k};
        final ArrayEx cols = Rave.range((Object)Math.max(0.0, Math.floor(-origin[0])), (Object)Math.max(0.0, Math.ceil(this.sizeVal[0] / k - origin[0])));
        ArrayEx rows = Rave.range((Object)Math.max(0.0, Math.floor(-origin[1])), (Object)Math.max(0.0, Math.ceil(this.sizeVal[1] / k - origin[1])));
        rows.forEach((ArrayEx.ArrayValueFunction)new ArrayEx.ArrayValueFunction<Number, Object>(){

            public Object getValue(final Number y, int index, ArrayEx<Number> array) {
                cols.forEach((ArrayEx.ArrayValueFunction)new ArrayEx.ArrayValueFunction<Number, Object>(){

                    public Object getValue(Number x, int index, ArrayEx<Number> array) {
                        tiles.push(new ArrayEx[]{new ArrayEx((Object[])new Double[]{x.doubleValue(), y.doubleValue(), z0})});
                        return null;
                    }
                });
                return null;
            }
        });
        tiles.translate = origin;
        tiles.scale = k;
        return tiles;
    }

    public double[] size() {
        return this.sizeVal;
    }

    public TileLayout size(double[] newSize) {
        this.sizeVal = newSize;
        return this;
    }

    public double scale() {
        return this.scaleVal;
    }

    public TileLayout scale(double newScaleVal) {
        this.scaleVal = newScaleVal;
        return this;
    }

    public double[] translate() {
        return this.translateVal;
    }

    public TileLayout translate(double[] newTranslateVal) {
        this.translateVal = newTranslateVal;
        return this;
    }

    public double zoomDelta() {
        return this.zoomDeltaVal;
    }

    public TileLayout zoomDelta(double newZoomDeltaVal) {
        this.zoomDeltaVal = newZoomDeltaVal;
        return this;
    }

    public static class TilesData
    extends ArrayEx<ArrayEx<Double>> {
        public double scale;
        public double[] translate;
    }
}

