/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.ext.statistics;

import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.rave.core.ExtensionFactory;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.context.RaveContextManager;
import com.ibm.rave.ext.statistics.outliersUtility.PeirceCriterion;
import java.util.List;

public final class RaveStatistics {
    public static final String STATISTICS = "statistics";
    @InlineStringConstant
    private static final String EXTENSION_REGISTRATION_STATUS_KEY = "RAVESTATISTICS_EXTENSION_REGISTRATION_STATUS_KEY";

    private RaveStatistics() {
    }

    public PeirceCriterion peirceCriterion() {
        return new PeirceCriterion();
    }

    public ArrayEx<Integer> outliers(List<Number> data) {
        return this.peirceCriterion().outliers(data);
    }

    private static RegistrationStatus getRegistrationStatus() {
        RegistrationStatus registrationStatus = (RegistrationStatus)RaveContextManager.INSTANCE.getRaveContext().getData(EXTENSION_REGISTRATION_STATUS_KEY);
        if (registrationStatus == null) {
            registrationStatus = new RegistrationStatus();
            RaveContextManager.INSTANCE.getRaveContext().putData(EXTENSION_REGISTRATION_STATUS_KEY, (Object)registrationStatus);
        }
        return registrationStatus;
    }

    public static boolean init() {
        RegistrationStatus registrationStatus = RaveStatistics.getRegistrationStatus();
        if (!registrationStatus.registered) {
            registrationStatus.registered = Rave.capabilities.extension(STATISTICS, (ExtensionFactory)new ExtensionFactory<RaveStatistics>(){

                public RaveStatistics create() {
                    return new RaveStatistics();
                }
            });
        }
        return registrationStatus.registered;
    }

    private static class RegistrationStatus {
        boolean registered = false;

        private RegistrationStatus() {
        }
    }
}

