/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.ext.symbol;

import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.context.RaveContextManager;
import com.ibm.rave.core.svg.SymbolCreator;

public final class RaveSymbol {
    public static final String RECTANLGE = "rectangle";
    public static final String HORIZONTAL_RECTANGLE = "horizontal-rectangle";
    public static final String VERTICAL_RECTANGLE = "vertical-rectangle";
    public static final String TRIANGLE_LEFT = "triangle-left";
    public static final String TRIANGLE_RIGHT = "triangle-right";
    public static final String STAR = "star";
    public static final String DONUT = "donut";
    public static final String DONUTPLUS = "donutPlus";
    public static final String PENTAGON = "pentagon";
    @InlineStringConstant
    private static final String EXTENSION_REGISTRATION_STATUS_KEY = "RAVESYMBOL_EXTENSION_REGISTRATION_STATUS_KEY";

    private static RegistrationStatus getRegistrationStatus() {
        RegistrationStatus registrationStatus = (RegistrationStatus)RaveContextManager.INSTANCE.getRaveContext().getData(EXTENSION_REGISTRATION_STATUS_KEY);
        if (registrationStatus == null) {
            registrationStatus = new RegistrationStatus();
            RaveContextManager.INSTANCE.getRaveContext().putData(EXTENSION_REGISTRATION_STATUS_KEY, (Object)registrationStatus);
        }
        return registrationStatus;
    }

    public static boolean init() {
        RegistrationStatus registrationStatus = RaveSymbol.getRegistrationStatus();
        if (!registrationStatus.registered) {
            final double SQRT3 = Math.sqrt(3.0);
            SymbolCreator rect = new SymbolCreator(){

                public String create(double size) {
                    double r = Math.sqrt(size / 2.0) / 2.0;
                    double w = 2.0 * r;
                    return "M" + -w + "," + -r + "H" + w + "V" + r + "H" + -w + "Z";
                }
            };
            boolean status = Rave.svg.symbolCreator(RECTANLGE, rect);
            status &= Rave.svg.symbolCreator(HORIZONTAL_RECTANGLE, rect);
            status &= Rave.svg.symbolCreator(VERTICAL_RECTANGLE, new SymbolCreator(){

                public String create(double size) {
                    double r = Math.sqrt(size / 2.0) / 2.0;
                    double h = 2.0 * r;
                    return "M" + -r + "," + -h + "H" + r + "V" + h + "H" + -r + "Z";
                }
            });
            status &= Rave.svg.symbolCreator(TRIANGLE_LEFT, new SymbolCreator(){

                public String create(double size) {
                    double ry = Math.sqrt(size / SQRT3);
                    double rx = ry * SQRT3 / 2.0;
                    return "M" + -rx + ",0L" + rx + "," + -ry + " " + rx + "," + ry + "Z";
                }
            });
            status &= Rave.svg.symbolCreator(TRIANGLE_RIGHT, new SymbolCreator(){

                public String create(double size) {
                    double ry = Math.sqrt(size / SQRT3);
                    double rx = ry * SQRT3 / 2.0;
                    return "M" + rx + ",0L" + -rx + "," + ry + " " + -rx + "," + -ry + "Z";
                }
            });
            status &= Rave.svg.symbolCreator(STAR, new SymbolCreator(){

                public String create(double size) {
                    double outerRadius = Math.sqrt(size / Math.PI) * 1.5;
                    double innerRadius = outerRadius * 0.4;
                    String results = "M0," + outerRadius;
                    double angle = 0.6283185307179586;
                    for (int i = 0; i < 10; ++i) {
                        double r = (i & 1) == 0 ? outerRadius : innerRadius;
                        double currX = 0.0 + Math.cos((double)i * angle) * r;
                        double currY = 0.0 + Math.sin((double)i * angle) * r;
                        if (i == 0) {
                            results = "M " + currX + "," + currY;
                        }
                        results = results + " L " + currX + "," + currY;
                    }
                    results = results + " Z";
                    return results;
                }
            });
            status &= Rave.svg.symbolCreator(DONUT, new SymbolCreator(){

                public String create(double size) {
                    double r1 = Math.sqrt(size / Math.PI);
                    double r2 = r1 * 0.4;
                    String outer = "M0 0m-" + r1 + ",0a" + r1 + "," + r1 + ",0 1,0 " + r1 * 2.0 + ",0a " + r1 + "," + r1 + " 0 1,0 -" + r1 * 2.0 + ",0z";
                    String inner = "M0 0m-" + r2 + ",0a" + r2 + "," + r2 + ",0 0,1 " + r2 * 2.0 + ",0a " + r2 + "," + r2 + " 0 0,1 -" + r2 * 2.0 + ",0z";
                    return outer + inner;
                }
            });
            status &= Rave.svg.symbolCreator(DONUTPLUS, new SymbolCreator(){

                public String create(double size) {
                    double r = Math.sqrt(size / Math.PI);
                    String circle = "M0," + r + "A" + r + "," + r + " 0 1,1 0," + -r + "A" + r + "," + r + " 0 1,1 0," + r + "Z";
                    double r1 = Math.sqrt(size * 0.6 / Math.PI);
                    double r2 = r1 * 0.7;
                    String outer = "M0 0m-" + r1 + ",0a" + r1 + "," + r1 + ",0 1,0 " + r1 * 2.0 + ",0a " + r1 + "," + r1 + " 0 1,0 -" + r1 * 2.0 + ",0z";
                    String inner = "M0 0m-" + r2 + ",0a" + r2 + "," + r2 + ",0 0,1 " + r2 * 2.0 + ",0a " + r2 + "," + r2 + " 0 0,1 -" + r2 * 2.0 + ",0z";
                    return circle + outer + inner;
                }
            });
            status &= Rave.svg.symbolCreator(PENTAGON, new SymbolCreator(){

                public String create(double size) {
                    double radius = Math.sqrt(size / Math.PI);
                    String results = "M";
                    for (int i = 0; i < 5; ++i) {
                        double angle = (double)(i * 2) * Math.PI / 5.0 - 1.5707963267948966;
                        double currX = radius * Math.cos(angle);
                        double currY = radius * Math.sin(angle);
                        results = results + currX + "," + currY + " ";
                    }
                    return results;
                }
            });
            status &= Rave.svg.symbolCreator("compositeViewLegendLineSymbol", new SymbolCreator(){

                public String create(double size) {
                    double len = Math.sqrt(size) / 2.0;
                    double l3 = len / 3.0;
                    return "M" + -len + "," + len + "L" + -l3 + "," + (-l3 + 1.5) + " " + l3 + "," + (l3 + 1.5) + " " + len + "," + (-len + 3.0) + " " + len + "," + -len + " " + l3 + "," + (l3 - 1.5) + " " + -l3 + "," + (-l3 - 1.15) + " " + -len + "," + (len - 3.0) + "Z";
                }
            });
        }
        return registrationStatus.registered;
    }

    private static class RegistrationStatus {
        boolean registered = false;

        private RegistrationStatus() {
        }
    }
}

