/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.ext.text.internal.wrap;

import com.ibm.rave.ext.text.internal.wrap.TextData;
import com.ibm.rave.ext.text.internal.wrap.TextOperation;

public class WrapOperation
extends TextOperation {
    @Override
    protected void _doRun(TextData lines) {
        String[] words = this._splitTextIntoWords(this._text);
        if (words.length == 0) {
            return;
        }
        this.createContext();
        this._initFont(lines, this._font, this._fontSize);
        this._wrap(lines, words);
        lines.fontSize = this._fontSize;
    }

    @Override
    protected String _ellipsize(String text, TextData lines) {
        lines.clipped = false;
        boolean forceTruncation = lines.tooTall;
        if (!forceTruncation && this._measureText(text) <= this._width) {
            lines.truncated = false;
            return text;
        }
        return this._doEllipsize(text, lines);
    }

    @Override
    protected String _clip(String text, TextData lines) {
        String result = super._clip(text, lines);
        if (lines.tooTall) {
            lines.clipped = true;
        }
        return result;
    }

    @Override
    protected String _truncateOrClip(String testLine, TextData lines) {
        String line = super._truncateOrClip(testLine, lines);
        if (line == null && lines.tooTall && !lines.truncated) {
            lines.clipped = true;
        }
        return line;
    }

    protected void _wrap(TextData textData, String[] words) {
        int n;
        if (textData.lineHeight > this._height) {
            return;
        }
        String line = "";
        String space = "";
        double total_height = 0.0;
        boolean notClipped = true;
        for (n = 0; notClipped && n < words.length && total_height < this._height; ++n) {
            String testLine = line.concat(space).concat(words[n]);
            space = " ";
            if (this._measureText(testLine) > this._width) {
                if (this._measureText(words[n]) > this._width) {
                    this._truncateOrClip(testLine, textData);
                    if (textData.length() <= 0) {
                        return;
                    }
                    notClipped = false;
                    line = "";
                } else {
                    textData.add(line);
                    line = words[n];
                }
                total_height += textData.lineHeight;
                continue;
            }
            line = testLine;
        }
        if (n == words.length && total_height + textData.lineHeight <= this._height) {
            if (line.length() > 0) {
                this._truncateOrClip(line, textData);
            }
            return;
        }
        if (total_height > this._height) {
            int index = textData.length() - 1;
            textData.lines.remove(index);
            total_height -= textData.lineHeight;
        }
        int index = textData.length() - 1;
        line = textData.lines.get(index);
        textData.lines.remove(index);
        textData.tooTall = true;
        this._truncateOrClip(line, textData);
    }
}

