/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.ext.text.nativeImpl;

import com.ibm.rave.core.Rave;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.css.CSSStyleDeclaration;
import com.ibm.rave.core.css.CSSStyleRule;
import com.ibm.rave.core.css.CSSStyleSheet;
import com.ibm.rave.core.internal.css.CSSStyle;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.CallbackFunction;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.render.internal.properties.SceneNodeDefaultStyles;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.HashMap;
import java.util.List;

public class FontChecker
implements RunFunction<Selector> {
    private static final String FONT_FAMILY_SEPARATOR = ",";
    private static final String FONT_FAMILY_SELECTOR = ".vizlibrary";
    private static final String FONT_FAMILY = "font-family";
    private static final String FONT = "font";
    private static final String FONT_CHECKED = "fontChecked";
    private static final String FONT_ORIGINAL = "origFontFamily";
    private static final String FONT_FAMILY_SET = "fontFamilySet";
    private static HashMap<String, Font> FONTS = new HashMap();
    private static ArrayEx<Font> CSS_FONTS;
    private static boolean _noCSS_Fonts;
    public CallbackFunction<SceneNode> nodeFontChecker = new CallbackFunction<SceneNode>(){

        public void run(SceneNode node, Object data, int index, int group) {
            FontChecker.this.replaceLimitedFonts(node);
        }
    };

    public boolean replaceLimitedFonts(SceneNode textNode) {
        FontChecker.prepareFonts();
        if (_noCSS_Fonts) {
            return false;
        }
        String text = textNode.getText();
        if (text == null || "".equals(text)) {
            return false;
        }
        String fontProp = (String)textNode.getProperty(FONT_CHECKED);
        String familyName = (String)textNode.getStyle(FONT_FAMILY);
        if (fontProp != null && fontProp.equals(text)) {
            if (!FontChecker.fontHasChanged(textNode, familyName)) {
                return false;
            }
            textNode.removeProperty(FONT_CHECKED);
        }
        if ((fontProp = (String)textNode.getProperty(FONT_ORIGINAL)) != null) {
            textNode.setStyle(FONT_FAMILY, (Object)fontProp);
        }
        int CSS_Index = 0;
        boolean replaced = false;
        Font font = FontChecker.getFontFamily(familyName);
        if (font == null) {
            CSS_Index = 1;
            replaced = true;
            font = (Font)CSS_FONTS.get(0);
        }
        String newFamilyName = font.getFamily();
        textNode.setProperty(FONT_ORIGINAL, (Object)((String)textNode.getStyle(FONT_FAMILY)));
        int start = font.canDisplayUpTo(text);
        while (start >= 0 && CSS_Index < CSS_FONTS.length()) {
            if ((start = (font = (Font)CSS_FONTS.get(CSS_Index++)).canDisplayUpTo(text)) >= 0) continue;
            newFamilyName = font.getFamily();
            replaced = true;
        }
        if (replaced) {
            this.setFontStyle(textNode, newFamilyName);
        }
        textNode.setProperty(FONT_CHECKED, (Object)textNode.getText());
        textNode.setProperty(FONT_FAMILY_SET, (Object)FontChecker.cleanFamilyName(newFamilyName));
        return replaced;
    }

    public Object run(Selector text, Object ... args) {
        text.each(this.nodeFontChecker);
        return null;
    }

    private void setFontStyle(SceneNode textNode, String newFamilyName) {
        textNode.setStyle(FONT_FAMILY, (Object)newFamilyName, "important");
        String fontString = (String)textNode.getStyle(FONT);
        if (fontString == null || "".equals(fontString)) {
            CSSStyle style = SceneNodeDefaultStyles.defaultStyles[20];
            fontString = (String)style.rawValue;
        }
        if (fontString != null) {
            int pos = fontString.indexOf("/");
            pos = fontString.indexOf(" ", pos) + 1;
            fontString = fontString.substring(0, pos) + newFamilyName;
            textNode.setStyle(FONT, (Object)fontString, "important");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void prepareFonts() {
        if (FONTS.size() == 0) {
            HashMap<String, Font> hashMap = FONTS;
            synchronized (hashMap) {
                if (FONTS.size() == 0) {
                    CSS_FONTS = new ArrayEx();
                    HashMap<String, Object> systemFonts = new HashMap<String, Object>();
                    Font[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
                    for (Font font : fonts) {
                        String family = font.getFamily().toLowerCase();
                        if (FONTS.containsKey(family)) continue;
                        FONTS.put(family, font);
                    }
                    for (String string : GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
                        systemFonts.put(string.toLowerCase(), string);
                    }
                    ArrayEx styleSheets = Rave.css.styleSheets();
                    for (CSSStyleSheet styleSheet : styleSheets) {
                        List list = styleSheet.getCssRules();
                        for (CSSStyleRule rule : list) {
                            String[] fontNames;
                            CSSStyleDeclaration style;
                            String fontstr;
                            if (!FONT_FAMILY_SELECTOR.equals(rule.getSelectorText()) || (fontstr = (style = rule.getStyle()).getPropertyValue(FONT_FAMILY)) == null) continue;
                            for (String font : fontNames = fontstr.split(FONT_FAMILY_SEPARATOR)) {
                                if (!FONTS.containsKey(font = FontChecker.cleanFamilyName(font))) continue;
                                CSS_FONTS.add((Object)FONTS.get(font));
                            }
                        }
                    }
                    if (CSS_FONTS.length() > 0) {
                        _noCSS_Fonts = false;
                    }
                }
            }
        }
    }

    private static String cleanFamilyName(String name) {
        String fontName = name.trim();
        fontName = fontName.replaceAll("'", "");
        fontName = fontName.replaceAll("\"", "");
        return fontName.toLowerCase();
    }

    private static boolean fontHasChanged(SceneNode textNode, String familyName) {
        int pos;
        String fontString;
        String fontSet = (String)textNode.getProperty(FONT_FAMILY_SET);
        return fontSet == null || !fontSet.equals(FontChecker.cleanFamilyName(familyName)) || (fontString = (String)textNode.getStyle(FONT)) == null || (pos = fontString.indexOf("/")) <= 0 || !(fontString = fontString.substring(pos = fontString.indexOf(" ", pos) + 1, fontString.length())).equals(familyName);
    }

    private static Font getFontFamily(String families) {
        String[] choices;
        if (families == null) {
            return null;
        }
        String familyStr = families + FONT_FAMILY_SEPARATOR;
        for (String choice : choices = familyStr.split(FONT_FAMILY_SEPARATOR)) {
            Font found = FONTS.get(FontChecker.cleanFamilyName(choice));
            if (found == null) continue;
            return found;
        }
        return null;
    }

    static {
        _noCSS_Fonts = true;
    }
}

