/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.ext.text.wrap;

import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.css.CSSSize;
import com.ibm.rave.core.geom.Dim;
import com.ibm.rave.core.geom.Insets;
import com.ibm.rave.core.geom.RaveRect;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.CallbackFunction;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.ext.text.internal.wrap.FontStyleStruct;
import com.ibm.rave.ext.text.internal.wrap.TextData;
import com.ibm.rave.ext.text.internal.wrap.TextOperation;
import com.ibm.rave.ext.text.nativeImpl.FontChecker;
import java.util.List;

public class TextFlow
implements RunFunction<Selector> {
    public static final String CENTER = "center";
    public static final String RIGHT = "right";
    public static final String LEFT = "left";
    public static final String TOP = "top";
    public static final String BOTTOM = "bottom";
    public static final String MIDDLE = "middle";
    private static final String _CENTER = "middle";
    private static final String _RIGHT = "end";
    private static final String _LEFT = "start";
    private static final String _DY = "dy";
    private static final String _FONT_SIZE = "font-size";
    private static final String _FONT = "font";
    private static final String _LINE_HEIGHT = "line-height";
    private static final String _WIDTH = "width";
    private static final String _HEIGHT = "height";
    private static final String _X = "x";
    private static final String _Y = "y";
    private static final String _H_ALIGN = "text-anchor";
    private static final String _V_ALIGN = "alignment-baseline";
    private static final String _BIDI = "unicode-bidi";
    private static final String _BIDI_EMBED = "embed";
    private static final String _BIDI_OVERRIDE = "bidi-override";
    private static final String _DIRECTION = "direction";
    private static final String _LTR = "ltr";
    private static final String _NAME = "name";
    private static final String _TRANSFORM = "transform";
    private static final String _TSPAN = "tspan";
    private static final String FONT_STYLE = "font-style";
    private static final String FONT_VARIANT = "font-variant";
    private static final String FONT_WEIGHT = "font-weight";
    private static final String FONT_SIZE = "font-size";
    private static final String LINE_HEIGHT = "line-height";
    private static final String FONT_FAMILY = "font-family";
    public static final String TSPAN_TRANSFORM_MARKER = " translate(0.0000,0.0000)";
    private boolean _transformMarkerAdded = false;
    private static final double EM = 1.36;
    private static final Insets DEFAULT_PADDING = TextFlow._createInsets();
    private boolean _wrap = false;
    private boolean _fit = false;
    private boolean _truncate = false;
    private boolean _drop = true;
    private Integer _overflow_min = 0;
    private FontChecker _fontChecker;
    private ValueFunction<SceneNode, Integer> _overflow_minFn = null;
    private String _text_overflow = "...";
    private ValueFunction<SceneNode, String> _text_overflowFn = null;
    private boolean _alignement_set = false;
    private OMap<String, String> _current_styles;
    private String _alignment = "left";
    private ValueFunction<SceneNode, String> _alignmentFn = null;
    private String _valignment = "top";
    private ValueFunction<SceneNode, String> _valignmentFn = null;
    private Insets _padding = DEFAULT_PADDING;
    private ValueFunction<SceneNode, Insets> _paddingFn = null;
    private Double _lineSpacing = null;
    private ValueFunction<SceneNode, Double> _lineSpacingFn = null;
    private Dim _extent = null;
    private ValueFunction<SceneNode, Dim> _extentFn = new ValueFunction<SceneNode, Dim>(){

        public Dim getValue(SceneNode text_node, Object data, int index, int groupIndex) {
            RaveRect bBox = text_node.getBBox();
            CSSSize css_width = Rave.util.parseCSSSize(text_node.getAttribute(TextFlow._WIDTH));
            double width = css_width == null ? bBox.width : css_width.value;
            CSSSize css_heigth = Rave.util.parseCSSSize(text_node.getAttribute(TextFlow._HEIGHT));
            double height = css_heigth == null ? bBox.height : css_heigth.value;
            return new Dim(width, height);
        }
    };
    private Double _maxFontSize = Double.POSITIVE_INFINITY;
    private ValueFunction<SceneNode, Double> _maxFontSizeFn = null;
    private Double _minFontSize = 4.0;
    private ValueFunction<SceneNode, Double> _minFontSizeFn = null;

    public TextFlow dropTextOnFail(boolean drop_lines) {
        this._drop = drop_lines;
        return this;
    }

    public boolean dropTextOnFail() {
        return this._drop;
    }

    public boolean wrap() {
        return this._wrap;
    }

    public TextFlow wrap(boolean wrapping) {
        this._wrap = wrapping;
        return this;
    }

    public boolean fit() {
        return this._fit;
    }

    public TextFlow fit(boolean fitting) {
        this._fit = fitting;
        return this;
    }

    public boolean truncate() {
        return this._truncate;
    }

    public TextFlow truncate(boolean truncation) {
        this._truncate = truncation;
        return this;
    }

    public TextFlow truncationMinChars(ValueFunction<SceneNode, Integer> overflowMinFn) {
        this._overflow_minFn = overflowMinFn;
        this._overflow_min = null;
        return this;
    }

    public Object truncationMinChars() {
        return this._overflow_minFn == null ? this._overflow_min : this._overflow_minFn;
    }

    public TextFlow truncationMinChars(int minimum) {
        this._overflow_min = minimum;
        this._overflow_minFn = null;
        return this;
    }

    public TextFlow textTruncateIndicator(String ellipses) {
        this._text_overflow = ellipses;
        this._text_overflowFn = null;
        return this;
    }

    public TextFlow textTruncateIndicator(ValueFunction<SceneNode, String> ellipses) {
        this._text_overflowFn = ellipses;
        this._text_overflow = null;
        return this;
    }

    public Object textTruncateIndicator() {
        return this._text_overflow == null ? this._text_overflowFn : this._text_overflow;
    }

    public TextFlow extent(int width, int height) {
        this._extent = new Dim((double)width, (double)height);
        this._extentFn = null;
        return this;
    }

    public TextFlow extent(ValueFunction<SceneNode, Dim> extentFn) {
        this._extentFn = extentFn;
        this._extent = null;
        return this;
    }

    public Object extent() {
        return this._extent == null ? this._extentFn : this._extent;
    }

    public TextFlow spacing(double lineSpacing) {
        this._lineSpacing = lineSpacing;
        this._lineSpacingFn = null;
        return this;
    }

    public TextFlow spacing(ValueFunction<SceneNode, Double> lineSpacingFn) {
        this._lineSpacingFn = lineSpacingFn;
        this._lineSpacing = null;
        return this;
    }

    public Object spacing() {
        return this._lineSpacingFn == null ? this._lineSpacing : this._lineSpacingFn;
    }

    public TextFlow alignment(String h_alignment) {
        this._alignment = CENTER.equals(h_alignment) ? CENTER : (RIGHT.equals(h_alignment) ? RIGHT : LEFT);
        this._alignement_set = true;
        this._alignmentFn = null;
        return this;
    }

    public TextFlow alignment(ValueFunction<SceneNode, String> alignmentFn) {
        this._alignmentFn = alignmentFn;
        this._alignement_set = true;
        return this;
    }

    public Object alignment() {
        return this._alignmentFn == null ? this._alignment : this._alignmentFn;
    }

    public TextFlow valignment(String v_alignment) {
        this._valignment = "middle".equals(v_alignment) ? "middle" : (BOTTOM.equals(v_alignment) ? BOTTOM : TOP);
        this._valignmentFn = null;
        return this;
    }

    public TextFlow valignment(ValueFunction<SceneNode, String> alignmentFn) {
        this._valignmentFn = alignmentFn;
        this._valignment = null;
        return this;
    }

    public Object valignment() {
        return this._valignmentFn == null ? this._valignment : this._valignmentFn;
    }

    private static final Insets _createInsets() {
        Insets result = new Insets();
        result.top = 0;
        result.left = 0;
        result.bottom = 0;
        result.right = 0;
        return result;
    }

    public Object run(Selector text, Object ... args) {
        this.flow(text);
        return null;
    }

    public void flow(Selector text) {
        boolean wrap = this.wrap();
        final boolean fit = this.fit();
        final boolean truncate = this.truncate();
        final byte operation = (byte)((wrap ? 1 : 0) | (fit ? 2 : 0));
        final TextFlow self = this;
        if (this._fontChecker == null) {
            this._fontChecker = new FontChecker();
        }
        text.each((CallbackFunction)new CallbackFunction<SceneNode>(){

            public void run(SceneNode node, Object data, int index, int groupIndex) {
                boolean fontReplaced = self._fontChecker.replaceLimitedFonts(node);
                Object transform = node.getAttribute(TextFlow._TRANSFORM);
                transform = transform != null ? ObjectConverter.toString((Object)transform) : "";
                int markerPos = ((String)transform).indexOf(TextFlow.TSPAN_TRANSFORM_MARKER);
                if (markerPos != -1) {
                    if (markerPos == 0) {
                        node.removeAttribute(TextFlow._TRANSFORM);
                    } else {
                        transform = ((String)transform).substring(0, markerPos);
                        node.setAttribute(TextFlow._TRANSFORM, transform);
                    }
                }
                self._transformMarkerAdded = false;
                TextOperation text_operation = self._getOperation(operation, (SceneNode)(truncate ? node : null), data, index, groupIndex);
                if (text_operation == null) {
                    return;
                }
                text_operation.overflowMin(self._overflow_minFn != null ? (Integer)self._overflow_minFn.getValue((Object)node, data, index, groupIndex) : ObjectConverter.toInt((Object)self._overflow_min));
                self._current_styles = node.getComputedStyles();
                Insets insets = self._paddingFn != null ? (Insets)self._paddingFn.getValue((Object)node, data, index, groupIndex) : self._padding;
                Bounds bounds = self._getBounds(node, data, index, groupIndex, insets);
                text_operation.size(bounds.width, bounds.height);
                double font_size = self._calculateFontSize(node, data, index, groupIndex);
                text_operation.font(TextFlow.createFontStruct((OMap<String, String>)self._current_styles));
                text_operation.fontSize(font_size);
                text_operation.maxFontSize(self._maxFontSizeFn != null ? ((Double)self._maxFontSizeFn.getValue((Object)node, data, index, groupIndex)).doubleValue() : self._maxFontSize.doubleValue());
                text_operation.minFontSize(self._minFontSizeFn != null ? ((Double)self._minFontSizeFn.getValue((Object)node, data, index, groupIndex)).doubleValue() : self._minFontSize.doubleValue());
                double em = self._calculateSpacing(node, data, index, groupIndex, font_size);
                text_operation.em(em);
                String text = node.getText();
                int n = Rave.bidi.format.determineDirection(text);
                Rave.bidi.format.getClass();
                boolean rtl = n == 1;
                text_operation.text(text);
                TextData result = text_operation.run();
                List<String> lines = result.lines;
                if (lines.size() == 0) {
                    if (self.dropTextOnFail()) {
                        lines.add("");
                    } else {
                        lines.add(node.getText());
                    }
                }
                self._applyTextNodeAttributes(bounds.width, bounds.height, node, data, index, groupIndex, insets, rtl);
                if (fit || fontReplaced) {
                    String fontSize = (String)node.getStyle("font-size");
                    if (fontSize != null && fontSize != "" && !fontSize.equals(result.font.fontSize)) {
                        node.setStyle(TextFlow._FONT, null);
                    }
                    node.setStyle(TextFlow._FONT, (Object)result.font.toString(), "important");
                }
                self._generateTspans(result, bounds, node, data, index, groupIndex, rtl);
            }
        });
    }

    private static FontStyleStruct createFontStruct(OMap<String, String> style) {
        FontStyleStruct struct = new FontStyleStruct();
        struct.fontStyle = (String)style.get((Object)FONT_STYLE);
        struct.fontVariant = (String)style.get((Object)FONT_VARIANT);
        struct.fontWeight = (String)style.get((Object)FONT_WEIGHT);
        struct.fontSize = (String)style.get((Object)"font-size");
        struct.lineHeight = (String)style.get((Object)"line-height");
        struct.fontFamily = (String)style.get((Object)FONT_FAMILY);
        return struct;
    }

    protected Double _calculateSpacing(SceneNode node, Object data, int index, int groupIndex, double font_size) {
        if (this.spacing() == null) {
            double line_height;
            CSSSize styled_height = Rave.util.parseCSSSize(this._current_styles.get((Object)"line-height"));
            double d = line_height = styled_height != null ? styled_height.value : 0.0;
            if (line_height > 0.0) {
                return line_height / (font_size == 0.0 ? 1.0 : font_size);
            }
            CSSSize dy_attr = Rave.util.parseCSSSize(this._current_styles.get((Object)_DY));
            if (dy_attr != null) {
                return dy_attr.value / font_size;
            }
            return 1.36;
        }
        return this._lineSpacingFn != null ? (Double)this._lineSpacingFn.getValue((Object)node, data, index, groupIndex) : this._lineSpacing;
    }

    protected Double _calculateFontSize(SceneNode node, Object data, int index, int groupIndex) {
        CSSSize size = Rave.util.parseCSSSize(this._current_styles.get((Object)"font-size"));
        double font_size = size != null ? size.value : node.getBBox().height;
        return font_size;
    }

    protected TextOperation _getOperation(byte operation, SceneNode node, Object data, int index, int groupIndex) {
        String overflow = null;
        if (node != null) {
            overflow = this._text_overflowFn != null ? (String)this._text_overflowFn.getValue((Object)node, data, index, groupIndex) : this._text_overflow;
        }
        return TextOperation.getOperation(operation, overflow);
    }

    public Object padding() {
        return this._padding == null ? this._paddingFn : this._padding;
    }

    public TextFlow padding(int top, int left, int bottom, int right) {
        this._padding = new Insets();
        this._padding.top = top;
        this._padding.left = left;
        this._padding.bottom = bottom;
        this._padding.right = right;
        this._paddingFn = null;
        return this;
    }

    public TextFlow padding(ValueFunction<SceneNode, Insets> paddingFn) {
        this._paddingFn = paddingFn;
        this._padding = null;
        return this;
    }

    public Object minFont() {
        return this._minFontSize == null ? this._minFontSizeFn : this._minFontSize;
    }

    public TextFlow minFont(ValueFunction<SceneNode, Double> minFontSizeFn) {
        this._minFontSizeFn = minFontSizeFn;
        this._minFontSize = null;
        return this;
    }

    @SwiftMethodOverload(skipOverloads={"Bool"})
    public TextFlow minFont(Object size) {
        this._minFontSize = ObjectConverter.toDouble((Object)size);
        this._minFontSizeFn = null;
        return this;
    }

    public Object maxFont() {
        return this._maxFontSizeFn == null ? this._maxFontSize : this._maxFontSizeFn;
    }

    public TextFlow maxFont(ValueFunction<SceneNode, Double> fontSizeFn) {
        this._maxFontSizeFn = fontSizeFn;
        this._maxFontSize = null;
        return this;
    }

    @SwiftMethodOverload(skipOverloads={"Bool"})
    public TextFlow maxFont(Object size) {
        this._maxFontSize = ObjectConverter.toDouble((Object)size);
        this._maxFontSizeFn = null;
        return this;
    }

    private Bounds _getBounds(SceneNode node, Object data, int index, int groupIndex, Insets insets) {
        Dim ext = this._extentFn != null ? (Dim)this._extentFn.getValue((Object)node, data, index, groupIndex) : this._extent;
        CSSSize size = node.getAttribute(_X) != null ? Rave.util.parseCSSSize(node.getAttribute(_X)) : Rave.util.parseCSSSize(this._current_styles.get((Object)_X));
        double x = size == null ? 0.0 : node.getSizePx(size);
        size = node.getAttribute(_Y) != null ? Rave.util.parseCSSSize(node.getAttribute(_Y)) : Rave.util.parseCSSSize(this._current_styles.get((Object)_Y));
        double y = size == null ? 0.0 : node.getSizePx(size);
        double width = ext.getWidth() - (double)insets.left.intValue() - (double)insets.right.intValue();
        double height = ext.getHeight() - (double)insets.top.intValue() - (double)insets.bottom.intValue();
        return new Bounds(x, y, width, height);
    }

    private void _applyTextNodeAttributes(double width, double height, SceneNode node, Object data, int index, int groupIndex, Insets insets, boolean rtl) {
        boolean align_rtl;
        Object transform = node.getAttribute(_TRANSFORM);
        Object object = transform = transform != null ? ObjectConverter.toString((Object)transform) : "";
        if (insets.left != 0 || insets.top != 0) {
            node.setAttribute(_TRANSFORM, (Object)((String)transform).concat(this._transformMarker() + " translate(" + insets.left + "," + insets.top + ")"));
        }
        node.setText(null);
        if (rtl) {
            node.setStyle(_BIDI, (Object)_BIDI_OVERRIDE);
            node.setStyle(_DIRECTION, (Object)_LTR);
        }
        String h_align = this._alignmentFn != null ? (String)this._alignmentFn.getValue((Object)node, data, index, groupIndex) : this._alignment;
        boolean bl = align_rtl = rtl && !this._alignement_set;
        if (h_align.equals(RIGHT) || align_rtl) {
            node.setStyle(_H_ALIGN, (Object)_RIGHT);
            node.setAttribute(_TRANSFORM, (Object)((String)transform).concat(this._transformMarker() + " translate(" + width + ",0)"));
        } else if (h_align.equals(CENTER)) {
            node.setStyle(_H_ALIGN, (Object)"middle");
            node.setAttribute(_TRANSFORM, (Object)((String)transform).concat(this._transformMarker() + " translate(" + width / 2.0 + ",0)"));
        }
    }

    private String _transformMarker() {
        if (!this._transformMarkerAdded) {
            this._transformMarkerAdded = true;
            return TSPAN_TRANSFORM_MARKER;
        }
        return "";
    }

    private void _generateTspans(TextData result, Bounds bounds, SceneNode node, Object data, int index, int groupIndex, boolean rtl) {
        String v_align;
        Selector text_node = Rave.select((SceneNode)node);
        List<String> lines = result.lines;
        double _height = 0.0;
        Double dy = result.lineHeight;
        for (int n = 0; n < lines.size() && _height < bounds.height; _height += result.lineHeight, ++n) {
            String line = lines.get(n);
            Selector tspan = text_node.append(_TSPAN).attr(_NAME, (Object)("line#" + n)).attr(_WIDTH, (Object)bounds.width).attr(_X, (Object)bounds.x).text((Object)line);
            CallbackFunction<SceneNode> recomputeStyles = new CallbackFunction<SceneNode>(){

                public void run(SceneNode context, Object data, int index, int groupIndex) {
                    context.getComputedStyles();
                }
            };
            tspan.each((CallbackFunction)recomputeStyles);
            tspan.call((RunFunction)this._fontChecker, new Object[0]);
            if (n != 0) {
                tspan.attr(_DY, (Object)dy);
            }
            if (!rtl) continue;
            tspan.attr(_BIDI, (Object)_BIDI_EMBED);
            text_node.append(_TSPAN).text((Object)"\n");
        }
        String string = v_align = this._valignmentFn != null ? (String)this._valignmentFn.getValue((Object)node, data, index, groupIndex) : this._valignment;
        if (v_align.equals(TOP)) {
            return;
        }
        Object transform = node.getAttribute(_TRANSFORM);
        transform = transform != null ? ObjectConverter.toString((Object)transform) : "";
        double delta_y = bounds.height - _height;
        if (v_align.equals("middle")) {
            node.setAttribute(_TRANSFORM, (Object)((String)transform).concat(this._transformMarker() + " translate(0," + delta_y / 2.0 + ")"));
            return;
        }
        node.setAttribute(_TRANSFORM, (Object)((String)transform).concat(this._transformMarker() + " translate(0," + delta_y + ")"));
    }

    private final class Bounds {
        public final double x;
        public final double y;
        public final double width;
        public final double height;

        public Bounds(double x, double y, double width, double height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }
    }
}

