/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.awt.internal;

import com.ibm.rave.awt.RavePanel;
import com.ibm.rave.awt.internal.AWTRavePanelSceneNode;
import com.ibm.rave.awt.internal.AWTSceneItemFactory;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.context.RaveOperationalMode;
import com.ibm.rave.core.css.RaveCSSEngine;
import com.ibm.rave.core.internal.selector.SelectionQueryEngine;
import com.ibm.rave.core.nativeImpl.graphicUtils.RenderingContext;
import com.ibm.rave.core.nativeImpl.timer.TimerEvent;
import com.ibm.rave.core.scene.ImageCreatedCallback;
import com.ibm.rave.core.scene.ImageFactory;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.scene.SceneNodeFactory;
import com.ibm.rave.render.AbstractRenderer;
import com.ibm.rave.render.image.CommonImageFactory;
import com.ibm.rave.render.internal.RendererConfiguration;
import com.ibm.rave.render.internal.nodes.RootProvider;
import com.ibm.rave.render.internal.nodes.RootSceneItem;
import com.ibm.rave.render.internal.nodes.awt.AWTRenderer;
import com.ibm.rave.render.internal.nodes.cache.SceneNodeCacheManager;
import com.ibm.rave.render.internal.query.SceneNodeSelectionQueryEngine;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class RavePanelDelegate
implements RootProvider {
    private final Object imageLock = new Object();
    private BufferedImage renderImage;
    private final AWTRenderer renderer;
    private final RootSceneItem sceneRoot;
    private final SceneNodeCacheManager cacheManager;
    private final int _width;
    private final int _height;
    private final String _id;
    private final RavePanel panel;

    public RavePanelDelegate(RavePanel panel, String id, int width, int height) {
        this.panel = panel;
        this.sceneRoot = new AWTRavePanelSceneNode(panel);
        this.sceneRoot.setOwner((SceneNode)this.sceneRoot);
        RendererConfiguration.INSTANCE.addRootProvider((RootProvider)this);
        this.cacheManager = new SceneNodeCacheManager();
        this.renderer = new AWTRenderer((SceneNode)this.sceneRoot, this);
        this.sceneRoot.setRenderer((AbstractRenderer)this.renderer);
        this.sceneRoot.setCacheManager(this.cacheManager);
        this.sceneRoot.setAttribute("id", (Object)id);
        this.sceneRoot.setAttribute("width", (Object)width);
        this.sceneRoot.setAttribute("height", (Object)height);
        this.sceneRoot.setStyle("fill", (Object)"none", null);
        this._width = width;
        this._height = height;
        this._id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRenderImage(BufferedImage image) {
        Object object = this.imageLock;
        synchronized (object) {
            this.renderImage = image;
        }
    }

    public final SceneNode getRoot() {
        return this.sceneRoot;
    }

    public SceneNodeCacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void createImage(final ImageCreatedCallback callback) {
        final RavePanelDelegate self = this;
        TimerEvent event = new TimerEvent(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean run(double elapsed) {
                RenderingContext context = Rave.canvas.create((double)self._width, (double)self._height).getContext("2d", new Object[0]);
                Graphics2D graphics = context.getGraphics();
                Object object = self.imageLock;
                synchronized (object) {
                    if (self.renderImage != null) {
                        graphics.drawImage((Image)self.renderImage, 0, 0, null);
                    }
                }
                callback.ready((Object)context.getImage());
                Rave.canvas.disposeContext(context);
                return true;
            }
        };
        Rave.timer.addEvent(event, 0.0, 0.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        Object object = this.imageLock;
        synchronized (object) {
            if (this.renderImage != null) {
                g.drawImage(this.renderImage, 0, 0, null);
            }
        }
    }

    public void repaint() {
        this.panel.repaint();
    }

    public RavePanel getPanel() {
        return this.panel;
    }

    public void dispose() {
        RendererConfiguration.INSTANCE.removeRootProvider((RootProvider)this);
    }

    static {
        if (RaveOperationalMode.MODE != 1) {
            SceneNodeSelectionQueryEngine queryEngine = new SceneNodeSelectionQueryEngine();
            String AWT = "awt";
            if (Rave.configuration.getQueryEngine(null) == null) {
                Rave.configuration.setQueryEngine(null, (SelectionQueryEngine)queryEngine);
            }
            Rave.configuration.setQueryEngine("awt", (SelectionQueryEngine)queryEngine);
            Rave.configuration.setSceneNodeFactory("awt", (SceneNodeFactory)new AWTSceneItemFactory());
            Rave.configuration.setImageFactory("awt", (ImageFactory)new CommonImageFactory());
            if (Rave.css == null) {
                Rave.css = new RaveCSSEngine();
            }
        }
    }
}

