/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.awt.internal.service.context;

import com.ibm.rave.awt.internal.AWTSceneItemFactory;
import com.ibm.rave.awt.internal.service.context.AWTRaveImageServiceContextManager;
import com.ibm.rave.awt.internal.service.context.ServerTimer;
import com.ibm.rave.core.Configuration;
import com.ibm.rave.core.context.RaveContext;
import com.ibm.rave.core.css.RaveCSSEngine;
import com.ibm.rave.core.internal.css.CSSStyleSheetManager;
import com.ibm.rave.core.internal.selector.SelectionQueryEngine;
import com.ibm.rave.core.interpolate.Interpolators;
import com.ibm.rave.core.scene.ImageFactory;
import com.ibm.rave.core.scene.SceneNodeFactory;
import com.ibm.rave.render.image.CommonImageFactory;
import com.ibm.rave.render.internal.RendererConfiguration;
import com.ibm.rave.render.internal.query.SceneNodeSelectionQueryEngine;

public final class AWTRaveImageServiceContext
extends RaveContext {
    private final AWTRaveImageServiceContextManager.RaveContextId id;
    private final Configuration configuration = new Configuration();
    private final RaveCSSEngine raveCSSEngine = new RaveCSSEngine();
    private final CSSStyleSheetManager cssStyleSheetManager = new CSSStyleSheetManager();
    private final RendererConfiguration rendererConfiguration = new RendererConfiguration();
    private final Interpolators interpolators = new Interpolators().initialize();
    private final ServerTimer timer = new ServerTimer();

    AWTRaveImageServiceContext(AWTRaveImageServiceContextManager.RaveContextId id) {
        this.id = id;
        this.initConfig();
    }

    private void initConfig() {
        SceneNodeSelectionQueryEngine queryEngine = new SceneNodeSelectionQueryEngine();
        if (this.configuration.getQueryEngine(null) == null) {
            this.configuration.setQueryEngine(null, (SelectionQueryEngine)queryEngine);
        }
        this.configuration.setQueryEngine("awt", (SelectionQueryEngine)queryEngine);
        this.configuration.setSceneNodeFactory("awt", (SceneNodeFactory)new AWTSceneItemFactory());
        this.configuration.setImageFactory("awt", (ImageFactory)new CommonImageFactory());
    }

    public boolean isValidThread() {
        return this.id.thread == Thread.currentThread();
    }

    public AWTRaveImageServiceContextManager.RaveContextId getId() {
        return this.id;
    }

    void dispose() {
    }

    Configuration getConfiguration() {
        return this.configuration;
    }

    RaveCSSEngine getRaveCSSEngine() {
        return this.raveCSSEngine;
    }

    CSSStyleSheetManager getCssStyleSheetManager() {
        return this.cssStyleSheetManager;
    }

    RendererConfiguration getRendererConfiguration() {
        return this.rendererConfiguration;
    }

    Interpolators getInterpolators() {
        return this.interpolators;
    }

    ServerTimer getTimer() {
        return this.timer;
    }

    void flushAllTimerEvents() {
        this.getTimer().flushAll();
    }
}

