/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.awt.internal.service.context;

import com.ibm.rave.awt.internal.service.context.AWTRaveImageServiceContext;
import com.ibm.rave.awt.internal.service.context.CSSStyleSheetManagerContextRouter;
import com.ibm.rave.awt.internal.service.context.ConfigurationContextRouter;
import com.ibm.rave.awt.internal.service.context.InterpolatorsContextRouter;
import com.ibm.rave.awt.internal.service.context.NamespacesContextRouter;
import com.ibm.rave.awt.internal.service.context.RaveCSSEngineContextRouter;
import com.ibm.rave.awt.internal.service.context.RendererConfigurationContextRouter;
import com.ibm.rave.awt.internal.service.context.ServerTimerContextRouter;
import com.ibm.rave.awt.internal.service.context.SymbolTypesContextRouter;
import com.ibm.rave.core.Configuration;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.context.RaveContextManager;
import com.ibm.rave.core.context.RaveOperationalMode;
import com.ibm.rave.core.internal.css.CSSStyleSheetManager;
import com.ibm.rave.core.interpolate.Interpolators;
import com.ibm.rave.core.nativeImpl.timer.Timer;
import com.ibm.rave.core.svg.SVG;
import com.ibm.rave.core.util.Namespace;
import com.ibm.rave.render.internal.RendererConfiguration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class AWTRaveImageServiceContextManager
extends RaveContextManager {
    private final Map<Thread, AWTRaveImageServiceContext> thread_contexts = new ConcurrentHashMap<Thread, AWTRaveImageServiceContext>();
    private final Map<RaveContextId, AWTRaveImageServiceContext> id_contexts = new ConcurrentHashMap<RaveContextId, AWTRaveImageServiceContext>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AWTRaveImageServiceContextManager getInstance() {
        if (RaveOperationalMode.MODE != 1) {
            throw new IllegalStateException("RaveOperationalMode is not set to IMAGE_SERVICE");
        }
        if (INSTANCE.getClass() == AWTRaveImageServiceContextManager.class) return (AWTRaveImageServiceContextManager)INSTANCE;
        Class<AWTRaveImageServiceContextManager> clazz = AWTRaveImageServiceContextManager.class;
        synchronized (AWTRaveImageServiceContextManager.class) {
            if (INSTANCE.getClass() == AWTRaveImageServiceContextManager.class) return (AWTRaveImageServiceContextManager)INSTANCE;
            INSTANCE = new AWTRaveImageServiceContextManager().initialize();
            // ** MonitorExit[var0] (shouldn't be in output)
            return (AWTRaveImageServiceContextManager)INSTANCE;
        }
    }

    private AWTRaveImageServiceContextManager() {
    }

    private AWTRaveImageServiceContextManager initialize() {
        Configuration.INSTANCE = new ConfigurationContextRouter();
        CSSStyleSheetManager.INSTANCE = new CSSStyleSheetManagerContextRouter();
        Interpolators.INSTANCE = new InterpolatorsContextRouter();
        Namespace.INSTANCE.prefix = new NamespacesContextRouter();
        RendererConfiguration.INSTANCE = new RendererConfigurationContextRouter();
        Timer.INSTANCE = new ServerTimerContextRouter();
        SVG.getInstance().symbolTypes = new SymbolTypesContextRouter();
        return this.overwriteRaveReferences();
    }

    private AWTRaveImageServiceContextManager overwriteRaveReferences() {
        Rave.timer = Timer.INSTANCE;
        Rave.configuration = Configuration.INSTANCE;
        Rave.interpolators = Interpolators.INSTANCE;
        Rave.css = new RaveCSSEngineContextRouter();
        return this;
    }

    public void disposeContext() {
        AWTRaveImageServiceContext context = this.getRaveContext();
        if (context != null && --context.getId().usage == 0) {
            this.thread_contexts.remove(Thread.currentThread());
            this.id_contexts.remove(context.getId());
            context.dispose();
        }
    }

    public AWTRaveImageServiceContext createContext() {
        Thread t = Thread.currentThread();
        AWTRaveImageServiceContext context = this.thread_contexts.get(t);
        if (context == null) {
            RaveContextId id = new RaveContextId(t);
            context = new AWTRaveImageServiceContext(id);
            this.thread_contexts.put(t, context);
            this.id_contexts.put(id, context);
        }
        ++context.getId().usage;
        return context;
    }

    public AWTRaveImageServiceContext getRaveContext() {
        return this.thread_contexts.get(Thread.currentThread());
    }

    public void flushAllTimerEvents() {
        AWTRaveImageServiceContext context = this.getRaveContext();
        if (context != null) {
            context.flushAllTimerEvents();
        }
    }

    public static final class RaveContextId {
        final Thread thread;
        int usage;

        private RaveContextId(Thread thread) {
            this.thread = thread;
            this.usage = 0;
        }
    }
}

