/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.render.internal.nodes.awt;

import com.ibm.rave.awt.internal.AWTPath2DHandler;
import com.ibm.rave.awt.internal.AWTShapeHelper;
import com.ibm.rave.core.color.RGB;
import com.ibm.rave.core.css.CSSSize;
import com.ibm.rave.core.geo.PathGenerator;
import com.ibm.rave.core.geom.Path2DHandler;
import com.ibm.rave.core.geom.RaveRect;
import com.ibm.rave.core.nativeImpl.graphicUtils.RenderingFontUtils;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.CallbackFunction;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.render.AbstractRenderer;
import com.ibm.rave.render.internal.nodes.AbstractSceneNode;
import com.ibm.rave.render.internal.nodes.CircleSceneItem;
import com.ibm.rave.render.internal.nodes.ClipPathSceneItem;
import com.ibm.rave.render.internal.nodes.EllipseSceneItem;
import com.ibm.rave.render.internal.nodes.ImageSceneItem;
import com.ibm.rave.render.internal.nodes.LineSceneItem;
import com.ibm.rave.render.internal.nodes.PathSceneItem;
import com.ibm.rave.render.internal.nodes.RectSceneItem;
import com.ibm.rave.render.internal.nodes.TextPathSceneItem;
import com.ibm.rave.render.internal.nodes.TextSceneItem;
import com.ibm.rave.render.internal.nodes.awt.AWTShadowRenderer;
import com.ibm.rave.render.internal.nodes.awt.TextPathUtility;
import com.ibm.rave.render.internal.style.AbstractStyle;
import com.ibm.rave.render.internal.style.FontStyle;
import com.ibm.rave.render.internal.style.GradientStop;
import com.ibm.rave.render.internal.style.LinearGradientFillStyle;
import com.ibm.rave.render.internal.style.RadialGradientFillStyle;
import com.ibm.rave.render.internal.style.ShadowStyle;
import com.ibm.rave.render.internal.style.StrokeStyle;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.imageio.ImageIO;

public abstract class AWTAbstractRenderer
extends AbstractRenderer {
    private static final Color COLOR_TRANSPARENT = new Color(0, 0, 0, 0);
    private Graphics2D graphics;
    private final Stack<AffineTransform> transforms = new Stack();
    private final Stack<Shape> clips = new Stack();
    private final Stack<Boolean> clipsChanged = new Stack();
    private final Stack<Boolean> transformsChanged = new Stack();
    private boolean clipping = false;
    private AbstractStyle currentFillStyle;
    private StrokeStyle currentStrokeStyle;
    private final Map<String, URL> urlCache = new HashMap<String, URL>();
    private final Stack<RenderContext> renderContexts = new Stack();
    protected RenderContext renderContext;

    public AWTAbstractRenderer(SceneNode root) {
        super(root);
    }

    public BufferedImage getRenderImage() {
        return this.renderContext.image;
    }

    public void addRectClip(RaveRect newClip) {
        this.graphics.setClip(AWTShapeHelper.convertRect(newClip));
        this.updateClipChanged();
    }

    private void updateTransformChanged() {
        this.transformsChanged.set(this.clipsChanged.size() - 1, Boolean.TRUE);
    }

    private void updateClipChanged() {
        this.clipsChanged.set(this.clipsChanged.size() - 1, Boolean.TRUE);
    }

    public void saveGraphicsState() {
        if (!this.transformsChanged.isEmpty() && !this.transformsChanged.peek().booleanValue()) {
            this.transforms.push(this.transforms.peek());
        } else {
            this.transforms.push(this.graphics.getTransform());
        }
        this.transformsChanged.push(Boolean.FALSE);
        if (!this.clipsChanged.isEmpty() && !this.clipsChanged.peek().booleanValue()) {
            this.clips.push(this.clips.peek());
        } else {
            this.clips.push(this.graphics.getClip());
        }
        this.clipsChanged.push(Boolean.FALSE);
    }

    public void restoreGraphicsState() {
        AffineTransform transform = this.transforms.pop();
        if (this.transformsChanged.pop().booleanValue() && transform != null) {
            this.graphics.setTransform(transform);
        }
        Shape clip = this.clips.pop();
        if (this.clipsChanged.pop().booleanValue()) {
            this.graphics.setClip(clip);
        }
    }

    public void start(boolean renderFromScratch) {
        RenderContext rc = new RenderContext(this.getWidth(), this.getHeight());
        this.graphics = rc.graphics2D;
        if (!renderFromScratch) {
            this.renderContext.image.copyData(rc.image.getRaster());
        }
        this.renderContext = rc;
    }

    public void clearRect(RaveRect rect) {
        Color bg = this.graphics.getBackground();
        this.graphics.setBackground(COLOR_TRANSPARENT);
        this.graphics.clearRect((int)Math.floor(rect.x), (int)Math.floor(rect.y), (int)Math.ceil(rect.width), (int)Math.ceil(rect.height));
        this.graphics.setBackground(bg);
    }

    public void fill(AbstractStyle fill) {
        this.currentFillStyle = null;
        if (fill != null && fill.isVisible()) {
            this.currentFillStyle = fill;
        }
    }

    public static final void applyFill(Shape shape, Graphics2D graphics, AbstractStyle fillStyle) {
        if (fillStyle != null) {
            graphics.setPaint(AWTAbstractRenderer.convertFill(fillStyle));
            if (shape != null) {
                graphics.fill(shape);
            }
        }
    }

    private static Paint convertFill(AbstractStyle fill) {
        switch (fill.getType()) {
            case 1001: {
                LinearGradientFillStyle linearGradiantStyle = (LinearGradientFillStyle)fill;
                Point2D.Double start = new Point2D.Double(linearGradiantStyle.x1, linearGradiantStyle.y1);
                Point2D.Double end = new Point2D.Double(linearGradiantStyle.x2, linearGradiantStyle.y2);
                if (start.equals(end)) break;
                List linearStops = linearGradiantStyle.getStops();
                int size = linearStops.size();
                if (size >= 2) {
                    return new LinearGradientPaint(start, end, AWTAbstractRenderer.getGradientOffsets(linearStops), AWTAbstractRenderer.getGradientColors(linearStops));
                }
                if (size == 1) {
                    return AWTAbstractRenderer.getFirstStopColor(linearStops);
                }
                return COLOR_TRANSPARENT;
            }
            case 1002: {
                RadialGradientFillStyle radialGradientStyle = (RadialGradientFillStyle)fill;
                float radius = (float)radialGradientStyle.r;
                if (!(radius > 0.0f)) break;
                Point2D.Double centre = new Point2D.Double(radialGradientStyle.cx, radialGradientStyle.cy);
                Point2D.Double focus = new Point2D.Double(radialGradientStyle.fx, radialGradientStyle.fy);
                List stops = radialGradientStyle.getStops();
                int rSize = stops.size();
                if (stops.size() >= 2) {
                    return new RadialGradientPaint(centre, radius, focus, AWTAbstractRenderer.getGradientOffsets(stops), AWTAbstractRenderer.getGradientColors(stops), MultipleGradientPaint.CycleMethod.NO_CYCLE);
                }
                if (rSize == 1) {
                    return AWTAbstractRenderer.getFirstStopColor(stops);
                }
                return COLOR_TRANSPARENT;
            }
            default: {
                return AWTAbstractRenderer.convertColor(fill.calculateColorWithOpacity());
            }
        }
        return null;
    }

    private static float[] getGradientOffsets(List<GradientStop> stops) {
        float[] offsets = new float[stops.size()];
        int index = 0;
        for (GradientStop stop : stops) {
            offsets[index++] = (float)stop.getOffset();
        }
        return offsets;
    }

    private static Color[] getGradientColors(List<GradientStop> stops) {
        Color[] colors = new Color[stops.size()];
        int index = 0;
        for (GradientStop stop : stops) {
            colors[index++] = AWTAbstractRenderer.convertColor(stop.calculateColor());
        }
        return colors;
    }

    private static Paint getFirstStopColor(List<GradientStop> stops) {
        return AWTAbstractRenderer.convertColor(stops.get(0).calculateColor());
    }

    private static Color convertColor(RGB color) {
        return new Color(color.getR(), color.getG(), color.getB(), (int)(color.getA() * 255.0));
    }

    public void stroke(StrokeStyle stroke) {
        this.currentStrokeStyle = null;
        if (stroke != null && stroke.isVisible()) {
            this.currentStrokeStyle = stroke;
        }
    }

    public static void applyStroke(Shape shape, Graphics2D g, StrokeStyle stroke) {
        if (stroke != null && shape != null) {
            RGB color = stroke.calculateColorWithOpacity();
            g.setPaint(new Color(color.getR(), color.getG(), color.getB(), (int)(color.getA() * 255.0)));
            int cap = 0;
            if ("round".equals(stroke.getLineCap())) {
                cap = 1;
            } else if ("square".equals(stroke.getLineCap())) {
                cap = 2;
            }
            int join = 0;
            if ("round".equals(stroke.getLineJoin())) {
                join = 1;
            } else if ("bevel".equals(stroke.getLineJoin())) {
                join = 2;
            }
            g.setStroke(new BasicStroke((float)stroke.getWidth(), cap, join, (float)stroke.getMiterLimit(), stroke.getDashArray(), (float)stroke.getDashOffset()));
            g.draw(shape);
        }
    }

    public void drawEllipse(EllipseSceneItem ellipse) {
        double rx = ellipse.getRx();
        double ry = ellipse.getRy();
        if (!this.clipping && rx > 0.0 && ry > 0.0 && (this.currentFillStyle != null || this.currentStrokeStyle != null)) {
            AWTAbstractRenderer.applyFill((Ellipse2D)ellipse.nativeSceneNode, this.graphics, this.currentFillStyle);
            if (this.currentStrokeStyle != null) {
                AWTAbstractRenderer.applyStroke((Ellipse2D)ellipse.nativeSceneNode, this.graphics, this.currentStrokeStyle);
            }
        }
    }

    public void drawRect(RectSceneItem rect) {
        double width = rect.getWidth();
        double height = rect.getHeight();
        if (!this.clipping && width > 0.0 && height > 0.0 && (this.currentFillStyle != null || this.currentStrokeStyle != null)) {
            AWTAbstractRenderer.applyFill((RectangularShape)rect.nativeSceneNode, this.graphics, this.currentFillStyle);
            if (this.currentStrokeStyle != null) {
                AWTAbstractRenderer.applyStroke((RectangularShape)rect.nativeSceneNode, this.graphics, this.currentStrokeStyle);
            }
        }
    }

    public void drawLine(LineSceneItem line) {
        if (this.currentStrokeStyle != null) {
            AWTAbstractRenderer.applyStroke((Line2D)line.nativeSceneNode, this.graphics, this.currentStrokeStyle);
        }
    }

    public void drawText(TextSceneItem textItem) {
        int x = (int)textItem.getX();
        int y = (int)textItem.getY();
        String text = textItem.getTextString();
        if (text == null || text.isEmpty()) {
            return;
        }
        FontStyle style = textItem.getFontStyle();
        Font font = RenderingFontUtils.findFont((String)style.getFamily(), (String)style.getStyle(), (String)style.getWeight(), (CSSSize)style.getCSSSize());
        this.graphics.setFont(font);
        AWTAbstractRenderer.applyFill(null, this.graphics, this.currentFillStyle);
        TextLayout text_layout = new TextLayout(text, font, this.graphics.getFontRenderContext());
        ShadowStyle shadow = textItem.getShadow();
        if (shadow != null) {
            int dx = (int)textItem.getSizePx(shadow.offset_x);
            int dy = (int)textItem.getSizePx(shadow.offset_y);
            Color color = shadow.color != null ? (Color)AWTAbstractRenderer.convertFill((AbstractStyle)shadow) : this.graphics.getColor();
            this.graphics.setColor(color);
            text_layout.draw(this.graphics, x + dx, y + dy);
        }
        AWTAbstractRenderer.applyFill(null, this.graphics, this.currentFillStyle);
        text_layout.draw(this.graphics, x, y);
        if (this.currentStrokeStyle != null) {
            Shape outline = text_layout.getOutline(null);
            this.graphics.setColor((Color)AWTAbstractRenderer.convertFill((AbstractStyle)this.currentStrokeStyle));
            this.graphics.setStroke(AWTAbstractRenderer.convertStroke(this.currentStrokeStyle));
            AffineTransform transform = this.graphics.getTransform();
            this.graphics.translate(x, y);
            this.graphics.draw(outline);
            this.graphics.setTransform(transform);
            this.updateTransformChanged();
        }
    }

    public void drawTextPath(TextPathSceneItem textPath, Selector paths) {
        final String text = textPath.getTextString();
        if (text == null || text.isEmpty() || !(textPath.getParentNode() instanceof TextSceneItem)) {
            return;
        }
        final double xoffset = textPath.getXOffset();
        final double yoffset = textPath.getYOffset();
        FontStyle style = textPath.getFontStyle();
        final Font font = RenderingFontUtils.findFont((String)style.getFamily(), (String)style.getStyle(), (String)style.getWeight(), (CSSSize)style.getCSSSize());
        this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.graphics.setFont(font);
        AWTAbstractRenderer.applyFill(null, this.graphics, this.currentFillStyle);
        if (this.currentFillStyle != null) {
            final AWTAbstractRenderer self = this;
            paths.each((CallbackFunction)new CallbackFunction<SceneNode>(){

                public void run(SceneNode context, Object data, int index, int groupIndex) {
                    PathSceneItem pathNode = (PathSceneItem)context;
                    PathGenerator d = pathNode.getPath();
                    Path2D.Double path2d = new Path2D.Double(0);
                    AWTPath2DHandler path2dHandler = new AWTPath2DHandler(path2d);
                    d.draw((Path2DHandler)path2dHandler);
                    Shape toDraw = TextPathUtility.transformTextOnPath(path2d, text, font, AWTAbstractRenderer.this.graphics.getFontRenderContext(), xoffset, yoffset);
                    self.graphics.fill(toDraw);
                }
            });
        }
    }

    private static Stroke convertStroke(StrokeStyle stroke) {
        String capString = stroke.getLineCap();
        int cap = 0;
        if ("round".equals(capString)) {
            cap = 1;
        } else if ("square".equals(capString)) {
            cap = 2;
        }
        String joinString = stroke.getLineJoin();
        int join = 0;
        if ("round".equals(joinString)) {
            join = 1;
        } else if ("bevel".equals(joinString)) {
            join = 2;
        }
        return new BasicStroke((float)stroke.getWidth(), cap, join, (float)stroke.getMiterLimit(), stroke.getDashArray(), (float)stroke.getDashOffset());
    }

    public void drawCircle(CircleSceneItem circle) {
        double height;
        double width = height = circle.getR() * 2.0;
        if (!this.clipping && width > 0.0 && height > 0.0 && (this.currentFillStyle != null || this.currentStrokeStyle != null)) {
            if (this.currentFillStyle != null) {
                AWTAbstractRenderer.applyFill((Ellipse2D)circle.nativeSceneNode, this.graphics, this.currentFillStyle);
            }
            if (this.currentStrokeStyle != null) {
                AWTAbstractRenderer.applyStroke((Ellipse2D)circle.nativeSceneNode, this.graphics, this.currentStrokeStyle);
            }
        }
    }

    public void drawPath(PathSceneItem path) {
        PathGenerator d = path.getPath();
        if (d != null && !this.clipping) {
            ShadowStyle shadow = path.getShadow();
            if (shadow != null) {
                AWTShadowRenderer shadowRenderer = new AWTShadowRenderer(this.graphics, shadow);
                shadowRenderer.render((AbstractSceneNode)path, this.currentFillStyle, this.currentStrokeStyle);
            }
            AWTAbstractRenderer.applyFill((Path2D)path.nativeSceneNode, this.graphics, this.currentFillStyle);
            AWTAbstractRenderer.applyStroke((Path2D)path.nativeSceneNode, this.graphics, this.currentStrokeStyle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawImage(ImageSceneItem image) {
        InputStream connection = null;
        String href = image.getHref();
        if (href != null && href.length() > 0) {
            URL url = this.urlCache.get(image.getHref());
            try {
                if (url == null) {
                    url = new URL(image.getHref());
                    this.urlCache.put(image.getHref(), url);
                }
                if ((connection = url.openStream()) != null) {
                    if (this.currentFillStyle != null) {
                        double opacity = this.currentFillStyle.getOpacity();
                        AlphaComposite ac = AlphaComposite.getInstance(3, (float)opacity);
                        this.graphics.setComposite(ac);
                    }
                    BufferedImage awtImage = ImageIO.read(connection);
                    this.graphics.drawImage(awtImage, (int)image.getX(), (int)image.getY(), (int)image.getWidth(), (int)image.getHeight(), null);
                }
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void addClip(ClipPathSceneItem clip) {
        this.clipping = true;
        List childNodes = clip.getChildNodes();
        if (childNodes.size() == 0) {
            this.graphics.clip(new Rectangle2D.Double(-10000.0, -10000.0, 0.0, 0.0));
            this.updateClipChanged();
        } else if (childNodes.size() == 1) {
            AbstractSceneNode node = (AbstractSceneNode)childNodes.get(0);
            this.graphics.clip((Shape)node.nativeSceneNode);
            this.updateClipChanged();
        } else if (childNodes.size() > 1) {
            Path2D.Double path = new Path2D.Double();
            for (SceneNode child : childNodes) {
                AbstractSceneNode node = (AbstractSceneNode)child;
                path.append((Shape)node.nativeSceneNode, false);
            }
            this.graphics.clip(path);
            this.updateClipChanged();
        }
        this.clipping = false;
    }

    public void transform(double m00, double m10, double m01, double m11, double m02, double m12) {
        AffineTransform transform = new AffineTransform(m00, m10, m01, m11, m02, m12);
        this.graphics.transform(transform);
        this.updateTransformChanged();
    }

    public Graphics2D getGraphics() {
        return this.graphics;
    }

    public void push() {
        this.renderContexts.push(this.renderContext);
        AffineTransform at = this.graphics.getTransform();
        this.saveGraphicsState();
        this.renderContext = new RenderContext(this.getWidth(), this.getHeight());
        this.graphics = this.renderContext.graphics2D;
        this.graphics.transform(at);
    }

    public void pop(double opacity) {
        BufferedImage img = this.renderContext.image;
        this.graphics.dispose();
        RenderContext rc = this.renderContexts.pop();
        AffineTransform at = rc.graphics2D.getTransform();
        this.renderContext = rc;
        this.graphics = rc.graphics2D;
        this.graphics.setTransform(new AffineTransform());
        this.drawTransparentImage(img, opacity);
        this.restoreGraphicsState();
    }

    public void shapeRendering(String mode) {
        Object hint = "crispEdges".equals(mode) ? RenderingHints.VALUE_STROKE_NORMALIZE : RenderingHints.VALUE_STROKE_DEFAULT;
        this.graphics.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, hint);
    }

    private void drawTransparentImage(BufferedImage image, double opacity) {
        Composite currentComp = this.graphics.getComposite();
        AlphaComposite ac = AlphaComposite.getInstance(3, (float)opacity);
        this.graphics.setComposite(ac);
        this.graphics.drawImage((Image)image, 0, 0, null);
        this.graphics.setComposite(currentComp);
    }

    private class RenderContext {
        public Graphics2D graphics2D;
        public BufferedImage image;

        public RenderContext(double width, double height) {
            this.image = new BufferedImage(width == 0.0 ? 1 : (int)width, height == 0.0 ? 1 : (int)height, 6);
            this.graphics2D = this.image.createGraphics();
            this.graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
    }
}

