/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.render.internal.nodes.awt;

import com.ibm.rave.core.geom.RectStruct;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.render.internal.nodes.RectSceneItem;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;

public class AWTRectSceneNode
extends RectSceneItem {
    public AWTRectSceneNode(String nsuri, SceneNode context) {
        super(nsuri, context);
        this.nativeSceneNode = new Rectangle2D.Double();
    }

    public int getDrawType() {
        return 1000;
    }

    public String getName() {
        return "rect";
    }

    public void doLayout() {
        super.doLayout();
        double _rx = this.rx * 2.0;
        double _ry = this.ry * 2.0;
        if (_rx > 0.0 && _ry <= 0.0) {
            _ry = _rx;
        } else if (_ry > 0.0 && _rx <= 0.0) {
            _rx = _ry;
        }
        if (_rx > 0.4 || _ry > 0.4) {
            if (!(this.nativeSceneNode instanceof RoundRectangle2D)) {
                this.nativeSceneNode = new RoundRectangle2D.Double();
            }
            ((RoundRectangle2D)this.nativeSceneNode).setRoundRect(this.x, this.y, this.width, this.height, _rx, _ry);
        } else {
            if (!(this.nativeSceneNode instanceof Rectangle2D)) {
                this.nativeSceneNode = new Rectangle2D.Double();
            }
            ((Rectangle2D)this.nativeSceneNode).setRect(this.x, this.y, this.width, this.height);
        }
    }

    protected boolean intersects(RectStruct rect) {
        return ((RectangularShape)this.nativeSceneNode).intersects(rect.x, rect.y, rect.width, rect.height) && this.intersectsClip(rect);
    }
}

