/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.render.internal.nodes.awt;

import com.ibm.rave.core.color.RGB;
import com.ibm.rave.render.internal.nodes.AbstractSceneNode;
import com.ibm.rave.render.internal.nodes.TextPathSceneItem;
import com.ibm.rave.render.internal.nodes.TextSceneItem;
import com.ibm.rave.render.internal.nodes.awt.AWTAbstractRenderer;
import com.ibm.rave.render.internal.nodes.awt.GraphicsUtil;
import com.ibm.rave.render.internal.style.AbstractStyle;
import com.ibm.rave.render.internal.style.ShadowStyle;
import com.ibm.rave.render.internal.style.StrokeStyle;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;

public class AWTShadowRenderer {
    private final Graphics2D g;
    private final ShadowStyle shadow;

    public AWTShadowRenderer(Graphics2D g, ShadowStyle shadow) {
        this.g = g;
        this.shadow = shadow;
    }

    public void render(AbstractSceneNode node, AbstractStyle fillStyle, StrokeStyle strokeStyle) {
        double dx = node.getSizePx(this.shadow.offset_x);
        double dy = node.getSizePx(this.shadow.offset_y);
        double radius = node.getSizePx(this.shadow.blur_radius);
        RGB rgb = this.shadow.getColor();
        Color color = rgb == null ? Color.black : new Color(rgb.getR(), rgb.getG(), rgb.getB(), (int)(rgb.getA() * 255.0));
        Rectangle bounds = ((Shape)node.nativeSceneNode).getBounds();
        if (bounds.width == 0 || bounds.height == 0) {
            return;
        }
        BufferedImage result = this.blur(node, fillStyle, strokeStyle, radius, color);
        this.g.drawImage(result, null, (int)(bounds.getX() + dx - 3.0 * radius), (int)(bounds.getY() + dy - 3.0 * radius));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage blur(AbstractSceneNode node, AbstractStyle fillStyle, StrokeStyle strokeStyle, double radius, Color color) {
        Graphics2D shadowGraphics = null;
        Shape shape = (Shape)node.nativeSceneNode;
        Rectangle bounds = shape.getBounds();
        int height = bounds.height;
        int width = bounds.width;
        boolean isText = node instanceof TextSceneItem || node instanceof TextPathSceneItem;
        int imageHeight = height + (int)(6.0 * radius);
        int imageWidth = width + (int)(6.0 * radius);
        BufferedImage bi = new BufferedImage(imageWidth, imageHeight, 2);
        shadowGraphics = bi.createGraphics();
        try {
            shadowGraphics.setRenderingHints(this.g.getRenderingHints());
            shadowGraphics.translate((double)(-bounds.x) + 3.0 * radius, (double)(-bounds.y) + 3.0 * radius);
            if (!isText) {
                AWTAbstractRenderer.applyFill(shape, shadowGraphics, fillStyle);
                AWTAbstractRenderer.applyStroke(shape, shadowGraphics, strokeStyle);
            }
        }
        finally {
            shadowGraphics.dispose();
        }
        int rgba = 0;
        int alpha = 0;
        if (color != null) {
            int effectColor = color.getRGB();
            double alphaScaler = (double)GraphicsUtil.getAlpha(effectColor) / 255.0;
            for (int y = 0; y < imageHeight; ++y) {
                for (int x = 0; x < imageWidth; ++x) {
                    rgba = bi.getRGB(x, y);
                    alpha = GraphicsUtil.getAlpha(rgba);
                    alpha = (int)Math.round((double)alpha * alphaScaler);
                    bi.setRGB(x, y, GraphicsUtil.updateAlpha(alpha, effectColor));
                }
            }
        } else {
            for (int y = 0; y < imageHeight; ++y) {
                for (int x = 0; x < imageWidth; ++x) {
                    rgba = bi.getRGB(x, y);
                    alpha = GraphicsUtil.getAlpha(rgba);
                    bi.setRGB(x, y, GraphicsUtil.rgb(alpha, 0, 0, 0));
                }
            }
        }
        GraphicsUtil.gaussianBlurBufferedImage(bi, (int)radius);
        return bi;
    }
}

