/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.areaBundle;

import com.ibm.rave.bundles.components.AreaComponentImpl;
import com.ibm.rave.bundles.components.AxesManager;
import com.ibm.rave.bundles.components.ComponentConfiguration;
import com.ibm.rave.bundles.data.LineDataUtilities;
import com.ibm.rave.bundles.views.BundleView;
import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.rave.core.Rave;
import com.ibm.rave.core.behavior.Zoom;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.functions.SingleValueFunction;
import com.ibm.rave.core.geom.RectStruct;
import com.ibm.rave.core.internal.collections.OMap;
import com.ibm.rave.core.layout.StackLayout;
import com.ibm.rave.core.nativeImpl.EventQueue;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scales.AbstractScale;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selection;
import com.ibm.rave.core.selector.ValueFunction;
import com.ibm.rave.core.util.Runnable;
import com.ibm.rave.library.action.BundleUtils;
import com.ibm.rave.library.action.internal.HighlightOperation;
import com.ibm.rave.library.action.internal.OperationsUtil;
import com.ibm.rave.library.datamodel.DataSet;
import com.ibm.rave.library.datamodel.DataSlotEntry;
import com.ibm.rave.library.framework.CoordinateScale;
import com.ibm.rave.library.framework.internal.BundleContext;
import com.ibm.rave.library.framework.internal.CSSConverter;
import com.ibm.rave.library.framework.internal.CoordinateScaleImpl;
import com.ibm.rave.library.framework.internal.LinearCoordinateScale;
import com.ibm.rave.library.framework.internal.ScaleManager;
import com.ibm.rave.library.palette.Palette;
import java.util.List;

public class AreaView
extends BundleView {
    @InlineStringConstant
    private static final String DATAMODEL_TABULAR = "tabular";
    @InlineStringConstant
    private static final String DATASET_DATA = "data";
    @InlineStringConstant
    private static final String DATASLOT_X = "x";
    @InlineStringConstant
    private static final String DATASLOT_Y = "y";
    @InlineStringConstant
    private static final String DATASLOT_GROUP = "color";
    private static final String AREA_INTREPOLATE_PROPERTY = "area.interpolate";
    private AreaComponentImpl _areaComponent = null;
    private boolean _isStacked = false;
    private CoordinateScaleImpl _dependentScale;
    private CoordinateScaleImpl _independentScale;
    private ArrayEx<LineDataUtilities.LineDatum> _areaData;
    private AbstractScale<?, ?> zoomXScale;
    private AbstractScale<?, ?> zoomYScale;
    private Object zoomendedTimer;
    private static ValueFunction<Object, ArrayEx<? extends Number>> STACKOFFSET_EXPANDPERCENT = new ValueFunction<Object, ArrayEx<? extends Number>>(){

        public ArrayEx<Double> getValue(Object context, Object data, int index, int groupIndex) {
            int j;
            ArrayEx aData = (ArrayEx)data;
            int n = aData.length();
            int m = ((ArrayEx)aData.get(0)).length();
            double k = 100.0 / (double)n;
            ArrayEx y0 = new ArrayEx();
            for (j = 0; j < m; ++j) {
                int i;
                double oPos = 0.0;
                double oNeg = 0.0;
                for (i = 0; i < n; ++i) {
                    double value = (Double)((ArrayEx)((ArrayEx)aData.get(i)).get(j)).get(1);
                    if (value >= 0.0) {
                        oPos += value;
                        continue;
                    }
                    oNeg += value;
                }
                if (oPos != 0.0 || oNeg != 0.0) {
                    for (i = 0; i < n; ++i) {
                        ArrayEx ijElement = (ArrayEx)((ArrayEx)aData.get(i)).get(j);
                        Double val = (Double)ijElement.get(1);
                        if (val >= 0.0) {
                            ijElement.set(1, (Object)(100.0 * val / oPos));
                            continue;
                        }
                        ijElement.set(1, (Object)(-100.0 * val / oNeg));
                    }
                    continue;
                }
                for (i = 0; i < n; ++i) {
                    ArrayEx ijElement = (ArrayEx)((ArrayEx)aData.get(i)).get(j);
                    ijElement.set(1, (Object)k);
                }
            }
            for (j = 0; j < m; ++j) {
                y0.set(j, (Object)0.0);
            }
            return y0;
        }
    };

    protected AreaView(BundleContext context) {
        super(context);
    }

    @Override
    protected boolean isAxesManagerRequired() {
        return true;
    }

    @Override
    public void setup() {
        super.setup();
        OMap style = new OMap();
        style.put((Object)"stroke-width", (Object)"1px");
        style.put((Object)"stroke", (Object)new ValueFunction<SceneNode, Object>(){

            public Object getValue(SceneNode context, Object data, int index, int groupIndex) {
                return Rave.select((SceneNode)context).style("fill");
            }
        });
        BundleUtils.setupDefaultActions((BundleContext)this.context, (String)".chart .element-shape", (OMap)style);
        this._areaComponent = new AreaComponentImpl();
        this._areaComponent.pointsAccessor(LineDataUtilities.POINTS_ACCESSOR).groupAccessor(LineDataUtilities.GROUP_ACCESSOR);
    }

    public void draw() {
        if (this.isUpdateNothing()) {
            return;
        }
        this.preDraw("g.vizlibrary-area");
        if (!this.validateDataModel("g.element-group", "g.grid", "g.axis")) {
            return;
        }
        String borderWidth = this.context.convertCSSSizeToPixels(this.context.getPropertyValue("area.borderWidth"));
        String borderColor = ObjectConverter.asString((Object)this.context.getPropertyValue("area.borderColor"));
        Double areaOpacity = ObjectConverter.asDouble((Object)this.context.getPropertyValue("area.opacity"));
        HighlightOperation highlight = (HighlightOperation)this.context.actions.action("highlight").getOperation();
        if (borderWidth.length() > 0 && CSSConverter.convertCSSSizeToPixelNumber((Object)borderWidth, (double)100.0, (double)10.0) > 0.0) {
            highlight.primaryStyleDefault.put((Object)"stroke-width", (Object)borderWidth);
        } else {
            highlight.primaryStyleDefault.put((Object)"stroke-width", (Object)"2px");
        }
        OMap unHighlightstyle = new OMap();
        unHighlightstyle.put((Object)"stroke-width", (Object)borderWidth);
        unHighlightstyle.put((Object)"stroke", (Object)borderColor);
        this.context.actions.action("unhighlight").setOperation(OperationsUtil.unhighlight((OMap)unHighlightstyle));
        OMap style = new OMap();
        style.put((Object)"stroke-width", (Object)borderWidth);
        style.put((Object)"stroke", (Object)borderColor);
        style.put((Object)"opacity", (Object)areaOpacity);
        this.context.actions.action("deselectAll").setOperation(OperationsUtil.deselectAll((OMap)style));
        this.context.actions.action("toggleSelect").setOperation(OperationsUtil.toggleSelection((OMap)style));
        String effect = this.getStringProperty("effect.name");
        int duration = this.getEffectDuration(effect);
        String dataHandling = this.getStringProperty("data.handling");
        boolean transpose = this.getBooleanProperty("transpose");
        this._isStacked = !"Simple".equals(dataHandling);
        DataSet dataSet = this.dataModel.dataset(DATASET_DATA);
        DataSlotEntry xDataSlotEntry = dataSet.slot(DATASLOT_X).entry();
        DataSlotEntry yDataSlotEntry = dataSet.slot(DATASLOT_Y).entry();
        DataSlotEntry groupDataSlotEntry = dataSet.slot(DATASLOT_GROUP).entry();
        if (groupDataSlotEntry == null && yDataSlotEntry != null) {
            dataSet.slot(DATASLOT_GROUP).overrideLabel(yDataSlotEntry.label());
        }
        ArrayEx data = ObjectConverter.listToArray((List)((List)dataSet.data()));
        Palette colorPalette = this.getPalette();
        colorPalette.setData(dataSet, DATASLOT_GROUP);
        colorPalette.setAccessor(LineDataUtilities.GROUP_ACCESSOR);
        String legendPosition = this.getLegendPosition();
        this._legends.visible(this.isShowLegend()).position(legendPosition).transition(!"none".equals(effect), duration).setPreExecute(this.context.getPreExecute()).selector(0, this.context.node.selectAll("g.legend")).palette(0, colorPalette).shape(0, "square").title(0, this.context.getDataSlotLabel("legend.title", groupDataSlotEntry)).titleFill(0, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fill"))).titleFontSize(0, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fontsize"))).titleFontFamily(0, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fontfamily"))).setDataSlot(0, groupDataSlotEntry);
        if (this.updateType == 0) {
            SingleValueFunction xAccessor = AreaView.accessorOf((DataSlotEntry)xDataSlotEntry);
            SingleValueFunction yAccessor = AreaView.accessorOf((DataSlotEntry)yDataSlotEntry);
            SingleValueFunction groupAccessor = AreaView.accessorOf((DataSlotEntry)groupDataSlotEntry);
            if (this._isStacked && groupAccessor != null) {
                this._areaData = LineDataUtilities.buildLinesForStacking((ArrayEx<Object>)data, (SingleValueFunction<Object, Object>)xAccessor, (SingleValueFunction<Object, Object>)yAccessor, (SingleValueFunction<Object, Object>)groupAccessor);
            } else {
                SingleValueFunction xScale = AreaView.domainCheckerOf((List)data, (DataSlotEntry)xDataSlotEntry);
                this._areaData = LineDataUtilities.buildLines((ArrayEx<Object>)data, (SingleValueFunction<Object, Object>)xAccessor, (SingleValueFunction<Object, Object>)xScale, (SingleValueFunction<Object, Object>)yAccessor, (SingleValueFunction<Object, Object>)groupAccessor);
            }
        }
        boolean stacked100 = "Stacked100".equals(this.getStringProperty("data.handling"));
        if (this.updateType <= 1) {
            boolean isLegendLeftOrRight;
            this._independentScale = ScaleManager.makeCoordinateScale((List)data, (DataSlotEntry)xDataSlotEntry, (boolean)false);
            this._dependentScale = ScaleManager.makeCoordinateScale((List)data, (DataSlotEntry)yDataSlotEntry);
            Number subDomainDivisionY = yDataSlotEntry.subDomainDivision();
            Double scaleDivisionY = subDomainDivisionY == null ? null : Double.valueOf(ObjectConverter.toDouble((Object)subDomainDivisionY));
            this._axes.visible(true).duration(duration).transpose(transpose).scale(0, this._independentScale).scale(2, this._dependentScale).setDataSlot(0, xDataSlotEntry).setDataSlot(2, yDataSlotEntry).useDefaultSelectors().useDefaultX1Properties(true).useDefaultY1Properties(true).scaleTickMagnitude(2, scaleDivisionY).setTickFormatter(0, xDataSlotEntry).setTickFormatterList(2, (ArrayEx<DataSlotEntry>)new ArrayEx((Object[])new DataSlotEntry[]{yDataSlotEntry}), stacked100 ? "percent" : "none", stacked100 ? AxesManager.percentFormat(0) : null);
            this.prepareLayoutComponent();
            this.prepareLayoutSizables(this._layoutComponent, false, true, true, false, this._legends.anyVisible());
            boolean bl = isLegendLeftOrRight = "left".equals(legendPosition) || "right".equals(legendPosition);
            if (isLegendLeftOrRight) {
                this._legends.preLayout(this._layoutComponent, false);
                this._axes.preLayout(this._layoutComponent, false, 0.1, 0.0, 0, 0.1, 0.0, 0);
            } else {
                this._axes.preLayout(this._layoutComponent, true, 0.1, 0.0, 0, 0.1, 0.0, 0);
                this._legends.preLayout(this._layoutComponent, true);
            }
            this._layoutComponent.layout();
            legendPosition = this._layoutComponent.legendPosition();
            this._legends.position(legendPosition);
            this._axes.useBoundsFromLayout(this._layoutComponent).setScaleRanges(0.1, 0.0, 0);
            if (this.updateType == 0 && this._independentScale != null) {
                LineDataUtilities.sortLines(this._areaData, this._independentScale);
            }
            if (this._isStacked && this._independentScale != null && this._dependentScale != null) {
                this._areaData = this.addBaseline(this._areaData, dataHandling);
                ArrayEx<Object> numbers = this.calculateDependentDomain(this._areaData, dataHandling);
                if (yDataSlotEntry.domain() == null) {
                    this._dependentScale = LinearCoordinateScale.create(numbers);
                    this._axes.scale(2, this._dependentScale).setScaleRanges(0.1, 0.0, 0);
                }
            }
            if (this._independentScale != null) {
                this._independentScale.expandZeroExtent(false);
                if (this.getBooleanProperty("axis.x.scale.nice")) {
                    this._independentScale.nice();
                }
                if (this.getBooleanProperty("axis.x.scale.includeZero")) {
                    this._independentScale.includeZero();
                }
                if (transpose) {
                    this.zoomYScale = this._independentScale.scale().copy();
                } else {
                    this.zoomXScale = this._independentScale.scale().copy();
                }
            }
            if (this._dependentScale != null) {
                if (!"Stream".equals(dataHandling) && this.getBooleanProperty("axis.y.scale.includeZero")) {
                    this._dependentScale.includeZero();
                }
                this._dependentScale.expandZeroExtent(false);
                if (this.getBooleanProperty("axis.y.scale.nice")) {
                    this._dependentScale.nice((Number)scaleDivisionY);
                }
                if (transpose) {
                    this.zoomXScale = this._dependentScale.scale().copy();
                } else {
                    this.zoomYScale = this._dependentScale.scale().copy();
                }
            }
            this.resetZoom();
        }
        RectStruct elementRect = this._layoutComponent.elementRect();
        this._clip.clipRect(elementRect).applyTo(this._chart.select((Object)".content")).run((Selection<?>)this.context.node.select((Object)"defs").transition().duration((Object)duration), new Object[0]);
        this._chart.select((Object)"rect.background.elements").attr(DATASLOT_X, (Object)elementRect.x).attr(DATASLOT_Y, (Object)elementRect.y).attr("width", (Object)elementRect.width).attr("height", (Object)elementRect.height);
        this._legends.rectangle(this._layoutComponent.legendRect());
        CoordinateScaleImpl xScale = this._independentScale;
        CoordinateScaleImpl yScale = this._dependentScale;
        if (transpose) {
            xScale = this._dependentScale;
            yScale = this._independentScale;
        }
        this.setBackgroundProperties(elementRect, duration);
        ((AreaComponentImpl)this._areaComponent.data(this._areaData.toArray()).independentScale(this._independentScale).dependentScale(this._dependentScale).transpose(transpose).colorPalette(colorPalette).effect(effect).stack(this._isStacked).setPreExecute(this.context.getPreExecute())).interpolate(this.getStringProperty(AREA_INTREPOLATE_PROPERTY)).borderColor(borderColor).borderWidth(borderWidth).chartOpacity(areaOpacity);
        this._chart.selectAll("g.element-group").transition().duration((Object)duration).call((RunFunction)this._areaComponent, new Object[0]);
        this._axes.visible(true).duration(duration).useDefaultSelectors().useDefaultX1Properties(true).useDefaultY1Properties(true).setTickFormatter(0, xDataSlotEntry).setTickFormatterList(2, (ArrayEx<DataSlotEntry>)new ArrayEx((Object[])new DataSlotEntry[]{yDataSlotEntry}), stacked100 ? "percent" : "none", stacked100 ? AxesManager.percentFormat(0) : null);
        this._axes.draw();
        this._legends.draw();
        if (this.updateType <= 2) {
            String ops = this.getStringProperty("zoom");
            if (xScale != null && (ops.equals("all") || ops.equals(DATASLOT_X))) {
                xScale.scale().domain(this.zoomXScale.domain());
            }
            if (yScale != null && (ops.equals("all") || ops.equals(DATASLOT_Y))) {
                yScale.scale().domain(this.zoomYScale.domain());
            }
            final AreaView self = this;
            Zoom zoom = (Zoom)this.context.actions.action("zoom").get("zoom");
            ComponentConfiguration.configureZoom(this._chart, zoom, xScale, yScale, null, null, null, elementRect, this._zoomP, this._zoomS, this.getStringProperty("zoom"), new RunFunction<SceneNode>(){

                public Object run(SceneNode context, Object ... args) {
                    self._chart.selectAll("g.element-group").call((RunFunction)self._areaComponent, new Object[0]);
                    self._axes.redraw(true);
                    return self._chart;
                }
            });
            zoom.on("zoomend.hideLabels", (RunFunction)new RunFunction<SceneNode>(){

                public Object run(SceneNode context, Object ... args) {
                    if (self._axes.hideAnyPanZoom()) {
                        if (self.zoomendedTimer != null) {
                            EventQueue.clearTimeout((Object)self.zoomendedTimer);
                        }
                        self.zoomendedTimer = EventQueue.setTimeout((Runnable)new Runnable(){

                            public void run() {
                                self.zoomendedTimer = null;
                                self._axes.redraw(false);
                            }
                        }, (int)300);
                    }
                    return null;
                }
            });
        }
        this.resetUpdate();
        this._chart.selectAll(".element-shape").classed("bundle-shape", true);
        this._chart.selectAll(".legendShape").classed("bundle-shape", true);
    }

    public CoordinateScale getCoordinateScale(String role) {
        if ("ROLE_X1".equals(role)) {
            return this._independentScale;
        }
        if ("ROLE_Y1".equals(role)) {
            return this._dependentScale;
        }
        return null;
    }

    public ArrayEx<LineDataUtilities.LineDatum> addBaseline(ArrayEx<LineDataUtilities.LineDatum> data, final String dataHandling) {
        final AreaView self = this;
        StackLayout stacklayout = Rave.layout.stack();
        stacklayout.values(new ValueFunction<Object, ArrayEx<?>>(){

            public ArrayEx<?> getValue(Object arg0, Object arg1, int arg2, int arg3) {
                return ((LineDataUtilities.LineDatum)arg1).points;
            }
        }).x((ValueFunction)new ValueFunction<Object, Object>(){

            public Object getValue(Object arg0, Object arg1, int arg2, int arg3) {
                return self._independentScale.scale().getValue(null, ((ArrayEx)arg1).get(0), arg2, arg3);
            }
        }).y((ValueFunction)new ValueFunction<Object, Object>(){

            public Object getValue(Object arg0, Object arg1, int arg2, int arg3) {
                return ((ArrayEx)arg1).get(1);
            }
        }).out(new StackLayout.StackOutFunction(){

            public void updateValue(Object context, Object stackNode, double y0, Object y) {
                ((ArrayEx)stackNode).add((Object)y0);
                if ("Stacked100".equals(dataHandling)) {
                    ((ArrayEx)stackNode).set(1, y);
                }
            }
        });
        if ("Stream".equals(dataHandling)) {
            stacklayout.offset("silhouette");
        }
        if ("Stacked100".equals(dataHandling)) {
            stacklayout.offset(STACKOFFSET_EXPANDPERCENT);
        }
        return stacklayout.accumulator("separate-positives-negatives").stack(data, 0);
    }

    private ArrayEx<Object> calculateDependentDomain(ArrayEx<LineDataUtilities.LineDatum> data, String dataHandling) {
        ArrayEx.ArrayValueFunction<ArrayEx<Object>, Object> yValueMin = new ArrayEx.ArrayValueFunction<ArrayEx<Object>, Object>(){

            public Double getValue(ArrayEx<Object> point, int ix, ArrayEx<ArrayEx<Object>> ctxt) {
                double v1 = ObjectConverter.toDouble((Object)point.get(2));
                return Math.min(v1, ObjectConverter.toDouble((Object)point.get(1)) + v1);
            }
        };
        ArrayEx.ArrayValueFunction<ArrayEx<Object>, Object> yValueMax = new ArrayEx.ArrayValueFunction<ArrayEx<Object>, Object>(){

            public Double getValue(ArrayEx<Object> point, int ix, ArrayEx<ArrayEx<Object>> ctxt) {
                double v1 = ObjectConverter.toDouble((Object)point.get(2));
                return Math.max(v1, ObjectConverter.toDouble((Object)point.get(1)) + v1);
            }
        };
        double min = ObjectConverter.toDouble((Object)Rave.min(data, (ValueFunction)new ValueFunction<List<?>, Number>((ArrayEx.ArrayValueFunction)yValueMin){
            final /* synthetic */ ArrayEx.ArrayValueFunction val$yValueMin;
            {
                this.val$yValueMin = arrayValueFunction;
            }

            public Number getValue(List<?> ctxt, Object lineData, int ix, int iy) {
                return ObjectConverter.toDouble((Object)Rave.min((List)((LineDataUtilities.LineDatum)lineData).points.map(this.val$yValueMin)));
            }
        }));
        double max = ObjectConverter.toDouble((Object)Rave.max(data, (ValueFunction)new ValueFunction<List<?>, Number>((ArrayEx.ArrayValueFunction)yValueMax){
            final /* synthetic */ ArrayEx.ArrayValueFunction val$yValueMax;
            {
                this.val$yValueMax = arrayValueFunction;
            }

            public Number getValue(List<?> ctxt, Object lineData, int ix, int iy) {
                return ObjectConverter.toDouble((Object)Rave.max((List)((LineDataUtilities.LineDatum)lineData).points.map(this.val$yValueMax)));
            }
        }));
        if ("Stream".equals(dataHandling)) {
            for (LineDataUtilities.LineDatum line : data) {
                for (ArrayEx point : line.points) {
                    if (point.get(2) == null) continue;
                    point.set(2, (Object)(ObjectConverter.toDouble((Object)point.get(2)) - min));
                }
            }
            max -= min;
            min = 0.0;
        }
        return new ArrayEx(new Object[]{min, max});
    }

    @Override
    protected String[] getGroupStructure() {
        return new String[]{"defs", "g.vizlibrary vizlibrary-area", "(", "rect.background chart", "g.chart", "(", "g.content", "(", "rect.background elements", "g.gridlines", "(", "g.grid left", "g.grid bottom", ")", "g.elements", "(", "g.element-group", ")", ")", "g.axes", "(", "g.axes-layout", "g.axisTransform left", "g.axisTransform bottom", ")", "g.axis-callout", ")", "g.legends", "(", "g.legends-layout", "g.legend", ")", ")"};
    }
}

