/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rave.bundles.boxplotBundle;

import com.ibm.rave.bundles.components.BoxplotComponentImpl;
import com.ibm.rave.bundles.components.ComponentConfiguration;
import com.ibm.rave.bundles.data.BoxplotDataUtilities;
import com.ibm.rave.bundles.data.BoxplotDatum;
import com.ibm.rave.bundles.views.BundleView;
import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.rave.core.behavior.Zoom;
import com.ibm.rave.core.collections.ArrayEx;
import com.ibm.rave.core.functions.SingleValueFunction;
import com.ibm.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.rave.core.scene.SceneNode;
import com.ibm.rave.core.selector.RunFunction;
import com.ibm.rave.core.selector.Selection;
import com.ibm.rave.core.selector.Selector;
import com.ibm.rave.library.action.ActionOperation;
import com.ibm.rave.library.action.BundleUtils;
import com.ibm.rave.library.action.internal.ActionImpl;
import com.ibm.rave.library.datamodel.DataSet;
import com.ibm.rave.library.datamodel.DataSlotEntry;
import com.ibm.rave.library.framework.CoordinateScale;
import com.ibm.rave.library.framework.internal.BundleContext;
import com.ibm.rave.library.framework.internal.CSSConverter;
import com.ibm.rave.library.framework.internal.CoordinateScaleImpl;
import com.ibm.rave.library.framework.internal.ScaleManager;
import com.ibm.rave.library.palette.Palette;
import java.util.List;

public class BoxplotView
extends BundleView {
    private ArrayEx<BoxplotDatum> _boxplotData;
    private CoordinateScaleImpl _xScale;
    private List<Object> _xDomain;
    private CoordinateScaleImpl _yScale;
    private List<Object> _yDomain;
    private BoxplotComponentImpl _boxplotComponent;
    @InlineStringConstant
    private static final String DATASET_DATA = "data";
    @InlineStringConstant
    private static final String DATASLOT_X = "x";
    @InlineStringConstant
    private static final String DATASLOT_Y = "y";
    @InlineStringConstant
    private static final String DATASLOT_COLOR = "color";
    @InlineStringConstant
    private static final String DATASLOT_KEY = "key";
    @InlineStringConstant
    private static final String BOXPLOT_SIZE_PROPERTY = "boxplot.size";
    @InlineStringConstant
    private static final String BOXPLOT_APPLYSIZE_PROPERTY = "boxplot.applysize";
    @InlineStringConstant
    private static final String BOXPLOT_STYLE_FILL = "boxplot.style.fill";
    @InlineStringConstant
    private static final String BOXPLOT_STYLE_STROKE = "boxplot.style.stroke";
    @InlineStringConstant
    private static final String BOXPLOT_STYLE_STROKEWIDTH = "boxplot.style.stroke-width";
    @InlineStringConstant
    private static final String BOXPLOT_WHISKER_STYLE_STROKE = "boxplot.whisker.style.stroke";
    @InlineStringConstant
    private static final String BOXPLOT_WHISKER_STYLE_STROKEWIDTH = "boxplot.whisker.style.stroke-width";
    @InlineStringConstant
    private static final String BOXPLOT_MEDIAN_STYLE_STROKE = "boxplot.median.style.stroke";
    @InlineStringConstant
    private static final String BOXPLOT_MEDIAN_STYLE_STROKEWIDTH = "boxplot.median.style.stroke-width";
    @InlineStringConstant
    private static final String BOXPLOT_MEAN_STYLE_STROKE = "boxplot.mean.style.stroke";
    @InlineStringConstant
    private static final String BOXPLOT_MEAN_STYLE_STROKEWIDTH = "boxplot.mean.style.stroke-width";
    @InlineStringConstant
    private static final String BOXPLOT_OUTLIER_STYLE_FILL = "boxplot.outlier.style.fill";
    @InlineStringConstant
    private static final String BOXPLOT_OUTLIER_STYLE_STROKE = "boxplot.outlier.style.stroke";
    @InlineStringConstant
    private static final String BOXPLOT_OUTLIER_STYLE_STROKEWIDTH = "boxplot.outlier.style.stroke-width";
    @InlineStringConstant
    private static final String BOXPLOT_EXTREMUM_STYLE_FILL = "boxplot.extremum.style.fill";
    @InlineStringConstant
    private static final String BOXPLOT_EXTREMUM_STYLE_STROKE = "boxplot.extremum.style.stroke";
    @InlineStringConstant
    private static final String BOXPLOT_EXTREMUM_STYLE_STROKEWIDTH = "boxplot.extremum.style.stroke-width";

    protected BoxplotView(BundleContext context) {
        super(context);
    }

    @Override
    public void setup() {
        super.setup();
        this._boxplotData = new ArrayEx();
        this._xScale = null;
        this._yScale = null;
        final BoxplotComponentImpl component = this._boxplotComponent = new BoxplotComponentImpl(this.context);
        BundleUtils.setupZoomAction((BundleContext)this.context);
        ActionImpl action = this.context.actions.action("highlight");
        action.setBindFn(BundleUtils.bindAction((BundleContext)this.context, (String)".chart .element-shape", (ActionImpl)action, (String[])new String[]{"mouseenter.default"}));
        action.setOperation(new ActionOperation(){

            public void call(Object ... args) {
                component.highlight((Selector)args[0]);
            }
        });
        action = this.context.actions.action("unhighlight");
        action.setBindFn(BundleUtils.bindAction((BundleContext)this.context, (String)".chart .element-shape", (ActionImpl)action, (String[])new String[]{"mouseout.default"}));
        action.setOperation(new ActionOperation(){

            public void call(Object ... args) {
                component.unhighlight((Selector)args[0]);
            }
        });
        action = this.context.actions.action("toggleSelect");
        action.setBindFn(BundleUtils.bindAction((BundleContext)this.context, (String)".chart .element-shape", (ActionImpl)action, (String[])new String[]{"click.default", "touchstart.default"}));
        action.setOperation(new ActionOperation(){

            public void call(Object ... args) {
                component.toggleSelect((Selector)args[0]);
            }
        });
        action = this.context.actions.action("deselectAll");
        action.setBindFn(BundleUtils.bindAction((BundleContext)this.context, (String)".background", (ActionImpl)action, (String[])new String[]{"click.default", "touchstart.default"}));
        action.setOperation(new ActionOperation(){

            public void call(Object ... args) {
                component.deselectAll((Selector)args[0]);
            }
        });
    }

    @Override
    protected boolean isAxesManagerRequired() {
        return true;
    }

    public void draw() {
        if (this.isUpdateNothing()) {
            return;
        }
        this.preDraw("g.vizlibrary-boxplot");
        if (!this.validateDataModel("g.element-group", "g.grid", "g.axis")) {
            return;
        }
        final BoxplotView self = this;
        String effect = this.getStringProperty("effect.name");
        int duration = this.getEffectDuration(effect);
        DataSet dataSet = this.dataModel.dataset(DATASET_DATA);
        ArrayEx data = ObjectConverter.listToArray((List)((List)dataSet.data()));
        DataSlotEntry xEntry = dataSet.slot(DATASLOT_X).entry();
        DataSlotEntry yEntry = dataSet.slot(DATASLOT_Y).entry();
        DataSlotEntry colorEntry = dataSet.slot(DATASLOT_COLOR).entry();
        DataSlotEntry keyEntry = dataSet.slot(DATASLOT_KEY).entry();
        if (colorEntry == null && yEntry != null) {
            dataSet.slot(DATASLOT_COLOR).overrideLabel(yEntry.label());
        }
        if (this.updateType == 0) {
            boolean isClustered;
            CoordinateScaleImpl dataScale = colorEntry != null ? ScaleManager.makeClusteredScale((List)data, (List)new ArrayEx((Object[])new DataSlotEntry[]{xEntry, colorEntry})) : ScaleManager.makeCoordinateScale((List)data, (DataSlotEntry)xEntry);
            boolean bl = isClustered = colorEntry != null && "Clustered".equals(this.getStringProperty("data.handling"));
            if (dataScale != null) {
                dataScale.range(0.0, 1.0, null, null);
            }
            this._boxplotData = BoxplotDataUtilities.makeData((List)dataSet.data(), dataScale, isClustered, (SingleValueFunction<Object, Object>)BoxplotView.accessorOf((DataSlotEntry)xEntry), (SingleValueFunction<Object, Object>)BoxplotView.accessorOf((DataSlotEntry)yEntry), (SingleValueFunction<Object, Object>)BoxplotView.accessorOf((DataSlotEntry)colorEntry));
            this._boxplotComponent.data(this._boxplotData);
        }
        Palette colorPalette = this.getPalette();
        colorPalette.setData(dataSet, DATASLOT_COLOR);
        colorPalette.setNullColor(this.getStringProperty("color.null"));
        boolean showLegend = this.isShowLegend();
        String legendPosition = this.getLegendPosition();
        this._legends.visible(showLegend).position(legendPosition).transition(!"none".equals(effect), duration).setPreExecute(this.context.getPreExecute()).selector(0, this.context.node.selectAll("g.legend")).palette(0, colorPalette).title(0, this.context.getDataSlotLabel("legend.title", colorEntry)).titleFill(0, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fill"))).titleFontSize(0, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fontsize"))).titleFontFamily(0, ObjectConverter.asString((Object)this.context.getPropertyValue("legend.titlestyle.fontfamily"))).setDataSlot(0, colorEntry);
        if (this.updateType <= 1) {
            boolean isLegendLeftOrRight;
            boolean isClustered = colorEntry != null && "Clustered".equals(this.getStringProperty("data.handling"));
            this._xScale = isClustered ? ScaleManager.makeClusteredScale((List)data, (List)new ArrayEx((Object[])new DataSlotEntry[]{xEntry, colorEntry})) : ScaleManager.makeCoordinateScale((List)data, (DataSlotEntry)xEntry);
            this._yScale = ScaleManager.makeCoordinateScale((List)data, (DataSlotEntry)yEntry);
            this._axes.visible(true).duration(duration).transpose(false).scale(0, this._xScale).scale(2, this._yScale).setDataSlot(0, xEntry).setDataSlot(2, yEntry).useDefaultSelectors().useDefaultX1Properties(true).useDefaultY1Properties(true).setTickFormatter(0, xEntry).setTickFormatter(2, yEntry);
            this.prepareLayoutComponent();
            this.prepareLayoutSizables(this._layoutComponent, false, true, true, false, showLegend);
            boolean bl = isLegendLeftOrRight = "left".equals(legendPosition) || "right".equals(legendPosition);
            if (isLegendLeftOrRight) {
                this._legends.preLayout(this._layoutComponent, false);
                this._axes.preLayout(this._layoutComponent, false, 0.1, 0.0, 0, 0.1, 0.05, 0);
            } else {
                this._axes.preLayout(this._layoutComponent, true, 0.1, 0.0, 0, 0.1, 0.05, 0);
                this._legends.preLayout(this._layoutComponent, true);
            }
            this._layoutComponent.layout();
            this._axes.useBoundsFromLayout(this._layoutComponent).setScaleRanges(0.1, 0.0, 0);
            this._legends.rectangle(this._layoutComponent.legendRect());
            if (this._xScale != null) {
                this._xScale.expandZeroExtent(false);
                this._xScale.expandPixels(this.getBoxplotSize() / 2.0, false);
                if (this.getBooleanProperty("axis.x.scale.includeZero")) {
                    this._xScale.includeZero();
                }
                if (this.getBooleanProperty("axis.x.scale.nice")) {
                    this._xScale.nice();
                }
                this._xDomain = this._xScale.scale().copy().domain();
            }
            if (this._yScale != null) {
                this._yScale.expandZeroExtent(false);
                this._yScale.expandPixels(7.0, true);
                if (this.getBooleanProperty("axis.y.scale.includeZero")) {
                    this._yScale.includeZero();
                }
                if (this.getBooleanProperty("axis.y.scale.nice")) {
                    this._yScale.nice();
                }
                this._yDomain = this._yScale.scale().copy().domain();
            }
            this.resetZoom();
        }
        this.setBackgroundProperties(this._layoutComponent.elementRect(), duration);
        this._clip.clipRect(this._layoutComponent.elementRect()).applyTo(this.context.node.select((Object)".content")).run((Selection<?>)this.context.node.select((Object)"defs"), new Object[0]);
        this._axes.visible(true).duration(duration).useDefaultSelectors().useDefaultX1Properties(true).useDefaultY1Properties(true).setTickFormatter(0, xEntry).setTickFormatter(2, yEntry);
        this._axes.draw();
        this._legends.draw();
        ((BoxplotComponentImpl)this._boxplotComponent.xScale(this._xScale).yScale(this._yScale).key((SingleValueFunction<Object, Object>)BoxplotView.originalDatumAccessor((SingleValueFunction)BoxplotView.accessorOf((DataSlotEntry)keyEntry)))).yAccessor((SingleValueFunction<Object, Object>)BoxplotView.originalDatumAccessor((SingleValueFunction)BoxplotView.accessorOf((DataSlotEntry)yEntry))).colorPalette(colorPalette).colorAccessor((SingleValueFunction<Object, Object>)BoxplotView.accessorOf((DataSlotEntry)colorEntry)).effect(effect).duration(duration).boxplotSize(this.getBoxplotSize()).boxStyle(this.getStringPropertyEmptyAsNull(BOXPLOT_STYLE_FILL), this.getStringPropertyEmptyAsNull(BOXPLOT_STYLE_STROKE), this.context.convertCSSSizeToPixels((Object)this.getStringProperty(BOXPLOT_STYLE_STROKEWIDTH))).whiskerStyle(this.getStringPropertyEmptyAsNull(BOXPLOT_WHISKER_STYLE_STROKE), this.context.convertCSSSizeToPixels((Object)this.getStringProperty(BOXPLOT_WHISKER_STYLE_STROKEWIDTH))).meanStyle(this.getStringPropertyEmptyAsNull(BOXPLOT_MEAN_STYLE_STROKE), this.context.convertCSSSizeToPixels((Object)this.getStringProperty(BOXPLOT_MEAN_STYLE_STROKEWIDTH))).medianStyle(this.getStringPropertyEmptyAsNull(BOXPLOT_MEDIAN_STYLE_STROKE), this.context.convertCSSSizeToPixels((Object)this.getStringProperty(BOXPLOT_MEDIAN_STYLE_STROKEWIDTH))).outlierStyle(this.getStringPropertyEmptyAsNull(BOXPLOT_OUTLIER_STYLE_FILL), this.getStringPropertyEmptyAsNull(BOXPLOT_OUTLIER_STYLE_STROKE), this.context.convertCSSSizeToPixels((Object)this.getStringProperty(BOXPLOT_OUTLIER_STYLE_STROKEWIDTH))).extremeStyle(this.getStringPropertyEmptyAsNull(BOXPLOT_EXTREMUM_STYLE_FILL), this.getStringPropertyEmptyAsNull(BOXPLOT_EXTREMUM_STYLE_STROKE), this.context.convertCSSSizeToPixels((Object)this.getStringProperty(BOXPLOT_EXTREMUM_STYLE_STROKEWIDTH)));
        this.context.node.selectAll("g.elements").call((RunFunction)this._boxplotComponent, new Object[0]);
        if (this.updateType <= 2) {
            String zoomOp = this.getStringProperty("zoom");
            if (this._xScale != null && ("all".equals(zoomOp) || DATASLOT_X.equals(zoomOp))) {
                this._xScale.scale().domain(this._xDomain);
            }
            if (this._yScale != null && ("all".equals(zoomOp) || DATASLOT_Y.equals(zoomOp))) {
                this._yScale.scale().domain(this._yDomain);
            }
            Zoom zoom = (Zoom)this.context.actions.action("zoom").get("zoom");
            ComponentConfiguration.configureZoom(this._chart, zoom, this._xScale, this._yScale, null, null, null, this._layoutComponent.elementRect(), this._zoomP, this._zoomS, zoomOp, new RunFunction<SceneNode>(){

                public Object run(SceneNode node, Object ... args) {
                    self._boxplotComponent.boxplotSize(self.getBoxplotSize());
                    self.context.node.selectAll("g.elements").call((RunFunction)self._boxplotComponent, new Object[0]);
                    self._axes.redraw(false);
                    return self._chart;
                }
            });
        }
        this.resetUpdate();
    }

    public CoordinateScale getCoordinateScale(String role) {
        if ("ROLE_X1".equals(role)) {
            return this._xScale;
        }
        if ("ROLE_Y1".equals(role)) {
            return this._yScale;
        }
        return null;
    }

    private double getBoxplotSize() {
        if (this._xScale != null && !this._xScale.isContinuous() && !this.getBooleanProperty(BOXPLOT_APPLYSIZE_PROPERTY)) {
            return this._xScale.width() - 8.0;
        }
        Double v = CSSConverter.convertCSSSizeToPixelNumber((Object)this.getStringProperty(BOXPLOT_SIZE_PROPERTY), (double)this._layoutComponent.elementRect().width, (double)10.0);
        return v != null ? v : 10.0;
    }

    @Override
    protected String[] getGroupStructure() {
        return new String[]{"defs", "g.vizlibrary vizlibrary-boxplot", "(", "rect.background chart", "g.chart", "(", "g.content", "(", "rect.background elements", "g.gridlines", "(", "g.grid left", "g.grid bottom", ")", "g.elements", ")", "g.axes", "(", "g.axes-layout", "g.axisTransform left", "g.axisTransform bottom", ")", ")", "g.legends", "(", "g.legends-layout", "g.legend", ")", ")"};
    }
}

